/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.IdentifierRole;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.tools.ContentAssistExtension;
import org.eclipse.persistence.jpa.jpql.tools.ContentAssistProposals;
import org.eclipse.persistence.jpa.jpql.tools.ResultQuery;
import org.eclipse.persistence.jpa.jpql.tools.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.tools.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;
import org.eclipse.persistence.jpa.jpql.tools.utility.XmlEscapeCharacterConverter;
import org.eclipse.persistence.jpa.jpql.tools.utility.iterable.SnapshotCloneIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultContentAssistProposals
implements ContentAssistProposals {
    private String classNamePrefix;
    private ContentAssistProposals.ClassType classType;
    private String columnNamePrefix;
    private Set<IEntity> entities;
    private Map<IType, DefaultEnumProposals> enumProposals;
    private ContentAssistExtension extension;
    private Set<String> identificationVariables;
    private Set<String> identifiers;
    private JPQLGrammar jpqlGrammar;
    private Set<IMapping> mappings;
    private Map<String, IEntity> rangeIdentificationVariables;
    private String tableName;
    private String tableNamePrefix;
    private static final Map<String, String> LONGUEST_IDENTIFIERS = DefaultContentAssistProposals.buildLonguestIdentifiers();
    private static final Map<String, List<String>> ORDERED_IDENTIFIERS = DefaultContentAssistProposals.buildOrderedIdentifiers();

    public DefaultContentAssistProposals(JPQLGrammar jpqlGrammar, ContentAssistExtension extension) {
        this.initialize(jpqlGrammar, extension);
    }

    private static Map<String, String> buildLonguestIdentifiers() {
        HashMap<String, String> identifiers = new HashMap<String, String>();
        identifiers.put("IS EMPTY", "IS NOT EMPTY");
        identifiers.put("IS NULL", "IS NOT NULL");
        identifiers.put("IN", "NOT IN");
        identifiers.put("BETWEEN", "NOT BETWEEN");
        identifiers.put("MEMBER", "NOT MEMBER OF");
        identifiers.put("MEMBER OF", "NOT MEMBER OF");
        identifiers.put("NOT MEMBER", "NOT MEMBER OF");
        identifiers.put("JOIN", "LEFT OUTER JOIN FETCH");
        identifiers.put("JOIN FETCH", "LEFT OUTER JOIN FETCH");
        identifiers.put("LEFT JOIN", "LEFT OUTER JOIN FETCH");
        identifiers.put("LEFT JOIN FETCH", "LEFT OUTER JOIN FETCH");
        identifiers.put("LEFT OUTER JOIN", "LEFT OUTER JOIN FETCH");
        identifiers.put("INNER JOIN", "LEFT OUTER JOIN FETCH");
        identifiers.put("INNER JOIN FETCH", "LEFT OUTER JOIN FETCH");
        identifiers.put("SELECT", "DELETE FROM");
        identifiers.put("UPDATE", "DELETE FROM");
        return identifiers;
    }

    private static Map<String, List<String>> buildOrderedIdentifiers() {
        HashMap<String, List<String>> identifiers = new HashMap<String, List<String>>();
        identifiers.put("IS NOT EMPTY", Collections.singletonList("IS NOT EMPTY"));
        identifiers.put("IS NOT NULL", Collections.singletonList("IS NOT NULL"));
        identifiers.put("NOT IN", Collections.singletonList("NOT IN"));
        identifiers.put("NOT BETWEEN", Collections.singletonList("NOT BETWEEN"));
        ArrayList<String> members = new ArrayList<String>();
        members.add("MEMBER OF");
        members.add("NOT MEMBER");
        members.add("MEMBER");
        identifiers.put("NOT MEMBER OF", members);
        ArrayList<String> joins = new ArrayList<String>();
        joins.add("LEFT OUTER JOIN");
        joins.add("LEFT JOIN FETCH");
        joins.add("LEFT JOIN");
        joins.add("INNER JOIN FETCH");
        joins.add("INNER JOIN");
        joins.add("JOIN FETCH");
        joins.add("JOIN");
        identifiers.put("LEFT OUTER JOIN FETCH", joins);
        ArrayList<String> clauses = new ArrayList<String>();
        clauses.add("SELECT");
        clauses.add("UPDATE");
        identifiers.put("DELETE FROM", clauses);
        return identifiers;
    }

    @Override
    public Iterable<IEntity> abstractSchemaTypes() {
        return new SnapshotCloneIterable<IEntity>(this.entities);
    }

    public void addEntity(IEntity abstractSchemaType) {
        this.entities.add(abstractSchemaType);
    }

    public void addEnumConstant(IType enumType, String enumConstant) {
        DefaultEnumProposals proposal = this.enumProposals.get(enumType);
        if (proposal == null) {
            proposal = new DefaultEnumProposals(enumType);
            this.enumProposals.put(enumType, proposal);
        }
        proposal.constants.add(enumConstant);
    }

    public void addIdentificationVariable(String identificationVariable) {
        this.identificationVariables.add(identificationVariable);
    }

    public void addIdentifier(String identifier) {
        this.identifiers.add(identifier);
    }

    public void addMapping(IMapping mapping) {
        this.mappings.add(mapping);
    }

    public void addMappings(Collection<IMapping> mappings) {
        this.mappings.addAll(mappings);
    }

    public void addRangeIdentificationVariable(String identificationVariable, IEntity abstractSchemaType) {
        this.rangeIdentificationVariables.put(identificationVariable, abstractSchemaType);
    }

    @Override
    public Result buildEscapedQuery(String jpqlQuery, String proposal, int position, boolean insert) {
        Result result = this.buildQuery(jpqlQuery, proposal, position, insert);
        int[] positions = new int[]{result.position};
        result.jpqlQuery = ExpressionTools.escape(result.jpqlQuery, positions);
        result.position = positions[0];
        return result;
    }

    public int[] buildPositions(WordParser wordParser, String proposal, boolean insert) {
        int length;
        int startPosition;
        int index;
        String wordsToReplace = null;
        if (wordParser.isArithmeticSymbol(proposal.charAt(0))) {
            char character;
            int startIndex;
            int endIndex = startIndex = wordParser.position();
            while (wordParser.isArithmeticSymbol(character = wordParser.character(--startIndex))) {
            }
            while (wordParser.isArithmeticSymbol(character = wordParser.character(endIndex++))) {
            }
            index = ++startIndex;
            wordsToReplace = wordParser.substring(index, --endIndex);
        } else {
            wordsToReplace = this.longuestIdentifier(proposal);
            index = this.startPosition(wordParser, wordsToReplace);
            if (index == -1 && ORDERED_IDENTIFIERS.containsKey(wordsToReplace)) {
                for (String identifier : ORDERED_IDENTIFIERS.get(wordsToReplace)) {
                    wordsToReplace = identifier;
                    index = this.startPosition(wordParser, wordsToReplace);
                    if (index > -1) break;
                }
            }
        }
        if (index > -1) {
            startPosition = index;
        } else {
            String partialWord = wordParser.partialWord();
            String entireWord = wordParser.entireWord();
            int dotIndex = -1;
            if (this.isMappingName(proposal) || this.isEnumConstant(proposal) || this.isColumnName(proposal)) {
                dotIndex = partialWord.lastIndexOf(".");
            }
            if (dotIndex > 0) {
                wordsToReplace = entireWord.substring(dotIndex + 1);
                startPosition = wordParser.position() - partialWord.length() + dotIndex + 1;
            } else if (insert) {
                wordsToReplace = wordParser.word();
                startPosition = wordParser.position() - partialWord.length();
            } else {
                wordsToReplace = entireWord;
                startPosition = wordParser.position() - partialWord.length();
            }
        }
        if (insert) {
            String partialWord = wordParser.substring(startPosition, wordParser.position());
            length = partialWord.length();
        } else if (proposal != wordsToReplace) {
            length = wordsToReplace.length();
        } else {
            index = 0;
            int charIndex = 0;
            int wordLength = wordParser.length();
            int count = wordsToReplace.length();
            while (startPosition + index < wordLength && charIndex < count) {
                if (wordParser.character(startPosition + charIndex) != wordsToReplace.charAt(charIndex)) break;
                ++index;
                ++charIndex;
            }
            length = index;
        }
        return new int[]{startPosition, startPosition + length};
    }

    @Override
    public Result buildQuery(String jpqlQuery, String proposal, int position, boolean insert) {
        if (ExpressionTools.stringIsEmpty(proposal)) {
            return new Result(jpqlQuery, position);
        }
        WordParser wordParser = new WordParser(jpqlQuery);
        wordParser.setPosition(position);
        int[] positions = this.buildPositions(wordParser, proposal, insert);
        StringBuilder sb = new StringBuilder(jpqlQuery);
        sb.replace(positions[0], positions[1], proposal);
        return new Result(sb.toString(), positions[0] + proposal.length());
    }

    @Override
    public ResultQuery buildXmlQuery(String jpqlQuery, String proposal, int position, boolean insert) {
        if (ExpressionTools.stringIsEmpty(proposal)) {
            return new Result(jpqlQuery, position);
        }
        int[] positions = new int[]{position};
        String query = XmlEscapeCharacterConverter.unescape(jpqlQuery, positions);
        WordParser wordParser = new WordParser(query);
        wordParser.setPosition(positions[0]);
        int[] proposalPositions = this.buildPositions(wordParser, proposal, insert);
        proposal = XmlEscapeCharacterConverter.escape(proposal, new int[1]);
        XmlEscapeCharacterConverter.reposition(jpqlQuery, proposalPositions);
        StringBuilder sb = new StringBuilder(jpqlQuery);
        sb.replace(proposalPositions[0], proposalPositions[1], proposal);
        return new Result(sb.toString(), proposalPositions[0] + proposal.length());
    }

    @Override
    public Iterable<String> classNames() {
        if (this.classNamePrefix == null) {
            return Collections.emptyList();
        }
        return this.extension.classNames(this.classNamePrefix, this.classType);
    }

    @Override
    public Iterable<String> columnNames() {
        if (this.tableName == null) {
            return Collections.emptyList();
        }
        return this.extension.columnNames(this.tableName, this.columnNamePrefix);
    }

    @Override
    public Iterable<ContentAssistProposals.EnumProposals> enumConstant() {
        return new SnapshotCloneIterable<ContentAssistProposals.EnumProposals>(this.enumProposals.values());
    }

    @Override
    public IEntity getAbstractSchemaType(String identificationVariable) {
        return this.rangeIdentificationVariables.get(identificationVariable);
    }

    public String getClassNamePrefix() {
        return this.classNamePrefix;
    }

    @Override
    public ContentAssistProposals.ClassType getClassType() {
        return this.classType;
    }

    public String getColumnNamePrefix() {
        return this.columnNamePrefix;
    }

    public JPQLGrammar getGrammar() {
        return this.jpqlGrammar;
    }

    @Override
    public IdentifierRole getIdentifierRole(String identifier) {
        return this.jpqlGrammar.getExpressionRegistry().getIdentifierRole(identifier);
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableNamePrefix() {
        return this.tableNamePrefix;
    }

    @Override
    public boolean hasProposals() {
        return !this.mappings.isEmpty() || !this.entities.isEmpty() || !this.identifiers.isEmpty() || !this.enumProposals.isEmpty() || !this.identificationVariables.isEmpty() || this.classNames().iterator().hasNext() || this.tableNames().iterator().hasNext() || this.columnNames().iterator().hasNext() || !this.rangeIdentificationVariables.isEmpty();
    }

    @Override
    public Iterable<String> identificationVariables() {
        ArrayList<String> variables = new ArrayList<String>(this.identificationVariables.size() + this.rangeIdentificationVariables.size());
        variables.addAll(this.identificationVariables);
        variables.addAll(this.rangeIdentificationVariables.keySet());
        return new SnapshotCloneIterable<String>(variables);
    }

    @Override
    public Iterable<String> identifiers() {
        return new SnapshotCloneIterable<String>(this.identifiers);
    }

    protected void initialize(JPQLGrammar jpqlGrammar, ContentAssistExtension extension) {
        this.extension = extension;
        this.jpqlGrammar = jpqlGrammar;
        this.mappings = new HashSet<IMapping>();
        this.identifiers = new HashSet<String>();
        this.entities = new HashSet<IEntity>();
        this.identificationVariables = new HashSet<String>();
        this.rangeIdentificationVariables = new HashMap<String, IEntity>();
        this.enumProposals = new HashMap<IType, DefaultEnumProposals>();
    }

    public boolean isColumnName(String proposal) {
        for (String columName : this.columnNames()) {
            if (!columName.equals(proposal)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnumConstant(String proposal) {
        for (ContentAssistProposals.EnumProposals enumProposals : this.enumProposals.values()) {
            for (String enumConstant : enumProposals.enumConstants()) {
                if (!enumConstant.equals(proposal)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMappingName(String proposal) {
        for (IMapping mapping : this.mappings) {
            if (!mapping.getName().equals(proposal)) continue;
            return true;
        }
        return false;
    }

    public String longuestIdentifier(String proposal) {
        return LONGUEST_IDENTIFIERS.containsKey(proposal) ? LONGUEST_IDENTIFIERS.get(proposal) : proposal;
    }

    @Override
    public Iterable<IMapping> mappings() {
        return new SnapshotCloneIterable<IMapping>(this.mappings);
    }

    protected void removeIdentifier(String identifier) {
        this.identifiers.remove(identifier);
    }

    public void setClassNamePrefix(String prefix, ContentAssistProposals.ClassType classType) {
        this.classNamePrefix = prefix;
        this.classType = classType;
    }

    public void setTableName(String tableName, String prefix) {
        this.tableName = tableName;
        this.columnNamePrefix = prefix;
    }

    public void setTableNamePrefix(String tableNamePrefix) {
        this.tableNamePrefix = tableNamePrefix;
    }

    public int startPosition(WordParser wordParser, String proposal) {
        int index = wordParser.position();
        int maxMoveLength = proposal.length();
        while (index >= 0 && maxMoveLength > 0) {
            if (wordParser.startsWithIgnoreCase(proposal, index)) {
                return index;
            }
            --index;
            --maxMoveLength;
        }
        return -1;
    }

    @Override
    public Iterable<String> tableNames() {
        if (this.tableNamePrefix == null) {
            return Collections.emptyList();
        }
        return this.extension.tableNames(this.tableNamePrefix);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.identifiers.isEmpty()) {
            sb.append(this.identifiers);
        }
        if (!this.entities.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.entities);
        }
        if (!this.identificationVariables.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.identificationVariables);
        }
        if (!this.rangeIdentificationVariables.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.rangeIdentificationVariables);
        }
        if (!this.mappings.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.mappings);
        }
        for (String className : this.classNames()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(className);
        }
        for (String tableName : this.tableNames()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(tableName);
        }
        for (String columnName : this.columnNames()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(columnName);
        }
        for (ContentAssistProposals.EnumProposals enumProposals : this.enumConstant()) {
            for (String enumConstant : enumProposals.enumConstants()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(enumConstant);
            }
        }
        if (sb.length() == 0) {
            sb.append("<No Default Proposals>");
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultEnumProposals
    implements ContentAssistProposals.EnumProposals {
        private Set<String> constants;
        private IType enumType;

        DefaultEnumProposals(IType enumType) {
            this.enumType = enumType;
            this.constants = new HashSet<String>();
        }

        @Override
        public Iterable<String> enumConstants() {
            return new SnapshotCloneIterable<String>(this.constants);
        }

        @Override
        public IType enumType() {
            return this.enumType;
        }
    }

    private final class Result
    implements ResultQuery {
        private String jpqlQuery;
        private int position;

        public Result(String jpqlQuery, int position) {
            this.jpqlQuery = jpqlQuery;
            this.position = position;
        }

        public int getPosition() {
            return this.position;
        }

        public String getQuery() {
            return this.jpqlQuery;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Query=[").append(this.jpqlQuery);
            sb.append("], position=").append(this.position);
            return sb.toString();
        }
    }
}

