/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.transaction;

import javax.persistence.EntityTransaction;
import javax.persistence.TransactionRequiredException;
import org.eclipse.persistence.exceptions.TransactionException;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.transaction.TransactionWrapper;
import org.eclipse.persistence.internal.jpa.transaction.TransactionWrapperImpl;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.transaction.AbstractTransactionController;

public class JTATransactionWrapper
extends TransactionWrapperImpl
implements TransactionWrapper {
    protected AbstractTransactionController txnController;

    public JTATransactionWrapper(EntityManagerImpl entityManager) {
        super(entityManager);
        this.txnController = (AbstractTransactionController)entityManager.getDatabaseSession().getExternalTransactionController();
    }

    @Override
    public Object checkForTransaction(boolean validateExistence) {
        Object transaction = this.txnController.getTransaction();
        if (validateExistence && transaction == null) {
            this.throwCheckTransactionFailedException();
        }
        return transaction;
    }

    @Override
    public void clear() {
        this.localUOW.release();
        this.localUOW = null;
    }

    @Override
    public EntityTransaction getTransaction() {
        throw new IllegalStateException(TransactionException.entityTransactionWithJTANotAllowed().getMessage());
    }

    @Override
    public void setRollbackOnlyInternal() {
        if (this.txnController.getTransaction() != null) {
            this.txnController.markTransactionForRollback();
        }
    }

    protected void throwUserTransactionException() {
        throw TransactionException.entityTransactionWithJTANotAllowed();
    }

    protected void throwCheckTransactionFailedException() {
        throw new TransactionRequiredException(TransactionException.externalTransactionNotActive().getMessage());
    }

    @Override
    public void registerUnitOfWorkWithTxn(UnitOfWorkImpl uow) {
        uow.registerWithTransactionIfRequired();
    }

    @Override
    public boolean isJoinedToTransaction(UnitOfWorkImpl uow) {
        return uow.getParent().hasExternalTransactionController() && uow.isSynchronized();
    }

    @Override
    public void verifyRegisterUnitOfWorkWithTxn() {
    }

    @Override
    public boolean shouldFlushBeforeQuery(UnitOfWorkImpl uow) {
        return uow.isSynchronized();
    }
}

