/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.core.queries;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.core.queries.CoreAttributeGroup;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;

public class CoreAttributeItem<ATTRIBUTE_GROUP extends CoreAttributeGroup>
implements Serializable,
Cloneable {
    protected String attributeName;
    protected ATTRIBUTE_GROUP parent;
    protected ATTRIBUTE_GROUP group;
    protected ATTRIBUTE_GROUP keyGroup;
    protected Map<Object, ATTRIBUTE_GROUP> subGroups;
    protected Map<Object, ATTRIBUTE_GROUP> keyGroups;

    protected CoreAttributeItem() {
    }

    public CoreAttributeItem(ATTRIBUTE_GROUP parent, String attributeName) {
        this.parent = parent;
        this.attributeName = attributeName;
    }

    public void addGroups(Collection<ATTRIBUTE_GROUP> groups) {
        for (CoreAttributeGroup group : groups) {
            this.addSubGroup(group);
        }
    }

    public void addKeyGroup(ATTRIBUTE_GROUP keyGroup) {
        if (keyGroup != null) {
            Object type;
            if (this.keyGroups == null) {
                this.keyGroups = new HashMap<Object, ATTRIBUTE_GROUP>();
            }
            if (this.keyGroup == null) {
                this.keyGroup = keyGroup;
            }
            if ((type = ((CoreAttributeGroup)keyGroup).getType()) == null) {
                type = ((CoreAttributeGroup)keyGroup).getTypeName();
            }
            if (type == null && this.keyGroups.containsKey(type = ClassConstants.Object_Class)) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("only_one_root_subgraph"));
            }
            this.keyGroups.put(type, keyGroup);
            if (CoreAttributeItem.orderInheritance(keyGroup, this.keyGroups)) {
                ((CoreAttributeGroup)keyGroup).insertSubClass((CoreAttributeGroup)this.keyGroup);
                this.keyGroup = keyGroup;
            }
        }
    }

    public void addKeyGroups(Collection<ATTRIBUTE_GROUP> keyGroups) {
        for (CoreAttributeGroup group : keyGroups) {
            this.addKeyGroup(group);
        }
    }

    public void addSubGroup(ATTRIBUTE_GROUP group) {
        if (group != null) {
            Object type;
            if (this.subGroups == null) {
                this.subGroups = new HashMap<Object, ATTRIBUTE_GROUP>();
            }
            if (this.group == null) {
                this.group = group;
            }
            if ((type = ((CoreAttributeGroup)group).getType()) == null) {
                type = ((CoreAttributeGroup)group).getTypeName();
            }
            if (type == null && this.subGroups.containsKey(type = ClassConstants.Object_Class)) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("only_one_root_subgraph"));
            }
            this.subGroups.put(type, group);
            if (CoreAttributeItem.orderInheritance(group, this.subGroups)) {
                ((CoreAttributeGroup)group).insertSubClass((CoreAttributeGroup)this.group);
                this.group = group;
            }
        }
    }

    public CoreAttributeItem<ATTRIBUTE_GROUP> clone(Map<ATTRIBUTE_GROUP, ATTRIBUTE_GROUP> cloneMap, ATTRIBUTE_GROUP parentClone) {
        CoreAttributeItem clone = null;
        try {
            clone = (CoreAttributeItem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        clone.attributeName = this.attributeName;
        if (this.group != null) {
            clone.group = ((CoreAttributeGroup)this.group).clone(cloneMap);
        }
        if (clone.keyGroup != null) {
            clone.keyGroup = ((CoreAttributeGroup)this.keyGroup).clone(cloneMap);
        }
        clone.parent = parentClone;
        if (this.subGroups != null) {
            clone.subGroups = new HashMap<Object, ATTRIBUTE_GROUP>();
            for (Map.Entry<Object, ATTRIBUTE_GROUP> group : this.subGroups.entrySet()) {
                clone.subGroups.put(group.getKey(), ((CoreAttributeGroup)group.getValue()).clone(cloneMap));
            }
        }
        if (this.keyGroups != null) {
            clone.keyGroups = new HashMap<Object, ATTRIBUTE_GROUP>();
            for (Map.Entry<Object, ATTRIBUTE_GROUP> group : this.keyGroups.entrySet()) {
                clone.keyGroups.put(group.getKey(), ((CoreAttributeGroup)group.getValue()).clone(cloneMap));
            }
        }
        return clone;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        HashMap<Object, Object> newMap = new HashMap<Object, ATTRIBUTE_GROUP>();
        if (this.subGroups != null) {
            for (CoreAttributeGroup entry : this.subGroups.values()) {
                entry.convertClassNamesToClasses(classLoader);
                newMap.put(entry.getType(), entry);
                entry.setAllSubclasses(newMap);
            }
        }
        this.subGroups = newMap;
        newMap = new HashMap();
        if (this.keyGroups != null) {
            for (CoreAttributeGroup entry : this.keyGroups.values()) {
                entry.convertClassNamesToClasses(classLoader);
                newMap.put(entry.getType(), entry);
                entry.setAllSubclasses(newMap);
            }
        }
        this.keyGroups = newMap;
        for (CoreAttributeGroup group : this.subGroups.values()) {
            if (!CoreAttributeItem.orderInheritance(group, this.subGroups)) continue;
            group.insertSubClass((CoreAttributeGroup)this.group);
            this.group = group;
        }
        for (CoreAttributeGroup group : this.keyGroups.values()) {
            if (!CoreAttributeItem.orderInheritance(group, this.keyGroups)) continue;
            group.insertSubClass((CoreAttributeGroup)this.keyGroup);
            this.keyGroup = group;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        CoreAttributeGroup anotherGroup;
        if (this == obj) return true;
        if (obj == null) {
            return false;
        }
        CoreAttributeItem anotherItem = null;
        try {
            anotherItem = (CoreAttributeItem)obj;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (this.subGroups != null) {
            if (anotherItem.subGroups == null) {
                return false;
            }
            if (this.subGroups.size() != anotherItem.subGroups.size()) return false;
            for (Map.Entry<Object, ATTRIBUTE_GROUP> entry : this.subGroups.entrySet()) {
                anotherGroup = (CoreAttributeGroup)anotherItem.subGroups.get(entry.getKey());
                if (((CoreAttributeGroup)entry.getValue()).equals(anotherGroup)) continue;
                return false;
            }
        } else if (anotherItem.subGroups != null) {
            return false;
        }
        if (this.keyGroups != null) {
            if (anotherItem.keyGroups == null) {
                return false;
            }
            if (this.keyGroups.size() != anotherItem.keyGroups.size()) return false;
            for (Map.Entry<Object, ATTRIBUTE_GROUP> entry : this.keyGroups.entrySet()) {
                anotherGroup = (CoreAttributeGroup)anotherItem.keyGroups.get(entry.getKey());
                if (((CoreAttributeGroup)entry.getValue()).equals(anotherGroup)) continue;
                return false;
            }
            return true;
        } else {
            if (anotherItem.keyGroups == null) return true;
            return false;
        }
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public ATTRIBUTE_GROUP getGroup() {
        if (this.group == null) {
            return null;
        }
        return this.group;
    }

    public ATTRIBUTE_GROUP getGroup(Class type) {
        if (this.subGroups == null || type == null) {
            return null;
        }
        CoreAttributeGroup result = (CoreAttributeGroup)this.subGroups.get(type);
        while (result == null && !type.equals(ClassConstants.Object_Class)) {
            if ((type = type.getSuperclass()) == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("subclass_sought_not_a_managed_type", new Object[]{type.toString(), this.attributeName}));
            }
            result = (CoreAttributeGroup)this.subGroups.get(type);
        }
        return (ATTRIBUTE_GROUP)result;
    }

    public Map<Object, ATTRIBUTE_GROUP> getGroups() {
        return this.subGroups;
    }

    public ATTRIBUTE_GROUP getKeyGroup() {
        if (this.keyGroups == null) {
            return null;
        }
        return (ATTRIBUTE_GROUP)((CoreAttributeGroup)this.keyGroups.get(ClassConstants.Object_Class));
    }

    public ATTRIBUTE_GROUP getKeyGroup(Class type) {
        if (this.keyGroups == null || type == null) {
            return null;
        }
        CoreAttributeGroup result = (CoreAttributeGroup)this.keyGroups.get(type);
        while (result == null && !type.equals(ClassConstants.Object_Class)) {
            if ((type = type.getSuperclass()) == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("subclass_sought_not_a_managed_type", new Object[]{type.toString(), this.attributeName}));
            }
            result = (CoreAttributeGroup)this.keyGroups.get(type);
        }
        return (ATTRIBUTE_GROUP)result;
    }

    public Map<Object, ATTRIBUTE_GROUP> getKeyGroups() {
        return this.keyGroups;
    }

    public ATTRIBUTE_GROUP getParent() {
        return this.parent;
    }

    protected static boolean orderInheritance(CoreAttributeGroup group, Map<Object, ? extends CoreAttributeGroup> subGroups) {
        Class type = group.getType();
        if (type != null) {
            CoreAttributeGroup superClass = null;
            while (!type.equals(ClassConstants.Object_Class) && superClass == null) {
                type = type.getSuperclass();
                superClass = subGroups.get(type);
            }
            if (superClass != null) {
                superClass.insertSubClass(group);
            } else {
                return true;
            }
        }
        return false;
    }

    public void setRootGroup(ATTRIBUTE_GROUP group) {
        this.group = group;
        this.addSubGroup(group);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this.getAttributeName() + ")" + (this.subGroups != null ? " => " + this.subGroups.toString() : "") + (this.keyGroups != null ? " => " + this.keyGroups.toString() : "");
    }

    public String toStringNoClassName() {
        return String.valueOf(this.getAttributeName()) + (this.subGroups != null ? " => " + this.subGroups.toString() : "") + (this.keyGroups != null ? " => " + this.keyGroups.toString() : "");
    }
}

