/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.io.Serializable;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public abstract class BatchWritingMechanism
implements Cloneable,
Serializable {
    protected DatabaseAccessor databaseAccessor;
    protected int queryTimeoutCache = 0;
    protected int executionCount;
    protected int statementCount;
    protected int maxBatchSize;

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    protected void cacheQueryTimeout(AbstractSession session, DatabaseCall dbCall) {
        int callTimeout = dbCall.getQueryTimeout();
        if (callTimeout == -1 || callTimeout == 0) {
            return;
        }
        if (callTimeout > this.queryTimeoutCache) {
            this.queryTimeoutCache = callTimeout;
        }
    }

    protected void clearCacheQueryTimeout() {
        this.queryTimeoutCache = 0;
    }

    public void setAccessor(DatabaseAccessor accessor, AbstractSession session) {
        this.databaseAccessor = accessor;
    }

    public abstract void appendCall(AbstractSession var1, DatabaseCall var2);

    public abstract void clear();

    public abstract void executeBatchedStatements(AbstractSession var1);

    public BatchWritingMechanism clone() {
        try {
            return (BatchWritingMechanism)super.clone();
        }
        catch (CloneNotSupportedException notPossible) {
            throw new InternalError(notPossible.toString());
        }
    }
}

