/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.internal.expressions.ForUpdateOfClause;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedSubVector;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.ContainerIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.NoIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.WeavedObjectBasicIndirectionPolicy;
import org.eclipse.persistence.internal.queries.AttributeItem;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.BatchFetchPolicy;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.remote.DistributedSession;

public abstract class ForeignReferenceMapping
extends DatabaseMapping {
    public static final String QUERY_BATCH_PARAMETER = "query-batch-parameter";
    protected Class referenceClass;
    protected String referenceClassName;
    protected transient AbstractSession tempInitSession;
    protected transient ClassDescriptor referenceDescriptor;
    protected ReadQuery selectionQuery;
    protected boolean isPrivateOwned = false;
    protected BatchFetchType batchFetchType;
    protected IndirectionPolicy indirectionPolicy;
    protected transient boolean hasCustomSelectionQuery = false;
    protected DatabaseMapping relationshipPartner;
    protected String relationshipPartnerAttributeName;
    protected boolean cascadePersist;
    protected boolean cascadeMerge;
    protected boolean cascadeRefresh;
    protected boolean cascadeRemove;
    protected boolean cascadeDetach;
    protected boolean requiresTransientWeavedFields;
    protected int joinFetch = 0;
    public static final int INNER_JOIN = 1;
    public static final int OUTER_JOIN = 2;
    public static final int NONE = 0;
    protected boolean forceInitializationOfSelectionCriteria;
    ExtendPessimisticLockScope extendPessimisticLockScope;
    protected boolean isCascadeOnDeleteSetOnDatabase;
    protected PartitioningPolicy partitioningPolicy;
    protected String partitioningPolicyName;
    protected String mappedBy;

    protected ForeignReferenceMapping() {
        this.useBasicIndirection();
        this.cascadePersist = false;
        this.cascadeMerge = false;
        this.cascadeRefresh = false;
        this.cascadeRemove = false;
        this.requiresTransientWeavedFields = true;
        this.forceInitializationOfSelectionCriteria = false;
        this.extendPessimisticLockScope = ExtendPessimisticLockScope.NONE;
    }

    public String getMappedBy() {
        return this.mappedBy;
    }

    public PartitioningPolicy getPartitioningPolicy() {
        return this.partitioningPolicy;
    }

    public void setPartitioningPolicy(PartitioningPolicy partitioningPolicy) {
        this.partitioningPolicy = partitioningPolicy;
    }

    public String getPartitioningPolicyName() {
        return this.partitioningPolicyName;
    }

    public void setPartitioningPolicyName(String partitioningPolicyName) {
        this.partitioningPolicyName = partitioningPolicyName;
    }

    protected Object batchedValueFromRow(AbstractRecord row, ObjectLevelReadQuery query, CacheKey parentCacheKey) {
        ReadQuery batchQuery = (ReadQuery)query.getProperty(this);
        if (batchQuery == null) {
            Map<DatabaseMapping, ReadQuery> queries;
            if (query.hasBatchReadAttributes() && (queries = query.getBatchFetchPolicy().getMappingQueries()) != null) {
                batchQuery = queries.get(this);
            }
            if (batchQuery == null) {
                batchQuery = this.prepareNestedBatchQuery(query);
                batchQuery.setIsExecutionClone(true);
            } else {
                batchQuery = (ReadQuery)batchQuery.clone();
                batchQuery.setIsExecutionClone(true);
            }
            query.setProperty(this, batchQuery);
        }
        return this.indirectionPolicy.valueFromBatchQuery(batchQuery, row, query, parentCacheKey);
    }

    @Override
    public void buildBackupClone(Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        Object attributeValue = this.getAttributeValueFromObject(clone);
        Object clonedAttributeValue = this.indirectionPolicy.backupCloneAttribute(attributeValue, clone, backup, unitOfWork);
        this.setAttributeValueInObject(backup, clonedAttributeValue);
    }

    @Override
    public abstract Object buildBackupCloneForPartObject(Object var1, Object var2, Object var3, UnitOfWorkImpl var4);

    @Override
    public void buildClone(Object original, CacheKey cacheKey, Object clone, Integer refreshCascade, AbstractSession cloningSession) {
        Object attributeValue = null;
        if (!this.isCacheable && cacheKey != null && !cacheKey.isIsolated()) {
            ReadObjectQuery query = new ReadObjectQuery(this.descriptor.getJavaClass());
            query.setSession(cloningSession);
            attributeValue = this.valueFromRow(cacheKey.getProtectedForeignKeys(), null, query, cacheKey, cloningSession, true, null);
        } else {
            attributeValue = this.getAttributeValueFromObject(original);
        }
        attributeValue = this.indirectionPolicy.cloneAttribute(attributeValue, original, cacheKey, clone, refreshCascade, cloningSession, false);
        this.setAttributeValueInObject(clone, attributeValue);
    }

    @Override
    public void buildCloneFromRow(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object clone, CacheKey sharedCacheKey, ObjectBuildingQuery sourceQuery, UnitOfWorkImpl unitOfWork, AbstractSession executionSession) {
        Boolean[] wasCacheUsed = new Boolean[]{Boolean.FALSE};
        Object attributeValue = this.valueFromRow(databaseRow, joinManager, sourceQuery, sharedCacheKey, executionSession, true, wasCacheUsed);
        Object clonedAttributeValue = this.indirectionPolicy.cloneAttribute(attributeValue, null, sharedCacheKey, clone, null, unitOfWork, wasCacheUsed[0] == false);
        if (executionSession.isUnitOfWork() && sourceQuery.shouldRefreshIdentityMapResult()) {
            boolean wasAttributeValueFullyBuilt = this.isAttributeValueFullyBuilt(clone);
            Object oldAttribute = this.getAttributeValueFromObject(clone);
            this.setAttributeValueInObject(clone, clonedAttributeValue);
            if (wasAttributeValueFullyBuilt && this.indirectionPolicy.objectIsInstantiatedOrChanged(oldAttribute)) {
                this.indirectionPolicy.instantiateObject(clone, clonedAttributeValue);
            }
        } else {
            this.setAttributeValueInObject(clone, clonedAttributeValue);
        }
        if (joinManager != null && joinManager.isAttributeJoined(this.descriptor, this) || this.isExtendingPessimisticLockScope(sourceQuery) && this.extendPessimisticLockScope == ExtendPessimisticLockScope.TARGET_QUERY) {
            this.indirectionPolicy.instantiateObject(clone, clonedAttributeValue);
        }
    }

    @Override
    public abstract Object buildCloneForPartObject(Object var1, Object var2, CacheKey var3, Object var4, AbstractSession var5, Integer var6, boolean var7, boolean var8);

    @Override
    public Object clone() {
        ForeignReferenceMapping clone = (ForeignReferenceMapping)super.clone();
        clone.setIndirectionPolicy((IndirectionPolicy)this.indirectionPolicy.clone());
        clone.setSelectionQuery((ReadQuery)this.getSelectionQuery().clone());
        return clone;
    }

    public abstract Object[] buildReferencesPKList(Object var1, Object var2, AbstractSession var3);

    @Override
    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        if (this.isPrivateOwned()) {
            return this.compareObjectsWithPrivateOwned(firstObject, secondObject, session);
        }
        return this.compareObjectsWithoutPrivateOwned(firstObject, secondObject, session);
    }

    protected abstract boolean compareObjectsWithoutPrivateOwned(Object var1, Object var2, AbstractSession var3);

    protected abstract boolean compareObjectsWithPrivateOwned(Object var1, Object var2, AbstractSession var3);

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.getReferenceClassName() != null) {
            Class referenceClass;
            block7: {
                referenceClass = null;
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            referenceClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getReferenceClassName(), true, classLoader));
                            break block7;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.getReferenceClassName(), exception.getException());
                        }
                    }
                    referenceClass = PrivilegedAccessHelper.getClassForName(this.getReferenceClassName(), true, classLoader);
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.getReferenceClassName(), exc);
                }
            }
            this.setReferenceClass(referenceClass);
        }
        if (this.getSelectionQuery() != null) {
            this.getSelectionQuery().convertClassNamesToClasses(classLoader);
        }
    }

    @Override
    public DatabaseValueHolder createCloneValueHolder(ValueHolderInterface attributeValue, Object original, Object clone, AbstractRecord row, AbstractSession cloningSession, boolean buildDirectlyFromRow) {
        return cloningSession.createCloneQueryValueHolder(attributeValue, clone, row, this);
    }

    protected boolean dontDoMerge(Object target, Object source, MergeManager mergeManager) {
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return true;
        }
        if (mergeManager.isForRefresh()) {
            if (!this.isAttributeValueInstantiated(target)) {
                return true;
            }
        } else {
            if (mergeManager.shouldRefreshRemoteObject() && this.shouldMergeCascadeParts(mergeManager) && this.usesIndirection()) {
                return true;
            }
            if (!this.isAttributeValueInstantiated(source)) {
                return true;
            }
        }
        return false;
    }

    public void dontUseBatchReading() {
        this.setUsesBatchReading(false);
    }

    public void dontUseIndirection() {
        this.setIndirectionPolicy(new NoIndirectionPolicy());
    }

    protected void extendPessimisticLockScopeInTargetQuery(ObjectLevelReadQuery targetQuery, ObjectBuildingQuery sourceQuery) {
        targetQuery.setLockMode(sourceQuery.getLockMode());
    }

    public void extendPessimisticLockScopeInSourceQuery(ObjectLevelReadQuery sourceQuery) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive exception aggregation
     */
    public Object extractResultFromBatchQuery(ReadQuery batchQuery, CacheKey parentCacheKey, AbstractRecord sourceRow, AbstractSession session, ObjectLevelReadQuery originalQuery) throws QueryException {
        Map<Object, Object> batchedObjects = null;
        Object result = null;
        Object sourceKey = this.extractBatchKeyFromRow(sourceRow, session);
        if (sourceKey == null) {
            return null;
        }
        Object cachedObject = this.checkCacheForBatchKey(sourceRow, sourceKey, batchedObjects, batchQuery, originalQuery, session);
        if (cachedObject != null) {
            return cachedObject;
        }
        ReadQuery readQuery = batchQuery;
        synchronized (readQuery) {
            batchedObjects = batchQuery.getBatchObjects();
            BatchFetchPolicy originalPolicy = originalQuery.getBatchFetchPolicy();
            if (batchedObjects == null) {
                batchedObjects = new Hashtable<Object, Object>();
                batchQuery.setBatchObjects(batchedObjects);
            } else {
                result = batchedObjects.get(sourceKey);
                if (result == Helper.NULL_VALUE) {
                    return null;
                }
                if (result != null || !originalPolicy.isIN()) {
                    return result;
                }
            }
            if (result == null) {
                AbstractRecord translationRow = originalQuery.getTranslationRow();
                if (originalPolicy.isIN()) {
                    void var21_28;
                    void var21_22;
                    List<AbstractRecord> parentRows = originalPolicy.getDataResults(this);
                    int rowsSize = parentRows.size();
                    int size = Math.min(rowsSize, originalPolicy.getSize());
                    if (size == 0) {
                        return null;
                    }
                    int startIndex = 0;
                    if (size != rowsSize) {
                        startIndex = parentRows.indexOf(sourceRow);
                    }
                    ArrayList<List<Object>> foreignKeyValues = new ArrayList<List<Object>>(size);
                    HashSet<Object> foreignKeys = new HashSet<Object>(size);
                    int index = 0;
                    int offset = startIndex;
                    boolean bl = false;
                    while (var21_22 < size) {
                        AbstractRecord abstractRecord;
                        if (index >= rowsSize) break;
                        if (offset + index >= rowsSize) {
                            offset = index * -1;
                        }
                        if ((abstractRecord = parentRows.get(offset + index)) != null) {
                            Object foreignKey = this.extractBatchKeyFromRow(abstractRecord, session);
                            if (foreignKey == null) {
                                --var21_22;
                            } else {
                                cachedObject = this.checkCacheForBatchKey(abstractRecord, foreignKey, batchedObjects, batchQuery, originalQuery, session);
                                if (cachedObject != null) {
                                    --var21_22;
                                } else if (foreignKeys.contains(foreignKey)) {
                                    --var21_22;
                                } else {
                                    Object[] key = ((CacheId)foreignKey).getPrimaryKey();
                                    List<Object> foreignKeyValue = key[0];
                                    if (key.length > 1) {
                                        foreignKeyValue = Arrays.asList(key);
                                    }
                                    foreignKeyValues.add(foreignKeyValue);
                                    foreignKeys.add(foreignKey);
                                }
                            }
                        }
                        ++index;
                        ++var21_22;
                    }
                    Object var21_23 = null;
                    if (startIndex == 0) {
                        ArrayList<AbstractRecord> arrayList = new ArrayList<AbstractRecord>(parentRows.subList(index, rowsSize));
                    } else if (startIndex == offset) {
                        ArrayList<AbstractRecord> arrayList = new ArrayList<AbstractRecord>(parentRows.subList(0, startIndex - 1));
                        arrayList.addAll(parentRows.subList(index, rowsSize));
                    } else if (offset + index >= startIndex - 1) {
                        ArrayList arrayList = new ArrayList(0);
                    } else {
                        ArrayList<AbstractRecord> arrayList = new ArrayList<AbstractRecord>(parentRows.subList(offset + index, startIndex - 1));
                    }
                    originalPolicy.setDataResults(this, (List<AbstractRecord>)var21_28);
                    translationRow = translationRow.clone();
                    translationRow.put(QUERY_BATCH_PARAMETER, (Object)foreignKeyValues);
                    for (Object e : foreignKeys) {
                        batchedObjects.put(e, Helper.NULL_VALUE);
                    }
                } else if (batchQuery.isReadAllQuery() && ((ReadAllQuery)batchQuery).getBatchFetchPolicy().isIN()) {
                    throw QueryException.originalQueryMustUseBatchIN(this, originalQuery);
                }
                this.executeBatchQuery(batchQuery, parentCacheKey, batchedObjects, session, translationRow);
                batchQuery.setSession(null);
            }
        }
        result = batchedObjects.get(sourceKey);
        if (result == Helper.NULL_VALUE) {
            return null;
        }
        return result;
    }

    protected Object extractBatchKeyFromRow(AbstractRecord targetRow, AbstractSession session) {
        throw QueryException.batchReadingNotSupported(this, null);
    }

    @Override
    public abstract void collectQueryParameters(Set<DatabaseField> var1);

    protected Object checkCacheForBatchKey(AbstractRecord sourceRow, Object foreignKey, Map batchObjects, ReadQuery batchQuery, ObjectLevelReadQuery originalQuery, AbstractSession session) {
        return null;
    }

    protected void executeBatchQuery(DatabaseQuery query, CacheKey parentCacheKey, Map referenceObjectsByKey, AbstractSession session, AbstractRecord row) {
        throw QueryException.batchReadingNotSupported(this, query);
    }

    public ObjectLevelReadQuery prepareNestedJoins(JoinedAttributeManager joinManager, ObjectBuildingQuery baseQuery, AbstractSession session) {
        ObjectLevelReadQuery nestedQuery = (ObjectLevelReadQuery)((ObjectLevelReadQuery)this.getSelectionQuery()).deepClone();
        nestedQuery.setSession(session);
        if (baseQuery.hasPartialAttributeExpressions()) {
            nestedQuery.setPartialAttributeExpressions(this.extractNestedExpressions(((ObjectLevelReadQuery)baseQuery).getPartialAttributeExpressions(), nestedQuery.getExpressionBuilder(), false));
            if (nestedQuery.getPartialAttributeExpressions().isEmpty() && this.hasRootExpressionThatShouldUseOuterJoin(((ObjectLevelReadQuery)baseQuery).getPartialAttributeExpressions())) {
                nestedQuery.setShouldBuildNullForNullPk(true);
            }
        } else {
            List<Expression> nestedJoins;
            FetchGroup targetFetchGroup;
            FetchGroup sourceFG;
            if (nestedQuery.getDescriptor().hasFetchGroupManager() && (sourceFG = baseQuery.getExecutionFetchGroup()) != null && (targetFetchGroup = sourceFG.getGroup(this.getAttributeName())) != null) {
                nestedQuery.setFetchGroup(targetFetchGroup);
                nestedQuery.prepareFetchGroup();
            }
            if ((nestedJoins = this.extractNestedExpressions(joinManager.getJoinedAttributeExpressions(), nestedQuery.getExpressionBuilder(), false)).size() > 0) {
                nestedQuery.getJoinedAttributeManager().clear();
                nestedQuery.getJoinedAttributeManager().setJoinedAttributeExpressions_(nestedJoins);
                nestedQuery.getJoinedAttributeManager().prepareJoinExpressions(session);
                nestedQuery.getJoinedAttributeManager().computeJoiningMappingQueries(session);
                nestedQuery.getJoinedAttributeManager().computeJoiningMappingIndexes(true, session, 0);
            } else if (nestedQuery.hasJoining()) {
                nestedQuery.setJoinedAttributeManager(null);
            }
            if (baseQuery.isLockQuery()) {
                if (((ObjectLevelReadQuery)baseQuery).getLockingClause().isForUpdateOfClause()) {
                    ForUpdateOfClause clause = (ForUpdateOfClause)((ObjectLevelReadQuery)baseQuery).getLockingClause().clone();
                    clause.setLockedExpressions(this.extractNestedExpressions(clause.getLockedExpressions(), nestedQuery.getExpressionBuilder(), true));
                    nestedQuery.setLockingClause(clause);
                } else {
                    nestedQuery.setLockingClause(((ObjectLevelReadQuery)baseQuery).getLockingClause());
                }
            }
        }
        nestedQuery.setShouldMaintainCache(baseQuery.shouldMaintainCache());
        nestedQuery.setShouldRefreshIdentityMapResult(baseQuery.shouldRefreshIdentityMapResult());
        if (baseQuery.isObjectLevelReadQuery() && ((ObjectLevelReadQuery)baseQuery).hasAsOfClause()) {
            nestedQuery.setAsOfClause(((ObjectLevelReadQuery)baseQuery).getAsOfClause());
        }
        nestedQuery.setCascadePolicy(baseQuery.getCascadePolicy());
        if (nestedQuery.hasJoining()) {
            nestedQuery.getJoinedAttributeManager().computeJoiningMappingQueries(session);
        }
        nestedQuery.setSession(null);
        nestedQuery.setRequiresDeferredLocks(baseQuery.requiresDeferredLocks());
        return nestedQuery;
    }

    protected void postPrepareNestedBatchQuery(ReadQuery batchQuery, ObjectLevelReadQuery query) {
    }

    protected Expression buildBatchCriteria(ExpressionBuilder builder, ObjectLevelReadQuery query) {
        throw QueryException.batchReadingNotSupported(this, null);
    }

    public ReadQuery prepareNestedBatchQuery(ObjectLevelReadQuery query) {
        FetchGroup targetFetchGroup;
        FetchGroup sourceFetchGruop;
        ReadQuery mappingQuery;
        ClassDescriptor descriptorToUse = query.getDescriptor();
        if (descriptorToUse != this.descriptor && !descriptorToUse.getMappings().contains(this) && !this.descriptor.isDescriptorTypeAggregate()) {
            descriptorToUse = this.descriptor;
        }
        ExpressionBuilder builder = new ExpressionBuilder(this.referenceClass);
        builder.setQueryClassAndDescriptor(this.referenceClass, this.getReferenceDescriptor());
        ReadAllQuery batchQuery = new ReadAllQuery(this.referenceClass, builder);
        batchQuery.setName(this.getAttributeName());
        batchQuery.setDescriptor(this.getReferenceDescriptor());
        batchQuery.setSession(query.getSession());
        batchQuery.setShouldUseWrapperPolicy(false);
        if (query.shouldCascadeAllParts() || query.shouldCascadePrivateParts() && this.isPrivateOwned() || query.shouldCascadeByMapping() && this.cascadeRefresh) {
            batchQuery.setShouldRefreshIdentityMapResult(query.shouldRefreshIdentityMapResult());
            batchQuery.setCascadePolicy(query.getCascadePolicy());
            batchQuery.setShouldMaintainCache(query.shouldMaintainCache());
            if (query.hasAsOfClause()) {
                batchQuery.setAsOfClause(query.getAsOfClause());
            }
            batchQuery.setShouldBindAllParameters(query.getShouldBindAllParameters());
            batchQuery.setShouldPrepare(query.shouldPrepare());
        }
        batchQuery.setShouldOuterJoinSubclasses(query.shouldOuterJoinSubclasses());
        batchQuery.setQueryId(query.getQueryId());
        Expression batchSelectionCriteria = null;
        BatchFetchType batchType = query.getBatchFetchPolicy().getType();
        if (this.batchFetchType != null) {
            batchType = this.batchFetchType;
        }
        if (batchType == BatchFetchType.EXISTS) {
            ExpressionBuilder subBuilder = new ExpressionBuilder(descriptorToUse.getJavaClass());
            subBuilder.setQueryClassAndDescriptor(descriptorToUse.getJavaClass(), descriptorToUse);
            ReportQuery subQuery = new ReportQuery(descriptorToUse.getJavaClass(), subBuilder);
            subQuery.setDescriptor(descriptorToUse);
            subQuery.setShouldRetrieveFirstPrimaryKey(true);
            Object subCriteria = subBuilder.twist(this.getSelectionCriteria(), builder);
            if (query.getSelectionCriteria() != null) {
                subCriteria = query.getSelectionCriteria().cloneUsing(subBuilder).and((Expression)subCriteria);
            }
            if (descriptorToUse.getHistoryPolicy() != null) {
                if (query.getSession().getAsOfClause() != null) {
                    subBuilder.asOf(query.getSession().getAsOfClause());
                } else if (batchQuery.getAsOfClause() == null) {
                    subBuilder.asOf(AsOfClause.NO_CLAUSE);
                } else {
                    subBuilder.asOf(batchQuery.getAsOfClause());
                }
            }
            subQuery.setSelectionCriteria((Expression)subCriteria);
            batchSelectionCriteria = builder.exists(subQuery);
        } else if (batchType == BatchFetchType.IN) {
            batchSelectionCriteria = this.buildBatchCriteria(builder, query);
        } else {
            Expression backRef = builder.getManualQueryKey(String.valueOf(this.getAttributeName()) + "-back-ref", descriptorToUse);
            batchSelectionCriteria = backRef.twist(this.getSelectionCriteria(), builder);
            if (query.getSelectionCriteria() != null) {
                batchSelectionCriteria = batchSelectionCriteria.and(query.getSelectionCriteria().cloneUsing(backRef));
            }
            if (descriptorToUse.getQueryManager().getAdditionalJoinExpression() != null) {
                batchSelectionCriteria = batchSelectionCriteria.and(descriptorToUse.getQueryManager().getAdditionalJoinExpression().rebuildOn(backRef));
            }
            if (descriptorToUse.getHistoryPolicy() != null) {
                if (query.getSession().getAsOfClause() != null) {
                    backRef.asOf(query.getSession().getAsOfClause());
                } else if (batchQuery.getAsOfClause() == null) {
                    backRef.asOf(AsOfClause.NO_CLAUSE);
                } else {
                    backRef.asOf(batchQuery.getAsOfClause());
                }
                batchSelectionCriteria = batchSelectionCriteria.and(descriptorToUse.getHistoryPolicy().additionalHistoryExpression(backRef, backRef));
            }
        }
        batchQuery.setSelectionCriteria(batchSelectionCriteria);
        if (query.isDistinctComputed()) {
            batchQuery.setDistinctState(query.getDistinctState());
        }
        if ((mappingQuery = this.selectionQuery).isReadAllQuery()) {
            batchQuery.setOrderByExpressions(new ArrayList<Expression>(((ReadAllQuery)mappingQuery).getOrderByExpressions()));
            if (((ReadAllQuery)mappingQuery).hasBatchReadAttributes()) {
                for (Expression expression : ((ReadAllQuery)mappingQuery).getBatchReadAttributeExpressions()) {
                    batchQuery.addBatchReadAttribute(expression);
                }
            }
        }
        if (query.hasBatchReadAttributes()) {
            for (Expression expression : query.getBatchReadAttributeExpressions()) {
                ObjectExpression batchReadExpression = (ObjectExpression)expression;
                ExpressionBuilder expressionBuilder = batchReadExpression.getBuilder();
                if (expressionBuilder.getQueryClass() != null) continue;
                expressionBuilder.setSession(query.getSession().getRootSession(null));
                expressionBuilder.setQueryClass(query.getReferenceClass());
            }
            List<Expression> nestedExpressions = this.extractNestedExpressions(query.getBatchReadAttributeExpressions(), batchQuery.getExpressionBuilder(), false);
            batchQuery.getBatchReadAttributeExpressions().addAll(nestedExpressions);
        }
        batchQuery.setBatchFetchType(batchType);
        batchQuery.setBatchFetchSize(query.getBatchFetchPolicy().getSize());
        this.postPrepareNestedBatchQuery(batchQuery, query);
        if (batchQuery.getDescriptor().hasFetchGroupManager() && (sourceFetchGruop = query.getExecutionFetchGroup()) != null && (targetFetchGroup = sourceFetchGruop.getGroup(this.getAttributeName())) != null) {
            batchQuery.setFetchGroup(targetFetchGroup);
        }
        if (batchQuery.shouldPrepare()) {
            batchQuery.checkPrepare(query.getSession(), query.getTranslationRow());
        }
        batchQuery.setSession(null);
        return batchQuery;
    }

    @Override
    public void fixObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, DistributedSession session) {
        this.indirectionPolicy.fixObjectReferences(object, objectDescriptors, processedObjects, query, session);
    }

    @Override
    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
        Object attributeValue = super.getAttributeValueFromObject(object);
        Object indirectionValue = this.indirectionPolicy.validateAttributeOfInstantiatedObject(attributeValue);
        if (indirectionValue != attributeValue) {
            this.setAttributeValueInObject(object, indirectionValue);
            attributeValue = indirectionValue;
        }
        return attributeValue;
    }

    public Object getAttributeValueWithClonedValueHolders(Object object) {
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue instanceof DatabaseValueHolder) {
            return ((DatabaseValueHolder)attributeValue).clone();
        }
        if (attributeValue instanceof ValueHolder) {
            return ((ValueHolder)attributeValue).clone();
        }
        return attributeValue;
    }

    public Collection getFieldsForTranslationInAggregate() {
        return new NonSynchronizedVector(0);
    }

    protected ReadQuery getExtendPessimisticLockScopeDedicatedQuery(AbstractSession session, short lockMode) {
        return null;
    }

    public IndirectionPolicy getIndirectionPolicy() {
        return this.indirectionPolicy;
    }

    @Override
    public boolean isAttributeValueFromObjectInstantiated(Object object) {
        return this.indirectionPolicy.objectIsInstantiated(this.getAttributeValueFromObject(object));
    }

    public Expression getJoinCriteria(ObjectExpression context, Expression base) {
        Expression selectionCriteria = this.getSelectionCriteria();
        return context.getBaseExpression().twist(selectionCriteria, base);
    }

    @Override
    public Object getObjectCorrespondingTo(Object object, DistributedSession session, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query) {
        return session.getObjectCorrespondingTo(object, objectDescriptors, processedObjects, query);
    }

    @Override
    public Object getRealAttributeValueFromAttribute(Object attributeValue, Object object, AbstractSession session) {
        return this.indirectionPolicy.getRealAttributeValueFromObject(object, attributeValue);
    }

    @Override
    public boolean isLazy() {
        if (this.isLazy == null) {
            this.isLazy = this.usesIndirection();
        }
        return this.isLazy;
    }

    @Override
    public boolean isLockableMapping() {
        return !this.usesIndirection() && !this.referenceDescriptor.getCachePolicy().isIsolated();
    }

    @Override
    public void instantiateAttribute(Object object, AbstractSession session) {
        this.indirectionPolicy.instantiateObject(object, this.getAttributeValueFromObject(object));
    }

    public Class getReferenceClass() {
        return this.referenceClass;
    }

    public String getReferenceClassName() {
        if (this.referenceClassName == null && this.referenceClass != null) {
            this.referenceClassName = this.referenceClass.getName();
        }
        return this.referenceClassName;
    }

    @Override
    public ClassDescriptor getReferenceDescriptor() {
        if (this.referenceDescriptor == null) {
            if (this.getTempSession() == null) {
                return null;
            }
            this.referenceDescriptor = this.getTempSession().getDescriptor(this.getReferenceClass());
        }
        return this.referenceDescriptor;
    }

    @Override
    public DatabaseMapping getRelationshipPartner() {
        if (this.relationshipPartner == null && this.relationshipPartnerAttributeName != null) {
            this.setRelationshipPartner(this.getReferenceDescriptor().getObjectBuilder().getMappingForAttributeName(this.getRelationshipPartnerAttributeName()));
        }
        return this.relationshipPartner;
    }

    public String getRelationshipPartnerAttributeName() {
        return this.relationshipPartnerAttributeName;
    }

    public Expression getSelectionCriteria() {
        return this.getSelectionQuery().getSelectionCriteria();
    }

    public ReadQuery getSelectionQuery() {
        return this.selectionQuery;
    }

    protected AbstractSession getTempSession() {
        return this.tempInitSession;
    }

    @Override
    public Object getValueFromRemoteValueHolder(RemoteValueHolder remoteValueHolder) {
        return this.indirectionPolicy.getValueFromRemoteValueHolder(remoteValueHolder);
    }

    public boolean hasCustomSelectionQuery() {
        return this.hasCustomSelectionQuery;
    }

    @Override
    public void preInitialize(AbstractSession session) throws DescriptorException {
        Class attributeType;
        super.preInitialize(session);
        if (this.indirectionPolicy instanceof BasicIndirectionPolicy && ClassConstants.PersistenceWeavedLazy_Class.isAssignableFrom(this.getDescriptor().getJavaClass()) && !ClassConstants.ValueHolderInterface_Class.isAssignableFrom(attributeType = this.getAttributeAccessor().getAttributeClass())) {
            if (!this.indirectionPolicy.isWeavedObjectBasicIndirectionPolicy()) {
                if (this.getAttributeAccessor().isMethodAttributeAccessor()) {
                    this.useWeavedIndirection(this.getGetMethodName(), this.getSetMethodName(), true);
                } else if (this.getAttributeAccessor().isInstanceVariableAttributeAccessor()) {
                    this.useWeavedIndirection(Helper.getWeavedGetMethodName(this.getAttributeName()), Helper.getWeavedSetMethodName(this.getAttributeName()), false);
                }
            }
            this.setGetMethodName(Helper.getWeavedValueHolderGetMethodName(this.getAttributeName()));
            this.setSetMethodName(Helper.getWeavedValueHolderSetMethodName(this.getAttributeName()));
            super.preInitialize(session);
        }
        if (this.getPartitioningPolicyName() != null) {
            PartitioningPolicy policy = session.getProject().getPartitioningPolicy(this.getPartitioningPolicyName());
            if (policy == null) {
                session.getIntegrityChecker().handleError(DescriptorException.missingPartitioningPolicy(this.getPartitioningPolicyName(), null, this));
            }
            this.setPartitioningPolicy(policy);
        }
        if (this.isCascadeOnDeleteSetOnDatabase && !session.getPlatform().supportsDeleteOnCascade()) {
            this.isCascadeOnDeleteSetOnDatabase = false;
        }
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (this.isPrivateOwned && this.descriptor != null) {
            this.descriptor.addMappingsPostCalculateChanges(this);
        }
        this.initializeReferenceDescriptor(session);
        this.initializeSelectionQuery(session);
        this.indirectionPolicy.initialize();
        if (this.referenceDescriptor != null && this.referenceDescriptor.getCachePolicy().isIsolated()) {
            this.isCacheable = false;
        }
    }

    protected void initializeReferenceDescriptor(AbstractSession session) throws DescriptorException {
        if (this.getReferenceClass() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        ClassDescriptor refDescriptor = session.getDescriptor(this.getReferenceClass());
        if (refDescriptor == null) {
            throw DescriptorException.descriptorIsMissing(this.getReferenceClass().getName(), this);
        }
        if (refDescriptor.isAggregateDescriptor() && !this.isAggregateCollectionMapping()) {
            throw DescriptorException.referenceDescriptorCannotBeAggregate(this);
        }
        this.setReferenceDescriptor(refDescriptor);
    }

    public boolean isAttributeValueFullyBuilt(Object object) {
        Object attributeValue = super.getAttributeValueFromObject(object);
        return this.indirectionPolicy.isAttributeValueFullyBuilt(attributeValue);
    }

    protected void initializeSelectionQuery(AbstractSession session) throws DescriptorException {
        if (((ObjectLevelReadQuery)this.getSelectionQuery()).getReferenceClass() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        this.getSelectionQuery().setName(this.getAttributeName());
        this.getSelectionQuery().setDescriptor(this.getReferenceDescriptor());
        this.getSelectionQuery().setSourceMapping(this);
        if (this.getSelectionQuery().getPartitioningPolicy() == null) {
            this.getSelectionQuery().setPartitioningPolicy(this.getPartitioningPolicy());
        }
    }

    public boolean isAttributeValueInstantiated(Object object) {
        return this.indirectionPolicy.objectIsInstantiated(this.getAttributeValueFromObject(object));
    }

    public boolean isCascadeDetach() {
        return this.cascadeDetach;
    }

    public boolean isCascadePersist() {
        return this.cascadePersist;
    }

    public boolean isCascadeMerge() {
        return this.cascadeMerge;
    }

    public boolean isCascadeRefresh() {
        return this.cascadeRefresh;
    }

    public boolean isCascadeRemove() {
        return this.cascadeRemove;
    }

    @Override
    public boolean hasDependency() {
        return this.isPrivateOwned() || this.isCascadeRemove();
    }

    @Override
    public boolean isForeignReferenceMapping() {
        return true;
    }

    @Override
    public boolean isJoiningSupported() {
        return false;
    }

    @Override
    public boolean isPrivateOwned() {
        return this.isPrivateOwned;
    }

    @Override
    public void iterate(DescriptorIterator iterator) {
        Object attributeValue = this.getAttributeValueFromObject(iterator.getVisitedParent());
        this.indirectionPolicy.iterateOnAttributeValue(iterator, attributeValue);
    }

    @Override
    public abstract void iterateOnRealAttributeValue(DescriptorIterator var1, Object var2);

    @Override
    public void load(Object object, AttributeItem item, AbstractSession session) {
        this.instantiateAttribute(object, session);
        if (item.getGroup() != null) {
            Object value = this.getRealAttributeValueFromObject(object, session);
            session.load(value, item.getGroup());
        }
    }

    public void mergeRemoteValueHolder(Object clientSideDomainObject, Object serverSideDomainObject, MergeManager mergeManager) {
        this.indirectionPolicy.mergeRemoteValueHolder(clientSideDomainObject, serverSideDomainObject, mergeManager);
    }

    public void privateOwnedRelationship() {
        this.setIsPrivateOwned(true);
    }

    @Override
    public Object readFromRowIntoObject(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object targetObject, CacheKey parentCacheKey, ObjectBuildingQuery sourceQuery, AbstractSession executionSession, boolean isTargetProtected) throws DatabaseException {
        Boolean[] wasCacheUsed = new Boolean[]{Boolean.FALSE};
        Object attributeValue = this.valueFromRow(databaseRow, joinManager, sourceQuery, parentCacheKey, executionSession, isTargetProtected, wasCacheUsed);
        if (wasCacheUsed[0].booleanValue()) {
            Integer refreshCascade = null;
            if (sourceQuery != null && sourceQuery.isObjectBuildingQuery() && sourceQuery.shouldRefreshIdentityMapResult()) {
                refreshCascade = sourceQuery.getCascadePolicy();
            }
            attributeValue = this.indirectionPolicy.cloneAttribute(attributeValue, parentCacheKey.getObject(), parentCacheKey, targetObject, refreshCascade, executionSession, false);
        }
        if (executionSession.isUnitOfWork() && sourceQuery.shouldRefreshIdentityMapResult()) {
            boolean wasAttributeValueFullyBuilt = this.isAttributeValueFullyBuilt(targetObject);
            Object oldAttribute = this.getAttributeValueFromObject(targetObject);
            this.setAttributeValueInObject(targetObject, attributeValue);
            if (wasAttributeValueFullyBuilt && this.indirectionPolicy.objectIsInstantiatedOrChanged(oldAttribute)) {
                this.indirectionPolicy.instantiateObject(targetObject, attributeValue);
            }
        } else {
            this.setAttributeValueInObject(targetObject, attributeValue);
        }
        if (parentCacheKey != null) {
            this.indirectionPolicy.setSourceObject(parentCacheKey.getObject(), attributeValue);
        }
        return attributeValue;
    }

    @Override
    public void remoteInitialization(DistributedSession session) {
        super.remoteInitialization(session);
        this.setTempSession(session);
    }

    @Override
    public Map replaceValueHoldersIn(Object object, RemoteSessionController controller) {
        return controller.replaceValueHoldersIn(object);
    }

    public boolean requiresTransientWeavedFields() {
        return this.requiresTransientWeavedFields;
    }

    public void setCascadeAll(boolean value) {
        this.setCascadePersist(value);
        this.setCascadeMerge(value);
        this.setCascadeRefresh(value);
        this.setCascadeRemove(value);
        this.setCascadeDetach(value);
    }

    public void setCascadeDetach(boolean value) {
        this.cascadeDetach = value;
    }

    public void setCascadePersist(boolean value) {
        this.cascadePersist = value;
    }

    public void setCascadeMerge(boolean value) {
        this.cascadeMerge = value;
    }

    public void setCascadeRefresh(boolean value) {
        this.cascadeRefresh = value;
    }

    public void setCascadeRemove(boolean value) {
        this.cascadeRemove = value;
    }

    public void setCustomSelectionQuery(ReadQuery query) {
        this.setSelectionQuery(query);
        this.setHasCustomSelectionQuery(true);
    }

    protected void setHasCustomSelectionQuery(boolean bool) {
        this.hasCustomSelectionQuery = bool;
    }

    public void setForceInitializationOfSelectionCriteria(boolean bool) {
        this.forceInitializationOfSelectionCriteria = bool;
    }

    public void setIndirectionPolicy(IndirectionPolicy indirectionPolicy) {
        this.indirectionPolicy = indirectionPolicy;
        indirectionPolicy.setMapping(this);
    }

    public void setIsPrivateOwned(boolean isPrivateOwned) {
        if (this.descriptor != null && !this.isMapKeyMapping()) {
            if (isPrivateOwned && !this.isPrivateOwned) {
                this.descriptor.addMappingsPostCalculateChanges(this);
                if (this.getDescriptor().hasInheritance()) {
                    for (ClassDescriptor descriptor : this.getDescriptor().getInheritancePolicy().getAllChildDescriptors()) {
                        descriptor.addMappingsPostCalculateChanges(this);
                    }
                }
            } else if (!isPrivateOwned && this.isPrivateOwned) {
                this.descriptor.getMappingsPostCalculateChanges().remove(this);
                if (this.getDescriptor().hasInheritance()) {
                    for (ClassDescriptor descriptor : this.getDescriptor().getInheritancePolicy().getAllChildDescriptors()) {
                        descriptor.getMappingsPostCalculateChanges().remove(this);
                    }
                }
            }
        }
        this.isPrivateOwned = isPrivateOwned;
    }

    @Override
    public void setRealAttributeValueInObject(Object object, Object value) throws DescriptorException {
        this.indirectionPolicy.setRealAttributeValueInObject(object, value);
    }

    public void setReferenceClass(Class referenceClass) {
        this.referenceClass = referenceClass;
        if (referenceClass != null) {
            this.setReferenceClassName(referenceClass.getName());
            this.setSelectionQuery(this.getSelectionQuery());
        }
    }

    public void setReferenceClassName(String referenceClassName) {
        this.referenceClassName = referenceClassName;
    }

    protected void setReferenceDescriptor(ClassDescriptor aDescriptor) {
        this.referenceDescriptor = aDescriptor;
    }

    public void setRelationshipPartner(DatabaseMapping mapping) {
        this.relationshipPartner = mapping;
    }

    public void setRelationshipPartnerAttributeName(String attributeName) {
        this.relationshipPartnerAttributeName = attributeName;
    }

    public void setRequiresTransientWeavedFields(boolean requiresTransientWeavedFields) {
        this.requiresTransientWeavedFields = requiresTransientWeavedFields;
    }

    public void setSelectionCriteria(Expression anExpression) {
        this.getSelectionQuery().setSelectionCriteria(anExpression);
    }

    protected void setSelectionQuery(ReadQuery aQuery) {
        this.selectionQuery = aQuery;
        if (this.selectionQuery != null && this.selectionQuery.isObjectLevelReadQuery() && this.selectionQuery.getReferenceClassName() == null) {
            ((ObjectLevelReadQuery)this.selectionQuery).setReferenceClass(this.getReferenceClass());
        }
    }

    public void setSelectionSQLString(String sqlString) {
        this.getSelectionQuery().setSQLString(sqlString);
        this.setCustomSelectionQuery(this.getSelectionQuery());
    }

    public void setSelectionCall(Call call) {
        this.getSelectionQuery().setCall(call);
        this.setCustomSelectionQuery(this.getSelectionQuery());
    }

    public void setShouldExtendPessimisticLockScope(boolean shouldExtend) {
        this.extendPessimisticLockScope = shouldExtend ? ExtendPessimisticLockScope.TARGET_QUERY : ExtendPessimisticLockScope.NONE;
    }

    protected void setTempSession(AbstractSession session) {
        this.tempInitSession = session;
    }

    public void setUsesBatchReading(boolean usesBatchReading) {
        if (usesBatchReading) {
            this.setBatchFetchType(BatchFetchType.JOIN);
        } else {
            this.setBatchFetchType(null);
        }
    }

    public void setUsesIndirection(boolean usesIndirection) {
        if (usesIndirection) {
            this.useBasicIndirection();
        } else {
            this.dontUseIndirection();
        }
    }

    public boolean shouldExtendPessimisticLockScope() {
        return this.extendPessimisticLockScope != ExtendPessimisticLockScope.NONE;
    }

    public boolean shouldExtendPessimisticLockScopeInSourceQuery() {
        return this.extendPessimisticLockScope == ExtendPessimisticLockScope.SOURCE_QUERY;
    }

    public boolean shouldExtendPessimisticLockScopeInTargetQuery() {
        return this.extendPessimisticLockScope == ExtendPessimisticLockScope.TARGET_QUERY;
    }

    public boolean shouldExtendPessimisticLockScopeInDedicatedQuery() {
        return this.extendPessimisticLockScope == ExtendPessimisticLockScope.DEDICATED_QUERY;
    }

    protected boolean shouldForceInitializationOfSelectionCriteria() {
        return this.forceInitializationOfSelectionCriteria;
    }

    protected boolean shouldInitializeSelectionCriteria() {
        if (this.shouldForceInitializationOfSelectionCriteria()) {
            return true;
        }
        if (this.hasCustomSelectionQuery()) {
            return false;
        }
        return this.getSelectionCriteria() == null;
    }

    public boolean shouldMergeCascadeParts(MergeManager mergeManager) {
        return mergeManager.shouldCascadeByMapping() && (this.isCascadeMerge() && !mergeManager.isForRefresh() || this.isCascadeRefresh() && mergeManager.isForRefresh()) || mergeManager.shouldCascadeAllParts() || mergeManager.shouldCascadePrivateParts() && this.isPrivateOwned();
    }

    public boolean shouldRefreshCascadeParts(MergeManager mergeManager) {
        return mergeManager.shouldCascadeByMapping() && this.isCascadeRefresh() || mergeManager.shouldCascadeAllParts() || mergeManager.shouldCascadePrivateParts() && this.isPrivateOwned();
    }

    protected boolean shouldMergeCascadeReference(MergeManager mergeManager) {
        if (mergeManager.shouldCascadeReferences()) {
            return true;
        }
        return this.shouldMergeCascadeParts(mergeManager);
    }

    protected boolean shouldObjectModifyCascadeToParts(ObjectLevelModifyQuery query) {
        if (this.isReadOnly) {
            return false;
        }
        if (query.shouldCascadeOnlyDependentParts()) {
            return this.hasConstraintDependency();
        }
        if (this.isPrivateOwned) {
            return true;
        }
        return query.shouldCascadeAllParts();
    }

    public boolean shouldUseBatchReading() {
        return this.batchFetchType != null;
    }

    public void useBasicIndirection() {
        this.setIndirectionPolicy(new BasicIndirectionPolicy());
    }

    public void useBatchReading() {
        this.setBatchFetchType(BatchFetchType.JOIN);
    }

    public void useWeavedIndirection(String getMethodName, String setMethodName, boolean hasUsedMethodAccess) {
        this.setIndirectionPolicy(new WeavedObjectBasicIndirectionPolicy(getMethodName, setMethodName, null, hasUsedMethodAccess));
    }

    public void useContainerIndirection(Class containerClass) {
        ContainerIndirectionPolicy policy = new ContainerIndirectionPolicy();
        policy.setContainerClass(containerClass);
        this.setIndirectionPolicy(policy);
    }

    public boolean usesIndirection() {
        return this.indirectionPolicy.usesIndirection();
    }

    public abstract void updateChangeRecordForSelfMerge(ChangeRecord var1, Object var2, Object var3, UnitOfWorkChangeSet var4, UnitOfWorkImpl var5);

    public void setJoinFetch(int joinFetch) {
        this.joinFetch = joinFetch;
    }

    public int getJoinFetch() {
        return this.joinFetch;
    }

    public void setMappedBy(String mappedBy) {
        this.mappedBy = mappedBy;
    }

    public boolean isJoinFetched() {
        return this.getJoinFetch() != 0;
    }

    public boolean isInnerJoinFetched() {
        return this.getJoinFetch() == 1;
    }

    public boolean isOuterJoinFetched() {
        return this.getJoinFetch() == 2;
    }

    public void useInnerJoinFetch() {
        this.setJoinFetch(1);
    }

    public void useOuterJoinFetch() {
        this.setJoinFetch(2);
    }

    public boolean isCascadeOnDeleteSetOnDatabase() {
        return this.isCascadeOnDeleteSetOnDatabase;
    }

    public void setIsCascadeOnDeleteSetOnDatabase(boolean isCascadeOnDeleteSetOnDatabase) {
        this.isCascadeOnDeleteSetOnDatabase = isCascadeOnDeleteSetOnDatabase;
    }

    @Override
    public void setIsCacheable(boolean cacheable) {
        this.isCacheable = cacheable;
    }

    @Override
    public void validateBeforeInitialization(AbstractSession session) throws DescriptorException {
        super.validateBeforeInitialization(session);
        if (this.indirectionPolicy instanceof WeavedObjectBasicIndirectionPolicy && !ClassConstants.PersistenceWeavedLazy_Class.isAssignableFrom(this.getDescriptor().getJavaClass())) {
            Object[] args = new Object[]{this.getAttributeName(), this.getDescriptor().getJavaClass()};
            session.log(6, "metadata", "metadata_warning_ignore_lazy", args);
            this.setIndirectionPolicy(new NoIndirectionPolicy());
        }
        if (this.getAttributeAccessor() instanceof InstanceVariableAttributeAccessor) {
            Class attributeType = ((InstanceVariableAttributeAccessor)this.getAttributeAccessor()).getAttributeType();
            this.indirectionPolicy.validateDeclaredAttributeType(attributeType, session.getIntegrityChecker());
        } else if (this.getAttributeAccessor().isMethodAttributeAccessor()) {
            Class returnType = ((MethodAttributeAccessor)this.getAttributeAccessor()).getGetMethodReturnType();
            this.indirectionPolicy.validateGetMethodReturnType(returnType, session.getIntegrityChecker());
            Class parameterType = ((MethodAttributeAccessor)this.getAttributeAccessor()).getSetMethodParameterType();
            this.indirectionPolicy.validateSetMethodParameterType(parameterType, session.getIntegrityChecker());
        }
    }

    public abstract Object valueFromPKList(Object[] var1, AbstractRecord var2, AbstractSession var3);

    @Override
    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, CacheKey cacheKey, AbstractSession executionSession, boolean isTargetProtected, Boolean[] wasCacheUsed) throws DatabaseException {
        if (this.descriptor.getCachePolicy().isProtectedIsolation()) {
            if (this.isCacheable && isTargetProtected && cacheKey != null) {
                Object cached = cacheKey.getObject();
                if (cached != null) {
                    if (wasCacheUsed != null) {
                        wasCacheUsed[0] = Boolean.TRUE;
                    }
                    return this.getAttributeValueFromObject(cached);
                }
            } else if (!this.isCacheable && !isTargetProtected && cacheKey != null) {
                return this.indirectionPolicy.buildIndirectObject(new ValueHolder(null));
            }
        }
        if (sourceQuery.isObjectLevelReadQuery() && (((ObjectLevelReadQuery)sourceQuery).isAttributeBatchRead(this.descriptor, this.getAttributeName()) || sourceQuery.isReadAllQuery() && this.shouldUseBatchReading())) {
            return this.batchedValueFromRow(row, (ObjectLevelReadQuery)sourceQuery, cacheKey);
        }
        if (this.shouldUseValueFromRowWithJoin(joinManager, sourceQuery)) {
            return this.valueFromRowInternalWithJoin(row, joinManager, sourceQuery, cacheKey, executionSession, isTargetProtected);
        }
        return this.valueFromRowInternal(row, joinManager, sourceQuery, executionSession);
    }

    protected boolean shouldUseValueFromRowWithJoin(JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery) {
        return joinManager != null && joinManager.isAttributeJoined(this.descriptor, this) || sourceQuery.hasPartialAttributeExpressions();
    }

    protected Object valueFromRowInternalWithJoin(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, CacheKey parentCacheKey, AbstractSession executionSession, boolean isTargetProtected) throws DatabaseException {
        throw ValidationException.mappingDoesNotOverrideValueFromRowInternalWithJoin(Helper.getShortClassName(this.getClass()));
    }

    protected Object valueFromRowInternal(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        FetchGroup targetFetchGroup;
        FetchGroup sourceFG;
        ReadQuery targetQuery = this.selectionQuery;
        if (targetQuery.isObjectLevelReadQuery() && targetQuery.getDescriptor().hasFetchGroupManager() && (sourceFG = sourceQuery.getExecutionFetchGroup(this.getDescriptor())) != null && (targetFetchGroup = sourceFG.getGroup(this.getAttributeName())) != null) {
            if (targetQuery.shouldPrepare()) {
                targetQuery.checkPrepare(executionSession, row);
            }
            targetQuery = (ObjectLevelReadQuery)targetQuery.clone();
            targetQuery.setIsExecutionClone(true);
            ((ObjectLevelReadQuery)targetQuery).setFetchGroup(targetFetchGroup);
        }
        if (!this.indirectionPolicy.usesIndirection()) {
            if (targetQuery == this.selectionQuery) {
                if (targetQuery.shouldPrepare()) {
                    targetQuery.checkPrepare(executionSession, row);
                }
                targetQuery = (ObjectLevelReadQuery)targetQuery.clone();
                targetQuery.setIsExecutionClone(true);
            }
            targetQuery.setQueryId(sourceQuery.getQueryId());
            ((ObjectLevelReadQuery)targetQuery).setRequiresDeferredLocks(sourceQuery.requiresDeferredLocks());
        }
        if (targetQuery.isObjectLevelReadQuery()) {
            if (sourceQuery.shouldCascadeAllParts() || this.isPrivateOwned && sourceQuery.shouldCascadePrivateParts() || this.cascadeRefresh && sourceQuery.shouldCascadeByMapping()) {
                if (targetQuery == this.selectionQuery) {
                    if (targetQuery.shouldPrepare()) {
                        targetQuery.checkPrepare(executionSession, row);
                    }
                    targetQuery = (ObjectLevelReadQuery)targetQuery.clone();
                    targetQuery.setIsExecutionClone(true);
                }
                ((ObjectLevelReadQuery)targetQuery).setShouldRefreshIdentityMapResult(sourceQuery.shouldRefreshIdentityMapResult());
                targetQuery.setCascadePolicy(sourceQuery.getCascadePolicy());
                if (targetQuery.shouldMaintainCache()) {
                    targetQuery.setShouldMaintainCache(sourceQuery.shouldMaintainCache());
                }
                if (((ObjectLevelReadQuery)sourceQuery).hasAsOfClause()) {
                    targetQuery.setSelectionCriteria((Expression)targetQuery.getSelectionCriteria().clone());
                    ((ObjectLevelReadQuery)targetQuery).setAsOfClause(((ObjectLevelReadQuery)sourceQuery).getAsOfClause());
                }
            }
            if (this.isExtendingPessimisticLockScope(sourceQuery)) {
                if (this.extendPessimisticLockScope == ExtendPessimisticLockScope.TARGET_QUERY) {
                    if (targetQuery == this.selectionQuery) {
                        if (targetQuery.shouldPrepare()) {
                            targetQuery.checkPrepare(executionSession, row);
                        }
                        targetQuery = (ObjectLevelReadQuery)targetQuery.clone();
                        targetQuery.setIsExecutionClone(true);
                    }
                    this.extendPessimisticLockScopeInTargetQuery((ObjectLevelReadQuery)targetQuery, sourceQuery);
                } else if (this.extendPessimisticLockScope == ExtendPessimisticLockScope.DEDICATED_QUERY) {
                    ReadQuery dedicatedQuery = this.getExtendPessimisticLockScopeDedicatedQuery(executionSession, sourceQuery.getLockMode());
                    executionSession.executeQuery((DatabaseQuery)dedicatedQuery, row);
                }
            }
        }
        targetQuery = this.prepareHistoricalQuery(targetQuery, sourceQuery, executionSession);
        return this.indirectionPolicy.valueFromQuery(targetQuery, row, executionSession);
    }

    protected boolean isExtendingPessimisticLockScope(ObjectBuildingQuery sourceQuery) {
        return sourceQuery.isLockQuery() && sourceQuery.isObjectLevelReadQuery() && ((ObjectLevelReadQuery)sourceQuery).shouldExtendPessimisticLockScope();
    }

    protected ReadQuery prepareHistoricalQuery(ReadQuery targetQuery, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) {
        return targetQuery;
    }

    public AbstractRecord trimRowForJoin(AbstractRecord row, JoinedAttributeManager joinManager, AbstractSession executionSession) {
        Object value;
        if (joinManager != null && joinManager.getJoinedMappingIndexes_() != null && (value = joinManager.getJoinedMappingIndexes_().get(this)) != null) {
            return this.trimRowForJoin(row, value, executionSession);
        }
        return row;
    }

    public AbstractRecord trimRowForJoin(AbstractRecord row, Object value, AbstractSession executionSession) {
        int fieldStartIndex;
        if (value instanceof Integer) {
            fieldStartIndex = (Integer)value;
        } else {
            Map map = (Map)value;
            Class cls = this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().shouldReadSubclasses() ? this.getDescriptor().getInheritancePolicy().classFromRow(row, executionSession) : this.getDescriptor().getJavaClass();
            fieldStartIndex = (Integer)map.get(cls);
        }
        NonSynchronizedSubVector trimedFields = new NonSynchronizedSubVector(row.getFields(), fieldStartIndex, row.size());
        NonSynchronizedSubVector trimedValues = new NonSynchronizedSubVector(row.getValues(), fieldStartIndex, row.size());
        return new DatabaseRecord(trimedFields, trimedValues);
    }

    protected ObjectLevelReadQuery prepareNestedJoinQueryClone(AbstractRecord row, List dataResults, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) {
        ObjectLevelReadQuery nestedQuery = null;
        if (joinManager == null) {
            nestedQuery = this.prepareNestedJoins(joinManager, sourceQuery, executionSession);
            nestedQuery.setSession(executionSession);
            return nestedQuery;
        }
        if (joinManager.getJoinedMappingQueryClones() == null) {
            joinManager.setJoinedMappingQueryClones(new HashMap(5));
        }
        if ((nestedQuery = joinManager.getJoinedMappingQueryClones().get(this)) == null) {
            if (joinManager.getJoinedMappingQueries_() != null) {
                nestedQuery = joinManager.getJoinedMappingQueries_().get(this);
                nestedQuery = (ObjectLevelReadQuery)nestedQuery.clone();
            } else {
                nestedQuery = this.prepareNestedJoins(joinManager, sourceQuery, executionSession);
            }
            nestedQuery.setSession(executionSession);
            nestedQuery.setQueryId(joinManager.getBaseQuery().getQueryId());
            nestedQuery.setExecutionTime(joinManager.getBaseQuery().getExecutionTime());
            joinManager.getJoinedMappingQueryClones().put(this, nestedQuery);
        }
        if (nestedQuery.hasJoining() && nestedQuery.getJoinedAttributeManager().isToManyJoin()) {
            List<Object> nestedDataResults = dataResults;
            if (nestedDataResults == null) {
                Object sourceKey = this.descriptor.getObjectBuilder().extractPrimaryKeyFromRow(row, executionSession);
                nestedDataResults = joinManager.getDataResultsByPrimaryKey().get(sourceKey);
            }
            nestedDataResults = new ArrayList(nestedDataResults);
            Object indexObject = joinManager.getJoinedMappingIndexes_().get(this);
            int index = 0;
            while (index < nestedDataResults.size()) {
                AbstractRecord sourceRow = (AbstractRecord)nestedDataResults.get(index);
                nestedDataResults.set(index, this.trimRowForJoin(sourceRow, indexObject, executionSession));
                ++index;
            }
            nestedQuery.getJoinedAttributeManager().setDataResults(nestedDataResults, executionSession);
        }
        nestedQuery.setRequiresDeferredLocks(sourceQuery.requiresDeferredLocks());
        return nestedQuery;
    }

    public BatchFetchType getBatchFetchType() {
        return this.batchFetchType;
    }

    public void setBatchFetchType(BatchFetchType batchFetchType) {
        this.batchFetchType = batchFetchType;
    }

    public void addTargetForeignKeyField(DatabaseField targetForeignKeyField, DatabaseField sourcePrimaryKeyField) {
        throw new UnsupportedOperationException("addTargetForeignKeyField");
    }

    public void addForeignKeyField(DatabaseField sourceForeignKeyField, DatabaseField targetPrimaryKeyField) {
        throw new UnsupportedOperationException("addForeignKeyField");
    }

    @Override
    public List<Expression> getOrderByNormalizedExpressions(Expression base) {
        ArrayList<Expression> orderBys = new ArrayList<Expression>(this.referenceDescriptor.getPrimaryKeyFields().size());
        for (DatabaseField field : this.referenceDescriptor.getPrimaryKeyFields()) {
            orderBys.add(base.getField(field));
        }
        return orderBys;
    }

    static enum ExtendPessimisticLockScope {
        NONE,
        TARGET_QUERY,
        SOURCE_QUERY,
        DEDICATED_QUERY;

    }
}

