/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers.rcm;

import java.util.Enumeration;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServer;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServersModel;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.ConfigurableCacheSyncDistributedTest;

public class RelatedNewObjectNotSentTest
extends ConfigurableCacheSyncDistributedTest {
    protected Employee employee = null;
    protected Address address = null;
    protected Project project = null;
    protected Expression expression = null;

    public RelatedNewObjectNotSentTest() {
        this.cacheSyncConfigValues.put(Employee.class, new Integer(3));
        this.cacheSyncConfigValues.put(Address.class, new Integer(4));
        this.cacheSyncConfigValues.put(SmallProject.class, new Integer(4));
    }

    @Override
    public void setup() {
        super.setup();
        ExpressionBuilder employees = new ExpressionBuilder();
        this.expression = employees.get("firstName").equal((Object)"Charles");
        this.expression = this.expression.and(employees.get("lastName").equal((Object)"Chanley"));
        DistributedServer server = (DistributedServer)DistributedServersModel.getDistributedServers().get(0);
        Object result = server.getDistributedSession().readObject(Employee.class, this.expression);
        ((Employee)result).getManagedEmployees();
        ((Employee)result).getPhoneNumbers();
        ((Employee)result).getAddress();
        ((Employee)result).getManager();
        ((Employee)result).getProjects();
        ((Employee)result).getResponsibilitiesList();
    }

    public void test() {
        this.employee = (Employee)this.getSession().readObject(Employee.class, this.expression);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee employeeClone = (Employee)uow.registerObject((Object)this.employee);
        this.address = new Address();
        this.address.setCity("Minas Tirith");
        this.address.setStreet("1 Main Street");
        this.address.setProvince("Tirith");
        this.address.setPostalCode("ROH AN");
        this.address.setCountry("Rohan");
        Address addressClone = (Address)uow.registerObject((Object)this.address);
        employeeClone.setAddress(addressClone);
        this.project = new SmallProject();
        this.project.setName("TopLink for your brain");
        this.project.setDescription("Improves your memory, but includes one heck of a connection pool.");
        SmallProject projectClone = (SmallProject)uow.registerObject((Object)this.project);
        employeeClone.addProject(projectClone);
        uow.commit();
    }

    public void verify() {
        Employee distributedEmployee = (Employee)this.getObjectFromDistributedCache(this.employee);
        Address distributedAddress = (Address)this.getObjectFromDistributedCache(this.address);
        SmallProject distributedProject = (SmallProject)this.getObjectFromDistributedCache(this.project);
        if (!((AbstractSession)this.getSession()).compareObjects((Object)distributedEmployee.getAddress(), (Object)this.employee.getAddress())) {
            throw new TestErrorException("The employee's address was not properly merged.  The new address was not read into the distributed cache.");
        }
        distributedProject = null;
        boolean foundProject = false;
        Enumeration enumtr = distributedEmployee.getProjects().elements();
        while (enumtr.hasMoreElements() && !foundProject) {
            Project proj = (Project)enumtr.nextElement();
            if (!((AbstractSession)this.getSession()).compareObjects((Object)proj, (Object)this.project)) continue;
            foundProject = true;
        }
        if (!foundProject) {
            throw new TestErrorException("The employee's small project was not properly merged.  The new small project was not read into the distributed cache.");
        }
    }
}

