/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.optimization;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ReadAllBatchReadingTest
extends ReadAllTest {
    public ReadAllBatchReadingTest(int size) {
        super(Employee.class, size);
    }

    protected void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        super.setup();
    }

    protected void verify() throws Exception {
        super.verify();
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.dontMaintainCache();
        query.cascadeAllParts();
        query.setSelectionCriteria(this.getQuery().getSelectionCriteria());
        Vector normalEmps = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
        ContainerPolicy containerPolicy = this.getQuery().getContainerPolicy();
        if (this.getQuery().getContainerPolicy().isCursorPolicy() ? normalEmps.size() != ((Vector)this.objectsFromDatabase).size() || normalEmps.size() != this.getOriginalObjectsSize() : normalEmps.size() != containerPolicy.sizeFor(this.objectsFromDatabase) || normalEmps.size() != this.getOriginalObjectsSize()) {
            throw new TestErrorException("Size of batch result does not match.");
        }
        Enumeration enumtr = null;
        Object iter = null;
        if (containerPolicy.isCursorPolicy()) {
            enumtr = ((Vector)this.objectsFromDatabase).elements();
        } else {
            iter = containerPolicy.iteratorFor(this.objectsFromDatabase);
        }
        int subset = Math.min(3, normalEmps.size());
        for (int index = 0; index < subset; ++index) {
            Employee nemployee = (Employee)normalEmps.elementAt(index);
            Employee bemployee = null;
            bemployee = containerPolicy.isCursorPolicy() ? (Employee)enumtr.nextElement() : (Employee)containerPolicy.next(iter, (AbstractSession)this.getSession());
            bemployee.getAddress();
            bemployee.getManager();
            bemployee.getPhoneNumbers();
            bemployee.getProjects();
            bemployee.getResponsibilitiesList();
            ((AbstractSession)this.getSession()).compareObjects((Object)bemployee.getAddress(), (Object)nemployee.getAddress());
            if (bemployee.getPhoneNumbers().size() != nemployee.getPhoneNumbers().size()) {
                throw new TestErrorException("Phones not match.");
            }
            if (bemployee.getProjects().size() != nemployee.getProjects().size()) {
                throw new TestErrorException("Projects not match.");
            }
            if (bemployee.getResponsibilitiesList().size() != nemployee.getResponsibilitiesList().size()) {
                throw new TestErrorException("Responsibilties list not match.");
            }
            if (bemployee.getManager() == null && nemployee.getManager() == null) continue;
            if (bemployee.getManager() == null || nemployee.getManager() == null) {
                throw new TestErrorException("Mgr null not match.");
            }
            if (bemployee.getManager().getFirstName().equals(nemployee.getManager().getFirstName())) continue;
            throw new TestErrorException("Mgr name of batch result does not match.");
        }
    }
}

