/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.report;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.queries.report.ReportQueryTestCase;

public class Scenario1_2
extends ReportQueryTestCase {
    public Scenario1_2() {
        this.setDescription("DTF mappings with 1 Class & 2 Tables");
    }

    @Override
    protected void buildExpectedResults() {
        Vector employees = this.getSession().readAllObjects(Employee.class);
        Enumeration e = employees.elements();
        while (e.hasMoreElements()) {
            Employee emp = (Employee)e.nextElement();
            if (emp.getSalary() <= 40000 || emp.getSalary() >= 100000) continue;
            Object[] result = new Object[]{emp.getFirstName(), emp.getLastName(), new Integer(emp.getSalary())};
            this.addResult(result, null);
        }
    }

    @Override
    protected void setup() throws Exception {
        super.setup();
        this.reportQuery = new ReportQuery(new ExpressionBuilder());
        this.reportQuery.setReferenceClass(Employee.class);
        this.reportQuery.addAttribute("firstName");
        this.reportQuery.addAttribute("lastName");
        this.reportQuery.addAttribute("salary");
        Expression exp1 = this.reportQuery.getExpressionBuilder().get("salary").greaterThan(40000);
        Expression exp2 = this.reportQuery.getExpressionBuilder().get("salary").lessThan(100000);
        this.reportQuery.setSelectionCriteria(exp1.and(exp2));
    }
}

