/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.workbenchintegration.EmployeeWorkbenchIntegrationSystem;

public class ProjectXMLQueryManagerQueryOrderTest
extends AutoVerifyTestCase {
    Vector original;
    Vector current;

    public void test() {
        this.current = null;
        this.original = null;
        Project initialProj = new EmployeeWorkbenchIntegrationSystem().getInitialProject();
        ClassDescriptor initialDescriptor = initialProj.getDescriptor(Employee.class);
        Project readinProj = this.getSession().getProject();
        ClassDescriptor currentDescriptor = readinProj.getDescriptor(Employee.class);
        this.original = initialDescriptor.getDescriptorQueryManager().getAllQueries();
        this.current = currentDescriptor.getDescriptorQueryManager().getAllQueries();
    }

    protected void verify() {
        if (this.original.size() != this.current.size()) {
            throw new TestErrorException("The number of queries read was not equal to the number originally.");
        }
        Iterator orig = this.original.iterator();
        Iterator curr = this.current.iterator();
        while (orig.hasNext()) {
            DatabaseQuery origQuery = (DatabaseQuery)orig.next();
            int argumentTypesSize = 0;
            if (origQuery.getArguments() != null) {
                argumentTypesSize = origQuery.getArguments().size();
            }
            Vector argumentTypes = new Vector();
            for (int i = 0; i < argumentTypesSize; ++i) {
                argumentTypes.addElement(origQuery.getArgumentTypeNames().get(i));
            }
            DatabaseQuery currentQuery = (DatabaseQuery)curr.next();
            if (origQuery.getName() == currentQuery.getName() || origQuery.getName() != null && origQuery.getName().equals(currentQuery.getName()) || argumentTypes.equals(currentQuery.getArgumentTypeNames())) continue;
            throw new TestErrorException("A query in the descriptor query manager does not match the original based on arguments");
        }
    }
}

