/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.jpql;

import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.RollbackException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.platform.server.oc4j.Oc4jPlatform;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.QuerySQLTracker;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.AddressType;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Buyer;
import org.eclipse.persistence.testing.models.jpa.advanced.Customer;
import org.eclipse.persistence.testing.models.jpa.advanced.Dealer;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.models.jpa.advanced.EmploymentPeriod;
import org.eclipse.persistence.testing.models.jpa.advanced.LargeProject;
import org.eclipse.persistence.testing.models.jpa.advanced.Man;
import org.eclipse.persistence.testing.models.jpa.advanced.PartnerLinkPopulator;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;
import org.eclipse.persistence.testing.models.jpa.advanced.SmallProject;
import org.eclipse.persistence.testing.models.jpa.advanced.Woman;
import org.eclipse.persistence.testing.models.jpa.advanced.compositepk.CompositePKTableCreator;
import org.eclipse.persistence.testing.models.jpa.datatypes.DataTypesTableCreator;
import org.eclipse.persistence.testing.models.jpa.inherited.Accredidation;
import org.eclipse.persistence.testing.models.jpa.inherited.Becks;
import org.eclipse.persistence.testing.models.jpa.inherited.BecksTag;
import org.eclipse.persistence.testing.models.jpa.inherited.BeerConsumer;
import org.eclipse.persistence.testing.models.jpa.inherited.Birthday;
import org.eclipse.persistence.testing.models.jpa.inherited.Blue;
import org.eclipse.persistence.testing.models.jpa.inherited.Corona;
import org.eclipse.persistence.testing.models.jpa.inherited.CoronaTag;
import org.eclipse.persistence.testing.models.jpa.inherited.ExpertBeerConsumer;
import org.eclipse.persistence.testing.models.jpa.inherited.InheritedTableManager;
import org.eclipse.persistence.testing.models.jpa.inherited.TelephoneNumber;
import org.eclipse.persistence.testing.tests.jpa.jpql.JUnitDomainObjectComparer;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.StoredFunctionDefinition;

public class JUnitJPQLComplexTestSuite
extends JUnitTestCase {
    static JUnitDomainObjectComparer comparer;

    public JUnitJPQLComplexTestSuite() {
    }

    public JUnitJPQLComplexTestSuite(String name) {
        super(name);
    }

    public void tearDown() {
        this.clearCache();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("JUnitJPQLComplexTestSuite");
        suite.addTest((Test)new JUnitJPQLComplexTestSuite("testSetup"));
        ArrayList<String> tests = new ArrayList<String>();
        tests.add("complexABSTest");
        tests.add("complexABSWithParameterTest");
        tests.add("complexInTest1");
        tests.add("complexInTest2");
        tests.add("complexInTest3");
        tests.add("complexInTest4");
        tests.add("complexInTest5");
        tests.add("complexLengthTest");
        tests.add("complexLikeTest");
        tests.add("complexNotInTest");
        tests.add("complexNotLikeTest");
        tests.add("complexParameterTest");
        tests.add("complexReverseAbsTest");
        tests.add("complexReverseLengthTest");
        tests.add("complexReverseParameterTest");
        tests.add("complexReverseSqrtTest");
        tests.add("complexSqrtTest");
        tests.add("complexStringInTest");
        tests.add("complexStringNotInTest");
        tests.add("complexSubstringTest");
        tests.add("complexLocateTest");
        tests.add("complexNestedOneToManyUsingInClause");
        tests.add("complexUnusedVariableTest");
        tests.add("complexJoinTest");
        tests.add("complexJoinTest2");
        tests.add("complexJoinTest3");
        tests.add("complexMultipleJoinOfSameRelationship");
        tests.add("complexMultipleLeftOuterJoinOfSameRelationship");
        tests.add("complexFetchJoinTest");
        tests.add("complexOneToOneFetchJoinTest");
        tests.add("complexSelectRelationshipTest");
        tests.add("complexConstructorTest");
        tests.add("complexConstructorVariableTest");
        tests.add("complexConstructorRelationshipTest");
        tests.add("complexConstructorEmbeddableTest");
        tests.add("complexConstructorAggregatesTest");
        tests.add("complexConstructorCountOnJoinedVariableTest");
        tests.add("complexConstructorConstantTest");
        tests.add("complexConstructorCaseTest");
        tests.add("complexConstructorMapTest");
        tests.add("complexResultPropertiesTest");
        tests.add("complexInSubqueryTest");
        tests.add("complexExistsTest");
        tests.add("complexNotExistsTest");
        tests.add("complexExistsSubqueryJoinTest");
        tests.add("complexMultipleExistsSubqueryTest");
        tests.add("complexInSubqueryJoinTest");
        tests.add("complexInSubqueryJoinInTest");
        tests.add("complexMemberOfTest");
        tests.add("complexNotMemberOfTest");
        tests.add("complexNotMemberOfPathTest");
        tests.add("complexMemberOfElementCollectionTest");
        tests.add("complexNavigatingEmbedded");
        tests.add("complexNavigatingTwoLevelOfEmbeddeds");
        tests.add("complexNamedQueryResultPropertiesTest");
        tests.add("complexOuterJoinQuery");
        tests.add("complexInheritanceTest");
        tests.add("complexInheritanceUsingNamedQueryTest");
        tests.add("mapContainerPolicyMapKeyInSelectTest");
        tests.add("mapContainerPolicyMapValueInSelectTest");
        tests.add("mapContainerPolicyMapEntryInSelectTest");
        tests.add("mapContainerPolicyMapKeyInSelectionCriteriaTest");
        tests.add("mapContainerPolicyMapValueInSelectionCriteriaTest");
        tests.add("mappedKeyMapContainerPolicyMapKeyInSelectionCriteriaTest");
        tests.add("mappedKeyMapContainerPolicyMapKeyInSelectTest");
        tests.add("mappedKeyMapContainerPolicyMapEntryInSelectTest");
        tests.add("mappedKeyMapContainerPolicyEmbeddableMapKeyInSelectionCriteriaTest");
        tests.add("mappedKeyMapContainerPolicyElementCollectionSelectionCriteriaTest");
        tests.add("mappedKeyMapContainerPolicyNavigateMapKeyInEntityTest");
        tests.add("mappedKeyMapContainerPolicyNavigateMapKeyInEmbeddableTest");
        tests.add("complexThreeLevelJoinOneTest");
        tests.add("complexThreeLevelJoinManyTest");
        tests.add("complexIndexOfInSelectClauseTest");
        tests.add("complexIndexOfInWhereClauseTest");
        tests.add("complexCoalesceInWhereTest");
        tests.add("complexCoalesceInSelectTest");
        tests.add("complexNullIfInWhereTest");
        tests.add("complexNullIfInSelectTest");
        tests.add("complexSimpleCaseInSelectTest");
        tests.add("complexSimpleCaseInWhereTest");
        tests.add("complexConditionCaseInSelectTest");
        tests.add("complexConditionCaseInWhereTest");
        tests.add("complexConditionCaseInUpdateTest");
        tests.add("complexTypeInParamTest");
        tests.add("complexTypeInTest");
        tests.add("complexTypeParameterTest");
        tests.add("absInSelectTest");
        tests.add("modInSelectTest");
        tests.add("sqrtInSelectTest");
        tests.add("sizeInSelectTest");
        tests.add("mathInSelectTest");
        tests.add("paramNoVariableTest");
        tests.add("mappedContainerPolicyCompoundMapKeyTest");
        tests.add("updateWhereExistsTest");
        tests.add("deleteWhereExistsTest");
        tests.add("caseTypeTest");
        tests.add("variableReferencedOnlyInParameterTest");
        tests.add("standardFunctionCreateQueryTest");
        tests.add("customFunctionNVLTest");
        tests.add("testFuncWithStoredFunc");
        tests.add("testFuncWithMySQLFuncs");
        tests.add("testNestedFUNCs");
        tests.add("testFunctionInSelect");
        tests.add("testFunctionInOrderBy");
        tests.add("testFunctionInGroupBy");
        tests.add("testBrackets");
        tests.add("testComplexBetween");
        tests.add("testComplexLike");
        tests.add("testComplexIn");
        tests.add("testQueryKeys");
        tests.add("complexOneToOneJoinOptimization");
        tests.add("testCountOneToManyQueryKey");
        tests.add("testEnumNullNotNull");
        tests.add("testPessimisticLock");
        tests.add("testAliasedFunction");
        tests.add("testSubselectInGroupBy");
        tests.add("testSubselectInSelect");
        tests.add("testSubselectInFrom");
        tests.add("testParralelFrom");
        tests.add("testGroupByInIn");
        tests.add("testJoinFetchAlias");
        tests.add("testNestedJoinFetch");
        tests.add("testNestedJoinFetchAlias");
        tests.add("testDistinctOrderByEmbedded");
        tests.add("testElementCollection");
        tests.add("testDoubleAggregateManyToMany");
        tests.add("testGroupByHavingFunction");
        if (!JUnitJPQLComplexTestSuite.isJPA10()) {
            tests.add("testSubSelect");
            tests.add("testSubSelect2");
        }
        tests.add("testOrderPackage");
        tests.add("testSubselectStackOverflow");
        tests.add("testAliasPlus");
        tests.add("testFunctionsWithParameters");
        tests.add("testEmbeddableDistinct");
        tests.add("testSingleEncapsulatedInputParameter");
        tests.add("testObjectIn");
        tests.add("testMemberOf");
        tests.add("testOrderByDistinct");
        tests.add("testJoinFetchWithJoin");
        tests.add("testNestedSubqueries");
        tests.add("testOnClause");
        tests.add("testFUNCTIONWithStoredFunc");
        tests.add("testSQLCast");
        tests.add("testOPERATOR");
        tests.add("testCOLUMN");
        tests.add("testClassNameInFrom");
        tests.add("testLeftParameters");
        tests.add("testCast");
        tests.add("testExtract");
        tests.add("testNullOrdering");
        tests.add("testRegexp");
        tests.add("testUnion");
        tests.add("testComplexPathExpression");
        tests.add("testDirectColletionInSubquery");
        tests.add("testNestedArrays1");
        tests.add("testNestedArrays2");
        tests.add("testNoSelect");
        tests.add("testHierarchicalClause");
        tests.add("testDeleteWithUnqualifiedPathExpression");
        tests.add("testElementCollectionInLikeExpression");
        Collections.sort(tests);
        for (String test : tests) {
            suite.addTest((Test)new JUnitJPQLComplexTestSuite(test));
        }
        return suite;
    }

    public void testSetup() {
        this.clearCache();
        ServerSession session = JUnitTestCase.getServerSession();
        EmployeePopulator employeePopulator = new EmployeePopulator();
        PartnerLinkPopulator partnerLinkPopulator = new PartnerLinkPopulator();
        new AdvancedTableCreator().replaceTables((DatabaseSession)session);
        comparer = new JUnitDomainObjectComparer();
        comparer.setSession((AbstractSession)session.getActiveSession());
        employeePopulator.buildExamples();
        employeePopulator.persistExample((Session)session);
        partnerLinkPopulator.buildExamples();
        partnerLinkPopulator.persistExample((Session)session);
        new InheritedTableManager().replaceTables((DatabaseSession)session);
        new DataTypesTableCreator().replaceTables((DatabaseSession)session);
        if (this.supportsStoredFunctions()) {
            SchemaManager schema = new SchemaManager((DatabaseSession)session);
            schema.replaceObject((DatabaseObjectDefinition)this.buildStoredFunction());
        }
        new CompositePKTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
    }

    public StoredFunctionDefinition buildStoredFunction() {
        StoredFunctionDefinition func = new StoredFunctionDefinition();
        func.setName("StoredFunction_In");
        func.addArgument("P_IN", Long.class);
        func.setReturnType(Long.class);
        func.addStatement("RETURN P_IN * 1000");
        return func;
    }

    public void complexABSTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp1 = (Employee)JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        Employee emp2 = (Employee)JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class).lastElement();
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + "(ABS(emp.salary) = ";
        ejbqlString = ejbqlString + emp1.getSalary() + ")";
        ejbqlString = ejbqlString + " OR (ABS(emp.salary) = ";
        ejbqlString = ejbqlString + emp2.getSalary() + ")";
        Vector<Employee> expectedResult = new Vector<Employee>();
        expectedResult.add(emp1);
        expectedResult.add(emp2);
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Complex ABS test failed", (boolean)comparer.compareObjects(result, expectedResult));
        this.rollbackTransaction(em);
        this.closeEntityManager(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complexABSWithParameterTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee emp = (Employee)JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
            Employee emp2 = (Employee)em.merge((Object)emp);
            this.clearCache();
            Query q = em.createQuery("SELECT emp FROM Employee emp WHERE emp.salary = ABS(:sal)");
            q.setParameter("sal", (Object)emp.getSalary());
            List result = q.getResultList();
            boolean found = false;
            for (Employee e : result) {
                if (!e.equals(emp2)) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)"Complex ABS with parameter test failed", (boolean)found);
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    public void complexInTest1() {
        EntityManager em = this.createEntityManager();
        Employee emp1 = (Employee)JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        Employee emp2 = (Employee)JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(1);
        Employee emp3 = (Employee)JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(2);
        Vector expectedResult = new Vector();
        Vector<Integer> idVector = new Vector<Integer>();
        idVector.add(emp1.getId());
        idVector.add(emp2.getId());
        idVector.add(emp3.getId());
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        ExpressionBuilder eb = new ExpressionBuilder();
        Expression whereClause = eb.get("id").in(idVector);
        raq.setSelectionCriteria(whereClause);
        expectedResult = (Vector)JUnitJPQLComplexTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.id IN (";
        ejbqlString = ejbqlString + emp1.getId().toString() + ", ";
        ejbqlString = ejbqlString + emp2.getId().toString() + ", ";
        ejbqlString = ejbqlString + emp3.getId().toString();
        ejbqlString = ejbqlString + ")";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Complex IN test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void complexInTest2() {
        EntityManager em = this.createEntityManager();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.id IN :param";
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(-1);
        params.add(0);
        params.add(1);
        em.createQuery(ejbqlString).setParameter("param", params).getResultList();
    }

    public void complexInTest3() {
        EntityManager em = this.createEntityManager();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE UPPER(emp.lastName) IN :param";
        ArrayList<String> params = new ArrayList<String>();
        params.add("SMITH");
        params.add("FILION");
        params.add("DELACHEVROTI\u00c8RE");
        em.createQuery(ejbqlString).setParameter("param", params).getResultList();
    }

    public void complexInTest4() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("SELECT lp from LargeProject lp WHERE lp.budget = :budget and TYPE(lp) IN :employeeTypes and lp.name IN :employeeStatus");
        query.setParameter("budget", (Object)60000);
        ArrayList<String> status = new ArrayList<String>();
        status.add("EclipseLink");
        status.add("JPQL");
        query.setParameter("employeeStatus", status);
        ArrayList<Class> types = new ArrayList<Class>();
        types.add(LargeProject.class);
        types.add(SmallProject.class);
        query.setParameter("employeeTypes", types);
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void complexInTest5() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("SELECT e from Employee e WHERE e.responsibilities IN :responsibilities");
        ArrayList<String> types = new ArrayList<String>();
        types.add("responsibilities1");
        types.add("responsibilities2");
        query.setParameter("responsibilities", types);
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void complexLengthTest() {
        if (JUnitTestCase.getServerSession().getPlatform().isSQLServer()) {
            JUnitJPQLComplexTestSuite.getServerSession().logMessage("Warning SQL doesnot support LENGTH function");
            return;
        }
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + "(LENGTH(emp.firstName) = ";
        ejbqlString = ejbqlString + expectedResult.getFirstName().length() + ")";
        ejbqlString = ejbqlString + " AND ";
        ejbqlString = ejbqlString + "(LENGTH(emp.lastName) = ";
        ejbqlString = ejbqlString + expectedResult.getLastName().length() + ")";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Complex Length test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
    }

    public void complexLikeTest() {
        EntityManager em = this.createEntityManager();
        Employee emp = (Employee)JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        String firstName = emp.getFirstName();
        String partialFirstName = emp.getFirstName().substring(0, 1);
        partialFirstName = partialFirstName + "_";
        partialFirstName = partialFirstName + firstName.substring(2, Math.min(4, firstName.length() - 1));
        partialFirstName = partialFirstName + "%";
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        ExpressionBuilder eb = new ExpressionBuilder();
        Expression whereClause = eb.get("firstName").like(partialFirstName);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitJPQLComplexTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName LIKE \"" + partialFirstName + "\"";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Complex Like test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void complexNotInTest() {
        EntityManager em = this.createEntityManager();
        Employee emp1 = (Employee)JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        Employee emp2 = (Employee)JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(1);
        Employee emp3 = (Employee)JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(2);
        ExpressionBuilder builder = new ExpressionBuilder();
        Vector<Integer> idVector = new Vector<Integer>();
        idVector.add(emp1.getId());
        idVector.add(emp2.getId());
        idVector.add(emp3.getId());
        Expression whereClause = builder.get("id").notIn(idVector);
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitJPQLComplexTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.id NOT IN (";
        ejbqlString = ejbqlString + emp1.getId().toString() + ", ";
        ejbqlString = ejbqlString + emp2.getId().toString() + ", ";
        ejbqlString = ejbqlString + emp3.getId().toString();
        ejbqlString = ejbqlString + ")";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Complex Not IN test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void complexNotLikeTest() {
        EntityManager em = this.createEntityManager();
        Employee emp = (Employee)JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        String firstName = emp.getFirstName();
        String partialFirstName = emp.getFirstName().substring(0, 1);
        partialFirstName = partialFirstName + "_";
        partialFirstName = partialFirstName + firstName.substring(2, Math.min(4, firstName.length() - 1));
        partialFirstName = partialFirstName + "%";
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("firstName").notLike(partialFirstName);
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitJPQLComplexTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName NOT LIKE \"" + partialFirstName + "\"";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Complex Not LIKE test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void complexParameterTest() {
        EntityManager em = this.createEntityManager();
        Employee emp = (Employee)JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        String firstName = "firstName";
        String lastName = "lastName";
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get(firstName).equal(builder.getParameter(firstName));
        whereClause = whereClause.and(builder.get(lastName).equal(builder.getParameter(lastName)));
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        raq.addArgument(firstName);
        raq.addArgument(lastName);
        Vector<String> parameters = new Vector<String>();
        parameters.add(emp.getFirstName());
        parameters.add(emp.getLastName());
        Vector expectedResult = (Vector)JUnitJPQLComplexTestSuite.getServerSession().executeQuery((DatabaseQuery)raq, parameters);
        this.clearCache();
        emp = (Employee)expectedResult.firstElement();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + "emp.firstName = ?1 ";
        ejbqlString = ejbqlString + " AND ";
        ejbqlString = ejbqlString + "emp.lastName = ?2";
        List result = em.createQuery(ejbqlString).setParameter(1, (Object)emp.getFirstName()).setParameter(2, (Object)emp.getLastName()).getResultList();
        Assert.assertTrue((String)"Complex Paramter test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void complexReverseAbsTest() {
        EntityManager em = this.createEntityManager();
        Employee emp1 = (Employee)JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        Employee emp2 = (Employee)JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(1);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + emp1.getSalary();
        ejbqlString = ejbqlString + " = ABS(emp.salary)";
        ejbqlString = ejbqlString + " OR ";
        ejbqlString = ejbqlString + emp2.getSalary();
        ejbqlString = ejbqlString + " = ABS(emp.salary)";
        Vector<Employee> expectedResult = new Vector<Employee>();
        expectedResult.add(emp1);
        expectedResult.add(emp2);
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Complex reverse ABS test failed", (boolean)comparer.compareObjects(result, expectedResult));
    }

    public void complexReverseLengthTest() {
        if (JUnitTestCase.getServerSession().getPlatform().isSQLServer()) {
            JUnitJPQLComplexTestSuite.getServerSession().logMessage("Warning SQL doesnot support LENGTH function");
            return;
        }
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + expectedResult.getFirstName().length();
        ejbqlString = ejbqlString + " = LENGTH(emp.firstName)";
        ejbqlString = ejbqlString + " AND ";
        ejbqlString = ejbqlString + expectedResult.getLastName().length();
        ejbqlString = ejbqlString + " = LENGTH(emp.lastName)";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Complex reverse Length test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
    }

    public void complexReverseParameterTest() {
        EntityManager em = this.createEntityManager();
        Employee emp = (Employee)JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        String firstName = "firstName";
        String lastName = "lastName";
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get(firstName).equal(builder.getParameter(firstName));
        whereClause = whereClause.and(builder.get(lastName).equal(builder.getParameter(lastName)));
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        raq.addArgument(firstName);
        raq.addArgument(lastName);
        Vector<String> parameters = new Vector<String>();
        parameters.add(emp.getFirstName());
        parameters.add(emp.getLastName());
        Vector expectedResult = (Vector)JUnitJPQLComplexTestSuite.getServerSession().executeQuery((DatabaseQuery)raq, parameters);
        this.clearCache();
        emp = (Employee)expectedResult.firstElement();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + "?1 = emp.firstName";
        ejbqlString = ejbqlString + " AND ";
        ejbqlString = ejbqlString + "?2 = emp.lastName";
        List result = em.createQuery(ejbqlString).setParameter(1, (Object)emp.getFirstName()).setParameter(2, (Object)emp.getLastName()).getResultList();
        Assert.assertTrue((String)"Complex Reverse Paramter test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void complexReverseSqrtTest() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            JUnitJPQLComplexTestSuite.getServerSession().logMessage("Test complexReverseSqrtTest skipped for this platform, Symfoware doesn't support SQRT, COS, SIN, TAN functions.");
            return;
        }
        EntityManager em = this.createEntityManager();
        ReadAllQuery raq = new ReadAllQuery();
        ExpressionBuilder expbldr = new ExpressionBuilder();
        Expression whereClause1 = expbldr.get("lastName").equal((Object)"TestCase1");
        Expression whereClause2 = expbldr.get("lastName").equal((Object)"TestCase2");
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause1.or(whereClause2));
        Vector expectedResult = (Vector)JUnitJPQLComplexTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        Employee emp1 = (Employee)expectedResult.elementAt(0);
        Employee emp2 = (Employee)expectedResult.elementAt(1);
        double salarySquareRoot1 = Math.sqrt(new Double(emp1.getSalary()));
        double salarySquareRoot2 = Math.sqrt(new Double(emp2.getSalary()));
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + salarySquareRoot1;
        ejbqlString = ejbqlString + " = SQRT(emp.salary)";
        ejbqlString = ejbqlString + " OR ";
        ejbqlString = ejbqlString + salarySquareRoot2;
        ejbqlString = ejbqlString + " = SQRT(emp.salary)";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Complex Reverse Square Root test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void complexSqrtTest() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            JUnitJPQLComplexTestSuite.getServerSession().logMessage("Test complexSqrtTest skipped for this platform, Symfoware doesn't support SQRT, COS, SIN, TAN functions.");
            return;
        }
        EntityManager em = this.createEntityManager();
        ReadAllQuery raq = new ReadAllQuery();
        ExpressionBuilder expbldr = new ExpressionBuilder();
        Expression whereClause1 = expbldr.get("lastName").equal((Object)"TestCase1");
        Expression whereClause2 = expbldr.get("lastName").equal((Object)"TestCase2");
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause1.or(whereClause2));
        Vector expectedResult = (Vector)JUnitJPQLComplexTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        Employee emp1 = (Employee)expectedResult.elementAt(0);
        Employee emp2 = (Employee)expectedResult.elementAt(1);
        double salarySquareRoot1 = Math.sqrt(new Double(emp1.getSalary()));
        double salarySquareRoot2 = Math.sqrt(new Double(emp2.getSalary()));
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + "(SQRT(emp.salary) = ";
        ejbqlString = ejbqlString + salarySquareRoot1 + ")";
        ejbqlString = ejbqlString + " OR ";
        ejbqlString = ejbqlString + "(SQRT(emp.salary) = ";
        ejbqlString = ejbqlString + salarySquareRoot2 + ")";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Complex Square Root test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void complexStringInTest() {
        EntityManager em = this.createEntityManager();
        Employee emp1 = (Employee)JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        Employee emp2 = (Employee)JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(1);
        Employee emp3 = (Employee)JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(2);
        Vector<String> fnVector = new Vector<String>();
        fnVector.add(emp1.getFirstName());
        fnVector.add(emp2.getFirstName());
        fnVector.add(emp3.getFirstName());
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        ExpressionBuilder eb = new ExpressionBuilder();
        Expression whereClause = eb.get("firstName").in(fnVector);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitJPQLComplexTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName IN (";
        ejbqlString = ejbqlString + "\"" + emp1.getFirstName() + "\"" + ", ";
        ejbqlString = ejbqlString + "\"" + emp2.getFirstName() + "\"" + ", ";
        ejbqlString = ejbqlString + "\"" + emp3.getFirstName() + "\"";
        ejbqlString = ejbqlString + ")";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Complex String In test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void complexStringNotInTest() {
        EntityManager em = this.createEntityManager();
        Employee emp1 = (Employee)JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        Employee emp2 = (Employee)JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(1);
        Employee emp3 = (Employee)JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(2);
        ExpressionBuilder builder = new ExpressionBuilder();
        Vector<String> nameVector = new Vector<String>();
        nameVector.add(emp1.getFirstName());
        nameVector.add(emp2.getFirstName());
        nameVector.add(emp3.getFirstName());
        Expression whereClause = builder.get("firstName").notIn(nameVector);
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitJPQLComplexTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName NOT IN (";
        ejbqlString = ejbqlString + "\"" + emp1.getFirstName() + "\"" + ", ";
        ejbqlString = ejbqlString + "\"" + emp2.getFirstName() + "\"" + ", ";
        ejbqlString = ejbqlString + "\"" + emp3.getFirstName() + "\"";
        ejbqlString = ejbqlString + ")";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Complex String Not In test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void complexSubstringTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        String firstNamePart = expectedResult.getFirstName().substring(0, 2);
        String lastNamePart = expectedResult.getLastName().substring(0, 1);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + "(SUBSTRING(emp.firstName, 1, 2) = ";
        ejbqlString = ejbqlString + "\"" + firstNamePart + "\")";
        ejbqlString = ejbqlString + " AND ";
        ejbqlString = ejbqlString + "(SUBSTRING(emp.lastName, 1, 1) = ";
        ejbqlString = ejbqlString + "\"" + lastNamePart + "\")";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Complex Sub String test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
    }

    public void complexLocateTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        String jpql = "SELECT e FROM Employee e WHERE e.firstName = 'Emanual' AND e.lastName = 'Smith'";
        Employee expectedResult = (Employee)em.createQuery(jpql).getSingleResult();
        jpql = "SELECT e FROM Employee e WHERE LOCATE('manual', e.firstName) = 2 AND e.lastName = 'Smith'";
        Employee result = (Employee)em.createQuery(jpql).getSingleResult();
        Assert.assertTrue((String)"Complex LOCATE(String, String) test failed", (boolean)result.equals(expectedResult));
        jpql = "SELECT e FROM Employee e WHERE LOCATE('a', e.firstName, 4) = 6 AND e.lastName = 'Smith'";
        result = (Employee)em.createQuery(jpql).getSingleResult();
        Assert.assertTrue((String)"Complex LOCATE(String, String) test failed", (boolean)result.equals(expectedResult));
        this.rollbackTransaction(em);
        this.closeEntityManager(em);
    }

    public void complexNestedOneToManyUsingInClause() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.anyOf("managedEmployees").anyOf("projects").get("name").equal((Object)"Enterprise");
        ReadAllQuery readQuery = new ReadAllQuery();
        readQuery.dontMaintainCache();
        readQuery.setReferenceClass(Employee.class);
        readQuery.setSelectionCriteria(whereClause);
        List expectedResult = (List)JUnitJPQLComplexTestSuite.getServerSession().executeQuery((DatabaseQuery)readQuery);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp, IN(emp.managedEmployees) mEmployees, IN(mEmployees.projects) projects WHERE projects.name = 'Enterprise'";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Complex Nested One To Many Using In Clause test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void complexUnusedVariableTest() {
        EntityManager em = this.createEntityManager();
        ReportQuery reportQuery = new ReportQuery();
        reportQuery.dontMaintainCache();
        reportQuery.setShouldReturnWithoutReportQueryResult(true);
        reportQuery.setReferenceClass(Employee.class);
        ExpressionBuilder builder = reportQuery.getExpressionBuilder();
        reportQuery.addNonFetchJoinedAttribute(builder.get("address"));
        reportQuery.addItem("emp", (Expression)builder);
        Vector expectedResult = (Vector)JUnitJPQLComplexTestSuite.getServerSession().executeQuery((DatabaseQuery)reportQuery);
        this.clearCache();
        String ejbqlString = "SELECT emp FROM Employee emp JOIN emp.address a";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Complex Unused Variable test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void complexJoinTest() {
        EntityManager em = this.createEntityManager();
        Vector emps = JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class);
        Employee empWithManager = null;
        Employee empWithOutManager = null;
        for (Employee e : emps) {
            Employee manager = e.getManager();
            if (manager != null) {
                if (empWithManager == null) {
                    empWithManager = e;
                }
            } else if (empWithOutManager == null) {
                empWithOutManager = e;
            }
            if (empWithManager == null || empWithOutManager == null) continue;
            break;
        }
        String ejbqlString = "SELECT m FROM Employee emp JOIN emp.manager m WHERE emp.id IN (:id1, :id2)";
        Query query = em.createQuery(ejbqlString);
        query.setParameter("id1", (Object)empWithOutManager.getId());
        query.setParameter("id2", (Object)empWithManager.getId());
        List result = query.getResultList();
        List<Employee> expectedResult = Arrays.asList(empWithManager.getManager());
        Assert.assertTrue((String)"Complex Join test failed", (boolean)comparer.compareObjects(result, expectedResult));
        ejbqlString = "SELECT m FROM Employee emp LEFT OUTER JOIN emp.manager m WHERE emp.id IN (:id1, :id2)";
        query = em.createQuery(ejbqlString);
        query.setParameter("id1", (Object)empWithOutManager.getId());
        query.setParameter("id2", (Object)empWithManager.getId());
        result = query.getResultList();
        expectedResult = Arrays.asList(empWithManager.getManager(), null);
        Assert.assertTrue((String)"Complex Join test failed", (boolean)comparer.compareObjects(result, expectedResult));
    }

    public void complexJoinTest2() {
        EntityManager em = this.createEntityManager();
        Vector emps = JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class);
        Employee empWithManager = null;
        Employee empWithOutManager = null;
        for (Employee e : emps) {
            Employee manager = e.getManager();
            if (manager != null) {
                if (empWithManager == null) {
                    empWithManager = e;
                }
            } else if (empWithOutManager == null) {
                empWithOutManager = e;
            }
            if (empWithManager == null || empWithOutManager == null) continue;
            break;
        }
        String ejbqlString = "SELECT m FROM Employee emp JOIN emp.manager m WHERE emp.id IN (:id1, :id2)";
        Query query = em.createQuery(ejbqlString);
        query.setMaxResults(5);
        query.setParameter("id1", (Object)empWithOutManager.getId());
        query.setParameter("id2", (Object)empWithManager.getId());
        List result = query.getResultList();
        List<Employee> expectedResult = Arrays.asList(empWithManager.getManager());
        Assert.assertTrue((String)"Complex Join test failed", (boolean)comparer.compareObjects(result, expectedResult));
        ejbqlString = "SELECT m FROM Employee emp LEFT OUTER JOIN emp.manager m WHERE emp.id IN (:id1, :id2)";
        query = em.createQuery(ejbqlString);
        query.setMaxResults(5);
        query.setParameter("id1", (Object)empWithOutManager.getId());
        query.setParameter("id2", (Object)empWithManager.getId());
        result = query.getResultList();
        expectedResult = Arrays.asList(empWithManager.getManager(), null);
        Assert.assertTrue((String)"Complex Join test failed", (boolean)comparer.compareObjects(result, expectedResult));
    }

    public void complexJoinTest3() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("SELECT e FROM Employee e");
        List expectedResult = query.getResultList();
        Iterator iterator = expectedResult.iterator();
        while (iterator.hasNext()) {
            Employee employee = (Employee)iterator.next();
            if (employee.getManager() != null) continue;
            iterator.remove();
        }
        query = em.createQuery("SELECT e FROM Employee e join e.manager m");
        query.setMaxResults(500);
        List result = query.getResultList();
        if (expectedResult.size() != result.size()) {
            JUnitJPQLComplexTestSuite.fail((String)("Join did not filter employees without managers:" + result));
        }
        query = em.createQuery("SELECT e.id FROM Employee e join e.manager m");
        query.setMaxResults(500);
        result = query.getResultList();
        if (expectedResult.size() != result.size()) {
            JUnitJPQLComplexTestSuite.fail((String)("Join did not filter employees without managers:" + result));
        }
        query = em.createQuery("SELECT count(p.number) FROM PhoneNumber p group by p.owner.id");
        query.setMaxResults(500);
        result = query.getResultList();
        query = em.createQuery("SELECT count(e.id) FROM Employee e group by e.address.ID");
        query.setMaxResults(500);
        result = query.getResultList();
    }

    public void complexMultipleJoinOfSameRelationship() {
        String jpql;
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery(jpql = "SELECT p1, p2 FROM Employee emp JOIN emp.phoneNumbers p1 JOIN emp.phoneNumbers p2 WHERE p1.type = 'Pager' AND p2.areaCode = '613'");
        Object[] result = (Object[])query.getSingleResult();
        Assert.assertTrue((String)"Complex multiple JOIN of same relationship test failed", (result[0] != result[1] ? 1 : 0) != 0);
    }

    public void complexMultipleLeftOuterJoinOfSameRelationship() {
        String jpql;
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery(jpql = "SELECT p1, p2 FROM Employee emp LEFT JOIN emp.phoneNumbers p1 LEFT JOIN emp.phoneNumbers p2 WHERE p1.type = 'Pager' AND p2.areaCode = '613'");
        Object[] result = (Object[])query.getSingleResult();
        Assert.assertTrue((String)"Complex multiple JOIN of same relationship test failed", (result[0] != result[1] ? 1 : 0) != 0);
    }

    public void complexFetchJoinTest() {
        EntityManager em = this.createEntityManager();
        ReportQuery reportQuery = new ReportQuery();
        reportQuery.dontMaintainCache();
        reportQuery.setShouldReturnWithoutReportQueryResult(true);
        reportQuery.setReferenceClass(Employee.class);
        ExpressionBuilder builder = reportQuery.getExpressionBuilder();
        ArrayList<Expression> joins = new ArrayList<Expression>(1);
        joins.add(builder.get("address"));
        reportQuery.addItem("emp", (Expression)builder, joins);
        Vector expectedResult = (Vector)JUnitJPQLComplexTestSuite.getServerSession().executeQuery((DatabaseQuery)reportQuery);
        this.clearCache();
        String ejbqlString = "SELECT emp FROM Employee emp JOIN FETCH emp.address";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Complex Fetch Join test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void complexOneToOneFetchJoinTest() {
        EntityManager em = this.createEntityManager();
        Vector allMen = JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Man.class);
        ArrayList<Integer> allMenIds = new ArrayList<Integer>(allMen.size());
        for (Man man : allMen) {
            allMenIds.add(man != null ? Integer.valueOf(man.getId()) : null);
        }
        Collections.sort(allMenIds);
        this.clearCache();
        String ejbqlString = "SELECT m FROM Man m LEFT JOIN FETCH m.partnerLink";
        List result = em.createQuery(ejbqlString).getResultList();
        ArrayList<Integer> ids = new ArrayList<Integer>(result.size());
        for (Man man : result) {
            ids.add(man != null ? Integer.valueOf(man.getId()) : null);
        }
        Collections.sort(ids);
        Assert.assertEquals((String)"Complex OneToOne Fetch Join test failed", allMenIds, ids);
    }

    public void complexSelectRelationshipTest() {
        if (JUnitJPQLComplexTestSuite.isOnServer()) {
            return;
        }
        JpaEntityManager em = (JpaEntityManager)this.createEntityManager();
        Vector emps = em.getActiveSession().readAllObjects(Employee.class);
        Employee empWithManager = null;
        Employee empWithOutManager = null;
        for (Employee e : emps) {
            Employee manager = e.getManager();
            if (manager != null) {
                if (empWithManager == null) {
                    empWithManager = e;
                }
            } else if (empWithOutManager == null) {
                empWithOutManager = e;
            }
            if (empWithManager == null || empWithOutManager == null) continue;
            break;
        }
        String ejbqlString = "SELECT emp.manager FROM Employee emp WHERE emp.id = :id";
        Query query = em.createQuery(ejbqlString);
        query.setParameter("id", (Object)empWithManager.getId());
        Employee result = (Employee)query.getSingleResult();
        Assert.assertEquals((String)"Select Relationship Test Case Failed (employee with manager)", (Object)empWithManager.getManager(), (Object)result);
        query.setParameter("id", (Object)empWithOutManager.getId());
        result = (Employee)query.getSingleResult();
        Assert.assertNull((String)"Select Relationship Test Case Failed (employee without manager)", (Object)result);
    }

    public void complexConstructorTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp = (Employee)JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        String ejbqlString = "SELECT NEW org.eclipse.persistence.testing.tests.jpa.jpql.JUnitJPQLComplexTestSuite.EmployeeDetail(emp.firstName, emp.lastName) FROM Employee emp WHERE emp.id = :id";
        Query query = em.createQuery(ejbqlString);
        query.setParameter("id", (Object)emp.getId());
        EmployeeDetail result = (EmployeeDetail)query.getSingleResult();
        EmployeeDetail expectedResult = new EmployeeDetail(emp.getFirstName(), emp.getLastName());
        Assert.assertTrue((String)"Constructor Test Case Failed", (boolean)result.equals(expectedResult));
        this.rollbackTransaction(em);
        this.closeEntityManager(em);
    }

    public void complexConstructorVariableTest() {
        if (JUnitJPQLComplexTestSuite.isOnServer()) {
            return;
        }
        JpaEntityManager em = (JpaEntityManager)this.createEntityManager();
        Employee emp = (Employee)em.getActiveSession().readAllObjects(Employee.class).firstElement();
        String jpqlString = "SELECT NEW org.eclipse.persistence.testing.tests.jpa.jpql.JUnitJPQLComplexTestSuite.EmployeeDetail(emp) FROM Employee emp WHERE emp.id = :id";
        Query query = em.createQuery(jpqlString);
        query.setParameter("id", (Object)emp.getId());
        EmployeeDetail result = (EmployeeDetail)query.getSingleResult();
        EmployeeDetail expectedResult = new EmployeeDetail(emp);
        Assert.assertTrue((String)"Constructor with variable argument Test Case Failed", (boolean)result.equals(expectedResult));
    }

    public void complexConstructorRelationshipTest() {
        if (JUnitJPQLComplexTestSuite.isOnServer()) {
            return;
        }
        JpaEntityManager em = (JpaEntityManager)this.createEntityManager();
        Vector emps = em.getActiveSession().readAllObjects(Employee.class);
        Employee empWithManager = null;
        Employee empWithOutManager = null;
        for (Employee e : emps) {
            Employee manager = e.getManager();
            if (manager != null) {
                if (empWithManager == null) {
                    empWithManager = e;
                }
            } else if (empWithOutManager == null) {
                empWithOutManager = e;
            }
            if (empWithManager == null || empWithOutManager == null) continue;
            break;
        }
        String ejbqlString = "SELECT NEW org.eclipse.persistence.testing.tests.jpa.jpql.JUnitJPQLComplexTestSuite.EmployeeDetail(emp.firstName, emp.lastName, emp.manager) FROM Employee emp WHERE emp.id = :id";
        Query query = em.createQuery(ejbqlString);
        query.setParameter("id", (Object)empWithManager.getId());
        EmployeeDetail result = (EmployeeDetail)query.getSingleResult();
        EmployeeDetail expectedResult = new EmployeeDetail(empWithManager.getFirstName(), empWithManager.getLastName(), empWithManager.getManager());
        Assert.assertTrue((String)"Constructor Relationship Test Case Failed (employee with manager)", (boolean)result.equals(expectedResult));
        query.setParameter("id", (Object)empWithOutManager.getId());
        result = (EmployeeDetail)query.getSingleResult();
        expectedResult = new EmployeeDetail(empWithOutManager.getFirstName(), empWithOutManager.getLastName(), empWithOutManager.getManager());
        Assert.assertTrue((String)"Constructor Relationship Test Case Failed (employee without manager)", (boolean)result.equals(expectedResult));
    }

    public void complexConstructorAggregatesTest() {
        EntityManager em = this.createEntityManager();
        Vector emps = JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class);
        Employee emp = null;
        for (Employee e : emps) {
            Collection managed = e.getManagedEmployees();
            if (managed == null || managed.size() <= 0) continue;
            emp = e;
            break;
        }
        String ejbqlString = "SELECT NEW org.eclipse.persistence.testing.tests.jpa.jpql.JUnitJPQLComplexTestSuite.LongHolder(SUM(emp.salary), COUNT(emp)) FROM Employee emp WHERE emp.manager.id = :id";
        Query query = em.createQuery(ejbqlString);
        query.setParameter("id", (Object)emp.getId());
        LongHolder result = (LongHolder)query.getSingleResult();
        Collection managed = emp.getManagedEmployees();
        int count = 0;
        int sum = 0;
        if (managed != null) {
            count = managed.size();
            for (Employee e : managed) {
                sum += e.getSalary();
            }
        }
        LongHolder expectedResult = new LongHolder(new Long(sum), new Long(count));
        Assert.assertTrue((String)"Constructor with aggregates argument Test Case Failed", (boolean)result.equals(expectedResult));
    }

    public void complexConstructorCountOnJoinedVariableTest() {
        EntityManager em = this.createEntityManager();
        Vector emps = JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class);
        ArrayList<EmployeeDetail> expectedResult = new ArrayList<EmployeeDetail>();
        for (Employee e : emps) {
            Collection managed = e.getManagedEmployees();
            if (managed == null || managed.size() <= 0) continue;
            EmployeeDetail d = new EmployeeDetail(e.getFirstName(), e.getLastName(), new Long(managed.size()));
            expectedResult.add(d);
        }
        String jpql = "SELECT NEW org.eclipse.persistence.testing.tests.jpa.jpql.JUnitJPQLComplexTestSuite.EmployeeDetail(emp.firstName, emp.lastName, COUNT(m)) FROM Employee emp JOIN emp.managedEmployees m GROUP BY emp.firstName, emp.lastName";
        Query query = em.createQuery(jpql);
        List result = query.getResultList();
        Assert.assertTrue((String)"complexConstructorCountOnJoinedVariableTest Failed", (boolean)comparer.compareObjects(result, expectedResult));
    }

    public void complexConstructorConstantTest() {
        if (JUnitJPQLComplexTestSuite.isOnServer()) {
            return;
        }
        JpaEntityManager em = (JpaEntityManager)this.createEntityManager();
        Employee emp = (Employee)em.getActiveSession().readAllObjects(Employee.class).firstElement();
        String jpqlString = "SELECT NEW org.eclipse.persistence.testing.tests.jpa.jpql.JUnitJPQLComplexTestSuite.EmployeeDetail(emp.firstName, 'Ott') FROM Employee emp WHERE emp.id = :id";
        Query query = em.createQuery(jpqlString);
        query.setParameter("id", (Object)emp.getId());
        EmployeeDetail result = (EmployeeDetail)query.getSingleResult();
        EmployeeDetail expectedResult = new EmployeeDetail(emp.getFirstName(), "Ott");
        Assert.assertTrue((String)"complexConstructorConstantTest Failed", (boolean)result.equals(expectedResult));
    }

    public void complexConstructorCaseTest() {
        if (JUnitJPQLComplexTestSuite.isOnServer()) {
            return;
        }
        if (JUnitTestCase.getServerSession().getPlatform().isDerby()) {
            JUnitJPQLComplexTestSuite.warning((String)"The test simpleCaseInWhereTest is not supported on Derby, because Derby does not support simple CASE");
            return;
        }
        JpaEntityManager em = (JpaEntityManager)this.createEntityManager();
        Expression exp = new ExpressionBuilder().get("firstName").equal((Object)"Bob");
        Employee emp = (Employee)em.getActiveSession().readAllObjects(Employee.class, exp).firstElement();
        String jpqlString = "SELECT NEW org.eclipse.persistence.testing.tests.jpa.jpql.JUnitJPQLComplexTestSuite.EmployeeDetail(case emp.firstName when 'Bob' then 'Robert' else '' end, 'Ott') FROM Employee emp WHERE emp.id = :id";
        Query query = em.createQuery(jpqlString);
        query.setParameter("id", (Object)emp.getId());
        EmployeeDetail result = (EmployeeDetail)query.getSingleResult();
        EmployeeDetail expectedResult = new EmployeeDetail("Robert", "Ott");
        Assert.assertTrue((String)"complexConstructorCaseTest Failed", (boolean)result.equals(expectedResult));
    }

    public void complexConstructorEmbeddableTest() {
        if (JUnitJPQLComplexTestSuite.isOnServer()) {
            return;
        }
        JpaEntityManager em = (JpaEntityManager)this.createEntityManager();
        Employee emp = (Employee)em.getActiveSession().readAllObjects(Employee.class).firstElement();
        String jpqlString = "SELECT NEW org.eclipse.persistence.testing.tests.jpa.jpql.JUnitJPQLComplexTestSuite.EmployeeDetail(emp.period) FROM Employee emp WHERE emp.id = :id";
        Query query = em.createQuery(jpqlString);
        query.setParameter("id", (Object)emp.getId());
        EmployeeDetail result = (EmployeeDetail)query.getSingleResult();
        EmployeeDetail expectedResult = new EmployeeDetail(emp.getPeriod());
        Assert.assertTrue((String)"Constructor with Embeddable parameter Test Case Failed to return", (boolean)result.equals(expectedResult));
    }

    public void complexConstructorMapTest() {
        if (JUnitJPQLComplexTestSuite.isOnServer()) {
            return;
        }
        JpaEntityManager em = (JpaEntityManager)this.createEntityManager();
        this.beginTransaction((EntityManager)em);
        BeerConsumer consumer = new BeerConsumer();
        consumer.setName("Marvin Monroe");
        em.persist((Object)consumer);
        Blue blue = new Blue();
        blue.setAlcoholContent((Object)Float.valueOf(5.0f));
        blue.setUniqueKey(BigInteger.ONE);
        consumer.addBlueBeerToConsume(blue);
        em.persist((Object)blue);
        em.flush();
        String jpqlString = "SELECT NEW org.eclipse.persistence.testing.tests.jpa.jpql.JUnitJPQLComplexTestSuite.EmployeeDetail('Mel', 'Ott', Key(b)) FROM BeerConsumer bc join bc.blueBeersToConsume b";
        Query query = em.createQuery(jpqlString);
        EmployeeDetail result = (EmployeeDetail)query.getSingleResult();
        EmployeeDetail expectedResult = new EmployeeDetail("Mel", "Ott", BigInteger.ONE);
        this.rollbackTransaction((EntityManager)em);
        Assert.assertTrue((String)"Constructor with variable argument Test Case Failed", (boolean)result.equals(expectedResult));
    }

    public void complexResultPropertiesTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        String ejbql = "SELECT e FROM Employee e ORDER BY e.id";
        Query query = em.createQuery(ejbql);
        List allEmps = query.getResultList();
        int nrOfEmps = allEmps.size();
        List result = null;
        List expectedResult = null;
        int firstResult = 2;
        int maxResults = nrOfEmps - 1;
        query = em.createQuery(ejbql);
        query.setFirstResult(firstResult);
        result = query.getResultList();
        expectedResult = allEmps.subList(firstResult, nrOfEmps);
        Assert.assertTrue((String)"Query.setFirstResult Test Case Failed", (boolean)((Object)result).equals(expectedResult));
        query = em.createQuery(ejbql);
        query.setMaxResults(maxResults);
        result = query.getResultList();
        expectedResult = allEmps.subList(0, maxResults);
        Assert.assertTrue((String)"Query.setMaxResult Test Case Failed", (boolean)((Object)result).equals(expectedResult));
        maxResults = nrOfEmps - firstResult - 1;
        query = em.createQuery(ejbql);
        query.setFirstResult(firstResult);
        query.setMaxResults(maxResults);
        result = query.getResultList();
        expectedResult = allEmps.subList(firstResult, nrOfEmps - 1);
        Assert.assertTrue((String)("Query.setFirstResult and Query.setMaxResults Test Case Failed (result=" + result + "; expected=" + expectedResult + ")"), (boolean)((Object)result).equals(expectedResult));
        this.rollbackTransaction(em);
        this.closeEntityManager(em);
    }

    public void complexNamedQueryResultPropertiesTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Query query = em.createNamedQuery("findAllEmployeesOrderById");
        List allEmps = query.getResultList();
        int nrOfEmps = allEmps.size();
        int firstResult = 2;
        Query query1 = em.createNamedQuery("findAllEmployeesOrderById");
        query1.setMaxResults(nrOfEmps - 2);
        List result1 = query1.getResultList();
        List expectedResult1 = allEmps.subList(0, nrOfEmps - 2);
        Assert.assertTrue((String)"Query1 set  MaxResults Test Case Failed", (boolean)((Object)result1).equals(expectedResult1));
        query1.setFirstResult(firstResult);
        query1.setMaxResults(nrOfEmps - 1);
        result1 = query1.getResultList();
        expectedResult1 = allEmps.subList(firstResult, nrOfEmps);
        Assert.assertTrue((String)("Query1 set FirstResult and MaxResults Test Case Failed (result=" + result1 + "; expected=" + expectedResult1 + ")"), (boolean)((Object)result1).equals(expectedResult1));
        result1 = query1.getResultList();
        expectedResult1 = allEmps.subList(firstResult, nrOfEmps);
        Assert.assertTrue((String)"Query1 without setting Test Case Failed", (boolean)((Object)result1).equals(expectedResult1));
        query1.setFirstResult(1);
        query1.setMaxResults(nrOfEmps - 2);
        result1 = query1.getResultList();
        expectedResult1 = allEmps.subList(1, nrOfEmps - 1);
        Assert.assertTrue((String)"Query1.setFirstResult Test Case Failed", (boolean)((Object)result1).equals(expectedResult1));
        Query query2 = em.createNamedQuery("findAllEmployeesOrderById");
        List result2 = query2.getResultList();
        List expectedResult2 = allEmps.subList(0, nrOfEmps);
        Assert.assertTrue((String)"Query2 without setting", (boolean)((Object)result2).equals(expectedResult2));
        Query query3 = em.createNamedQuery("findAllEmployeesOrderById");
        query3.setFirstResult(0);
        List result3 = query3.getResultList();
        List expectedResult3 = allEmps.subList(0, nrOfEmps);
        Assert.assertTrue((String)"Query3.set FirstResult and MaxResults Test Case Failed", (boolean)((Object)result3).equals(expectedResult3));
        Query query4 = em.createNamedQuery("findAllEmployeesOrderById");
        query4.setMaxResults(nrOfEmps - 3);
        List result4 = query4.getResultList();
        List expectedResult4 = allEmps.subList(0, nrOfEmps - 3);
        Assert.assertTrue((String)"Query4 set MaxResult only Test Case Failed", (boolean)((Object)result4).equals(expectedResult4));
        this.rollbackTransaction(em);
        this.closeEntityManager(em);
    }

    public void complexInSubqueryTest() {
        EntityManager em = this.createEntityManager();
        ReportQuery reportQuery = new ReportQuery();
        reportQuery.dontMaintainCache();
        reportQuery.setShouldReturnWithoutReportQueryResult(true);
        reportQuery.setReferenceClass(Employee.class);
        ExpressionBuilder builder = reportQuery.getExpressionBuilder();
        reportQuery.setSelectionCriteria(builder.get("address").get("city").equal((Object)"Ottawa"));
        reportQuery.addItem("id", builder.get("id"));
        Vector expectedResult = (Vector)JUnitJPQLComplexTestSuite.getServerSession().executeQuery((DatabaseQuery)reportQuery);
        String ejbqlString = "SELECT e.id FROM Employee e WHERE e.address.city IN (SELECT a.city FROM e.address a WHERE a.city = 'Ottawa')";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Complex IN Subquery Test Case Failed", (boolean)((Object)result).equals(expectedResult));
    }

    public void complexExistsTest() {
        EntityManager em = this.createEntityManager();
        Vector allEmps = JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class);
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        for (Employee e : allEmps) {
            Collection projects = e.getProjects();
            if (projects == null || projects.size() <= 0) continue;
            expectedResult.add(e.getId());
        }
        String ejbqlString = "SELECT e.id FROM Employee e WHERE EXISTS (SELECT p FROM e.projects p)";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Complex Not Exists test failed", (boolean)comparer.compareObjects(result, expectedResult));
    }

    public void complexNotExistsTest() {
        EntityManager em = this.createEntityManager();
        Vector allEmps = JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class);
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        for (Employee e : allEmps) {
            Collection projects = e.getProjects();
            if (projects != null && projects.size() != 0) continue;
            expectedResult.add(e.getId());
        }
        String ejbqlString = "SELECT e.id FROM Employee e WHERE NOT EXISTS (SELECT p FROM e.projects p)";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Complex Not Exists test failed", (boolean)comparer.compareObjects(result, expectedResult));
    }

    public void complexMultipleExistsSubqueryTest() {
        Vector allEmps = JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class);
        ArrayList<Employee> expectedResult = new ArrayList<Employee>();
        for (Employee e : allEmps) {
            if (e.getManager() == null) continue;
            expectedResult.add(e);
        }
        EntityManager em = this.createEntityManager();
        String ejbqlString = "SELECT e from Employee e  WHERE EXISTS (SELECT e1.id FROM Employee e1 WHERE e.manager.id = e1.id)  OR EXISTS (SELECT e2.id FROM Employee e2 WHERE e.manager.id = e2.manager.id AND e.id <> e2.id)";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Complex Multiple Exists SubQuery test failed", (boolean)comparer.compareObjects(result, expectedResult));
    }

    public void complexExistsSubqueryJoinTest() {
        EntityManager em = this.createEntityManager();
        Vector allEmps = JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class);
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        for (Employee e : allEmps) {
            List dealers = e.getDealers();
            if (dealers == null || dealers.size() <= 0) continue;
            for (Dealer d : dealers) {
                List customers = d.getCustomers();
                if (customers == null || customers.size() <= 0) continue;
                for (Customer c : customers) {
                    if (c.getBudget() <= 0) continue;
                    expectedResult.add(e.getId());
                }
            }
        }
        String ejbqlString = "SELECT emp FROM Employee AS emp WHERE EXISTS (SELECT dealers FROM emp.dealers AS dealers join dealers.customers AS customers WHERE customers.budget > 0)";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Complex Exists Subquery with join Test Case Failed", (boolean)comparer.compareObjects(result, expectedResult));
    }

    public void complexInSubqueryJoinTest() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp = builder.get("manager").isNull().not();
        ReadAllQuery query = new ReadAllQuery(Employee.class, exp);
        Vector expectedResult = (Vector)JUnitJPQLComplexTestSuite.getServerSession().executeQuery((DatabaseQuery)query);
        String ejbqlString = "SELECT e FROM Employee e WHERE e.firstName IN (SELECT emps.firstName FROM Employee emp join emp.managedEmployees emps)";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Complex IN Subquery with join Test Case Failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void complexInSubqueryJoinInTest() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp = builder.get("manager").isNull().not();
        ReadAllQuery query = new ReadAllQuery(Employee.class, exp);
        Vector expectedResult = (Vector)JUnitJPQLComplexTestSuite.getServerSession().executeQuery((DatabaseQuery)query);
        String ejbqlString = "SELECT e FROM Employee e WHERE e.firstName IN (SELECT emps.firstName FROM Employee emp, in(emp.managedEmployees) emps)";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Complex IN Subquery with join Test Case Failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void complexMemberOfTest() {
        EntityManager em = this.createEntityManager();
        Vector allEmps = JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class);
        ArrayList<Employee> expectedResult = new ArrayList<Employee>();
        String ejbqlString = "SELECT e FROM Employee e WHERE e MEMBER OF e.managedEmployees";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Complex MEMBER OF test failed", (boolean)comparer.compareObjects(result, expectedResult));
        for (Employee e : allEmps) {
            Collection projects = e.getProjects();
            if (projects == null || projects.size() <= 0) continue;
            expectedResult.add(e);
        }
        ejbqlString = "SELECT DISTINCT e FROM Employee e, Project p WHERE p MEMBER OF e.projects";
        result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Complex MEMBER OF test failed", (boolean)comparer.compareObjects(result, expectedResult));
    }

    public void complexNotMemberOfTest() {
        EntityManager em = this.createEntityManager();
        Vector allEmps = JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class);
        String ejbqlString = "SELECT e FROM Employee e WHERE e NOT MEMBER OF e.managedEmployees";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Complex MEMBER OF test failed", (boolean)comparer.compareObjects(result, (Collection)allEmps));
    }

    public void complexNotMemberOfPathTest() {
        EntityManager em = this.createEntityManager();
        Vector allEmps = JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class);
        String ejbqlString = "SELECT e FROM Employee e  WHERE e.manager NOT MEMBER OF e.managedEmployees";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Complex MEMBER OF test failed", (boolean)comparer.compareObjects(result, (Collection)allEmps));
    }

    public void complexMemberOfElementCollectionTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Buyer buyer = new Buyer();
        buyer.setName("RBCL buyer");
        buyer.setDescription("RBCL buyer");
        buyer.addRoyalBankCreditLine(10L);
        em.persist((Object)buyer);
        em.flush();
        ArrayList<Buyer> expectedResult = new ArrayList<Buyer>();
        expectedResult.add(buyer);
        String ejbqlString = "SELECT b FROM Buyer b  WHERE 10 MEMBER OF b.creditLines";
        List result = em.createQuery(ejbqlString).getResultList();
        this.rollbackTransaction(em);
        Assert.assertTrue((String)"Complex MEMBER OF test failed", (boolean)comparer.compareObjects(result, expectedResult));
    }

    public void complexInheritanceTest() {
        EntityManager em = this.createEntityManager();
        JUnitJPQLComplexTestSuite.getServerSession().addAlias("ProjectBaseClass", JUnitJPQLComplexTestSuite.getServerSession().getDescriptor(Project.class));
        Project expectedResult = (Project)JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Project.class).firstElement();
        String projectName = expectedResult.getName();
        String ejbqlString = "SELECT OBJECT(project) FROM ProjectBaseClass project WHERE project.name = \"" + projectName + "\"";
        List result = em.createQuery(ejbqlString).getResultList();
        JUnitJPQLComplexTestSuite.getServerSession().getAliasDescriptors().remove("ProjectBaseClass");
        Assert.assertTrue((String)"Complex Inheritance test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
    }

    public void complexInheritanceUsingNamedQueryTest() {
        Project expectedResult = (Project)JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Project.class).firstElement();
        String argument = expectedResult.getName();
        String queryName = "findLargeProjectByNameEJBQL";
        ServerSession uow = JUnitJPQLComplexTestSuite.getServerSession();
        if (!JUnitJPQLComplexTestSuite.getServerSession().containsQuery(queryName)) {
            JUnitJPQLComplexTestSuite.getServerSession().addAlias("ProjectBaseClass", JUnitJPQLComplexTestSuite.getServerSession().getDescriptor(Project.class));
            ReadObjectQuery query = new ReadObjectQuery();
            query.setEJBQLString("SELECT OBJECT(project) FROM ProjectBaseClass project WHERE project.name = ?1");
            query.setName(queryName);
            query.addArgument("1");
            query.setReferenceClass(Project.class);
            uow.addQuery("findLargeProjectByNameEJBQL", (DatabaseQuery)query);
        }
        Project result = (Project)uow.executeQuery("findLargeProjectByNameEJBQL", (Object)argument);
        JUnitJPQLComplexTestSuite.getServerSession().removeQuery("findLargeProjectByBudgetEJBQL");
        JUnitJPQLComplexTestSuite.getServerSession().getAliasDescriptors().remove("ProjectBaseClass");
        Assert.assertTrue((String)"Complex Inheritance using named query test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
    }

    public void complexNavigatingEmbedded() {
        EntityManager em = this.createEntityManager();
        String jpqlString = "SELECT e.formerEmployment.formerCompany FROM Employee e WHERE e.formerEmployment.formerCompany = 'Former company'";
        Query query = em.createQuery(jpqlString);
        List result = query.getResultList();
        String expected = "Former company";
        Assert.assertTrue((String)"Complex navigation of embedded in the select/where clause failed", (boolean)result.contains(expected));
    }

    public void complexNavigatingTwoLevelOfEmbeddeds() {
        EntityManager em = this.createEntityManager();
        String jpqlString = "SELECT emp.formerEmployment.period.startDate FROM Employee emp";
        Query query = em.createQuery(jpqlString);
        List result = query.getResultList();
        Calendar cal = Calendar.getInstance();
        cal.set(1990, 1, 1, 0, 0, 0);
        cal.set(14, 0);
        Date expected = new Date(cal.getTime().getTime());
        Assert.assertTrue((String)"Complex navigation of two level of embeddeds in the select clause failed", (boolean)result.contains(expected));
    }

    public void complexOuterJoinQuery() {
        EntityManager em = this.createEntityManager();
        String jpql = "SELECT t3.firstName, t2.number, t4.firstName, t1.name FROM Employee t0 INNER JOIN t0.projects t1 LEFT OUTER JOIN t0.phoneNumbers t2 LEFT OUTER JOIN t1.teamLeader t3 LEFT OUTER JOIN t1.teamMembers t4 WHERE t0.firstName = 'Nancy' AND t0.lastName = 'White' ORDER BY t4.firstName ASC ";
        Query q = em.createQuery(jpql);
        List result = q.getResultList();
        Assert.assertEquals((String)"Complex outer join query (1): unexpected result size", (int)2, (int)result.size());
        Object[] result0 = (Object[])result.get(0);
        Assert.assertNull((String)"Complex outer join query (1): unexpected result value (0, 0):", (Object)result0[0]);
        Assert.assertEquals((String)"Complex outer join query (1): unexpected result value (0, 1):", (Object)result0[1], (Object)"5551234");
        Assert.assertEquals((String)"Complex outer join query (1): unexpected result value (0, 2):", (Object)result0[2], (Object)"Marcus");
        Assert.assertEquals((String)"Complex outer join query (1): unexpected result value (0, 3):", (Object)result0[3], (Object)"Swirly Dirly");
        Object[] result1 = (Object[])result.get(1);
        Assert.assertNull((String)"Complex outer join query (1): unexpected result value (1, 0):", (Object)result1[0]);
        Assert.assertEquals((String)"Complex outer join query (1): unexpected result value (1, 1):", (Object)result1[1], (Object)"5551234");
        Assert.assertEquals((String)"Complex outer join query (1): unexpected result value (1, 2):", (Object)result1[2], (Object)"Nancy");
        Assert.assertEquals((String)"Complex outer join query (1): unexpected result value (1, 3):", (Object)result1[3], (Object)"Swirly Dirly");
        jpql = "SELECT t3.firstName, t2.number, t4.firstName, t1.name FROM Employee t0 LEFT OUTER JOIN t0.projects t1 LEFT OUTER JOIN t0.phoneNumbers t2 LEFT OUTER JOIN t1.teamLeader t3 LEFT OUTER JOIN t1.teamMembers t4 WHERE t0.firstName = 'Jill' AND t0.lastName = 'May' ORDER BY t2.number ASC ";
        q = em.createQuery(jpql);
        result = q.getResultList();
        Assert.assertEquals((String)"Complex outer join query (2): unexpected result size", (int)2, (int)result.size());
        result0 = (Object[])result.get(0);
        Assert.assertNull((String)"Complex outer join query (2): unexpected result value (0, 0):", (Object)result0[0]);
        Assert.assertEquals((String)"Complex outer join query (2): unexpected result value (0, 1):", (Object)result0[1], (Object)"2255943");
        Assert.assertNull((String)"Complex outer join query (2): unexpected result value (0, 2):", (Object)result0[2]);
        Assert.assertNull((String)"Complex outer join query (2): unexpected result value (0, 3):", (Object)result0[3]);
        result1 = (Object[])result.get(1);
        Assert.assertNull((String)"Complex outer join query (2): unexpected result value (1, 0):", (Object)result1[0]);
        Assert.assertEquals((String)"Complex outer join query (2): unexpected result value (1, 1):", (Object)result1[1], (Object)"2258812");
        Assert.assertNull((String)"Complex outer join query (2): unexpected result value (1, 2):", (Object)result1[2]);
        Assert.assertNull((String)"Complex outer join query (2): unexpected result value (1, 3):", (Object)result1[3]);
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapContainerPolicyMapKeyInSelectTest() {
        if (JUnitJPQLComplexTestSuite.getServerSession().getServerPlatform() != null && JUnitJPQLComplexTestSuite.getServerSession().getServerPlatform() instanceof Oc4jPlatform) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer consumer = new BeerConsumer();
            consumer.setName("Marvin Monroe");
            em.persist((Object)consumer);
            Blue blue = new Blue();
            blue.setAlcoholContent((Object)Float.valueOf(5.0f));
            blue.setUniqueKey(BigInteger.ONE);
            consumer.addBlueBeerToConsume(blue);
            em.persist((Object)blue);
            BeerConsumer consumer2 = new BeerConsumer();
            consumer2.setName("Marvin Monroe2");
            em.persist((Object)consumer2);
            Blue blue2 = new Blue();
            blue2.setAlcoholContent((Object)Float.valueOf(5.0f));
            blue2.setUniqueKey(BigInteger.valueOf(2L));
            consumer2.addBlueBeerToConsume(blue2);
            em.persist((Object)blue2);
            em.flush();
            Vector<BigInteger> expectedResult = new Vector<BigInteger>();
            expectedResult.add(BigInteger.ONE);
            this.clearCache();
            String ejbqlString = "SELECT KEY(b) FROM BeerConsumer bc join bc.blueBeersToConsume b where bc.name = 'Marvin Monroe'";
            List result = em.createQuery(ejbqlString).getResultList();
            Assert.assertTrue((String)"mapContainerPolicyMapKeyInSelectTest failed", (boolean)comparer.compareObjects(result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapContainerPolicyMapValueInSelectTest() {
        if (JUnitJPQLComplexTestSuite.getServerSession().getServerPlatform() != null && JUnitJPQLComplexTestSuite.getServerSession().getServerPlatform() instanceof Oc4jPlatform) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer consumer = new BeerConsumer();
            consumer.setName("Marvin Monroe");
            em.persist((Object)consumer);
            Blue blue = new Blue();
            blue.setAlcoholContent((Object)Float.valueOf(5.0f));
            blue.setUniqueKey(BigInteger.ONE);
            consumer.addBlueBeerToConsume(blue);
            em.persist((Object)blue);
            BeerConsumer consumer2 = new BeerConsumer();
            consumer2.setName("Marvin Monroe2");
            em.persist((Object)consumer2);
            Blue blue2 = new Blue();
            blue2.setAlcoholContent((Object)Float.valueOf(5.0f));
            blue2.setUniqueKey(BigInteger.valueOf(2L));
            consumer2.addBlueBeerToConsume(blue2);
            em.persist((Object)blue2);
            em.flush();
            Vector<Blue> expectedResult = new Vector<Blue>();
            expectedResult.add(blue);
            this.clearCache();
            String ejbqlString = "SELECT VALUE(b) FROM BeerConsumer bc join bc.blueBeersToConsume b where bc.name = 'Marvin Monroe'";
            List result = em.createQuery(ejbqlString).getResultList();
            Assert.assertTrue((String)"mapContainerPolicyMapValueInSelectTest failed", (boolean)comparer.compareObjects(result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapContainerPolicyMapEntryInSelectTest() {
        if (JUnitJPQLComplexTestSuite.getServerSession().getServerPlatform() != null && JUnitJPQLComplexTestSuite.getServerSession().getServerPlatform() instanceof Oc4jPlatform) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer consumer = new BeerConsumer();
            consumer.setName("Marvin Monroe");
            em.persist((Object)consumer);
            Blue blue = new Blue();
            blue.setAlcoholContent((Object)Float.valueOf(5.0f));
            blue.setUniqueKey(BigInteger.ONE);
            consumer.addBlueBeerToConsume(blue);
            em.persist((Object)blue);
            BeerConsumer consumer2 = new BeerConsumer();
            consumer2.setName("Marvin Monroe2");
            em.persist((Object)consumer2);
            Blue blue2 = new Blue();
            blue2.setAlcoholContent((Object)Float.valueOf(5.0f));
            blue2.setUniqueKey(BigInteger.valueOf(2L));
            consumer2.addBlueBeerToConsume(blue2);
            em.persist((Object)blue2);
            em.flush();
            this.clearCache();
            String ejbqlString = "SELECT ENTRY(b) FROM BeerConsumer bc join bc.blueBeersToConsume b where bc.name = 'Marvin Monroe'";
            List result = em.createQuery(ejbqlString).getResultList();
            Assert.assertTrue((String)"Incorrect number of values returned", (result.size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Did not return a Map.Entry", (boolean)(result.get(0) instanceof Map.Entry));
            Map.Entry entry = (Map.Entry)result.get(0);
            Assert.assertTrue((String)"Keys do not match", (boolean)entry.getKey().equals(BigInteger.ONE));
            Assert.assertTrue((String)"Values do not match", (boolean)comparer.compareObjects(entry.getValue(), blue));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapContainerPolicyMapKeyInSelectionCriteriaTest() {
        if (JUnitJPQLComplexTestSuite.getServerSession().getServerPlatform() != null && JUnitJPQLComplexTestSuite.getServerSession().getServerPlatform() instanceof Oc4jPlatform) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer consumer = new BeerConsumer();
            consumer.setName("Marvin Monroe");
            em.persist((Object)consumer);
            Blue blue = new Blue();
            blue.setAlcoholContent((Object)Float.valueOf(5.0f));
            blue.setUniqueKey(BigInteger.ONE);
            consumer.addBlueBeerToConsume(blue);
            em.persist((Object)blue);
            BeerConsumer consumer2 = new BeerConsumer();
            consumer2.setName("Marvin Monroe2");
            em.persist((Object)consumer2);
            Blue blue2 = new Blue();
            blue2.setAlcoholContent((Object)Float.valueOf(5.0f));
            blue2.setUniqueKey(BigInteger.valueOf(2L));
            consumer2.addBlueBeerToConsume(blue2);
            em.persist((Object)blue2);
            em.flush();
            Vector<BeerConsumer> expectedResult = new Vector<BeerConsumer>();
            expectedResult.add(consumer);
            this.clearCache();
            String ejbqlString = "SELECT bc FROM BeerConsumer bc join bc.blueBeersToConsume b where KEY(b) = 1";
            List result = em.createQuery(ejbqlString).getResultList();
            Assert.assertTrue((String)"mapContainerPolicyMapKeyInSelectionCriteriaTest failed", (boolean)comparer.compareObjects(result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapContainerPolicyMapValueInSelectionCriteriaTest() {
        if (JUnitJPQLComplexTestSuite.getServerSession().getServerPlatform() != null && JUnitJPQLComplexTestSuite.getServerSession().getServerPlatform() instanceof Oc4jPlatform) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer consumer = new BeerConsumer();
            consumer.setName("Marvin Monroe");
            em.persist((Object)consumer);
            Blue blue = new Blue();
            blue.setAlcoholContent((Object)Float.valueOf(5.0f));
            blue.setUniqueKey(BigInteger.ONE);
            consumer.addBlueBeerToConsume(blue);
            em.persist((Object)blue);
            BeerConsumer consumer2 = new BeerConsumer();
            consumer2.setName("Marvin Monroe2");
            em.persist((Object)consumer2);
            Blue blue2 = new Blue();
            blue2.setAlcoholContent((Object)Float.valueOf(5.0f));
            blue2.setUniqueKey(BigInteger.valueOf(2L));
            consumer2.addBlueBeerToConsume(blue2);
            em.persist((Object)blue2);
            em.flush();
            Vector<BeerConsumer> expectedResult = new Vector<BeerConsumer>();
            expectedResult.add(consumer);
            this.clearCache();
            String ejbqlString = "SELECT bc FROM BeerConsumer bc join bc.blueBeersToConsume b where VALUE(b).uniqueKey = 1";
            List result = em.createQuery(ejbqlString).getResultList();
            Assert.assertTrue((String)"mapContainerPolicyMapValueInSelectionCriteriaTest failed", (boolean)comparer.compareObjects(result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mappedKeyMapContainerPolicyMapKeyInSelectionCriteriaTest() {
        if (JUnitJPQLComplexTestSuite.getServerSession().getServerPlatform() != null && JUnitJPQLComplexTestSuite.getServerSession().getServerPlatform() instanceof Oc4jPlatform) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer consumer = new BeerConsumer();
            consumer.setName("Marvin Monroe");
            em.persist((Object)consumer);
            Becks becks = new Becks();
            becks.setAlcoholContent((Object)5.0);
            BecksTag tag = new BecksTag();
            tag.setCallNumber("123");
            consumer.addBecksBeerToConsume(becks, tag);
            em.persist((Object)becks);
            em.persist((Object)tag);
            BeerConsumer consumer2 = new BeerConsumer();
            consumer.setName("Marvin Monroe2");
            em.persist((Object)consumer2);
            Becks becks2 = new Becks();
            becks2.setAlcoholContent((Object)5.0);
            BecksTag tag2 = new BecksTag();
            tag2.setCallNumber("1234");
            consumer2.addBecksBeerToConsume(becks2, tag2);
            em.persist((Object)becks2);
            em.persist((Object)tag2);
            em.flush();
            Vector<BeerConsumer> expectedResult = new Vector<BeerConsumer>();
            expectedResult.add(consumer);
            this.clearCache();
            String ejbqlString = "SELECT bc FROM BeerConsumer bc join bc.becksBeersToConsume b where Key(b).callNumber = '123'";
            List result = em.createQuery(ejbqlString).getResultList();
            Assert.assertTrue((String)"mappedKeyMapContainerPolicyMapKeyInSelectionCriteriaTest failed", (boolean)comparer.compareObjects(result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mappedKeyMapContainerPolicyMapKeyInSelectTest() {
        if (JUnitJPQLComplexTestSuite.getServerSession().getServerPlatform() != null && JUnitJPQLComplexTestSuite.getServerSession().getServerPlatform() instanceof Oc4jPlatform) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer consumer = new BeerConsumer();
            consumer.setName("Marvin Monroe");
            em.persist((Object)consumer);
            Becks becks = new Becks();
            becks.setAlcoholContent((Object)5.0);
            BecksTag tag = new BecksTag();
            tag.setCallNumber("123");
            consumer.addBecksBeerToConsume(becks, tag);
            em.persist((Object)becks);
            em.persist((Object)tag);
            BeerConsumer consumer2 = new BeerConsumer();
            consumer.setName("Marvin Monroe2");
            em.persist((Object)consumer2);
            Becks becks2 = new Becks();
            becks2.setAlcoholContent((Object)5.0);
            BecksTag tag2 = new BecksTag();
            tag2.setCallNumber("1234");
            consumer2.addBecksBeerToConsume(becks2, tag2);
            em.persist((Object)becks2);
            em.persist((Object)tag2);
            em.flush();
            Vector<BecksTag> expectedResult = new Vector<BecksTag>();
            expectedResult.add(tag);
            this.clearCache();
            String ejbqlString = "SELECT Key(b) FROM BeerConsumer bc join bc.becksBeersToConsume b where Key(b).callNumber = '123'";
            List result = em.createQuery(ejbqlString).getResultList();
            Assert.assertTrue((String)"mappedKeyMapContainerPolicyMapKeyInSelectTest failed", (boolean)comparer.compareObjects(result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mappedKeyMapContainerPolicyMapEntryInSelectTest() {
        if (JUnitJPQLComplexTestSuite.getServerSession().getServerPlatform() != null && JUnitJPQLComplexTestSuite.getServerSession().getServerPlatform() instanceof Oc4jPlatform) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer consumer = new BeerConsumer();
            consumer.setName("Marvin Monroe");
            em.persist((Object)consumer);
            Becks becks = new Becks();
            becks.setAlcoholContent((Object)5.0);
            BecksTag tag = new BecksTag();
            tag.setCallNumber("123");
            consumer.addBecksBeerToConsume(becks, tag);
            em.persist((Object)becks);
            em.persist((Object)tag);
            BeerConsumer consumer2 = new BeerConsumer();
            consumer2.setName("Marvin Monroe2");
            em.persist((Object)consumer2);
            Becks becks2 = new Becks();
            becks2.setAlcoholContent((Object)5.0);
            BecksTag tag2 = new BecksTag();
            tag2.setCallNumber("1234");
            consumer2.addBecksBeerToConsume(becks2, tag2);
            em.persist((Object)becks2);
            em.persist((Object)tag2);
            em.flush();
            this.clearCache();
            String ejbqlString = "SELECT ENTRY(b) FROM BeerConsumer bc join bc.becksBeersToConsume b where Key(b) = :becksTag";
            List result = em.createQuery(ejbqlString).setParameter("becksTag", (Object)tag).getResultList();
            Assert.assertTrue((String)"Incorrect number of values returned", (result.size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Did not return a Map.Entry", (boolean)(result.get(0) instanceof Map.Entry));
            Map.Entry entry = (Map.Entry)result.get(0);
            Assert.assertTrue((String)"Keys do not match", (boolean)comparer.compareObjects(entry.getKey(), tag));
            Assert.assertTrue((String)"Values do not match", (boolean)comparer.compareObjects(entry.getValue(), becks));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mappedKeyMapContainerPolicyEmbeddableMapKeyInSelectionCriteriaTest() {
        if (JUnitJPQLComplexTestSuite.getServerSession().getServerPlatform() != null && JUnitJPQLComplexTestSuite.getServerSession().getServerPlatform() instanceof Oc4jPlatform) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer consumer = new BeerConsumer();
            consumer.setName("Marvin Monroe");
            em.persist((Object)consumer);
            Corona corona = new Corona();
            corona.setAlcoholContent((Object)5.0);
            CoronaTag tag = new CoronaTag();
            tag.setCode("123");
            tag.setNumber(Integer.valueOf(123));
            consumer.addCoronaBeerToConsume(corona, tag);
            em.persist((Object)corona);
            BeerConsumer consumer2 = new BeerConsumer();
            consumer2.setName("Marvin Monroe2");
            em.persist((Object)consumer2);
            Corona corona2 = new Corona();
            corona2.setAlcoholContent((Object)5.0);
            CoronaTag tag2 = new CoronaTag();
            tag2.setCode("1234");
            tag2.setNumber(Integer.valueOf(1234));
            consumer2.addCoronaBeerToConsume(corona2, tag2);
            em.persist((Object)corona2);
            em.flush();
            Vector<BeerConsumer> expectedResult = new Vector<BeerConsumer>();
            expectedResult.add(consumer);
            this.clearCache();
            String ejbqlString = "SELECT bc FROM BeerConsumer bc join bc.coronaBeersToConsume b where Key(b).code = :key";
            List result = em.createQuery(ejbqlString).setParameter("key", (Object)"123").getResultList();
            Assert.assertTrue((String)"mappedKeyMapContainerPolicyEmbeddableMapKeyInSelectionCriteriaTest failed", (boolean)comparer.compareObjects(result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mappedKeyMapContainerPolicyElementCollectionSelectionCriteriaTest() {
        if (JUnitJPQLComplexTestSuite.getServerSession().getServerPlatform() != null && JUnitJPQLComplexTestSuite.getServerSession().getServerPlatform() instanceof Oc4jPlatform) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            ExpertBeerConsumer consumer = new ExpertBeerConsumer();
            consumer.setAccredidation(new Accredidation());
            consumer.setName("Marvin Monroe");
            Birthday bday = new Birthday();
            bday.setDay(Integer.valueOf(25));
            bday.setMonth(Integer.valueOf(6));
            bday.setYear(Integer.valueOf(2009));
            consumer.addCelebration(bday, "Lots of Cake!");
            ExpertBeerConsumer consumer2 = new ExpertBeerConsumer();
            consumer2.setAccredidation(new Accredidation());
            consumer2.setName("Marvin Monroe2");
            Birthday bday2 = new Birthday();
            bday2.setDay(Integer.valueOf(25));
            bday2.setMonth(Integer.valueOf(6));
            bday2.setYear(Integer.valueOf(2001));
            consumer2.addCelebration(bday, "Lots of food!");
            em.persist((Object)consumer);
            em.flush();
            Vector<ExpertBeerConsumer> expectedResult = new Vector<ExpertBeerConsumer>();
            expectedResult.add(consumer);
            this.clearCache();
            String ejbqlString = "SELECT bc FROM EXPERT_CONSUMER bc join bc.celebrations c where Key(c).day = :celebration";
            List result = em.createQuery(ejbqlString).setParameter("celebration", (Object)25).getResultList();
            Assert.assertTrue((String)"mappedKeyMapContainerPolicyElementCollctionSelectionCriteriaTest failed", (boolean)comparer.compareObjects(result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mappedKeyMapContainerPolicyNavigateMapKeyInEntityTest() {
        if (JUnitJPQLComplexTestSuite.getServerSession().getServerPlatform() != null && JUnitJPQLComplexTestSuite.getServerSession().getServerPlatform() instanceof Oc4jPlatform) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer consumer = new BeerConsumer();
            consumer.setName("Marvin Monroe");
            em.persist((Object)consumer);
            Becks becks = new Becks();
            becks.setAlcoholContent((Object)5.0);
            BecksTag tag = new BecksTag();
            tag.setCallNumber("123");
            consumer.addBecksBeerToConsume(becks, tag);
            em.persist((Object)becks);
            em.persist((Object)tag);
            BeerConsumer consumer2 = new BeerConsumer();
            consumer2.setName("Marvin Monroe2");
            em.persist((Object)consumer2);
            Becks becks2 = new Becks();
            becks2.setAlcoholContent((Object)5.0);
            BecksTag tag2 = new BecksTag();
            tag2.setCallNumber("1234");
            consumer2.addBecksBeerToConsume(becks2, tag2);
            em.persist((Object)becks2);
            em.persist((Object)tag2);
            em.flush();
            Vector<String> expectedResult = new Vector<String>();
            expectedResult.add("123");
            this.clearCache();
            String ejbqlString = "SELECT KEY(becks).callNumber from BeerConsumer bc join bc.becksBeersToConsume becks where bc.name = 'Marvin Monroe'";
            List result = em.createQuery(ejbqlString).getResultList();
            Assert.assertTrue((String)"mappedKeyMapContainerPolicyNavigateMapKeyInEntityTest failed", (boolean)comparer.compareObjects(result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mappedKeyMapContainerPolicyNavigateMapKeyInEmbeddableTest() {
        if (JUnitJPQLComplexTestSuite.getServerSession().getServerPlatform() != null && JUnitJPQLComplexTestSuite.getServerSession().getServerPlatform() instanceof Oc4jPlatform) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer consumer = new BeerConsumer();
            consumer.setName("Marvin Monroe");
            em.persist((Object)consumer);
            Corona corona = new Corona();
            corona.setAlcoholContent((Object)5.0);
            CoronaTag tag = new CoronaTag();
            tag.setCode("123");
            tag.setNumber(Integer.valueOf(123));
            consumer.addCoronaBeerToConsume(corona, tag);
            em.persist((Object)corona);
            BeerConsumer consumer2 = new BeerConsumer();
            consumer2.setName("Marvin Monroe2");
            em.persist((Object)consumer2);
            Corona corona2 = new Corona();
            corona2.setAlcoholContent((Object)5.0);
            CoronaTag tag2 = new CoronaTag();
            tag2.setCode("1234");
            tag2.setNumber(Integer.valueOf(1234));
            consumer2.addCoronaBeerToConsume(corona2, tag2);
            em.persist((Object)corona2);
            em.flush();
            Vector<String> expectedResult = new Vector<String>();
            expectedResult.add("123");
            this.clearCache();
            String ejbqlString = "SELECT KEY(c).code from BeerConsumer bc join bc.coronaBeersToConsume c where bc.name = 'Marvin Monroe'";
            List result = em.createQuery(ejbqlString).getResultList();
            Assert.assertTrue((String)"mappedKeyMapContainerPolicyNavigateMapKeyInEmbeddableTest failed", (boolean)comparer.compareObjects(result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    public void complexTypeParameterTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Vector expectedResult = JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(LargeProject.class);
        this.clearCache();
        String ejbqlString = "select p from Project p where TYPE(p) = :param";
        List result = em.createQuery(ejbqlString).setParameter("param", LargeProject.class).getResultList();
        Assert.assertTrue((String)"complexTypeParameterTest failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        this.rollbackTransaction(em);
        this.closeEntityManager(em);
    }

    public void complexTypeInTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Vector expectedResult = JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(LargeProject.class);
        expectedResult.addAll(JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(SmallProject.class));
        this.clearCache();
        String ejbqlString = "select p from Project p where TYPE(p) in(LargeProject, SmallProject)";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"complexTypeParameterTest failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        this.rollbackTransaction(em);
        this.closeEntityManager(em);
    }

    public void complexTypeInParamTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Vector expectedResult = JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(LargeProject.class);
        expectedResult.addAll(JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(SmallProject.class));
        this.clearCache();
        String ejbqlString = "select p from Project p where TYPE(p) in :param";
        ArrayList<Class> params = new ArrayList<Class>(2);
        params.add(LargeProject.class);
        params.add(SmallProject.class);
        List result = em.createQuery(ejbqlString).setParameter("param", params).getResultList();
        Assert.assertTrue((String)"complexTypeParameterTest failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        this.rollbackTransaction(em);
        this.closeEntityManager(em);
    }

    public void complexThreeLevelJoinOneTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Expression exp = new ExpressionBuilder().get("manager").get("address").get("city").equal((Object)"Ottawa");
        Vector expectedResult = JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class, exp);
        this.clearCache();
        String ejbqlString = "select e from Employee e join e.manager.address a where a.city = 'Ottawa'";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"complexThreeLevelJoinOneTest failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        this.rollbackTransaction(em);
        this.closeEntityManager(em);
    }

    public void complexThreeLevelJoinManyTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Expression exp = new ExpressionBuilder().get("manager").anyOf("phoneNumbers").get("areaCode").equal((Object)"613");
        Vector expectedResult = JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class, exp);
        this.clearCache();
        String ejbqlString = "select distinct e from Employee e join e.manager.phoneNumbers p where p.areaCode = '613'";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"complexThreeLevelJoinOneTest failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        this.rollbackTransaction(em);
        this.closeEntityManager(em);
    }

    public void complexIndexOfInSelectClauseTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        ExpertBeerConsumer consumer = new ExpertBeerConsumer();
        consumer.setAccredidation(new Accredidation());
        consumer.getDesignations().add("guru");
        consumer.getDesignations().add("beer-meister");
        em.persist((Object)consumer);
        em.flush();
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(new Integer(0));
        expectedResult.add(new Integer(1));
        this.clearCache();
        String ejbqlString = "select index(d) from EXPERT_CONSUMER e join e.designations d";
        List result = em.createQuery(ejbqlString).getResultList();
        this.rollbackTransaction(em);
        Assert.assertTrue((String)"complexIndexOfInSelectClauseTest failed", (boolean)comparer.compareObjects(result, expectedResult));
    }

    public void complexIndexOfInWhereClauseTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        ExpertBeerConsumer consumer = new ExpertBeerConsumer();
        consumer.setAccredidation(new Accredidation());
        consumer.getDesignations().add("guru");
        consumer.getDesignations().add("beer-meister");
        em.persist((Object)consumer);
        em.flush();
        String expectedResult = "guru";
        this.clearCache();
        String ejbqlString = "select d from EXPERT_CONSUMER e join e.designations d where index(d) = 0";
        String result = (String)em.createQuery(ejbqlString).getSingleResult();
        this.rollbackTransaction(em);
        Assert.assertTrue((String)"complexIndexOfInWhereClauseTest failed", (boolean)result.equals(expectedResult));
    }

    public void complexCoalesceInWhereTest() {
        EntityManager em = this.createEntityManager();
        Expression exp = new ExpressionBuilder().get("firstName").equal((Object)"Bob");
        Vector expectedResult = JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class, exp);
        this.clearCache();
        String ejbqlString = "select e from Employee e where coalesce(e.firstName, e.lastName) = 'Bob'";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"complexIndexOfInWhereClauseTest failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void complexCoalesceInSelectTest() {
        EntityManager em = this.createEntityManager();
        ReportQuery reportQuery = new ReportQuery();
        reportQuery.dontMaintainCache();
        reportQuery.setShouldReturnWithoutReportQueryResult(true);
        reportQuery.setReferenceClass(Employee.class);
        ExpressionBuilder builder = reportQuery.getExpressionBuilder();
        reportQuery.addItem("firstName", builder.get("firstName"));
        Vector expectedResult = (Vector)JUnitJPQLComplexTestSuite.getServerSession().executeQuery((DatabaseQuery)reportQuery);
        this.clearCache();
        String ejbqlString = "select coalesce(e.firstName, e.lastName) from Employee e";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"complexIndexOfInWhereClauseTest failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void complexNullIfInWhereTest() {
        EntityManager em = this.createEntityManager();
        Expression exp = new ExpressionBuilder().get("firstName").equal((Object)"Bob");
        Vector expectedResult = JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class, exp);
        this.clearCache();
        String ejbqlString = "select e from Employee e where nullIf(e.firstName, 'Bob') is null";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"complexIndexOfInWhereClauseTest failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void complexNullIfInSelectTest() {
        EntityManager em = this.createEntityManager();
        Vector<Object> expectedResult = new Vector<Object>();
        expectedResult.add(null);
        this.clearCache();
        String ejbqlString = "select nullIf(e.firstName, 'Bob') from Employee e where e.firstName = 'Bob'";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"complexIndexOfInWhereClauseTest failed", (boolean)comparer.compareObjects(result, expectedResult));
    }

    public void complexSimpleCaseInSelectTest() {
        if (JUnitTestCase.getServerSession().getPlatform().isDerby()) {
            JUnitJPQLComplexTestSuite.warning((String)"The test complexSimpleCaseInSelectTest is not supported on Derby, because Derby does not support simple CASE");
            return;
        }
        EntityManager em = this.createEntityManager();
        Vector<String> expectedResult = new Vector<String>(2);
        expectedResult.add("Robert");
        expectedResult.add("Gillian");
        this.clearCache();
        String ejbqlString = "select case e.firstName when 'Bob' then 'Robert' when 'Jill' then 'Gillian' else '' end from Employee e where e.firstName = 'Bob' or e.firstName = 'Jill'";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"complexSimpleCaseInSelectTest failed", (boolean)comparer.compareObjects(result, expectedResult));
    }

    public void complexSimpleCaseInWhereTest() {
        if (JUnitTestCase.getServerSession().getPlatform().isDerby()) {
            JUnitJPQLComplexTestSuite.warning((String)"The test complexSimpleCaseInWhereTest is not supported on Derby, because Derby does not support simple CASE");
            return;
        }
        EntityManager em = this.createEntityManager();
        Expression exp = new ExpressionBuilder().get("firstName").equal((Object)"Bob");
        Vector expectedResult = JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class, exp);
        this.clearCache();
        String ejbqlString = "select e from Employee e where case e.firstName when 'Bob' then 'Robert' when 'Jill' then 'Gillian' else '' end = 'Robert'";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"complexSimpleCaseInWhereTest failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void complexConditionCaseInSelectTest() {
        EntityManager em = this.createEntityManager();
        Vector<String> expectedResult = new Vector<String>(2);
        expectedResult.add("Robert");
        expectedResult.add("Gillian");
        this.clearCache();
        String ejbqlString = "select case when e.firstName = 'Bob' then 'Robert' when e.firstName = 'Jill' then 'Gillian' else '' end from Employee e  where e.firstName = 'Bob' or e.firstName = 'Jill'";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"complexConditionCaseInSelectTest failed", (boolean)comparer.compareObjects(result, expectedResult));
    }

    public void complexConditionCaseInWhereTest() {
        EntityManager em = this.createEntityManager();
        Expression exp = new ExpressionBuilder().get("firstName").equal((Object)"Bob");
        Vector expectedResult = JUnitJPQLComplexTestSuite.getServerSession().readAllObjects(Employee.class, exp);
        this.clearCache();
        String ejbqlString = "select e from Employee e where case when e.firstName = 'Bob' then 'Robert' when e.firstName = 'Jill' then 'Gillian' else '' end = 'Robert'";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"complexConditionCaseInWhereTest failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void complexConditionCaseInUpdateTest() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            JUnitJPQLComplexTestSuite.getServerSession().logMessage("Test complexConditionCaseInUpdateTest skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        this.clearCache();
        String ejbqlString = "Update Employee e set e.lastName = case when e.firstName = 'Bob' then 'Jones' when e.firstName = 'Jill' then 'Jones' else '' end";
        em.createQuery(ejbqlString).executeUpdate();
        String verificationString = "select e from Employee e where e.lastName = 'Jones'";
        List results = em.createQuery(verificationString).getResultList();
        this.rollbackTransaction(em);
        JUnitJPQLComplexTestSuite.assertTrue((String)"complexConditionCaseInUpdateTest - wrong number of results", (results.size() == 2 ? 1 : 0) != 0);
        for (Employee e : results) {
            JUnitJPQLComplexTestSuite.assertTrue((String)("complexConditionCaseInUpdateTest wrong last name for - " + e.getFirstName()), (boolean)e.getLastName().equals("Jones"));
        }
    }

    public void absInSelectTest() {
        String ejbqlString;
        EntityManager em = this.createEntityManager();
        List result = em.createQuery(ejbqlString = "select abs(e.salary) from Employee e where e.firstName = 'Bob' and e.lastName = 'Smith'").getResultList();
        JUnitJPQLComplexTestSuite.assertTrue((String)"The wrong absolute value was returned.", ((Integer)result.get(0) == 35000 ? 1 : 0) != 0);
    }

    public void modInSelectTest() {
        String ejbqlString;
        EntityManager em = this.createEntityManager();
        List result = em.createQuery(ejbqlString = "select mod(e.salary, 10) from Employee e where e.firstName = 'Bob' and e.lastName = 'Smith'").getResultList();
        JUnitJPQLComplexTestSuite.assertTrue((String)"The wrong mod value was returned.", ((Integer)result.get(0) == 0 ? 1 : 0) != 0);
    }

    public void sqrtInSelectTest() {
        String ejbqlString;
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            JUnitJPQLComplexTestSuite.getServerSession().logMessage("Test sqrtInSelectTest skipped for this platform, Symfoware doesn't support SQRT, COS, SIN, TAN functions.");
            return;
        }
        EntityManager em = this.createEntityManager();
        List result = em.createQuery(ejbqlString = "select sqrt(e.salary) from Employee e where e.firstName = 'Bob' and e.lastName = 'Smith'").getResultList();
        JUnitJPQLComplexTestSuite.assertTrue((String)"The wrong square root value was returned.", ((Double)result.get(0) > 187.0 ? 1 : 0) != 0);
        JUnitJPQLComplexTestSuite.assertTrue((String)"The wrong square root value was returned.", ((Double)result.get(0) < 188.0 ? 1 : 0) != 0);
    }

    public void sizeInSelectTest() {
        String ejbqlString;
        EntityManager em = this.createEntityManager();
        List result = em.createQuery(ejbqlString = "select size(e.phoneNumbers) from Employee e where e.firstName = 'Betty'").getResultList();
        JUnitJPQLComplexTestSuite.assertTrue((String)"The wrong absolute value was returned.", ((Integer)result.get(0) == 2 ? 1 : 0) != 0);
    }

    public void mathInSelectTest() {
        String ejbqlString;
        EntityManager em = this.createEntityManager();
        List result = em.createQuery(ejbqlString = "select e.salary + 100 from Employee e where e.firstName = 'Bob' and e.lastName = 'Smith'").getResultList();
        JUnitJPQLComplexTestSuite.assertTrue((String)"The wrong value was returned.", ((Integer)result.get(0) == 35100 ? 1 : 0) != 0);
    }

    public void paramNoVariableTest() {
        EntityManager em = this.createEntityManager();
        List expectedResult = em.createQuery("select e from Employee e where e.firstName = 'Bob'").getResultList();
        String ejbqlString = "select e from Employee e where :arg = 1 or e.firstName = 'Bob'";
        List result = em.createQuery(ejbqlString).setParameter("arg", (Object)2).getResultList();
        JUnitJPQLComplexTestSuite.assertTrue((String)("The wrong number of employees returned, expected:" + expectedResult + " got:" + result), (result.size() == expectedResult.size() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mappedContainerPolicyCompoundMapKeyTest() {
        if (JUnitJPQLComplexTestSuite.getServerSession().getServerPlatform() != null && JUnitJPQLComplexTestSuite.getServerSession().getServerPlatform() instanceof Oc4jPlatform) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer consumer = new BeerConsumer();
            consumer.setName("Marvin Monroe");
            em.persist((Object)consumer);
            TelephoneNumber number = new TelephoneNumber();
            number.setType("Home");
            number.setAreaCode("975");
            number.setNumber("1234567");
            em.persist((Object)number);
            consumer.addTelephoneNumber(number);
            BeerConsumer consumer2 = new BeerConsumer();
            consumer2.setName("Marvin Monroe2");
            em.persist((Object)consumer2);
            TelephoneNumber number2 = new TelephoneNumber();
            number2.setType("Home");
            number2.setAreaCode("974");
            number2.setNumber("1234567");
            em.persist((Object)number2);
            consumer2.addTelephoneNumber(number2);
            em.flush();
            Vector<TelephoneNumber> expectedResult = new Vector<TelephoneNumber>();
            expectedResult.add(number);
            this.clearCache();
            String ejbqlString = "SELECT KEY(number) from BeerConsumer bc join bc.telephoneNumbers number where bc.name = 'Marvin Monroe'";
            List result = em.createQuery(ejbqlString).getResultList();
            Assert.assertTrue((String)"mappedContainerPolicyCompoundMapKeyTest failed", (boolean)comparer.compareObjects(result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    public void updateWhereExistsTest() {
        this.whereExistsTest(true);
    }

    public void deleteWhereExistsTest() {
        this.whereExistsTest(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void whereExistsTest(boolean shouldUpdate) {
        String lastName = (shouldUpdate ? "update" : "delete") + "WhereExistsTest";
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            JUnitJPQLComplexTestSuite.getServerSession().logMessage("Test " + lastName + " skipped for this platform, " + "Symfoware doesn't support UpdateAll/DeleteAll queries that involve a subquery " + "that includes a reference to a table in the outer query (see rfe 298193).");
            return;
        }
        int nMen = 4;
        int nWomen = 2;
        Assert.assertTrue((String)"Test setup problem: nMen should be greater than nWomen", (nMen > nWomen ? 1 : 0) != 0);
        EntityManager em = this.createEntityManager();
        String whereExists = " WHERE EXISTS (SELECT w FROM Woman w WHERE w.firstName = m.firstName AND w.lastName = m.lastName AND m.lastName = '" + lastName + "')";
        String jpqlCount = "SELECT COUNT(m) FROM Man m" + whereExists;
        String jpqlUpdateOrDelete = (shouldUpdate ? "UPDATE Man m SET m.firstName = 'New'" : "DELETE FROM Man m") + whereExists;
        this.beginTransaction(em);
        try {
            for (int i = 0; i < nMen; ++i) {
                em.persist((Object)new Man(Integer.toString(i), lastName));
                if (i >= nWomen) continue;
                em.persist((Object)new Woman(Integer.toString(i), lastName));
            }
            em.flush();
            em.clear();
            Query countQuery = em.createQuery(jpqlCount);
            long nMenRead = (Long)countQuery.getSingleResult();
            Assert.assertTrue((String)("Test setup problem: nMenRead should be equal to nWomen before update/delete, but nMenRead =" + nMenRead + "; nWomen =" + nWomen), ((long)nWomen == nMenRead ? 1 : 0) != 0);
            Query updateOrDeleteQuery = em.createQuery(jpqlUpdateOrDelete);
            int nMenUpdatedOrDeleted = updateOrDeleteQuery.executeUpdate();
            em.flush();
            em.clear();
            nMenRead = (Long)countQuery.getSingleResult();
            Assert.assertTrue((String)("nMenUpdatedOrDeleted should be equal to nWomen, but nMenUpdatedOrDeleted =" + nMenUpdatedOrDeleted + "; nWomen =" + nWomen), (nMenUpdatedOrDeleted == nWomen ? 1 : 0) != 0);
            Assert.assertTrue((String)("nMenRead should be 0 after deletion, but nMenRead =" + nMenRead), (nMenRead == 0L ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    public void caseTypeTest() {
        if (JUnitTestCase.getServerSession().getPlatform().isDerby()) {
            JUnitJPQLComplexTestSuite.warning((String)"The test caseTypeTest is not supported on Derby, because Derby does not support simple CASE");
            return;
        }
        EntityManager em = this.createEntityManager();
        String jpqlString1 = "SELECT CONCAT(case e.firstName when 'Bob' then 'Robert' when 'Jill' then 'Gillian' else '' end, ' - full name') FROM Employee e";
        em.createQuery(jpqlString1).getResultList();
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            JUnitJPQLComplexTestSuite.warning((String)"The test 'caseTypeTest' is not supported on Symfoware, EclipseLink will convert some (not all) Integer into String, and because Symfoware does not support implicit type conversion, we ended up with the addition between String and Integer which is illegal on Symfoware.");
            this.closeEntityManager(em);
            return;
        }
        String jpqlString2 = "SELECT case e.firstName when 'Bob' then 1 when 'Jill' then 2 else 0 end + 1 FROM Employee e";
        em.createQuery(jpqlString2).getResultList();
        this.closeEntityManager(em);
    }

    public void variableReferencedOnlyInParameterTest() {
        if (this.getDatabaseSession().getPlatform().isSymfoware()) {
            JUnitJPQLComplexTestSuite.warning((String)"Test variableReferencedOnlyInParameterTest skipped for this platform, Symfoware doesn't support SQRT, COS, SIN, TAN functions.");
            return;
        }
        EntityManager em = this.createEntityManager();
        String[] jpqlString = new String[]{"SELECT (e.id + 1) FROM Employee e", "SELECT ABS(e.id) FROM Employee e", "SELECT LENGTH(e.firstName) FROM Employee e", "SELECT MOD(e.id, 2) FROM Employee e", "SELECT SQRT(e.id) FROM Employee e", "SELECT LOCATE(e.firstName, 'a') FROM Employee e", "SELECT SIZE(e.phoneNumbers) FROM Employee e", "SELECT CONCAT(e.firstName, e.lastName) FROM Employee e", "SELECT CONCAT('a', e.lastName) FROM Employee e", "SELECT CONCAT(e.firstName, 'b') FROM Employee e", "SELECT SUBSTRING(e.firstName, 1, 2) FROM Employee e", "SELECT TRIM(e.firstName) FROM Employee e", "SELECT TRIM(LEADING FROM e.firstName) FROM Employee e", "SELECT TRIM(TRAILING FROM e.firstName) FROM Employee e", "SELECT TRIM(LEADING 'A' FROM e.firstName) FROM Employee e", "SELECT TRIM(TRAILING 'A' FROM e.firstName) FROM Employee e", "SELECT UPPER(e.firstName) FROM Employee e", "SELECT LOWER(e.firstName) FROM Employee e"};
        String jpql = null;
        for (int i = 0; i < jpqlString.length; ++i) {
            jpql = jpqlString[i];
            if ((this.getDatabaseSession().getPlatform().isSybase() || this.getDatabaseSession().getPlatform().isSQLServer()) && (jpql == "SELECT TRIM(LEADING 'A' FROM e.firstName) FROM Employee e" || jpql == "SELECT TRIM(TRAILING 'A' FROM e.firstName) FROM Employee e")) {
                JUnitJPQLComplexTestSuite.warning((String)("Not supported on Sybase/SQL Server " + jpql));
                continue;
            }
            Query query = em.createQuery(jpql);
            query.getResultList();
        }
        this.closeEntityManager(em);
    }

    public void standardFunctionCreateQueryTest() {
        boolean shouldPrintJpql = false;
        boolean shouldPrintStackTrace = false;
        EntityManager em = this.createEntityManager();
        String[] jpqlString = new String[]{"SELECT e.id FROM Employee e WHERE ABS(:param0) = e.id", "SELECT e.id FROM Employee e WHERE ABS(e.id) = :param0", "SELECT e.id FROM Employee e WHERE SQRT(:param0) = e.id", "SELECT e.id FROM Employee e WHERE SQRT(e.id) = :param", "SELECT e.id FROM Employee e WHERE LENGTH(:param0) = e.id", "SELECT e.id FROM Employee e WHERE LENGTH(e.firstName) = :param0", "SELECT e.id FROM Employee e WHERE MOD(e.id, :param0) = 1", "SELECT e.id FROM Employee e WHERE MOD(:param0, :param1) = e.id", "SELECT e.id FROM Employee e WHERE LOCATE(e.firstName, :param0, :param1) = :param2", "SELECT e.id FROM Employee e WHERE CONCAT(:param0, e.firstName, :param1) = :param2", "SELECT e.id FROM Employee e WHERE SUBSTRING(e.firstName, :param1, :param2) = :param3", "SELECT e.id FROM Employee e WHERE SUBSTRING(e.firstName, :param1, :param2) = e.lastName", "SELECT e.id FROM Employee e WHERE SUBSTRING(:param0, :param1, :param2) = e.firstName", "SELECT e.id FROM Employee e WHERE TRIM(:param0) = e.firstName", "SELECT e.id FROM Employee e WHERE TRIM(e.firstName) = :param0", "SELECT e.id FROM Employee e WHERE TRIM(LEADING FROM e.firstName) = :param0", "SELECT e.id FROM Employee e WHERE TRIM(BOTH FROM :param0) = e.firstName", "SELECT e.id FROM Employee e WHERE TRIM(LEADING 'a' FROM e.firstName) = :param0", "SELECT e.id FROM Employee e WHERE TRIM(TRAILING 'a' FROM e.firstName) = :param0", "SELECT e.id FROM Employee e WHERE TRIM(' ' FROM e.firstName) = :param0", "SELECT e.id FROM Employee e WHERE TRIM('a' FROM e.firstName) = :param0", "SELECT e.id FROM Employee e WHERE TRIM(BOTH 'a' FROM e.firstName) = :param0", "SELECT e.id FROM Employee e WHERE TRIM(LEADING :param0 FROM :param1) = e.firstName", "SELECT e.id FROM Employee e WHERE LOWER(:param0) = e.firstName", "SELECT e.id FROM Employee e WHERE UPPER(:param0) = e.lastName", "SELECT ABS(e.id) FROM Employee e", "SELECT SQRT(e.id) FROM Employee e", "SELECT LENGTH(e.firstName) FROM Employee e", "SELECT MOD(e.id, 2) FROM Employee e", "SELECT LOCATE('abc', e.firstName, 2) FROM Employee e", "SELECT LOCATE('abc', e.firstName) FROM Employee e", "SELECT LOCATE(e.firstName, 'abc', 2) FROM Employee e", "SELECT LOCATE(e.firstName, 'abc') FROM Employee e", "SELECT CONCAT(e.firstName, 'A', 'Blah') FROM Employee e", "SELECT SUBSTRING(e.firstName, 1, 2) FROM Employee e", "SELECT TRIM(LEADING 'a' FROM e.firstName) FROM Employee e", "SELECT TRIM(TRAILING 'a' FROM e.firstName) FROM Employee e", "SELECT TRIM(e.firstName) FROM Employee e", "SELECT TRIM(' ' FROM e.firstName) FROM Employee e", "SELECT TRIM(BOTH 'a' FROM e.firstName) FROM Employee e", "SELECT TRIM(LEADING FROM e.firstName) FROM Employee e", "SELECT TRIM('a' FROM e.firstName) FROM Employee e", "SELECT TRIM(e.firstName) FROM Employee e", "SELECT LOWER(e.firstName) FROM Employee e", "SELECT UPPER(e.firstName) FROM Employee e"};
        String errorMsg = "";
        String jpql = null;
        for (int i = 0; i < jpqlString.length; ++i) {
            try {
                jpql = jpqlString[i];
                em.createQuery(jpql);
                continue;
            }
            catch (Exception ex) {
                if (shouldPrintJpql) {
                    System.out.println(jpql);
                }
                if (shouldPrintStackTrace) {
                    ex.printStackTrace();
                }
                errorMsg = errorMsg + '\t' + jpql + " - " + ex + '\n';
            }
        }
        this.closeEntityManager(em);
        if (errorMsg.length() > 0) {
            errorMsg = "Failed:\n" + errorMsg;
            JUnitJPQLComplexTestSuite.fail((String)errorMsg);
        }
    }

    public void customFunctionNVLTest() {
        if (!JUnitJPQLComplexTestSuite.getServerSession().getPlatform().isOracle()) {
            JUnitJPQLComplexTestSuite.warning((String)"The test customFunctionNVLTest is supported on Oracle only");
            return;
        }
        EntityManager em = this.createEntityManager();
        String[] jpqlString = new String[]{"SELECT FUNC('NVL', e.firstName, 'NoFirstName'), func('NVL', e.lastName, 'NoLastName') FROM Employee e", "SELECT FUNC('NVL', e.firstName, :param0), func('NVL', :param1, e.lastName) FROM Employee e", "SELECT FUNC('NVL', e.firstName, SUBSTRING(e.lastName, 1)), func('NVL', e.lastName, CONCAT(e.lastName, ' no name')) FROM Employee e", "SELECT CONCAT(FUNC('NVL', e.firstName, 'NoFirstName'), func('NVL', e.lastName, 'NoLastName')) FROM Employee e", "SELECT e.id FROM Employee e WHERE FUNC('NVL', e.firstName, 'NoFirstName') = func('NVL', e.lastName, 'NoLastName')", "SELECT e.id FROM Employee e WHERE FUNC('NVL', e.firstName, :param0) = func('NVL', :param1, e.lastName)", "SELECT e.id FROM Employee e WHERE FUNC('NVL', e.firstName, SUBSTRING(e.lastName, 1)) = func('NVL', e.lastName, CONCAT(e.lastName, ' no name'))", "SELECT e.id FROM Employee e WHERE CONCAT(FUNC('NVL', e.firstName, 'NoFirstName'), func('NVL', e.lastName, 'NoLastName')) = 'NoFirstNameNoLastName'"};
        String errorMsg = "";
        String jpql = null;
        for (int i = 0; i < jpqlString.length; ++i) {
            try {
                jpql = jpqlString[i];
                Query query = em.createQuery(jpql);
                if (i == 1 || i == 5) {
                    query.setParameter("param0", (Object)"Blah0");
                    query.setParameter("param1", (Object)"Blah1");
                }
                query.getResultList();
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                errorMsg = errorMsg + '\t' + jpql + " - " + ex + '\n';
            }
        }
        this.closeEntityManager(em);
        if (errorMsg.length() > 0) {
            errorMsg = "Failed:\n" + errorMsg;
            JUnitJPQLComplexTestSuite.fail((String)errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFuncWithStoredFunc() {
        if (!this.supportsStoredFunctions()) {
            JUnitJPQLComplexTestSuite.warning((String)"this test is not suitable for running on dbs that don't support stored function");
            return;
        }
        String sqlString = "SELECT e.id FROM Employee e WHERE e.salary = FUNC('StoredFunction_In', 75)";
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery(sqlString);
            List result = query.getResultList();
            Employee emp = (Employee)em.find(Employee.class, result.get(0));
            JUnitJPQLComplexTestSuite.assertTrue((String)"Func is not working properly with stored function.", (emp.getSalary() == 75000 ? 1 : 0) != 0);
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFUNCTIONWithStoredFunc() {
        if (!this.isHermesParser()) {
            JUnitJPQLComplexTestSuite.warning((String)"testJoinFetchAlias only works with Hermes");
            return;
        }
        if (!this.supportsStoredFunctions()) {
            JUnitJPQLComplexTestSuite.warning((String)"this test is not suitable for running on dbs that don't support stored function");
            return;
        }
        String jpql = "SELECT e.id FROM Employee e WHERE e.salary = FUNCTION('StoredFunction_In', 75)";
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery(jpql);
            List result = query.getResultList();
            Employee emp = (Employee)em.find(Employee.class, result.get(0));
            JUnitJPQLComplexTestSuite.assertTrue((String)"FUNCTION is not working properly with stored function.", (emp.getSalary() == 75000 ? 1 : 0) != 0);
            query = em.createQuery("SELECT FUNCTION('StoredFunction_In', e.id) + 5 FROM Employee e WHERE FUNCTION('StoredFunction_In', 75) + 5 = e.salary");
            query.getResultList();
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSQLCast() {
        if (!this.isHermesParser()) {
            JUnitJPQLComplexTestSuite.warning((String)"testSQLCast only works with Hermes");
            return;
        }
        if (!this.getPlatform().isOracle()) {
            JUnitJPQLComplexTestSuite.warning((String)"testSQLCast only works with Oracle");
            return;
        }
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery("Select SQL('CAST(? AS INTEGER)', e.id) from Employee e where SQL('CAST(? AS INTEGER)', e.id) > 0");
            query.getResultList();
            query = em.createQuery("Select e from Employee e order by SQL('? NULLS LAST', e.id)");
            query.getResultList();
            query = em.createQuery("Select e from Employee e where e.id > 0 AND SQL('? = ? + ?', e.id, e.id, e.id)");
            query.getResultList();
            query = em.createQuery("Select e from Employee e where SQL('1 = 1')");
            query.getResultList();
            query = em.createQuery("Select e from Employee e where SQL('? = ?', 1, 2)");
            query.getResultList();
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCast() {
        if (!this.isHermesParser()) {
            JUnitJPQLComplexTestSuite.warning((String)"testCast only works with Hermes");
            return;
        }
        EntityManager em = this.createEntityManager();
        try {
            Query query = null;
            query = em.createQuery("Select cast(e.firstName as char(30)) from Employee e where cast(e.firstName as char(30)) = 'Bob'");
            query.getResultList();
            if (this.getDatabaseSession().getPlatform().isMySQL()) {
                query = em.createQuery("Select cast(e.firstName as char) from Employee e where cast(e.firstName as char) = 'Bob'");
                query.getResultList();
            }
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegexp() {
        if (!this.isHermesParser()) {
            JUnitJPQLComplexTestSuite.warning((String)"testRegexp only works with Hermes");
            return;
        }
        if (!this.getDatabaseSession().getPlatform().isOracle() && !this.getDatabaseSession().getPlatform().isMySQL()) {
            JUnitJPQLComplexTestSuite.warning((String)"REGEXP only supported on Oracle, MySQL.");
            return;
        }
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery("Select e from Employee e where e.firstName regexp '^B.*'");
            query.getResultList();
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNullOrdering() {
        if (!this.isHermesParser()) {
            JUnitJPQLComplexTestSuite.warning((String)"testNullOrdering only works with Hermes");
            return;
        }
        if (!this.getDatabaseSession().getPlatform().isOracle()) {
            JUnitJPQLComplexTestSuite.warning((String)"NULLS FIRST only supported on Oracle.");
            return;
        }
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery("Select e from Employee e order by e.id desc");
            query.getResultList();
            query = em.createQuery("Select e from Employee e order by e.id asc");
            query.getResultList();
            query = em.createQuery("Select e from Employee e order by e.id");
            query.getResultList();
            query = em.createQuery("Select e from Employee e order by e.id asc nulls first");
            query.getResultList();
            query = em.createQuery("Select e from Employee e order by e.id desc nulls last");
            query.getResultList();
            query = em.createQuery("Select e from Employee e order by e.id nulls last");
            query.getResultList();
            query = em.createQuery("Select e from Employee e order by e.id nulls last, e.firstName nulls first");
            query.getResultList();
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExtract() {
        if (!this.isHermesParser()) {
            JUnitJPQLComplexTestSuite.warning((String)"testExtract only works with Hermes");
            return;
        }
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery("Select extract(year from e.period.startDate) from Employee e where extract(day from e.period.startDate) = 4");
            query.getResultList();
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnion() {
        if (!this.isHermesParser()) {
            JUnitJPQLComplexTestSuite.warning((String)"testUnion only works with Hermes");
            return;
        }
        if (this.getDatabaseSession().getPlatform().isMySQL() || this.getDatabaseSession().getPlatform().isSybase() || this.getDatabaseSession().getPlatform().isSymfoware()) {
            JUnitJPQLComplexTestSuite.warning((String)"INTERSECT not supported on this database.");
            return;
        }
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery("Select a from Address a where a.city = 'Ottawa' union Select a2 from Address a2 union all Select a2 from Address a2 intersect Select a from Address a where a.city = 'Ottawa' except Select a from Address a where a.city = 'Ottawa'");
            List result = query.getResultList();
            if (result.size() > 0) {
                JUnitJPQLComplexTestSuite.fail((String)("Expected no results: " + result));
            }
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCOLUMN() {
        if (!this.isHermesParser()) {
            JUnitJPQLComplexTestSuite.warning((String)"testCOLUMN only works with Hermes");
            return;
        }
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery("Select COLUMN('F_NAME', e) from Employee e where COLUMN('EMP_ID', e) > 0");
            query.getResultList();
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOPERATOR() {
        if (!this.isHermesParser()) {
            JUnitJPQLComplexTestSuite.warning((String)"testOPERATOR only works with Hermes");
            return;
        }
        if (!this.getPlatform().isOracle()) {
            JUnitJPQLComplexTestSuite.warning((String)"testOPERATOR only works with Oracle");
            return;
        }
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery("Select OPERATOR('Ceil', e.id) from Employee e where OPERATOR('Least', e.id, 0) > 0");
            query.getResultList();
            query = em.createQuery("Select e from Employee e order by OPERATOR('Mod', e.id, 2)");
            query.getResultList();
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testFuncWithMySQLFuncs() {
        if (!JUnitJPQLComplexTestSuite.getServerSession().getPlatform().isMySQL()) {
            JUnitJPQLComplexTestSuite.warning((String)"The test testFuncWithMySQLFuncs is supported on MySQL only");
            return;
        }
        String[] jpqlStrings = new String[]{"Select e.id from Employee e Order By FUNC('UNHEX', e.firstName)", "Select FUNC('CRC32', e.lastName) from Employee e", "Select FUNC('BINARY', e.firstName) from Employee e", "Select FUNC('ENCRYPT', e.firstName), FUNC('ENCRYPT', e.lastName) from Employee e", "SELECT FUNC('UTC_DATE'), e.id FROM Employee e", "SELECT FUNC('CONCAT','GroupA', FUNC('SUBSTRING',e.firstName, 1, 2)) FROM Employee e WHERE TRIM(' ' FROM e.firstName) = e.firstName"};
        EntityManager em = this.createEntityManager();
        String errorMsg = "";
        for (int i = 0; i < jpqlStrings.length; ++i) {
            try {
                Query query = em.createQuery(jpqlStrings[i]);
                query.getResultList();
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                errorMsg = errorMsg + '\t' + jpqlStrings[i] + " - " + ex + '\n';
            }
        }
        this.closeEntityManager(em);
        if (errorMsg.length() > 0) {
            errorMsg = "Failed:\n" + errorMsg;
            JUnitJPQLComplexTestSuite.fail((String)errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNestedFUNCs() {
        if (!JUnitJPQLComplexTestSuite.getServerSession().getPlatform().isOracle()) {
            JUnitJPQLComplexTestSuite.warning((String)"The test testNestedFUNCs is supported on Oracle only");
            return;
        }
        String jpqlString = "select FUNC('NVL',FUNC('TO_NUMBER', FUNC('DECODE', FUNC('SUBSTRB', e.firstName,1,1),' ', NULL,FUNC('SUBSTRB',e.lastName,1,10)), null), -99) from Employee e";
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery(jpqlString);
            query.getResultList();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JUnitJPQLComplexTestSuite.fail((String)("nested fucntions don't work, the error is" + ex.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testFunctionInSelect() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select UPPER(e.firstName) from Employee e");
        query.getResultList();
        query = em.createQuery("Select AVG(e.salary + 10) + 10 from Employee e");
        query.getResultList();
        query = em.createQuery("Select ABS(MAX(ABS(e.salary))) + 10 from Employee e");
        query.getResultList();
        query = em.createQuery("Select new org.eclipse.persistence.testing.tests.jpa.jpql.JUnitJPQLComplexTestSuite.EmployeeDetail(e.firstName, e.lastName) from Employee e");
        query.getResultList();
        query = em.createQuery("Select new org.eclipse.persistence.testing.tests.jpa.jpql.JUnitJPQLComplexTestSuite.EmployeeDetail(UPPER(e.firstName), e.lastName) from Employee e");
        query.getResultList();
        query = em.createQuery("Select new org.eclipse.persistence.testing.tests.jpa.jpql.JUnitJPQLComplexTestSuite.EmployeeDetail(MAX(e.firstName), MAX(e.lastName)) from Employee e");
        query.getResultList();
        query = em.createQuery("Select 1 from Employee e");
        query.getResultList();
        if (!this.isHermesParser()) {
            JUnitJPQLComplexTestSuite.warning((String)"testFunctionInSelect only works with Hermes");
            return;
        }
        query = em.createQuery("Select concat(e2.firstName, e2.lastName) from Employee e2");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where e.firstName in (Select concat(e2.firstName, e2.lastName) from Employee e2)");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testFunctionInOrderBy() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e from Employee e order by UPPER(e.firstName)");
        query.getResultList();
        query = em.createQuery("Select e from Employee e order by e.salary / 2");
        query.getResultList();
        query = em.createQuery("Select COUNT(a) from Employee e join e.address a group by a order by COUNT(a) desc");
        query.getResultList();
        query = em.createQuery("SELECT wt FROM WrapperTypes wt order by wt.booleanData");
        List result = query.getResultList();
        result.toString();
        this.closeEntityManager(em);
    }

    public void testFunctionInGroupBy() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select UPPER(e.firstName), COUNT(e) from Employee e group by UPPER(e.firstName)");
        query.getResultList();
        query = em.createQuery("Select e from Employee e group by e");
        query.getResultList();
        query = em.createQuery("SELECT e FROM Employee e JOIN e.phoneNumbers p GROUP BY e");
        query.getResultList();
        query = em.createQuery("SELECT e, COUNT(p) FROM Employee e JOIN e.projects p GROUP BY e HAVING COUNT(p) >= 2");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testSubselectInGroupBy() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e.firstName, COUNT(e) from Employee e group by e.firstName having count(e) > (Select count(e2) from Employee e2)");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testSubselectInSelect() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            JUnitJPQLComplexTestSuite.getServerSession().logMessage("Test testSubselectInSelect is skipped on this platform, , Symfoware doesn't support sub-select. (see rfe 372172)");
            return;
        }
        if (!this.isHermesParser()) {
            JUnitJPQLComplexTestSuite.warning((String)"testSubselectInSelect only works with Hermes");
            return;
        }
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select (Select count(e2) from Employee e2 where e2.firstName = e.firstName), e.firstName from Employee e");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testSubselectInFrom() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select avg(e3.c) from Employee e, (Select count(e2) as c, e2.firstName from Employee e2 group by e2.firstName) e3 where e.firstName = e3.firstName");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testLeftParameters() {
        EntityManager em = this.createEntityManager();
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            JUnitJPQLComplexTestSuite.warning((String)"The test 'testLeftParameters' is not supported on Symfoware, Symfoware doesn't support SQL left parameters. ");
            this.closeEntityManager(em);
            return;
        }
        Query query = em.createQuery("Select e from Employee e where :id = 1");
        query.setParameter("id", (Object)1);
        query.getResultList();
        query = em.createQuery("Select e from Employee e where e = :e");
        Employee e = new Employee();
        e.setId(Integer.valueOf(1234));
        query.setParameter("e", (Object)e);
        query.getResultList();
        query = em.createQuery("Select e from Employee e where :e = e");
        query.setParameter("e", (Object)e);
        query.getResultList();
        query = em.createQuery("Select e from Employee e where :a = e.address");
        Address a = new Address();
        a.setID(1234);
        query.setParameter("a", (Object)a);
        query.getResultList();
        query = em.createQuery("Select e from Employee e where e.address = e.address");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where (Select a from Address a where a = e.address) = e.address");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where (Select a.ID from Address a where a = e.address) = (Select a2.ID from Address a2 where a2 = e.address)");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where e.address is null");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where e.address = null");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where null = e.address");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where null = e");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testClassNameInFrom() {
        if (!this.isHermesParser()) {
            JUnitJPQLComplexTestSuite.warning((String)"testClassNameInFrom only works with Hermes");
            return;
        }
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e from org.eclipse.persistence.testing.models.jpa.advanced.Employee e where e.id > 0");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testParralelFrom() {
        Query query2;
        long count2;
        if (!this.isHermesParser()) {
            JUnitJPQLComplexTestSuite.warning((String)"testParralelFrom only works with Hermes");
            return;
        }
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select count(e) from Employee e");
        long count = (Long)query.getSingleResult();
        if (count * count != (count2 = ((Long)(query2 = em.createQuery("Select count(e) from Employee e, Employee e2")).getSingleResult()).longValue())) {
            JUnitJPQLComplexTestSuite.fail((String)("Incorrect count returned from parralel, got: " + count2 + " expected: n^2 " + count));
        }
        this.closeEntityManager(em);
    }

    public void testDirectColletionInSubquery() {
        EntityManager em = this.createEntityManager();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp LEFT JOIN emp.responsibilities respons WHERE (emp.responsibilities IS EMPTY) OR (respons IN (SELECT rs FROM Employee empx join empx.responsibilities rs WHERE 1 = 0))";
        em.createQuery(ejbqlString).getResultList();
        this.closeEntityManager(em);
    }

    public void testGroupByInIn() {
        if (!this.isHermesParser()) {
            JUnitJPQLComplexTestSuite.warning((String)"testGroupByInIn only works with Hermes");
            return;
        }
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e from Employee e where e.id <> 4 and (e.id in (select max(e2.id) from Employee e2 group by e2.id having max(e2.id) > 1))");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testDistinctOrderByEmbedded() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select distinct e from Employee e order by e.period.startDate");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testJoinFetchAlias() {
        if (!this.isHermesParser()) {
            JUnitJPQLComplexTestSuite.warning((String)"testJoinFetchAlias only works with Hermes");
            return;
        }
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e from Employee e join fetch e.address a order by a.city");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testOnClause() {
        int size2;
        if (!this.isHermesParser()) {
            JUnitJPQLComplexTestSuite.warning((String)"testOnClause only works with Hermes");
            return;
        }
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e from Employee e left join e.address a on a.city = 'Ottawa'");
        int size = query.getResultList().size();
        if (size == (size2 = (query = em.createQuery("Select e from Employee e left join e.address a where a.city = 'Ottawa'")).getResultList().size())) {
            JUnitJPQLComplexTestSuite.fail((String)"ON clause did not contain join");
        }
        if ((size = (query = em.createQuery("Select e from Employee e join e.address a on (a.city = 'Ottawa')")).getResultList().size()) != size2) {
            JUnitJPQLComplexTestSuite.fail((String)"ON clause join not used");
        }
        query = em.createQuery("Select e from Employee e left join e.manager m on m.id > 0 join m.address a on a.city = 'Ottawa' where a.city <> 'Ottawa'");
        query.getResultList();
        query = em.createQuery("Select e from Employee e left join Employee e2 on e.id = e2.id");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testNestedJoinFetch() {
        if (!this.isHermesParser()) {
            JUnitJPQLComplexTestSuite.warning((String)"testNestedJoinFetch only works with Hermes");
            return;
        }
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e from Employee e join fetch e.manager.address");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testNestedJoinFetchAlias() {
        if (!this.isHermesParser()) {
            JUnitJPQLComplexTestSuite.warning((String)"testNestedJoinFetchAlias only works with Hermes");
            return;
        }
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e from Employee e join fetch e.manager m join fetch m.address");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testNestedSubqueries() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e from Employee e where e.id = (Select Max(e2.id) from Employee e2 join e2.phoneNumbers p where e2.id = e.id and p.type in (Select p2.type from PhoneNumber p2))");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testJoinFetchWithJoin() {
        if (!this.isHermesParser()) {
            JUnitJPQLComplexTestSuite.warning((String)"testJoinFetchWithJoin only works with Hermes");
            return;
        }
        this.clearCache();
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e from Employee e join fetch e.phoneNumbers join e.phoneNumbers p where p.areaCode <> '613'");
        Employee employee = (Employee)query.getResultList().get(0);
        if (this.isWeavingEnabled() && employee.getPhoneNumbers() instanceof IndirectCollection && !((IndirectCollection)employee.getPhoneNumbers()).isInstantiated()) {
            JUnitJPQLComplexTestSuite.fail((String)"Join fetch did not occur.");
        }
        this.clearCache();
        em.clear();
        query = em.createQuery("Select e from Employee e join e.phoneNumbers p join fetch e.phoneNumbers where p.areaCode <> '613'");
        employee = (Employee)query.getResultList().get(0);
        if (this.isWeavingEnabled() && employee.getPhoneNumbers() instanceof IndirectCollection && !((IndirectCollection)employee.getPhoneNumbers()).isInstantiated()) {
            JUnitJPQLComplexTestSuite.fail((String)"Join fetch did not occur.");
        }
        this.closeEntityManager(em);
    }

    public void testElementCollection() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select b from Buyer b join b.creditLines l where l > 0");
        query.getResultList();
        query = em.createQuery("Select b from Buyer b join b.creditLines l where Key(l) <> ''");
        query.getResultList();
        query = em.createQuery("Select d from Department d join d.competencies c where c.rating > 0");
        query.getResultList();
        query = em.createQuery("Select b from BeerConsumer b join b.commentLookup c where KEY(c).number > 0");
        query.getResultList();
        query = em.createQuery("Select b from BeerConsumer b join b.commentLookup c where c <> ''");
        query.getResultList();
        query = em.createQuery("Select b from BeerConsumer b join b.redStripes r where r.alcoholContent > 0");
        query.getResultList();
        query = em.createQuery("Select b from BeerConsumer b join b.redStripes r where KEY(r) <> ''");
        query.getResultList();
        query = em.createQuery("Select b from BeerConsumer b join b.redStripesByAlcoholContent r where KEY(r) > 0");
        query.getResultList();
        query = em.createQuery("Select b from BeerConsumer b join b.redStripesByAlcoholContent r where r.alcoholContent > 0");
        query.getResultList();
        query = em.createQuery("Select b from Buyer b join b.creditLines l where l in :arg");
        ArrayList<Integer> args = new ArrayList<Integer>();
        args.add(0);
        query.setParameter("arg", args);
        query.getResultList();
        query = em.createQuery("Select b from Buyer b join b.creditLines l where l = :arg");
        query.setParameter("arg", args);
        query.getResultList();
        query = em.createQuery("select c from Buyer c join c.creditLines cc where key(cc) = :attrKey and value(cc) = :attrValue");
        query.setParameter("attrKey", (Object)"test");
        query.setParameter("attrValue", (Object)0);
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testDoubleAggregateManyToMany() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e.id, sum(p1.budget), sum(p2.budget) from Employee e join treat(e.projects as LargeProject) p1 join treat(e.projects as LargeProject) p2 where p1.budget > 200 and p2.budget > 0 group by e.id");
        List results = query.getResultList();
        for (Object[] result : results) {
            if (!result[1].equals(result[2])) continue;
        }
        this.closeEntityManager(em);
    }

    public void testGroupByHavingFunction() {
        if (!this.isHermesParser()) {
            JUnitJPQLComplexTestSuite.warning((String)"testGroupByHavingFunction only works with Hermes");
            return;
        }
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e from Employee e join e.phoneNumbers p group by e having count(p)   > 100");
        if (query.getResultList().size() > 0) {
            JUnitJPQLComplexTestSuite.fail((String)"Group by not included");
        }
        this.closeEntityManager(em);
    }

    public void testGroupByWithoutFunction() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e from Employee e group by e");
        List results = query.getResultList();
        JUnitJPQLComplexTestSuite.assertNotNull((String)"Results should be non-null", (Object)results);
        JUnitJPQLComplexTestSuite.assertTrue((String)"Results should not be empty", (results.size() != 0 ? 1 : 0) != 0);
        String sql = ((DatabaseQuery)query.unwrap(DatabaseQuery.class)).getSQLString();
        if (sql.toUpperCase().indexOf("GROUP BY") != -1) {
            JUnitJPQLComplexTestSuite.fail((String)("GROUP BY not included in generated SQL: " + sql));
        }
        this.closeEntityManager(em);
    }

    public void testSubSelect() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e from Employee e where e.id in (Select p.id from PhoneNumber p where p.owner = e and e.id is not null)");
        query.getResultList().size();
        String sql = ((DatabaseQuery)query.unwrap(DatabaseQuery.class)).getSQLString();
        int index = sql.indexOf("CMP3_EMPLOYEE");
        if (index == -1) {
            JUnitJPQLComplexTestSuite.fail((String)"CMP3_EMPLOYEE table missing.");
        }
        if ((index = sql.indexOf("CMP3_EMPLOYEE", index + 1)) != -1) {
            JUnitJPQLComplexTestSuite.fail((String)"CMP3_EMPLOYEE table incorrectly joined twice.");
        }
        if (this.isHermesParser()) {
            index = sql.indexOf("IS NOT NULL");
            if (index == -1) {
                JUnitJPQLComplexTestSuite.fail((String)"IS NOT NULL missing.");
            }
        } else {
            JUnitJPQLComplexTestSuite.warning((String)"testSubSelect only works with Hermes");
        }
        this.closeEntityManager(em);
    }

    public void testSubSelect2() {
        if (!this.isHermesParser()) {
            JUnitJPQLComplexTestSuite.warning((String)"testSubSelect2 only works with Hermes");
            return;
        }
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e from Employee e where e.address in (Select a from e.address a)");
        query.getResultList().size();
        String sql = ((DatabaseQuery)query.unwrap(DatabaseQuery.class)).getSQLString();
        int index = sql.indexOf("CMP3_EMPLOYEE");
        if (index == -1) {
            JUnitJPQLComplexTestSuite.fail((String)"CMP3_EMPLOYEE table missing.");
        }
        if ((index = sql.indexOf("CMP3_EMPLOYEE", index + 1)) != -1) {
            JUnitJPQLComplexTestSuite.fail((String)"CMP3_EMPLOYEE table incorrectly joined twice.");
        }
        if ((index = sql.indexOf("CMP3_ADDRESS")) == -1) {
            JUnitJPQLComplexTestSuite.fail((String)"CMP3_ADDRESS table missing.");
        }
        if ((index = sql.indexOf("CMP3_ADDRESS", index + 1)) != -1) {
            JUnitJPQLComplexTestSuite.fail((String)"CMP3_ADDRESS table incorrectly joined twice.");
        }
        query = em.createQuery("Select e from Employee e where e.address.ID in (Select a.ID from e.address a)");
        query.getResultList().size();
        sql = ((DatabaseQuery)query.unwrap(DatabaseQuery.class)).getSQLString();
        index = sql.indexOf("CMP3_EMPLOYEE");
        if (index == -1) {
            JUnitJPQLComplexTestSuite.fail((String)"CMP3_EMPLOYEE table missing.");
        }
        if ((index = sql.indexOf("CMP3_EMPLOYEE", index + 1)) != -1) {
            JUnitJPQLComplexTestSuite.fail((String)"CMP3_EMPLOYEE table incorrectly joined twice.");
        }
        query = em.createQuery("Select e from Employee e where e is null");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where e is not null");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where e.address in (Select a from Address a where a is null)");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where e.address in (Select a from Address a where a is not null)");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testOrderPackage() {
        if (!this.isHermesParser()) {
            JUnitJPQLComplexTestSuite.warning((String)"testOrderPackage only works with Hermes");
            return;
        }
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select new org.eclipse.persistence.testing.models.jpa.advanced.order.select.where.Order(e.id) from Employee e");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testSubselectStackOverflow() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select object(e) from Employee e where :id in (select p.id from in(e.projects) p)");
        query.setParameter("id", (Object)123);
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testAliasPlus() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select (e.id + 5) as p from Employee e order by p");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testFunctionsWithParameters() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e from Employee e where exists (Select a from e.address a  where UPPER(:arg) = UPPER(:arg2))");
        query.setParameter("arg", (Object)"foo");
        query.setParameter("arg2", (Object)"FOO");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testMemberOf() {
        if (!this.isHermesParser()) {
            JUnitJPQLComplexTestSuite.warning((String)"testMemberOf only works with Hermes");
            return;
        }
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e from Employee e, IN(e.managedEmployees) m, IN(m.projects) p where e.id = 1234 and p not member of e.projects");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testOrderByDistinct() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select distinct(e) from Employee e, PhoneNumber p where p.owner = e order by e.firstName");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testSingleEncapsulatedInputParameter() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e from Employee e where e.address.city in (:city)");
        query.setParameter("city", (Object)"Ottawa");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testObjectIn() {
        ArrayList<PhoneNumber> phones;
        PhoneNumber phone;
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e from Employee e where e.id in (Select e2.id from Employee e2)");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where e in (Select e2 from Employee e2)");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where e.address in (Select a from Address a)");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where e.address = (Select a from Address a where a.ID = (Select Max(a2.ID) from Address a2))");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where e.address in (:a, :a2)");
        Address address = new Address();
        address.setID(123);
        query.setParameter("a", (Object)address);
        query.setParameter("a2", (Object)address);
        query.getResultList();
        query = em.createQuery("Select e from Employee e where e.address in :a");
        ArrayList<Address> addresses = new ArrayList<Address>();
        addresses.add(address);
        addresses.add(address);
        query.setParameter("a", addresses);
        query.getResultList();
        query = em.createQuery("Select e from Employee e join e.phoneNumbers p where p in (Select p2 from PhoneNumber p2)");
        query.getResultList();
        if (this.getPlatform().isOracle()) {
            query = em.createQuery("Select e from Employee e join e.phoneNumbers p where p in (:p, :p2)");
            phone = new PhoneNumber();
            phone.setId(Integer.valueOf(123));
            phone.setType("fax");
            query.setParameter("p", (Object)phone);
            query.setParameter("p2", (Object)phone);
            query.getResultList();
            query = em.createQuery("Select e from Employee e join e.phoneNumbers p where p in :p");
            phones = new ArrayList<PhoneNumber>();
            phones.add(phone);
            phones.add(phone);
            query.setParameter("p", phones);
            query.getResultList();
        }
        query = em.createQuery("Select e from Employee e where e.id not in (Select e2.id from Employee e2)");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where e not in (Select e2 from Employee e2)");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where e.address not in (Select a from Address a)");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where e.address <> (Select a from Address a where a.ID = (Select Max(a2.ID) from Address a2))");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where e.address not in (:a, :a2)");
        query.setParameter("a", (Object)address);
        query.setParameter("a2", (Object)address);
        query.getResultList();
        query = em.createQuery("Select e from Employee e where e.address not in :a");
        query.setParameter("a", addresses);
        query.getResultList();
        query = em.createQuery("Select e from Employee e join e.phoneNumbers p where p not in (Select p2 from PhoneNumber p2)");
        query.getResultList();
        if (this.getPlatform().isOracle()) {
            query = em.createQuery("Select e from Employee e join e.phoneNumbers p where p not in (:p, :p2)");
            phone = new PhoneNumber();
            phone.setId(Integer.valueOf(123));
            phone.setType("fax");
            query.setParameter("p", (Object)phone);
            query.setParameter("p2", (Object)phone);
            query.getResultList();
            query = em.createQuery("Select e from Employee e join e.phoneNumbers p where p not in :p");
            phones = new ArrayList();
            phones.add(phone);
            phones.add(phone);
            query.setParameter("p", phones);
            query.getResultList();
        }
        this.closeEntityManager(em);
    }

    public void testEmbeddableDistinct() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select count(e) from Employee e");
        long count = ((Number)query.getSingleResult()).longValue();
        query = em.createQuery("Select count(distinct e) from Employee e");
        query.getResultList();
        query = em.createQuery("Select e, count(distinct e) from Employee e group by e");
        query.getResultList();
        query = em.createQuery("Select g, count(distinct g) from Golfer g group by g");
        query.getResultList();
        query = em.createQuery("Select count(c) from PhoneNumber c");
        long count2 = ((Number)query.getSingleResult()).longValue();
        query = em.createQuery("Select count(distinct p) from PhoneNumber  p");
        query.getResultList();
        query = em.createQuery("Select count(distinct c) from Captain c");
        query.getResultList();
        query = em.createQuery("Select count(distinct c) from Captain c where c.id.name <> ''");
        query.getResultList();
        Object[] results = null;
        if (!this.getPlatform().isDerby()) {
            query = em.createQuery("Select count(distinct e2), count(distinct e) from Employee e2, Employee e");
            results = (Object[])query.getSingleResult();
            if (((Number)results[1]).longValue() != count) {
                JUnitJPQLComplexTestSuite.fail((String)("Employee count not correct: " + count + " was " + results[1]));
            }
            if (((Number)results[0]).longValue() != count) {
                JUnitJPQLComplexTestSuite.fail((String)("Employee 2 count not correct: " + count + " was " + results[0]));
            }
        }
        if (((Number)(results = (Object[])(query = em.createQuery("Select count(distinct p), count(distinct e) from PhoneNumber p, Employee e")).getSingleResult())[1]).longValue() != count) {
            JUnitJPQLComplexTestSuite.fail((String)("Employee count not correct: " + count + " was " + results[1]));
        }
        if (((Number)results[0]).longValue() != count2 && this.getPlatform().isMySQL()) {
            JUnitJPQLComplexTestSuite.fail((String)("PhoneNumber count not correct: " + count2 + " was " + results[0]));
        }
        if (this.getPlatform().isMySQL()) {
            query = em.createQuery("Select count(distinct p) from PhoneNumber p group by p.areaCode");
            query.getResultList();
            query = em.createQuery("Select c, count(distinct c) from Captain c group by c");
            query.getResultList();
        }
        this.closeEntityManager(em);
    }

    public void testBrackets() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select UPPER(e.firstName) from Employee e");
        query.getResultList();
        query = em.createQuery("Select UPPER(e.firstName) from Employee e");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where ((e.firstName = 'Bob'))");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where (((e.firstName = 'Bob') and (not (e.firstName = 'Bob'))))");
        query.getResultList();
        query = em.createQuery("Select (1 + 2) from Employee e where (((e.firstName = 'Bob') and (not (e.firstName = 'Bob'))))");
        query.getResultList();
        query = em.createQuery("Select (1 + 2) from Employee e where e = e");
        query.getResultList();
        query = em.createQuery("Select (1 + 2) * 1 from Employee e where e = e");
        query.getResultList();
        query = em.createQuery("Select 1 + (2 * 1) from Employee e where e = e");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testComplexLike() {
        if (!JUnitJPQLComplexTestSuite.getServerSession().getPlatform().isOracle()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e from Employee e where UPPER(e.firstName) like UPPER('b%')");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where e.firstName like (Select e2.firstName from Employee e2 where e = e2)");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where e.firstName like UPPER('b%') escape UPPER('_')");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where e.salary like '123%'");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where e.firstName like e.firstName");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where e.firstName like 'foox_' escape 'x'");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testComplexBetween() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            JUnitJPQLComplexTestSuite.getServerSession().logMessage("Test testComplexBetween skipped for this platform, Symfoware doesn't support subquery used in BETWEEN, LIKE, or NULL predicates.");
            return;
        }
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e from Employee e where e.firstName between 'L' and 'Z'");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where e.firstName between UPPER('L') and UPPER('Z')");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where e.salary between 10 and 10000");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where e.firstName between (Select e2.firstName from Employee e2 where e = e2) and (Select e3.firstName from Employee e3 where e = e3)");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testComplexIn() {
        if (this.getDatabaseSession().getPlatform().isSymfoware()) {
            JUnitJPQLComplexTestSuite.getServerSession().logMessage("Test testComplexIn skipped for this platform, Symfoware doesn't support the use of UPPER/LOWER in limit list of IN predicate.");
            return;
        }
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e from Employee e where e.firstName in (UPPER('L'), LOWER('Z'))");
        query.getResultList();
        if (!this.getDatabaseSession().getPlatform().isDerby() && !this.getDatabaseSession().getPlatform().isH2()) {
            query = em.createQuery("Select e from Employee e where e.firstName in ((Select e2.firstName from Employee e2 where e = e2), (Select e3.firstName from Employee e3 where e = e3))");
            query.getResultList();
        }
        query = em.createQuery("Select e from Employee e where e.firstName in :arg");
        query.setParameter("arg", Arrays.asList(new int[][]{{1, 2}}));
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testQueryKeys() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e.startTime from Employee e where e.startTime = :time");
        query.setParameter("time", (Object)new java.util.Date());
        query.getResultList();
        query = em.createQuery("Select boss from Employee e join e.boss boss");
        query.getResultList();
        query = em.createQuery("Select boss from Employee e left join e.boss boss");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where e.boss.firstName like '%'");
        query.getResultList();
        this.closeEntityManager(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complexOneToOneJoinOptimization() {
        QuerySQLTracker counter = new QuerySQLTracker((Session)JUnitJPQLComplexTestSuite.getServerSession());
        try {
            EntityManager em = this.createEntityManager();
            String jpql = "SELECT e FROM Employee e where e.address.ID = 5";
            Query query = em.createQuery(jpql);
            query.getResultList();
            String sql = (String)counter.getSqlStatements().get(0);
            if (sql.indexOf("CMP3_ADDRESS") != -1) {
                JUnitJPQLComplexTestSuite.fail((String)"Join to address should have been optimized.");
            }
        }
        finally {
            if (counter != null) {
                counter.remove();
            }
        }
    }

    public void testCountOneToManyQueryKey() {
        EntityManager em = this.createEntityManager();
        Employee emp = (Employee)em.createQuery("select e from Employee e where e.firstName = 'John' and e.lastName = 'Way'").getSingleResult();
        Long result = (Long)em.createQuery("select count(pn) from Employee e join e.phoneQK pn where e.id = :id").setParameter("id", (Object)emp.getId()).getSingleResult();
        JUnitJPQLComplexTestSuite.assertTrue((String)"Incorrect number of results returned", (boolean)result.equals(2L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnumNullNotNull() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee emp = new Employee();
            emp.setFirstName("Ellen");
            emp.setPayScale(Employee.SalaryRate.MANAGER);
            em.persist((Object)emp);
            em.flush();
            em.clear();
            this.clearCache();
            List results = em.createQuery("select e from Employee e where (e.payScale = :payScale and not :payScale IS NULL) or (:payScale IS NULL AND e.payScale IS NULL)").setParameter("payScale", (Object)Employee.SalaryRate.MANAGER).getResultList();
            JUnitJPQLComplexTestSuite.assertTrue((results.size() == 1 ? 1 : 0) != 0);
            JUnitJPQLComplexTestSuite.assertTrue((boolean)((Employee)results.get(0)).getFirstName().equals("Ellen"));
            if (JUnitJPQLComplexTestSuite.getServerSession().getPlatform().isDerby() || JUnitJPQLComplexTestSuite.getServerSession().getPlatform().isSymfoware()) {
                JUnitJPQLComplexTestSuite.getServerSession().getSessionLog().log(5, "Derby, Symfoware do not support the format 'NULL IS NULL'.");
            } else {
                results = em.createQuery("select e from Employee e where (e.payScale = :payScale and not :payScale IS NULL) or (:payScale IS NULL AND e.payScale IS NULL)").setParameter("payScale", null).getResultList();
                JUnitJPQLComplexTestSuite.assertTrue((results.size() == 15 ? 1 : 0) != 0);
            }
            results = em.createQuery("select e from Employee e where (e.payScale = :payScale and not :payScale IS NULL) or (:payScale = org.eclipse.persistence.testing.models.jpa.advanced.Employee.SalaryRate.MANAGER)").setParameter("payScale", (Object)Employee.SalaryRate.MANAGER).getResultList();
            JUnitJPQLComplexTestSuite.assertTrue((results.size() == 16 ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPessimisticLock() throws InterruptedException {
        if (JUnitTestCase.getServerSession().getPlatform().isHANA()) {
            return;
        }
        if (JUnitJPQLComplexTestSuite.isOnServer() || !this.isSelectForUpateSupported()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery("select e from Employee e where e.firstName=:name");
            query.setParameter("name", (Object)"Bob");
            Employee bob = (Employee)query.getSingleResult();
            final int bobId = bob.getId();
            this.clearCache();
            em.clear();
            query = em.createQuery("select e from Employee e where e.id=:id");
            query.setParameter("id", (Object)bobId);
            query.setHint("eclipselink.pessimistic-lock", (Object)"Lock");
            this.beginTransaction(em);
            bob = (Employee)query.getSingleResult();
            final EntityManager em2 = this.createEntityManager();
            try {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        block2: {
                            try {
                                JUnitJPQLComplexTestSuite.this.beginTransaction(em2);
                                Query query2 = em2.createQuery("select e from Employee e where e.id = :id");
                                query2.setParameter("id", (Object)bobId);
                                query2.setHint("javax.persistence.lock.timeout", (Object)10);
                                Employee emp = (Employee)query2.getSingleResult();
                                emp.setFirstName("Robert");
                                JUnitJPQLComplexTestSuite.this.commitTransaction(em2);
                            }
                            catch (RollbackException ex) {
                                if (ex.getMessage().indexOf("org.eclipse.persistence.exceptions.DatabaseException") != -1) break block2;
                                ex.printStackTrace();
                                Assert.fail((String)("it's not the right exception:" + (Object)((Object)ex)));
                            }
                        }
                    }
                };
                Thread t2 = new Thread(runnable);
                t2.start();
                Thread.sleep(1000L);
                em.refresh((Object)bob);
                JUnitJPQLComplexTestSuite.assertTrue((String)"pessimistic lock failed: parallel transaction modified locked entity (non-repeatable read)", (boolean)"Bob".equals(bob.getFirstName()));
                this.rollbackTransaction(em);
                t2.join();
            }
            finally {
                if (this.isTransactionActive(em2)) {
                    this.rollbackTransaction(em2);
                }
                this.closeEntityManager(em2);
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testAliasedFunction() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("select MOD(e.salary, 10) as m from Employee e where m = 0");
        List result = query.getResultList();
        JUnitJPQLComplexTestSuite.assertTrue((String)"incorrect results returned for /", (result.size() == 9 ? 1 : 0) != 0);
        query = em.createQuery("select e.salary / 10D s from Employee e where s > 1000");
        result = query.getResultList();
        JUnitJPQLComplexTestSuite.assertTrue((String)"incorrect results returned for /", (result.size() == 12 ? 1 : 0) != 0);
        query = em.createQuery("select Type(p) t from Project p where t = LargeProject");
        result = query.getResultList();
        JUnitJPQLComplexTestSuite.assertTrue((String)"incorrect results returned for Type", (result.size() == 5 ? 1 : 0) != 0);
        this.closeEntityManager(em);
    }

    public void testComplexPathExpression() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("select e from Employee e join e.projects p where treat(p as LargeProject).budget > 10000");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testNestedArrays1() {
        if (!(this.getPlatform().isOracle() || this.getPlatform().isMySQL() || this.getPlatform().isPostgreSQL())) {
            JUnitJPQLComplexTestSuite.warning((String)"Nested arrays not supported on this database.");
            return;
        }
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e from Employee e where (e.firstName, e.lastName) IN :names");
        ArrayList<ArrayList<String>> names = new ArrayList<ArrayList<String>>();
        names.add(new ArrayList<String>(Arrays.asList("Bob", "Smith")));
        names.add(new ArrayList<String>(Arrays.asList("John", "Doe")));
        query.setParameter("names", names);
        query.getResultList();
        query = em.createQuery("Select e from Employee e where (e.firstName, e.lastName) IN (Select e2.lastName, e2.firstName from Employee e2)");
        query.getResultList();
        query = em.createQuery("Select e from Employee e where (e.firstName, e.lastName) IN ((:f1, :l1), (:f2, :l2))");
        query.setParameter("f1", (Object)"Bob");
        query.setParameter("l1", (Object)"Smith");
        query.setParameter("f2", (Object)"John");
        query.setParameter("l2", (Object)"Doe");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testNestedArrays2() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("select attr from Employee attr, Address dn where (attr.id=dn.ID) and       (dn.type = :pdn) and      ((exists ( select A_0 from Employee A_0 where ( A_0.id = DN.ID ) and                                                    ( A_0.payScale IN (:V_A_0_1, :V_A_0)))) AND       (exists ( select A_1 from Employee A_1 where ( A_1.id = DN.ID ) and                                                    ( A_1.payScale = :V_A_1 )))      )");
        query.setParameter("pdn", (Object)new AddressType());
        query.setParameter("V_A_0_1", (Object)Employee.SalaryRate.MANAGER);
        query.setParameter("V_A_0", (Object)Employee.SalaryRate.EXECUTIVE);
        query.setParameter("V_A_1", (Object)Employee.SalaryRate.SENIOR);
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testNoSelect() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("from Employee e where e.firstName = 'Bob'");
        query.getResultList();
        query = em.createQuery("from Employee e join e.address a where a.city = 'Ottawa'");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testHierarchicalClause() {
        if (!this.getPlatform().isOracle()) {
            JUnitJPQLComplexTestSuite.warning((String)"Hierarchical selects only supported on Oracle.");
            return;
        }
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("Select e from Employee e connect by e.manager ");
        query.getResultList();
        query = em.createQuery("Select e from Employee e start with e.salary > 1000 connect by e.manager");
        query.getResultList();
        query = em.createQuery("Select e from Employee e connect by e.manager order siblings by e.firstName");
        query.getResultList();
        query = em.createQuery("Select e from Employee e join e.manager m connect by m.manager where e.salary > 100");
        query.getResultList();
        query = em.createQuery("Select e from Employee e start with e.salary > 1000 connect by e.manager order siblings by e.firstName");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public void testDeleteWithUnqualifiedPathExpression() {
        EntityManager em = this.createEntityManager();
        em.createQuery("DELETE FROM Employee WHERE salary = :value1 AND (roomNumber > :value2 OR roomNumber < 1)");
        this.closeEntityManager(em);
    }

    public void testElementCollectionInLikeExpression() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("SELECT b FROM Buyer b WHERE b.creditLines LIKE '%e%'");
        query.getResultList();
        this.closeEntityManager(em);
    }

    public static class LongHolder {
        public Long value1;
        public Long value2;

        public LongHolder(Long value1, Long value2) {
            this.value1 = value1;
            this.value2 = value2;
        }

        public int hashCode() {
            int result = 0;
            result += this.value1 != null ? this.value1.hashCode() : 0;
            return result += this.value2 != null ? this.value2.hashCode() : 0;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof LongHolder)) {
                return false;
            }
            LongHolder other = (LongHolder)o;
            return JUnitJPQLComplexTestSuite.equals(this.value1, other.value1) && JUnitJPQLComplexTestSuite.equals(this.value2, other.value2);
        }

        public String toString() {
            return "LongHolder(" + this.value1 + ", " + this.value2 + ")";
        }
    }

    public static class EmployeeDetail {
        public String firstName;
        public String lastName;
        public Employee manager;
        public Long count;
        public BigInteger code;
        public EmploymentPeriod period;

        public EmployeeDetail(String firstName, String lastName) {
            this.firstName = firstName;
            this.lastName = lastName;
        }

        public EmployeeDetail(String firstName, String lastName, Employee manager) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.manager = manager;
        }

        public EmployeeDetail(EmploymentPeriod e) {
            this.period = e;
        }

        public EmployeeDetail(Employee e) {
            this.firstName = e.getFirstName();
            this.lastName = e.getLastName();
            this.manager = e.getManager();
        }

        public EmployeeDetail(String firstName, String lastName, Long count) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.count = count;
        }

        public EmployeeDetail(String firstName, String lastName, BigInteger code) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.code = code;
        }

        public int hashCode() {
            int result = 0;
            result += this.firstName != null ? this.firstName.hashCode() : 0;
            result += this.lastName != null ? this.lastName.hashCode() : 0;
            result += this.manager != null ? this.manager.hashCode() : 0;
            result += this.count != null ? this.count.hashCode() : 0;
            result += this.code != null ? this.code.hashCode() : 0;
            return result += this.period != null ? this.period.hashCode() : 0;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof EmployeeDetail)) {
                return false;
            }
            EmployeeDetail other = (EmployeeDetail)o;
            return JUnitJPQLComplexTestSuite.equals(this.firstName, other.firstName) && JUnitJPQLComplexTestSuite.equals(this.lastName, other.lastName) && JUnitJPQLComplexTestSuite.equals(this.manager, other.manager) && JUnitJPQLComplexTestSuite.equals(this.count, other.count) && JUnitJPQLComplexTestSuite.equals(this.code, other.code) && JUnitJPQLComplexTestSuite.equals(this.period, other.period);
        }

        public String toString() {
            return "EmployeeDetail(" + this.firstName + ", " + this.lastName + ", " + this.manager + ", " + this.count + ", " + this.code + ", " + this.period + ")";
        }
    }
}

