/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.gen.internal;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.persistence.tools.gen.db.Column;
import org.eclipse.persistence.tools.gen.db.Schema;
import org.eclipse.persistence.tools.gen.internal.AssociationRole;
import org.eclipse.persistence.tools.gen.internal.ORMGenCustomizer;
import org.eclipse.persistence.tools.gen.internal.ORMGenTable;
import org.eclipse.persistence.tools.gen.internal.util.DBUtil;
import org.eclipse.persistence.tools.gen.internal.util.StringUtil;

public class BaseEntityGenCustomizer
extends ORMGenCustomizer {
    private static final long serialVersionUID = 1L;
    private static final String BASIC_MAPPING_KIND = "basic";
    private static final String ID_MAPPING_KIND = "id";
    private static final String VERSION_MAPPING_KIND = "version";
    private static final String AUTO_GENERATOR = "auto";
    private static final String NONE_GENERATOR = "none";
    private static final String IDENTITY_GENERATOR = "identity";
    private static final String SEQUENCE_GENERATOR = "sequence";
    private static final String TABLE_GENERATOR = "table";

    @Override
    public void init(File file, Schema schema) {
        super.init(file, schema);
    }

    @Override
    public List<String> getAllIdGenerators() {
        ArrayList<String> result = new ArrayList<String>(5);
        result.add(AUTO_GENERATOR);
        result.add(IDENTITY_GENERATOR);
        result.add(SEQUENCE_GENERATOR);
        result.add(TABLE_GENERATOR);
        result.add(NONE_GENERATOR);
        return result;
    }

    @Override
    public String getNoIdGenerator() {
        return NONE_GENERATOR;
    }

    @Override
    public String getIdentityIdGenerator() {
        return IDENTITY_GENERATOR;
    }

    @Override
    public Set<String> getSequenceIdGenerators() {
        HashSet<String> result = new HashSet<String>(3);
        result.add(SEQUENCE_GENERATOR);
        return result;
    }

    @Override
    public String getPropertyTypeFromColumn(Column column) {
        return DBUtil.getJavaType(column);
    }

    @Override
    public String[] getAllPropertyTypes() {
        return new String[]{"boolean", "Boolean", "byte", "Byte", "byte[]", "char", "char[]", "Character", "Character[]", "double", "Double", "float", "Float", "int", "Integer", "long", "Long", "Object", "short", "Short", "String", BigDecimal.class.getName(), BigInteger.class.getName(), Calendar.class.getName(), Date.class.getName(), java.sql.Date.class.getName(), Time.class.getName(), Timestamp.class.getName()};
    }

    @Override
    public String[] getAllMappingKinds() {
        return new String[]{BASIC_MAPPING_KIND, ID_MAPPING_KIND, VERSION_MAPPING_KIND};
    }

    @Override
    public String getBasicMappingKind() {
        return BASIC_MAPPING_KIND;
    }

    @Override
    public String getIdMappingKind() {
        return ID_MAPPING_KIND;
    }

    @Override
    public boolean editCascade(AssociationRole role) {
        return false;
    }

    @Override
    protected boolean manySideIsAssociationOwner() {
        return true;
    }

    public String genCascades(AssociationRole role) {
        List<String> cascades = StringUtil.strToList(role.getCascade(), ',', true);
        if (cascades == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append('{');
        int i = 0;
        int n = cascades.size();
        while (i < n) {
            String enumStr;
            String cascade = cascades.get(i);
            if (cascade.equals("all")) {
                enumStr = "CascadeType.ALL";
            } else if (cascade.equals("persist")) {
                enumStr = "CascadeType.PERSIST";
            } else if (cascade.equals("detach")) {
                enumStr = "CascadeType.DETACH";
            } else if (cascade.equals("merge")) {
                enumStr = "CascadeType.MERGE";
            } else if (cascade.equals("remove")) {
                enumStr = "CascadeType.REMOVE";
            } else {
                assert (cascade.equals("refresh"));
                enumStr = "CascadeType.REFRESH";
            }
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(enumStr);
            ++i;
        }
        buffer.append('}');
        return buffer.toString();
    }

    public String genCascadesXml(AssociationRole role) {
        List<String> cascades = StringUtil.strToList(role.getCascade(), ',', true);
        if (cascades == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int n = cascades.size();
        while (i < n) {
            String enumStr;
            String cascade = cascades.get(i);
            if (cascade.equals("all")) {
                enumStr = "<cascade-all></cascade-all>";
            } else if (cascade.equals("persist")) {
                enumStr = "<cascade-persist></cascade-persist>";
            } else if (cascade.equals("merge")) {
                enumStr = "<cascade-merge></cascade-merge>";
            } else if (cascade.equals("remove")) {
                enumStr = "<cascade-remove></cascade-remove>";
            } else if (cascade.equals("detach")) {
                enumStr = "<cascade-detach></cascade-detach>";
            } else {
                assert (cascade.equals("refresh"));
                enumStr = "<cascade-refresh></cascade-refresh>";
            }
            if (i != 0) {
                buffer.append("\n\t\t\t\t\t");
            }
            buffer.append(enumStr);
            ++i;
        }
        return buffer.toString();
    }

    @Override
    public String genFetch(ORMGenTable table) {
        String fetch = table.getDefaultFetch();
        if (fetch == null || "defaultFetch".equals(fetch)) {
            return "";
        }
        if (fetch.equals("lazy")) {
            return "FetchType.LAZY";
        }
        return "FetchType.EAGER";
    }

    @Override
    public String genFetchXml(ORMGenTable table) {
        String fetch = table.getDefaultFetch();
        if (fetch == null || "defaultFetch".equals(fetch)) {
            return "";
        }
        if (fetch.equals("lazy")) {
            return "LAZY";
        }
        return "EAGER";
    }
}

