/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db.relational.spi.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.persistence.tools.db.relational.spi.ExternalTable;
import org.eclipse.persistence.tools.db.relational.spi.ExternalTableDescription;
import org.eclipse.persistence.tools.db.relational.spi.jdbc.JDBCExternalDatabase;
import org.eclipse.persistence.tools.db.relational.spi.jdbc.JDBCExternalTable;
import org.eclipse.persistence.tools.utility.NameTools;
import org.eclipse.persistence.tools.utility.ObjectTools;

final class JDBCExternalTableDescription
implements ExternalTableDescription {
    private final JDBCExternalDatabase database;
    private final String catalogName;
    private final String schemaName;
    private final String name;
    private final String qualifiedName;
    private ExternalTable externalTable;

    JDBCExternalTableDescription(ResultSet resultSet, JDBCExternalDatabase database) throws SQLException {
        this(JDBCExternalTableDescription.trim(resultSet.getString(1)), JDBCExternalTableDescription.trim(resultSet.getString(2)), JDBCExternalTableDescription.trim(resultSet.getString(3)), database);
    }

    JDBCExternalTableDescription(String catalogName, String schemaName, String name, JDBCExternalDatabase database) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.name = name;
        this.qualifiedName = this.buildQualifiedName();
        this.database = database;
    }

    private static String trim(String s) {
        if (s == null) {
            return null;
        }
        return (s = s.trim()).length() == 0 ? null : s;
    }

    private String buildQualifiedName() {
        return NameTools.buildQualifiedName((String[])new String[]{this.catalogName, this.schemaName, this.name});
    }

    @Override
    public String getCatalogName() {
        return this.catalogName;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public ExternalTable getTable() {
        if (this.externalTable == null) {
            this.externalTable = this.buildExternalTable();
        }
        return this.externalTable;
    }

    @Override
    public String getAdditionalInfo() {
        try {
            return this.metaData().getURL();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    private ExternalTable buildExternalTable() {
        try {
            return new JDBCExternalTable(this);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    DatabaseMetaData metaData() {
        return this.database.metaData();
    }

    JDBCExternalDatabase getDatabase() {
        return this.database;
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (String)this.qualifiedName);
    }
}

