/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalForm;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.StringTools;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class AbstractExternalForm
implements ExternalForm {
    private List<String> attributeNamesOrder;
    private List<String> elementNamesOrder;
    private AbstractExternalForm parent;
    public static final String VERSION = "version";
    protected static final String XMLNS_ATTRIBUTE = "xmlns";
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    public static final String XMLNS_XSI = "xmlns:xsi";
    protected static final String XSD_URI = "http://www.w3.org/2001/XMLSchema";
    protected static final String XSD_URI_ATTRIBUTE = "xsi:schemaLocation";
    public static final String XSI_SLOC = "xsi:schemaLocation";
    public static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";

    protected AbstractExternalForm(AbstractExternalForm parent) {
        this.parent = parent;
        this.initialize();
    }

    protected final Element addChild(AbstractExternalForm parent, String elementName) {
        Element element = parent.getElement();
        if (element == null) {
            element = parent.addSelf();
        }
        return this.addChild(element, elementName);
    }

    protected final Element addChild(AbstractExternalForm parent, String elementName, int index) {
        Element element = parent.getElement();
        if (element == null) {
            element = parent.addSelf();
        }
        return this.addChild(element, elementName, index);
    }

    protected final Element addChild(AbstractExternalForm parent, String elementName, int index, List<String> elementNamesOrder) {
        Element element = parent.getElement();
        if (element == null) {
            element = parent.addSelf();
        }
        return this.addChild(element, elementName, index, elementNamesOrder);
    }

    protected final Element addChild(AbstractExternalForm parent, String elementName, List<String> elementNamesOrder) {
        Element element = parent.getElement();
        if (element == null) {
            element = parent.addSelf();
        }
        return this.addChild(element, elementName, elementNamesOrder);
    }

    protected final Element addChild(Element element, String elementName) {
        return this.addChild(element, elementName, this.getElementNamesOrder());
    }

    protected final Element addChild(Element element, String elementName, int index) {
        List<Element> children = this.getChildren(element);
        Element child = index < children.size() ? children.get(index) : null;
        Element childElement = this.getDocument().createElement(elementName);
        element.insertBefore(childElement, child);
        return childElement;
    }

    protected final Element addChild(Element element, String elementName, int index, List<String> elementNamesOrder) {
        Element elementOfInsertion;
        List<Element> children = this.getChildren((Node)element, elementName);
        Element element2 = elementOfInsertion = index < children.size() ? children.get(index) : null;
        if (elementOfInsertion == null) {
            elementOfInsertion = this.elementOfInsertion(element, elementName, elementNamesOrder);
        }
        Element childElement = this.getDocument().createElement(elementName);
        element.insertBefore(childElement, elementOfInsertion);
        return childElement;
    }

    protected final Element addChild(Element element, String elementName, List<String> elementNamesOrder) {
        Element childElement = this.getDocument().createElement(elementName);
        Element elementOfInsertion = this.elementOfInsertion(element, elementName, elementNamesOrder);
        element.insertBefore(childElement, elementOfInsertion);
        return childElement;
    }

    protected final Element addChild(String elementName) {
        Element element = this.getElement();
        if (element == null) {
            element = this.addSelf();
        }
        return this.addChild(element, elementName);
    }

    protected final Element addChild(String elementName, int index) {
        Element element = this.getElement();
        if (element == null) {
            element = this.addSelf();
        }
        return this.addChild(element, elementName, index);
    }

    protected final Element addChild(String elementName, List<String> elementNamesOrder) {
        Element element = this.getElement();
        if (element == null) {
            element = this.addSelf();
        }
        return this.addChild(element, elementName, elementNamesOrder);
    }

    protected final Element addChildTextNode(Element element, String elementName, String value) {
        return this.addChildTextNode(element, elementName, value, this.getElementNamesOrder());
    }

    protected final Element addChildTextNode(Element element, String elementName, String value, List<String> elementNamesOrder) {
        if (StringTools.isBlank((String)value)) {
            return null;
        }
        Element childElement = this.getDocument().createElement(elementName);
        Text text = this.getDocument().createTextNode(value);
        text.setNodeValue(value);
        childElement.appendChild(text);
        Element elementOfInsertion = this.elementOfInsertion(element, elementName, elementNamesOrder);
        element.insertBefore(childElement, elementOfInsertion);
        return childElement;
    }

    protected final Element addChildTextNode(String elementName, String value) {
        return this.addChildTextNode(elementName, value, this.getElementNamesOrder());
    }

    protected final Element addChildTextNode(String elementName, String value, List<String> elementNamesOrder) {
        Element element = this.getElement();
        if (element == null && value == null) {
            return null;
        }
        if (element == null) {
            element = this.addSelf();
        }
        return this.addChildTextNode(element, elementName, value, elementNamesOrder);
    }

    public Element addSelf() {
        return this.addSelf(this.getElementName());
    }

    protected Element addSelf(List<String> elementNamesOrder) {
        return this.addSelf(this.getElementName(), elementNamesOrder);
    }

    protected Element addSelf(String elementName) {
        return this.addSelf(elementName, this.getParent().getElementNamesOrder());
    }

    protected Element addSelf(String elementName, List<String> elementNamesOrder) {
        return this.addChild(this.getParent(), elementName, elementNamesOrder);
    }

    protected void addXmlns(Element ownerElement, String prefix, String uri) {
        ownerElement.setAttributeNS(XMLNS_URI, "xmlns:" + prefix, uri);
    }

    protected List<String> buildAttributeNamesOrder() {
        return Collections.emptyList();
    }

    protected List<String> buildElementNamesOrder() {
        return Collections.emptyList();
    }

    protected final String buildQualifiedName(String name) {
        String prefix = this.getPrefix();
        if (prefix == null) {
            return name;
        }
        StringBuilder qualifiedName = new StringBuilder();
        qualifiedName.append(prefix);
        qualifiedName.append(":");
        qualifiedName.append(name);
        return qualifiedName.toString();
    }

    protected Element elementOfInsertion(Element element, String elementName, List<String> elementNamesOrder) {
        return (Element)this.nodeOfInsertion(element, this.getChildren(element), elementName, elementNamesOrder);
    }

    private Text findTextNode(Element element) {
        NodeList children = element.getChildNodes();
        if (children == null) {
            return null;
        }
        int index = children.getLength();
        while (--index >= 0) {
            Node childNode = children.item(index);
            if (!this.isText(childNode)) continue;
            return (Text)childNode;
        }
        return null;
    }

    protected final List<Node> getAllChildren() {
        Element element = this.getElement();
        if (element != null) {
            return this.getAllChildren(element);
        }
        return Collections.emptyList();
    }

    protected final List<Node> getAllChildren(Node node) {
        ArrayList<Node> children = new ArrayList<Node>();
        NodeList childrenList = node.getChildNodes();
        if (childrenList != null) {
            int index = childrenList.getLength();
            while (--index >= 0) {
                Node child = childrenList.item(index);
                children.add(0, child);
            }
        }
        return children;
    }

    protected final int getAllChildrenSize() {
        Element element = this.getElement();
        if (element != null) {
            return this.getAllChildrenSize(element);
        }
        return 0;
    }

    protected final int getAllChildrenSize(Node node) {
        NodeList childrenList = node.getChildNodes();
        if (childrenList != null) {
            return childrenList.getLength();
        }
        return 0;
    }

    protected final String getAttribute(Element element, String attributeName) {
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    protected final String getAttribute(String attributeName) {
        Element element = this.getElement();
        if (element != null) {
            return this.getAttribute(element, attributeName);
        }
        return null;
    }

    protected final List<String> getAttributeNamesOrder() {
        return this.attributeNamesOrder;
    }

    protected final String getAttributeNS(Element element, String attributeName) {
        if (element.hasAttributeNS(XSI_URI, attributeName)) {
            return element.getAttributeNS(XSI_URI, attributeName);
        }
        return null;
    }

    protected final String getAttributeNS(String attributeName) {
        Element element = this.getElement();
        if (element != null) {
            return this.getAttributeNS(element, attributeName);
        }
        return null;
    }

    private List<Attr> getAttributes(Element element) {
        ArrayList<Attr> attributes = new ArrayList<Attr>();
        NamedNodeMap map = element.getAttributes();
        if (map != null) {
            int index = map.getLength();
            while (--index >= 0) {
                Node node = map.item(index);
                if (!this.isAttribute(node)) continue;
                attributes.add(0, (Attr)node);
            }
        }
        return attributes;
    }

    protected final Boolean getBooleanAttribute(Element element, String attributeName) {
        String value = this.getAttribute(element, attributeName);
        if (value == null) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    protected final Boolean getBooleanAttribute(String attributeName) {
        Element element = this.getElement();
        if (element == null) {
            return null;
        }
        return this.getBooleanAttribute(element, attributeName);
    }

    protected final Element getChild(AbstractExternalForm parent, String elementName) {
        return this.getChild((Node)parent.getElement(), elementName);
    }

    protected final Element getChild(AbstractExternalForm parent, String elementName, int index) {
        return this.getChild(parent.getElement(), elementName, index);
    }

    protected final Element getChild(Node node, int index) {
        List<Element> children = this.getChildren(node);
        if (index >= children.size()) {
            return null;
        }
        return children.get(index);
    }

    protected final Element getChild(Node node, String elementName) {
        for (Element child : this.getChildren(node)) {
            if (!ObjectTools.equals((Object)child.getNodeName(), (Object)elementName)) continue;
            return child;
        }
        return null;
    }

    protected final Element getChild(Node node, String elementName, int index) {
        if (index < 0) {
            return null;
        }
        List<Element> children = this.getChildren(node, elementName);
        if (index >= children.size()) {
            return null;
        }
        return children.get(index);
    }

    protected final Element getChild(String elementName) {
        Element element = this.getElement();
        if (element != null) {
            element = this.getChild((Node)element, elementName);
        }
        return element;
    }

    protected final Element getChild(String elementName, int index) {
        Element element = this.getElement();
        if (element != null) {
            element = this.getChild(element, elementName, index);
        }
        return element;
    }

    protected final String getChildAttribute(String childName, String attributeName) {
        Element element = this.getChild(childName);
        if (element == null) {
            return null;
        }
        return this.getAttribute(element, attributeName);
    }

    protected final Boolean getChildBooleanNode(Node element, String elementName) {
        String value = this.getChildTextNode(element, elementName);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    protected final Boolean getChildBooleanNode(String elementName) {
        Element element = this.getElement();
        if (element != null) {
            return this.getChildBooleanNode(element, elementName);
        }
        return null;
    }

    protected final <T extends Enum<T>> T getChildEnumNode(Node node, String elementName, Class<T> enumClass) {
        String value = this.getChildTextNode(node, elementName);
        if (value != null) {
            try {
                return Enum.valueOf(enumClass, value);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    protected final <T extends Enum<T>> T getChildEnumNode(String elementName, Class<T> enumClass) {
        Element element = this.getElement();
        if (element != null) {
            return this.getChildEnumNode(element, elementName, enumClass);
        }
        return null;
    }

    protected final Integer getChildIntegerNode(Node element, String elementName) {
        String value = this.getChildTextNode(element, elementName);
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected final Integer getChildIntegerNode(String elementName) {
        Element element = this.getElement();
        if (element != null) {
            return this.getChildIntegerNode(element, elementName);
        }
        return null;
    }

    protected final List<Element> getChildren() {
        Element element = this.getElement();
        if (element != null) {
            return this.getChildren(element);
        }
        return Collections.emptyList();
    }

    protected final List<Element> getChildren(Node node) {
        ArrayList<Element> children = new ArrayList<Element>();
        NodeList childrenList = node.getChildNodes();
        if (childrenList != null) {
            int index = childrenList.getLength();
            while (--index >= 0) {
                Node child = childrenList.item(index);
                if (!this.isElement(child)) continue;
                children.add(0, (Element)child);
            }
        }
        return children;
    }

    protected final List<Element> getChildren(Node node, Collection<String> elementNames) {
        List<Element> children = this.getChildren(node);
        Iterator<Element> iter = children.iterator();
        while (iter.hasNext()) {
            Element element = iter.next();
            String elementName = element.getNodeName();
            if (elementNames.contains(elementName)) continue;
            iter.remove();
        }
        return children;
    }

    protected final List<Element> getChildren(Node node, String elementName) {
        List<Element> children = this.getChildren(node);
        Iterator<Element> iter = children.iterator();
        while (iter.hasNext()) {
            Element element = iter.next();
            if (!ObjectTools.notEquals((Object)element.getNodeName(), (Object)elementName)) continue;
            iter.remove();
        }
        return children;
    }

    protected final List<Element> getChildren(String elementName) {
        Element element = this.getElement();
        if (element != null) {
            return this.getChildren((Node)element, elementName);
        }
        return Collections.emptyList();
    }

    protected final int getChildrenSize() {
        return this.getChildren().size();
    }

    protected final int getChildrenSize(Node node) {
        return this.getChildren(node).size();
    }

    protected final int getChildrenSize(Node element, Collection<String> elementNames) {
        return this.getChildren(element, elementNames).size();
    }

    protected final int getChildrenSize(Node element, String elementName) {
        return this.getChildren(element, elementName).size();
    }

    protected final int getChildrenSize(String elementName) {
        return this.getChildren(elementName).size();
    }

    protected final List<String> getChildrenTextNode(Node node, String elementName) {
        ArrayList<String> values = new ArrayList<String>();
        for (Element element : this.getChildren(node, elementName)) {
            values.add(element.getTextContent());
        }
        return values;
    }

    protected final List<String> getChildrenTextNode(String elementName) {
        Element element = this.getElement();
        if (element != null) {
            return this.getChildrenTextNode(element, elementName);
        }
        return Collections.emptyList();
    }

    protected final String getChildTextNode(Node node, String elementName) {
        Element child = this.getChild(node, elementName);
        if (child != null) {
            return this.getTextNode(child);
        }
        return null;
    }

    protected final Element getChildTextNode(Node node, String elementName, String text) {
        for (Element child : this.getChildren(node, elementName)) {
            String childText = this.getTextNode(child);
            if (!childText.equals(text)) continue;
            return child;
        }
        return null;
    }

    protected final String getChildTextNode(String elementName) {
        Element element = this.getElement();
        if (element != null) {
            return this.getChildTextNode(element, elementName);
        }
        return null;
    }

    protected final String getChildTextNode(String childName, String elementName) {
        Element child = this.getChild(childName);
        if (child != null) {
            return this.getChildTextNode(child, elementName);
        }
        return null;
    }

    protected Document getDocument() {
        return this.getParent().getDocument();
    }

    protected Element getElement() {
        return this.getChild(this.getParent(), this.getElementName());
    }

    protected abstract String getElementName();

    protected final List<String> getElementNamesOrder() {
        return this.elementNamesOrder;
    }

    protected final <T extends Enum<T>> T getEnumAttribute(Element element, String attributeName, Class<T> enumClass) {
        String value = this.getAttribute(element, attributeName);
        if (value != null) {
            try {
                return Enum.valueOf(enumClass, value);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    protected final <T extends Enum<T>> T getEnumAttribute(String attributeName, Class<T> enumClass) {
        Element element = this.getElement();
        if (element == null) {
            return null;
        }
        return this.getEnumAttribute(element, attributeName, enumClass);
    }

    protected final Integer getIntegerAttribute(Element element, String attributeName) {
        String value = this.getAttribute(attributeName);
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    protected final Integer getIntegerAttribute(String attributeName) {
        Element element = this.getElement();
        if (element == null) {
            return null;
        }
        return this.getIntegerAttribute(element, attributeName);
    }

    protected String getNamespace() {
        return this.getAttribute(XMLNS_ATTRIBUTE);
    }

    protected final String getNodeName(Node node) {
        return node.getNodeName();
    }

    protected AbstractExternalForm getParent() {
        return this.parent;
    }

    protected final Element getParentElement() {
        return this.getParent().getElement();
    }

    protected final String getPrefix() {
        Element element = this.getRootElement();
        NamedNodeMap attributes = element.getAttributes();
        if (attributes != null) {
            int index = attributes.getLength();
            while (--index >= 0) {
                Node node = attributes.item(index);
                String localName = node.getNodeName();
                String value = node.getNodeValue();
                if (localName == null || !localName.startsWith("xmlns:") || !XSI_URI.equals(value)) continue;
                return localName.substring("xmlns:".length());
            }
        }
        return null;
    }

    protected final AbstractExternalForm getRoot() {
        return this.parent == null ? this : this.parent.getRoot();
    }

    protected final Element getRootElement() {
        String rootElementName;
        Document document = this.getDocument();
        Element element = this.getChild((Node)document, rootElementName = this.getRoot().getElementName());
        if (element == null) {
            for (Element child : this.getChildren(document)) {
                if (!ObjectTools.notEquals((Object)child.getNodeName(), (Object)rootElementName)) continue;
                this.setElementName(child, rootElementName);
                return this.getRootElement();
            }
            element = this.addSelf();
        }
        return element;
    }

    protected String getSchemaLocation() {
        return this.getAttribute("xsi:schemaLocation");
    }

    protected final String getTextNode() {
        Element element = this.getElement();
        if (element != null) {
            return this.getTextNode(element);
        }
        return null;
    }

    protected final String getTextNode(Node element) {
        return element.getTextContent();
    }

    public final String getVersion() {
        return this.getAttribute(VERSION);
    }

    protected final boolean hasAnyChildren() {
        Element element = this.getElement();
        if (element != null) {
            return this.hasAnyChildren(element);
        }
        return false;
    }

    protected final boolean hasAnyChildren(Node node) {
        return this.getAllChildrenSize(node) > 0;
    }

    protected final boolean hasAttribute(Element element, String elementName) {
        return this.getAttribute(element, elementName) != null;
    }

    protected final boolean hasAttribute(String attributeName) {
        return this.getAttribute(attributeName) != null;
    }

    protected final boolean hasAttributeNS(Element element, String elementName) {
        return this.getAttributeNS(element, elementName) != null;
    }

    protected final boolean hasAttributeNS(String elementName) {
        return this.getAttributeNS(elementName) != null;
    }

    protected final boolean hasAttributes() {
        Element element = this.getElement();
        if (element != null) {
            return this.hasAttributes(element);
        }
        return false;
    }

    protected final boolean hasAttributes(Element element) {
        NamedNodeMap attributes = element.getAttributes();
        if (attributes == null) {
            return false;
        }
        return attributes.getLength() > 0;
    }

    protected final boolean hasChild(Element element, String elementName) {
        return this.getChild((Node)element, elementName) != null;
    }

    protected final boolean hasChild(String elementName) {
        Element element = this.getElement();
        if (element != null) {
            return this.hasChild(element, elementName);
        }
        return false;
    }

    protected final boolean hasChildren() {
        Element element = this.getElement();
        if (element != null) {
            return this.hasChildren(element);
        }
        return false;
    }

    protected final boolean hasChildren(Element element) {
        NodeList childrenList = element.getChildNodes();
        int count = 0;
        if (childrenList != null) {
            int index = childrenList.getLength();
            while (--index >= 0) {
                Node child = childrenList.item(index);
                if (!this.isElement(child)) continue;
                ++count;
            }
            return count > 0;
        }
        return false;
    }

    protected final boolean hasElement() {
        return this.getElement() != null;
    }

    protected void initialize() {
        this.attributeNamesOrder = this.buildAttributeNamesOrder();
        this.elementNamesOrder = this.buildElementNamesOrder();
    }

    protected boolean isAttribute(Node node) {
        return this.isNodeType(node, 2);
    }

    protected boolean isElement(Node node) {
        return this.isNodeType(node, 1);
    }

    protected boolean isNodeType(Node node, int type) {
        return node != null && node.getNodeType() == type;
    }

    protected boolean isText(Node node) {
        return this.isNodeType(node, 3);
    }

    private Node nodeOfInsertion(Element element, List<? extends Node> children, String nodeName, List<String> namesOrder) {
        if (namesOrder.isEmpty()) {
            return null;
        }
        int count = namesOrder.size();
        for (Node node : children) {
            String childName = this.getNodeName(node);
            int index = namesOrder.indexOf(nodeName) + 1;
            while (index < count) {
                String name = namesOrder.get(index);
                if (ObjectTools.equals((Object)childName, (Object)name)) {
                    return node;
                }
                ++index;
            }
        }
        return null;
    }

    protected final void remove(Element element) {
        Element parent = this.getElement();
        if (parent != null) {
            this.remove(parent, element);
        }
    }

    protected final void remove(Element element, Element childElement) {
        element.removeChild(childElement);
    }

    protected final void removeChild(AbstractExternalForm parent, String elementName, int index) {
        this.removeChild(parent.getElement(), elementName, index);
    }

    protected final void removeChild(Element element, int index) {
        Element childElement = this.getChild((Node)element, index);
        if (childElement != null) {
            this.remove(element, childElement);
        }
    }

    protected final void removeChild(Element element, String elementName) {
        Element childElement = this.getChild((Node)element, elementName);
        if (childElement != null) {
            this.remove(element, childElement);
        }
    }

    protected final void removeChild(Element element, String elementName, int index) {
        Element childElement = this.getChild(element, elementName, index);
        if (childElement != null) {
            this.remove(element, childElement);
        }
    }

    protected final void removeChild(String elementName) {
        Element element = this.getChild(elementName);
        if (element != null) {
            this.remove(this.getElement(), element);
        }
    }

    protected final void removeChild(String elementName, int index) {
        this.removeChild(this.getElement(), elementName, index);
    }

    protected final void removeChildren(Node node, String elementName) {
        for (Element childElement : this.getChildren(node, elementName)) {
            node.removeChild(childElement);
        }
    }

    protected final void removeChildren(String elementName) {
        Element element = this.getElement();
        if (element != null) {
            this.removeChildren(element, elementName);
        }
    }

    public void removeSelf() {
        Element element = this.getElement();
        if (this.parent != null && element != null) {
            this.parent.remove(element);
        }
    }

    protected final void setAttribute(Element element, String attributeName, Boolean value) {
        this.setAttribute(element, attributeName, value, this.getAttributeNamesOrder());
    }

    protected final void setAttribute(Element element, String attributeName, Boolean value, List<String> attributeNamesOrder) {
        this.setAttribute(element, attributeName, value != null ? value.toString() : null, attributeNamesOrder);
    }

    protected final void setAttribute(Element element, String attributeName, Enum<?> value) {
        this.setAttribute(element, attributeName, value, this.getAttributeNamesOrder());
    }

    protected final void setAttribute(Element element, String attributeName, Enum<?> value, List<String> attributeNamesOrder) {
        this.setAttribute(element, attributeName, value != null ? value.toString() : null, attributeNamesOrder);
    }

    protected final void setAttribute(Element element, String attributeName, Number value) {
        this.setAttribute(element, attributeName, value, this.getAttributeNamesOrder());
    }

    protected final void setAttribute(Element element, String attributeName, Number value, List<String> attributeNamesOrder) {
        this.setAttribute(element, attributeName, value != null ? value.toString() : null, attributeNamesOrder);
    }

    protected final void setAttribute(Element element, String attributeName, String value) {
        this.setAttribute(element, attributeName, value, this.getAttributeNamesOrder());
    }

    protected final void setAttribute(Element element, String attributeName, String value, List<String> attributeNamesOrder) {
        if (value == null) {
            element.removeAttribute(attributeName);
        } else if (this.hasAttribute(attributeName)) {
            element.setAttribute(attributeName, value);
        } else {
            Attr newAttribute = this.getDocument().createAttribute(attributeName);
            newAttribute.setValue(value);
            List<Attr> attributes = this.getAttributes(element);
            Attr elementOfInsertion = (Attr)this.nodeOfInsertion(element, attributes, attributeName, attributeNamesOrder);
            if (elementOfInsertion != null) {
                int indexOfInsertion = attributes.indexOf(elementOfInsertion);
                int index = attributes.size();
                while (--index >= 0) {
                    Node attributeNode = attributes.get(index);
                    element.removeAttribute(attributeNode.getNodeName());
                }
                attributes.add(indexOfInsertion, newAttribute);
                index = 0;
                while (index < attributes.size()) {
                    Attr attribute = attributes.get(index);
                    element.setAttributeNode(attribute);
                    ++index;
                }
            } else {
                element.setAttribute(attributeName, value);
            }
        }
    }

    protected final void setAttribute(String attributeName, Boolean value) {
        this.setAttribute(attributeName, value, this.getAttributeNamesOrder());
    }

    protected final void setAttribute(String attributeName, Boolean value, List<String> attributeNamesOrder) {
        Element element = this.getElement();
        if (element == null && value == null) {
            return;
        }
        if (element == null) {
            element = this.addSelf();
        }
        this.setAttribute(element, attributeName, value, attributeNamesOrder);
    }

    protected final void setAttribute(String attributeName, Enum<?> value) {
        this.setAttribute(attributeName, value, this.getAttributeNamesOrder());
    }

    protected final void setAttribute(String attributeName, Enum<?> value, List<String> attributeNamesOrder) {
        Element element = this.getElement();
        if (element == null && value == null) {
            return;
        }
        if (element == null) {
            element = this.addSelf();
        }
        this.setAttribute(element, attributeName, value, attributeNamesOrder);
    }

    protected final void setAttribute(String attributeName, Number value) {
        this.setAttribute(attributeName, value, this.getAttributeNamesOrder());
    }

    protected final void setAttribute(String attributeName, Number value, List<String> attributeNamesOrder) {
        Element element = this.getElement();
        if (element == null && value == null) {
            return;
        }
        if (element == null) {
            element = this.addSelf();
        }
        this.setAttribute(element, attributeName, value, attributeNamesOrder);
    }

    protected final void setAttribute(String attributeName, String value) {
        this.setAttribute(attributeName, value, this.getAttributeNamesOrder());
    }

    protected final void setAttribute(String attributeName, String value, List<String> attributeNamesOrder) {
        Element element = this.getElement();
        if (element == null && value == null) {
            return;
        }
        if (element == null) {
            element = this.addSelf();
        }
        this.setAttribute(element, attributeName, value, attributeNamesOrder);
    }

    protected final void setAttributeNS(Element element, String attributeName, Boolean value) {
        this.setAttributeNS(element, attributeName, value, this.getAttributeNamesOrder());
    }

    protected final void setAttributeNS(Element element, String attributeName, Boolean value, List<String> attributeNamesOrder) {
        this.setAttributeNS(element, attributeName, value != null ? value.toString() : null, attributeNamesOrder);
    }

    protected final void setAttributeNS(Element element, String attributeName, Enum<?> value) {
        this.setAttributeNS(element, attributeName, value, this.getAttributeNamesOrder());
    }

    protected final void setAttributeNS(Element element, String attributeName, Enum<?> value, List<String> attributeNamesOrder) {
        this.setAttributeNS(element, attributeName, value != null ? value.toString() : null, attributeNamesOrder);
    }

    protected final void setAttributeNS(Element element, String attributeName, Number value) {
        this.setAttributeNS(element, attributeName, value, this.getAttributeNamesOrder());
    }

    protected final void setAttributeNS(Element element, String attributeName, Number value, List<String> attributeNamesOrder) {
        this.setAttributeNS(element, attributeName, value != null ? value.toString() : null, attributeNamesOrder);
    }

    protected final void setAttributeNS(Element element, String attributeName, String value) {
        this.setAttributeNS(element, attributeName, value, this.getAttributeNamesOrder());
    }

    protected final void setAttributeNS(Element element, String attributeName, String value, List<String> attributeNamesOrder) {
        StringBuilder sb = new StringBuilder();
        sb.append("Update attribute: ");
        sb.append(this.getPrefix());
        sb.append(":");
        sb.append(attributeName);
        sb.append(" = ");
        sb.append(value);
        if (value == null) {
            element.removeAttributeNS(XSI_URI, attributeName);
        } else if (this.hasAttribute(attributeName)) {
            attributeName = this.buildQualifiedName(attributeName);
            element.setAttributeNS(XSI_URI, attributeName, value);
        } else {
            attributeName = this.buildQualifiedName(attributeName);
            Attr newAttribute = this.getDocument().createAttributeNS(XSI_URI, attributeName);
            newAttribute.setValue(value);
            List<Attr> attributes = this.getAttributes(element);
            Attr elementOfInsertion = (Attr)this.nodeOfInsertion(element, attributes, attributeName, attributeNamesOrder);
            if (elementOfInsertion != null) {
                int indexOfInsertion = attributes.indexOf(elementOfInsertion);
                int index = attributes.size();
                while (--index >= 0) {
                    Node attributeNode = attributes.get(index);
                    element.removeAttribute(attributeNode.getNodeName());
                }
                attributes.add(indexOfInsertion, newAttribute);
                index = 0;
                int count = attributes.size();
                while (index < count) {
                    Attr attribute = attributes.get(index);
                    element.setAttributeNode(attribute);
                    ++index;
                }
            } else {
                element.setAttributeNS(XSI_URI, attributeName, value);
            }
        }
    }

    protected final void setAttributeNS(String attributeName, Boolean value) {
        this.setAttributeNS(attributeName, value, this.getAttributeNamesOrder());
    }

    protected final void setAttributeNS(String attributeName, Boolean value, List<String> attributeNamesOrder) {
        this.setAttributeNS(attributeName, value != null ? value.toString() : null, attributeNamesOrder);
    }

    protected final void setAttributeNS(String attributeName, Enum<?> value) {
        this.setAttributeNS(attributeName, value, this.getAttributeNamesOrder());
    }

    protected final void setAttributeNS(String attributeName, Enum<?> value, List<String> attributeNamesOrder) {
        this.setAttributeNS(attributeName, value != null ? value.toString() : null, attributeNamesOrder);
    }

    protected final void setAttributeNS(String attributeName, Number value) {
        this.setAttributeNS(attributeName, value, this.getAttributeNamesOrder());
    }

    protected final void setAttributeNS(String attributeName, Number value, List<String> attributeNamesOrder) {
        this.setAttributeNS(attributeName, value != null ? value.toString() : null, attributeNamesOrder);
    }

    protected final void setAttributeNS(String attributeName, String value) {
        this.setAttributeNS(attributeName, value, this.getAttributeNamesOrder());
    }

    protected final void setAttributeNS(String attributeName, String value, List<String> attributeNamesOrder) {
        Element element = this.getElement();
        if (element == null && value == null) {
            return;
        }
        if (element == null) {
            element = this.addSelf();
        }
        this.setAttributeNS(element, attributeName, value, attributeNamesOrder);
    }

    protected final void setElementName(Element element, String elementName) {
        this.getDocument().removeChild(element);
        Element newElement = this.addSelf(elementName, this.getElementNamesOrder());
        for (Node childNode : this.getAllChildren(element)) {
            newElement.appendChild(childNode);
        }
    }

    protected final void setNamespace(String uri) {
        Element element = this.getRootElement();
        element.setAttributeNS(XMLNS_URI, XMLNS_ATTRIBUTE, uri);
    }

    protected final void setSchemaLocation(String uri) {
        Element element = this.getRootElement();
        element.setAttributeNS(XSI_URI, "xsi:schemaLocation", uri);
    }

    protected final void setTextNode(Element element, String value) {
        this.updateTextNode(element, this.getElementName(), value);
    }

    protected final void setTextNode(String value) {
        this.updateTextNode(this.getParent().getElement(), this.getElementName(), value, this.getParent().getElementNamesOrder());
    }

    public final void setVersion(String version) {
        this.setAttribute(VERSION, version);
    }

    protected final void updateChildAttribute(String childName, String attributeName, Boolean value) {
        this.updateChildAttribute(childName, attributeName, value != null ? value.toString() : null);
    }

    protected final void updateChildAttribute(String childName, String attributeName, Enum<?> value) {
        this.updateChildAttribute(childName, attributeName, value != null ? value.name() : null);
    }

    protected final void updateChildAttribute(String childName, String attributeName, Number value) {
        this.updateChildAttribute(childName, attributeName, value != null ? value.toString() : null);
    }

    protected final void updateChildAttribute(String childName, String attributeName, String value) {
        Element element = this.getChild(childName);
        if (element == null && value != null) {
            element = this.addChild(childName);
        }
        if (value != null) {
            this.setAttribute(element, attributeName, value);
        } else if (element != null) {
            this.removeChild(childName);
        }
    }

    protected final void updateChildChildTextNode(String parentChildName, String childName, Boolean value) {
        this.updateChildChildTextNode(parentChildName, childName, value != null ? value.toString() : null);
    }

    protected final void updateChildChildTextNode(String parentChildName, String childName, Enum<?> value) {
        this.updateChildChildTextNode(parentChildName, childName, value != null ? value.name() : null);
    }

    protected final void updateChildChildTextNode(String parentChildName, String childName, Number value) {
        this.updateChildChildTextNode(parentChildName, childName, value != null ? value.toString() : null);
    }

    protected final void updateChildChildTextNode(String parentChildName, String childName, String value) {
        Element element = this.getChild(parentChildName);
        if (element == null && value != null) {
            element = this.addChild(parentChildName);
        }
        this.updateTextNode(element, childName, value);
    }

    protected final void updateChildTextNode(String elementName, Boolean value) {
        this.updateChildTextNode(elementName, value, this.getElementNamesOrder());
    }

    protected final void updateChildTextNode(String elementName, Boolean value, List<String> elementNamesOrder) {
        this.updateChildTextNode(elementName, value != null ? value.toString() : null, elementNamesOrder);
    }

    protected final void updateChildTextNode(String elementName, Enum<?> value) {
        this.updateChildTextNode(elementName, value, this.getElementNamesOrder());
    }

    protected final void updateChildTextNode(String elementName, Enum<?> value, List<String> elementNamesOrder) {
        this.updateChildTextNode(elementName, value != null ? value.toString() : null, elementNamesOrder);
    }

    protected final void updateChildTextNode(String elementName, Number value) {
        this.updateChildTextNode(elementName, value, this.getElementNamesOrder());
    }

    protected final void updateChildTextNode(String elementName, Number value, List<String> elementNamesOrder) {
        this.updateChildTextNode(elementName, value != null ? value.toString() : null, elementNamesOrder);
    }

    protected final void updateChildTextNode(String elementName, String value) {
        this.updateChildTextNode(elementName, value, this.getElementNamesOrder());
    }

    protected final void updateChildTextNode(String elementName, String value, List<String> elementNamesOrder) {
        Element element = this.getElement();
        if (element == null && value == null) {
            return;
        }
        if (element == null) {
            element = this.addSelf();
        }
        this.updateTextNode(element, elementName, value, elementNamesOrder);
    }

    protected final void updateTextNode(Element element, String elementName, Boolean value) {
        this.updateTextNode(element, elementName, value, this.getElementNamesOrder());
    }

    protected final void updateTextNode(Element element, String elementName, Boolean value, List<String> elementNamesOrder) {
        this.updateTextNode(element, elementName, value == null ? null : value.toString(), elementNamesOrder);
    }

    protected final void updateTextNode(Element element, String elementName, Enum<?> value) {
        this.updateTextNode(element, elementName, value, this.getElementNamesOrder());
    }

    protected final void updateTextNode(Element element, String elementName, Enum<?> value, List<String> elementNamesOrder) {
        this.updateTextNode(element, elementName, value != null ? value.toString() : null, elementNamesOrder);
    }

    protected final void updateTextNode(Element element, String elementName, Number value) {
        this.updateTextNode(element, elementName, value, this.getElementNamesOrder());
    }

    protected final void updateTextNode(Element element, String elementName, Number value, List<String> elementNamesOrder) {
        this.updateTextNode(element, elementName, value != null ? value.toString() : null, elementNamesOrder);
    }

    protected final void updateTextNode(Element element, String elementName, String value) {
        this.updateTextNode(element, elementName, value, this.getElementNamesOrder());
    }

    protected final void updateTextNode(Element element, String elementName, String value, List<String> elementNamesOrder) {
        boolean valueNotEmpty;
        Element childElement;
        if (StringTools.isBlank((String)value)) {
            value = null;
        }
        if ((childElement = this.getChild((Node)element, elementName)) != null && value == null) {
            this.remove(element, childElement);
            return;
        }
        boolean bl = valueNotEmpty = !StringTools.isBlank((String)value);
        if (childElement == null && valueNotEmpty) {
            this.addChildTextNode(element, elementName, value, elementNamesOrder);
        } else if (childElement != null && valueNotEmpty) {
            Text text = this.findTextNode(childElement);
            if (text == null) {
                text = this.getDocument().createTextNode(value);
                childElement.appendChild(text);
            } else {
                text.setNodeValue(value);
            }
        }
    }
}

