/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.FetchType;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.tools.mapping.orm.ExternalBasicCollectionMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalBatchFetch;
import org.eclipse.persistence.tools.mapping.orm.ExternalCollectionTable;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.BatchFetch;
import org.eclipse.persistence.tools.mapping.orm.dom.CollectionTable;
import org.eclipse.persistence.tools.mapping.orm.dom.ConvertibleMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.EmbeddableEntity;
import org.eclipse.persistence.tools.mapping.orm.dom.EntityColumn;

final class BasicCollectionMapping
extends ConvertibleMapping
implements ExternalBasicCollectionMapping {
    static final String BASIC_COLLECTION = "basic-collection";
    static final String FETCH = "fetch";
    static final String JOIN_FETCH = "join-fetch";
    static final String VALUE_COLUMN = "value-column";

    BasicCollectionMapping(EmbeddableEntity parent, int index) {
        super(parent, index);
    }

    @Override
    public final void addBatchFetch() {
        BatchFetch batchFetch = this.buildBatchFetch();
        batchFetch.addSelf();
    }

    @Override
    public void addCollectionTable(String name) {
        CollectionTable collectionTable = this.buildCollectionTable();
        collectionTable.addSelf();
        collectionTable.setName(name);
    }

    @Override
    public void addValueColumn(String columnName) {
        EntityColumn valueColumn = this.buildValueColumn();
        valueColumn.addSelf();
        valueColumn.setName(columnName);
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add(FETCH);
        names.add("access");
        return names;
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(VALUE_COLUMN);
        names.add("convert");
        names.add("converter");
        names.add("type-converter");
        names.add("object-type-converter");
        names.add("struct-converter");
        names.add("collection-table");
        names.add(JOIN_FETCH);
        names.add("batch-fetch");
        names.add("property");
        names.add("access-methods");
        return names;
    }

    private BatchFetch buildBatchFetch() {
        return new BatchFetch(this);
    }

    private CollectionTable buildCollectionTable() {
        return new CollectionTable(this);
    }

    private EntityColumn buildValueColumn() {
        return new EntityColumn(this, VALUE_COLUMN);
    }

    @Override
    public final ExternalBatchFetch getBatchFetch() {
        if (this.hasChild("batch-fetch")) {
            return this.buildBatchFetch();
        }
        return null;
    }

    @Override
    public ExternalCollectionTable getCollectionTable() {
        if (this.hasChild("collection-table")) {
            return this.buildCollectionTable();
        }
        return null;
    }

    @Override
    protected String getElementName() {
        return BASIC_COLLECTION;
    }

    @Override
    public FetchType getFetchType() {
        return this.getEnumAttribute(FETCH, FetchType.class);
    }

    @Override
    public JoinFetchType getJoinFetchType() {
        return this.getChildEnumNode(JOIN_FETCH, JoinFetchType.class);
    }

    @Override
    public ExternalEntityColumn getValueColumn() {
        if (this.hasChild(VALUE_COLUMN)) {
            return this.buildValueColumn();
        }
        return null;
    }

    @Override
    public final void removeBatchFetch() {
        this.removeChild("batch-fetch");
    }

    @Override
    public void removeCollectionTable() {
        CollectionTable collectionTable = this.buildCollectionTable();
        collectionTable.removeSelf();
    }

    @Override
    public void removeValueColumn() {
        EntityColumn valueColumn = this.buildValueColumn();
        valueColumn.removeSelf();
    }

    @Override
    public void setFetchType(FetchType type) {
        this.setAttribute(FETCH, (Enum<?>)type);
    }

    @Override
    public void setJoinFetchType(JoinFetchType type) {
        this.updateChildTextNode(JOIN_FETCH, (Enum<?>)type);
    }
}

