/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.annotations.ChangeTrackingType;
import org.eclipse.persistence.tools.mapping.orm.ExternalAccessMethods;
import org.eclipse.persistence.tools.mapping.orm.ExternalBasicCollectionMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalBasicMapMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalBasicMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalCloneCopyPolicy;
import org.eclipse.persistence.tools.mapping.orm.ExternalConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalCopyPolicy;
import org.eclipse.persistence.tools.mapping.orm.ExternalElementCollectionMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalEmbeddableEntity;
import org.eclipse.persistence.tools.mapping.orm.ExternalEmbeddedMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalIDMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalInstantiationCopyPolicy;
import org.eclipse.persistence.tools.mapping.orm.ExternalManyToManyMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalManyToOneMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalNoSql;
import org.eclipse.persistence.tools.mapping.orm.ExternalObjectTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalOneToManyMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalOneToOneMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalProperty;
import org.eclipse.persistence.tools.mapping.orm.ExternalStructConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalTransientMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.dom.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.dom.AccessMethods;
import org.eclipse.persistence.tools.mapping.orm.dom.BasicCollectionMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.BasicMapMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.BasicMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.CloneCopyPolicy;
import org.eclipse.persistence.tools.mapping.orm.dom.Converter;
import org.eclipse.persistence.tools.mapping.orm.dom.CopyPolicy;
import org.eclipse.persistence.tools.mapping.orm.dom.ElementCollectionMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.EmbeddedMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.InstantiationCopyPolicy;
import org.eclipse.persistence.tools.mapping.orm.dom.ManyToManyMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.ManyToOneMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.Mapping;
import org.eclipse.persistence.tools.mapping.orm.dom.NoSql;
import org.eclipse.persistence.tools.mapping.orm.dom.ORMConfiguration;
import org.eclipse.persistence.tools.mapping.orm.dom.ObjectTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.dom.OneToManyMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.OneToOneMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.Property;
import org.eclipse.persistence.tools.mapping.orm.dom.StructConverter;
import org.eclipse.persistence.tools.mapping.orm.dom.TransientMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.TypeConverter;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.collection.ListTools;
import org.eclipse.persistence.tools.utility.iterable.EmptyListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class EmbeddableEntity
extends AbstractExternalForm
implements ExternalEmbeddableEntity {
    private int index;
    static final String ACCESS = "access";
    static final String CHANGE_TRACKING = "change-tracking";
    static final String CLASS = "class";
    static final String CUSTOMIZER = "customizer";
    static final String DESCRIPTION = "description";
    static final String EMBEDDABLE = "embeddable";
    static final String EXCLUDE_DEFAULT_MAPPINGS = "exclude-default-mappings";
    static final String METADATA_COMPLETE = "metadata-complete";
    static final String TYPE = "type";

    EmbeddableEntity(ORMConfiguration parent, int index) {
        super(parent);
        this.index = index;
    }

    @Override
    public final void addAccessMethods(String getMethodName, String setMethodName) {
        AccessMethods accessMethods = this.buildAccessMethods();
        accessMethods.addSelf();
        accessMethods.setGetMethod(getMethodName);
        accessMethods.setSetMethod(setMethodName);
    }

    @Override
    public final ExternalBasicCollectionMapping addBasicCollectionMapping(String name) {
        BasicCollectionMapping mapping = this.buildBasicCollectionMapping(this.mappingsSize());
        mapping.addSelf();
        mapping.setName(name);
        return mapping;
    }

    @Override
    public final ExternalBasicMapMapping addBasicMapMapping(String name) {
        BasicMapMapping mapping = this.buildBasicMapMapping(this.mappingsSize());
        mapping.addSelf();
        mapping.setName(name);
        return mapping;
    }

    @Override
    public final ExternalBasicMapping addBasicMapping(String name) {
        BasicMapping mapping = this.buildBasicMapping(this.mappingsSize());
        mapping.addSelf();
        mapping.setName(name);
        return mapping;
    }

    @Override
    public final ExternalCloneCopyPolicy addCloneCopyPolicy() {
        CloneCopyPolicy cloneCopyPolicy = this.buildCloneCopyPolicy();
        cloneCopyPolicy.addSelf();
        return cloneCopyPolicy;
    }

    @Override
    public final ExternalConverter addConverter(int index, String name) {
        Converter converter = this.buildConverter(index);
        converter.addSelf();
        converter.setName(name);
        return converter;
    }

    @Override
    public final ExternalCopyPolicy addCopyPolicy() {
        CopyPolicy copyPolicy = this.buildCopyPolicy();
        copyPolicy.addSelf();
        return copyPolicy;
    }

    @Override
    public final ExternalElementCollectionMapping addElementCollectionMapping(String name) {
        ElementCollectionMapping mapping = this.buildElementCollectionMapping(this.mappingsSize());
        mapping.addSelf();
        mapping.setName(name);
        return mapping;
    }

    @Override
    public final ExternalEmbeddedMapping addEmbeddedMapping(String name) {
        EmbeddedMapping mapping = this.buildEmbeddedMapping(this.mappingsSize());
        mapping.addSelf();
        mapping.setName(name);
        return mapping;
    }

    @Override
    public ExternalIDMapping addIdMapping(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ExternalInstantiationCopyPolicy addInstantiationCopyPolicy() {
        InstantiationCopyPolicy instantiationCopyPolicy = this.buildInstantiationCopyPolicy();
        instantiationCopyPolicy.addSelf();
        return instantiationCopyPolicy;
    }

    @Override
    public final ExternalManyToManyMapping addManyToManyMapping(String name) {
        ManyToManyMapping mapping = this.buildManyToManyMapping(this.mappingsSize());
        mapping.addSelf();
        mapping.setName(name);
        return mapping;
    }

    @Override
    public final ExternalManyToOneMapping addManyToOneMapping(String name) {
        ManyToOneMapping mapping = this.buildManyToOneMapping(this.mappingsSize());
        mapping.addSelf();
        mapping.setName(name);
        return mapping;
    }

    @Override
    public final ExternalNoSql addNoSql() {
        NoSql noSql = new NoSql(this);
        noSql.addSelf();
        return noSql;
    }

    @Override
    public final ExternalObjectTypeConverter addObjectTypeConverter(int index, String name) {
        ObjectTypeConverter converter = this.buildObjectTypeConverter(index);
        converter.addSelf();
        converter.setName(name);
        return converter;
    }

    @Override
    public final ExternalOneToManyMapping addOneToManyMapping(String name) {
        OneToManyMapping mapping = this.buildOneToManyMapping(this.mappingsSize());
        mapping.addSelf();
        mapping.setName(name);
        return mapping;
    }

    @Override
    public final ExternalOneToOneMapping addOneToOneMapping(String name) {
        OneToOneMapping mapping = this.buildOneToOneMapping(this.mappingsSize());
        mapping.addSelf();
        mapping.setName(name);
        return mapping;
    }

    @Override
    public final void addProperty(int index, String name, String value) {
        Property property = this.buildProperty(index);
        property.addSelf();
        property.setName(name);
        property.setValue(value);
    }

    @Override
    protected final Element addSelf(String elementName) {
        return this.addChild(this.getParent(), elementName, this.index, this.getParent().getElementNamesOrder());
    }

    @Override
    public final ExternalStructConverter addStructConverter(int index, String name) {
        StructConverter converter = this.buildStructConverter(index);
        converter.addSelf();
        converter.setName(name);
        return converter;
    }

    @Override
    public final ExternalTransientMapping addTransientMapping(String name) {
        TransientMapping mapping = this.buildTransientMapping(this.mappingsSize());
        mapping.addSelf();
        mapping.setName(name);
        return mapping;
    }

    @Override
    public final ExternalTypeConverter addTypeConverter(int index, String name) {
        TypeConverter converter = this.buildTypeConverter(index);
        converter.addSelf();
        converter.setName(name);
        return converter;
    }

    private AccessMethods buildAccessMethods() {
        return new AccessMethods(this);
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(CLASS);
        names.add(ACCESS);
        names.add(METADATA_COMPLETE);
        names.add(EXCLUDE_DEFAULT_MAPPINGS);
        return names;
    }

    private BasicCollectionMapping buildBasicCollectionMapping(int index) {
        return new BasicCollectionMapping(this, index);
    }

    private BasicMapMapping buildBasicMapMapping(int index) {
        return new BasicMapMapping(this, index);
    }

    private BasicMapping buildBasicMapping(int index) {
        return new BasicMapping(this, index);
    }

    private CloneCopyPolicy buildCloneCopyPolicy() {
        return new CloneCopyPolicy(this);
    }

    private Converter buildConverter(int index) {
        return new Converter(this, index);
    }

    private CopyPolicy buildCopyPolicy() {
        return new CopyPolicy(this);
    }

    private ElementCollectionMapping buildElementCollectionMapping(int index) {
        return new ElementCollectionMapping(this, index);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(DESCRIPTION);
        names.add("access-methods");
        names.add(CUSTOMIZER);
        names.add(CHANGE_TRACKING);
        names.add("no-sql");
        names.add("converter");
        names.add("type-converter");
        names.add("object-type-converter");
        names.add("struct-converter");
        names.add("property");
        names.add("copy-policy");
        names.add("instantiation-copy-policy");
        names.add("clone-copy-policy");
        names.add("attributes");
        return names;
    }

    private EmbeddedMapping buildEmbeddedMapping(int index) {
        return new EmbeddedMapping(this, index);
    }

    private InstantiationCopyPolicy buildInstantiationCopyPolicy() {
        return new InstantiationCopyPolicy(this);
    }

    private ManyToManyMapping buildManyToManyMapping(int index) {
        return new ManyToManyMapping(this, index);
    }

    private ManyToOneMapping buildManyToOneMapping(int index) {
        return new ManyToOneMapping(this, index);
    }

    Mapping buildMapping(String elementName, int index) {
        if (ObjectTools.equals((Object)elementName, (Object)"basic")) {
            return this.buildBasicMapping(index);
        }
        if (ObjectTools.equals((Object)elementName, (Object)"basic-collection")) {
            return this.buildBasicCollectionMapping(index);
        }
        if (ObjectTools.equals((Object)elementName, (Object)"basic-map")) {
            return this.buildBasicMapMapping(index);
        }
        if (ObjectTools.equals((Object)elementName, (Object)"embedded")) {
            return this.buildEmbeddedMapping(index);
        }
        if (ObjectTools.equals((Object)elementName, (Object)ElementCollectionMapping.ELEMENT_COLLECTION)) {
            return this.buildElementCollectionMapping(index);
        }
        if (ObjectTools.equals((Object)elementName, (Object)"many-to-many")) {
            return this.buildManyToManyMapping(index);
        }
        if (ObjectTools.equals((Object)elementName, (Object)"many-to-one")) {
            return this.buildManyToOneMapping(index);
        }
        if (ObjectTools.equals((Object)elementName, (Object)"one-to-many")) {
            return this.buildOneToManyMapping(index);
        }
        if (ObjectTools.equals((Object)elementName, (Object)"one-to-one")) {
            return this.buildOneToOneMapping(index);
        }
        if (ObjectTools.equals((Object)elementName, (Object)"transient")) {
            return this.buildTransientMapping(index);
        }
        return null;
    }

    Collection<String> buildMappingNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("basic");
        names.add("basic-collection");
        names.add("basic-map");
        names.add("embedded");
        names.add(ElementCollectionMapping.ELEMENT_COLLECTION);
        names.add("many-to-many");
        names.add("many-to-one");
        names.add("one-to-many");
        names.add("one-to-one");
        names.add("transient");
        return names;
    }

    private ObjectTypeConverter buildObjectTypeConverter(int index) {
        return new ObjectTypeConverter(this, index);
    }

    private OneToManyMapping buildOneToManyMapping(int index) {
        return new OneToManyMapping(this, index);
    }

    private OneToOneMapping buildOneToOneMapping(int index) {
        return new OneToOneMapping(this, index);
    }

    private Property buildProperty(int index) {
        return new Property(this, index);
    }

    private StructConverter buildStructConverter(int index) {
        return new StructConverter(this, index);
    }

    private TransientMapping buildTransientMapping(int index) {
        return new TransientMapping(this, index);
    }

    private TypeConverter buildTypeConverter(int index) {
        return new TypeConverter(this, index);
    }

    @Override
    public final ListIterable<ExternalConverter> converters() {
        int count = this.convertersSize();
        ArrayList<Converter> converters = new ArrayList<Converter>(count);
        int index = count;
        while (--index >= 0) {
            Converter converter = this.buildConverter(index);
            converters.add(0, converter);
        }
        return new ListListIterable(converters);
    }

    @Override
    public final int convertersSize() {
        return this.getChildrenSize("converter");
    }

    @Override
    public final ExternalAccessMethods getAccessMethods() {
        Element element = this.getChild("access-methods");
        if (element == null) {
            return null;
        }
        return this.buildAccessMethods();
    }

    @Override
    public final String getAccessType() {
        return this.getAttribute(ACCESS);
    }

    @Override
    public final ChangeTrackingType getChangeTrackingType() {
        Element element = this.getChild(CHANGE_TRACKING);
        if (element == null) {
            return null;
        }
        return this.getEnumAttribute(element, TYPE, ChangeTrackingType.class);
    }

    @Override
    public final String getClassName() {
        return this.getAttribute(CLASS);
    }

    @Override
    public final ExternalCloneCopyPolicy getCloneCopyPolicy() {
        Element element = this.getChild("clone-copy-policy");
        if (element == null) {
            return null;
        }
        return this.buildCloneCopyPolicy();
    }

    @Override
    public final ExternalConverter getConverter(int index) {
        Element element = this.getChild("converter", index);
        if (element == null) {
            return null;
        }
        return this.buildConverter(index);
    }

    @Override
    public final ExternalCopyPolicy getCopyPolicy() {
        Element element = this.getChild("copy-policy");
        if (element == null) {
            return null;
        }
        return this.buildCopyPolicy();
    }

    @Override
    public final String getCustomizerClassName() {
        return this.getChildAttribute(CUSTOMIZER, CLASS);
    }

    @Override
    public final String getDescription() {
        return this.getChildTextNode(DESCRIPTION);
    }

    @Override
    public final Element getElement() {
        return this.getChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    protected String getElementName() {
        return EMBEDDABLE;
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public final ExternalInstantiationCopyPolicy getInstantiationCopyPolicy() {
        Element element = this.getChild("instantiation-copy-policy");
        if (element == null) {
            return null;
        }
        return this.buildInstantiationCopyPolicy();
    }

    public final List<ExternalMapping> getMappings() {
        return ListTools.list(this.mappings());
    }

    @Override
    public final Mapping getMapping(String name) {
        for (ExternalMapping mapping : this.mappings()) {
            if (!ObjectTools.equals((Object)name, (Object)mapping.getName())) continue;
            return (Mapping)mapping;
        }
        return null;
    }

    @Override
    public final ExternalNoSql getNoSql() {
        if (this.hasChild("no-sql")) {
            return new NoSql(this);
        }
        return null;
    }

    @Override
    public final ExternalObjectTypeConverter getObjectTypeConverter(int index) {
        Element element = this.getChild("object-type-converter", index);
        if (element == null) {
            return null;
        }
        return this.buildObjectTypeConverter(index);
    }

    @Override
    protected final ORMConfiguration getParent() {
        return (ORMConfiguration)super.getParent();
    }

    @Override
    public final ExternalProperty getProperty(int index) {
        Element element = this.getChild("property", index);
        if (element == null) {
            return null;
        }
        return this.buildProperty(index);
    }

    @Override
    public final ExternalStructConverter getStructConverter(int index) {
        Element element = this.getChild("struct-converter", index);
        if (element == null) {
            return null;
        }
        return this.buildStructConverter(index);
    }

    @Override
    public final ExternalTypeConverter getTypeConverter(int index) {
        Element element = this.getChild("type-converter", index);
        if (element == null) {
            return null;
        }
        return this.buildTypeConverter(index);
    }

    @Override
    public final ListIterable<ExternalIDMapping> idMappings() {
        ArrayList<ExternalIDMapping> idMappings = new ArrayList<ExternalIDMapping>();
        for (ExternalMapping mapping : this.mappings()) {
            if (!(mapping instanceof ExternalIDMapping)) continue;
            idMappings.add((ExternalIDMapping)mapping);
        }
        return new ListListIterable(idMappings);
    }

    @Override
    public final Boolean isExcludeDefaultMappings() {
        return this.getBooleanAttribute(EXCLUDE_DEFAULT_MAPPINGS);
    }

    @Override
    public final Boolean isMetadataComplete() {
        return this.getBooleanAttribute(METADATA_COMPLETE);
    }

    @Override
    public final ListIterable<ExternalMapping> mappings() {
        Element element = this.getChild("attributes");
        if (element != null) {
            return this.mappings(element);
        }
        return EmptyListIterable.instance();
    }

    private ListIterable<ExternalMapping> mappings(Element element) {
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        int index = 0;
        for (Element childElement : this.getChildren(element)) {
            String elementName = this.getNodeName(childElement);
            Mapping mapping = this.buildMapping(elementName, index++);
            if (mapping == null) continue;
            mappings.add(mapping);
        }
        return new ListListIterable(mappings);
    }

    @Override
    public final int mappingsSize() {
        Element attributes = this.getChild("attributes");
        if (attributes != null) {
            return this.getChildrenSize((Node)attributes, this.buildMappingNames());
        }
        return 0;
    }

    @Override
    public final ListIterable<ExternalObjectTypeConverter> objectTypeConverters() {
        int count = this.objectTypeConvertersSize();
        ArrayList<ObjectTypeConverter> converters = new ArrayList<ObjectTypeConverter>(count);
        int index = count;
        while (--index >= 0) {
            ObjectTypeConverter converter = this.buildObjectTypeConverter(index);
            converters.add(0, converter);
        }
        return new ListListIterable(converters);
    }

    @Override
    public final int objectTypeConvertersSize() {
        return this.getChildrenSize("object-type-converter");
    }

    @Override
    public final ListIterable<ExternalProperty> properties() {
        int count = this.propertiesSize();
        ArrayList<Property> converters = new ArrayList<Property>(count);
        int index = count;
        while (--index >= 0) {
            Property converter = this.buildProperty(index);
            converters.add(0, converter);
        }
        return new ListListIterable(converters);
    }

    @Override
    public final int propertiesSize() {
        return this.getChildrenSize("property");
    }

    @Override
    public final void removeAccessMethods() {
        this.removeChild("access-methods");
    }

    @Override
    public final void removeCloneCopyPolicy() {
        CloneCopyPolicy policy = this.buildCloneCopyPolicy();
        policy.removeSelf();
    }

    @Override
    public final void removeConverter(int index) {
        Converter converter = this.buildConverter(index);
        converter.removeSelf();
    }

    @Override
    public final void removeCopyPolicy() {
        CopyPolicy policy = this.buildCopyPolicy();
        policy.removeSelf();
    }

    @Override
    public final void removeInstantiationCopyPolicy() {
        InstantiationCopyPolicy policy = this.buildInstantiationCopyPolicy();
        policy.removeSelf();
    }

    @Override
    public final void removeMapping(String name) {
        Mapping mapping = this.getMapping(name);
        if (mapping != null) {
            mapping.removeSelf();
        }
    }

    @Override
    public final void removeNoSql() {
        NoSql noSql = new NoSql(this);
        noSql.removeSelf();
    }

    @Override
    public final void removeObjectTypeConverter(int index) {
        ObjectTypeConverter converter = this.buildObjectTypeConverter(index);
        converter.removeSelf();
    }

    @Override
    public final void removeProperty(int index) {
        Property converter = this.buildProperty(index);
        converter.removeSelf();
    }

    @Override
    public final void removeSelf() {
        this.removeChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    public final void removeStructConverter(int index) {
        StructConverter converter = this.buildStructConverter(index);
        converter.removeSelf();
    }

    @Override
    public final void removeTypeConverter(int index) {
        TypeConverter converter = this.buildTypeConverter(index);
        converter.removeSelf();
    }

    @Override
    public final void setAccessType(String type) {
        this.setAttribute(ACCESS, type);
    }

    @Override
    public final void setChangeTrackingType(ChangeTrackingType type) {
        Element element = this.getChild(CHANGE_TRACKING);
        if (element == null && type == null) {
            return;
        }
        if (element == null && type != null) {
            element = this.addChild(CHANGE_TRACKING);
        }
        if (type != null) {
            this.setAttribute(element, TYPE, (Enum<?>)type);
        } else if (element != null) {
            this.removeChild(CHANGE_TRACKING);
        }
    }

    @Override
    public final void setClassName(String className) {
        this.setAttribute(CLASS, className);
    }

    @Override
    public final void setCustomizerClassName(String name) {
        Element element = this.getChild(CUSTOMIZER);
        if (element == null && name != null) {
            element = this.addChild(CUSTOMIZER);
        }
        if (name != null) {
            this.setAttribute(element, CLASS, name);
        } else if (element != null) {
            this.removeChild(CUSTOMIZER);
        }
    }

    @Override
    public final void setDescription(String description) {
        this.updateChildTextNode(DESCRIPTION, description);
    }

    @Override
    public final void setExcludeDefaultMappings(Boolean excludeDefaultMappings) {
        this.setAttribute(EXCLUDE_DEFAULT_MAPPINGS, excludeDefaultMappings);
    }

    @Override
    public final void setMetadataComplete(Boolean metaDataComplete) {
        this.setAttribute(METADATA_COMPLETE, metaDataComplete);
    }

    @Override
    public final ListIterable<ExternalStructConverter> structConverters() {
        int count = this.structConvertersSize();
        ArrayList<StructConverter> converters = new ArrayList<StructConverter>(count);
        int index = count;
        while (--index >= 0) {
            StructConverter converter = this.buildStructConverter(index);
            converters.add(0, converter);
        }
        return new ListListIterable(converters);
    }

    @Override
    public final int structConvertersSize() {
        return this.getChildrenSize("struct-converter");
    }

    @Override
    public final ListIterable<ExternalTypeConverter> typeConverters() {
        int count = this.typeConvertersSize();
        ArrayList<TypeConverter> converters = new ArrayList<TypeConverter>(count);
        int index = count;
        while (--index >= 0) {
            TypeConverter converter = this.buildTypeConverter(index);
            converters.add(0, converter);
        }
        return new ListListIterable(converters);
    }

    @Override
    public final int typeConvertersSize() {
        return this.getChildrenSize("type-converter");
    }
}

