/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalManyToManyMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalNoSqlJoinField;
import org.eclipse.persistence.tools.mapping.orm.dom.EmbeddableEntity;
import org.eclipse.persistence.tools.mapping.orm.dom.NoSqlJoinField;
import org.eclipse.persistence.tools.mapping.orm.dom.ObjectCollectionMapping;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;

final class ManyToManyMapping
extends ObjectCollectionMapping
implements ExternalManyToManyMapping {
    static final String MANY_TO_MANY = "many-to-many";

    ManyToManyMapping(EmbeddableEntity parent, int index) {
        super(parent, index);
    }

    @Override
    public void addJoinField(int index, String name) {
        ExternalNoSqlJoinField joinField = this.buildJoinField(index);
        joinField.setName(name);
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("target-entity");
        names.add("fetch");
        names.add("access");
        names.add("mapped-by");
        return names;
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("order-by");
        names.add("order-column");
        names.add("map-key");
        names.add("map-key-class");
        names.add("map-key-temporal");
        names.add("map-key-enumerated");
        names.add("map-key-convert");
        names.add("map-key-attribute-override");
        names.add("map-key-association-override");
        names.add("map-key-column");
        names.add("map-key-join-column");
        names.add("join-table");
        names.add("cascade");
        names.add("join-fetch");
        names.add("batch-fetch");
        names.add("property");
        names.add("access-methods");
        return names;
    }

    private ExternalNoSqlJoinField buildJoinField(int index) {
        return new NoSqlJoinField(this, index);
    }

    @Override
    protected String getElementName() {
        return MANY_TO_MANY;
    }

    @Override
    public String getMappedByMappingName() {
        return this.getAttribute("mapped-by");
    }

    @Override
    public ListIterable<ExternalNoSqlJoinField> joinFields() {
        int count = this.joinFieldSize();
        ArrayList<ExternalNoSqlJoinField> joinFields = new ArrayList<ExternalNoSqlJoinField>(count);
        int index = count;
        while (--index >= 0) {
            ExternalNoSqlJoinField joinField = this.buildJoinField(index);
            joinFields.add(0, joinField);
        }
        return new ListListIterable(joinFields);
    }

    @Override
    public int joinFieldSize() {
        return this.getChildrenSize("join-field");
    }

    @Override
    public void removeJoinField(int index) {
        this.removeChild("join-field", index);
    }

    @Override
    public void setMappedByMappingName(String name) {
        this.setAttribute("mapped-by", name);
    }
}

