/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.dom.EmbeddableEntity;
import org.eclipse.persistence.tools.utility.ClassNameTools;
import org.eclipse.persistence.tools.utility.StringTools;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

abstract class Mapping
extends AbstractExternalForm
implements ExternalMapping {
    private int index;
    static final String ATTRIBUTE_TYPE = "attribute-type";
    static final String ATTRIBUTES = "attributes";
    static final String NAME = "name";

    Mapping(EmbeddableEntity parent, int index) {
        super(parent);
        this.index = index;
    }

    @Override
    protected final Element addSelf(String elementName, List<String> elementNamesOrder) {
        Element element = this.getChild(this.getParent(), ATTRIBUTES);
        if (element == null) {
            element = this.addChild((AbstractExternalForm)this.getParent(), ATTRIBUTES, elementNamesOrder);
        }
        return this.addChild(element, elementName, this.index);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("id");
        names.add("embedded-id");
        names.add("basic");
        names.add("version");
        names.add("many-to-one");
        names.add("one-to-many");
        names.add("one-to-one");
        names.add("many-to-many");
        names.add("embedded");
        names.add("transient");
        return names;
    }

    @Override
    public final String getAttributeType() {
        return this.getAttribute(ATTRIBUTE_TYPE);
    }

    @Override
    public final String getAttributeTypeShortName() {
        return ClassNameTools.simpleName((String)this.getAttributeType());
    }

    @Override
    public final Element getElement() {
        Element element = this.getChild(this.getParent(), ATTRIBUTES);
        if (element == null) {
            return null;
        }
        return this.getChild((Node)element, this.index);
    }

    @Override
    public final String getGetMethodName() {
        return this.javabeanAccessorName("get", this.getName(), "");
    }

    final int getIndex() {
        return this.index;
    }

    @Override
    public final String getName() {
        return this.getAttribute(NAME);
    }

    @Override
    protected EmbeddableEntity getParent() {
        return (EmbeddableEntity)super.getParent();
    }

    @Override
    public final String getSetMethodName() {
        return this.javabeanAccessorName("set", this.getName(), "");
    }

    @Override
    public boolean isBasicMapping() {
        return false;
    }

    @Override
    public boolean isElementCollectionMapping() {
        return false;
    }

    @Override
    public boolean isEmbeddedMapping() {
        return false;
    }

    @Override
    public boolean isIdMapping() {
        return false;
    }

    private String javabeanAccessorName(String prefix, String propertyName, String suffix) {
        StringBuilder sb = new StringBuilder(propertyName.length() + 10);
        sb.append(prefix);
        if (propertyName.length() >= 2 && Character.isUpperCase(propertyName.charAt(1))) {
            sb.append(propertyName);
        } else {
            sb.append(StringTools.capitalize((String)propertyName));
        }
        sb.append(suffix);
        return sb.toString();
    }

    @Override
    public final void removeSelf() {
        Element element = this.getChild(this.getParent(), ATTRIBUTES);
        if (element != null) {
            this.removeChild(element, this.index);
            if (!this.hasAnyChildren(element)) {
                this.remove(this.getParent().getElement(), element);
            }
        }
    }

    @Override
    public void setAttributeType(String attributeType) {
        this.setAttribute(ATTRIBUTE_TYPE, attributeType);
    }

    @Override
    public final void setName(String name) {
        this.setAttribute(NAME, name);
    }
}

