/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalNoSqlJoinField;
import org.eclipse.persistence.tools.mapping.orm.ExternalOneToManyMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.EmbeddableEntity;
import org.eclipse.persistence.tools.mapping.orm.dom.JoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.NoSqlJoinField;
import org.eclipse.persistence.tools.mapping.orm.dom.ObjectCollectionMapping;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Element;

final class OneToManyMapping
extends ObjectCollectionMapping
implements ExternalOneToManyMapping {
    static final String MAPS_ID = "maps-id";
    static final String ONE_TO_MANY = "one-to-many";
    static final String ORPHAN_REMOVAL = "orphan-removal";
    static final String PRIVATE_OWNED = "private-owned";

    OneToManyMapping(EmbeddableEntity parent, int index) {
        super(parent, index);
    }

    @Override
    public void addJoinColumn(int index, String name) {
        JoinColumn joinColumn = this.buildJoinColumn("join-column", index);
        joinColumn.addSelf();
        joinColumn.setName(name);
    }

    @Override
    public void addJoinField(int index, String name) {
        ExternalNoSqlJoinField joinField = this.buildJoinField(index);
        joinField.setName(name);
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("target-entity");
        names.add("fetch");
        names.add("access");
        names.add("mapped-by");
        names.add(MAPS_ID);
        names.add(ORPHAN_REMOVAL);
        return names;
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("order-by");
        names.add("order-column");
        names.add("map-key");
        names.add("map-key-class");
        names.add("map-key-temporal");
        names.add("map-key-enumerated");
        names.add("map-key-convert");
        names.add("map-key-attribute-override");
        names.add("map-key-association-override");
        names.add("map-key-column");
        names.add("map-key-join-column");
        names.add("join-table");
        names.add("join-column");
        names.add("cascade");
        names.add(PRIVATE_OWNED);
        names.add("join-fetch");
        names.add("batch-fetch");
        names.add("property");
        names.add("access-methods");
        return names;
    }

    private ExternalNoSqlJoinField buildJoinField(int index) {
        return new NoSqlJoinField(this, index);
    }

    @Override
    protected String getElementName() {
        return ONE_TO_MANY;
    }

    @Override
    public Boolean getId() {
        return null;
    }

    @Override
    public ExternalJoinColumn getJoinColumn(int index) {
        Element element = this.getChild("join-column", index);
        if (element == null) {
            return null;
        }
        return this.buildJoinColumn("join-column", index);
    }

    @Override
    public String getMappedByMappingName() {
        return this.getAttribute("mapped-by");
    }

    @Override
    public String getMapsId() {
        return this.getAttribute(MAPS_ID);
    }

    @Override
    public Boolean isOrphanRemoval() {
        return this.getBooleanAttribute(ORPHAN_REMOVAL);
    }

    @Override
    public Boolean isPrivateOwned() {
        return this.hasChild(PRIVATE_OWNED);
    }

    @Override
    public ListIterable<ExternalJoinColumn> joinColumns() {
        int count = this.joinColumnsSize();
        ArrayList<JoinColumn> joinColumns = new ArrayList<JoinColumn>(count);
        int index = count;
        while (--index >= 0) {
            JoinColumn joinColumn = this.buildJoinColumn("join-column", index);
            joinColumns.add(0, joinColumn);
        }
        return new ListListIterable(joinColumns);
    }

    @Override
    public int joinColumnsSize() {
        return this.getChildrenSize("join-column");
    }

    @Override
    public ListIterable<ExternalNoSqlJoinField> joinFields() {
        int count = this.joinFieldSize();
        ArrayList<ExternalNoSqlJoinField> joinFields = new ArrayList<ExternalNoSqlJoinField>(count);
        int index = count;
        while (--index >= 0) {
            ExternalNoSqlJoinField joinField = this.buildJoinField(index);
            joinFields.add(0, joinField);
        }
        return new ListListIterable(joinFields);
    }

    @Override
    public int joinFieldSize() {
        return this.getChildrenSize("join-field");
    }

    @Override
    public void removeJoinColumn(int index) {
        JoinColumn joinColumn = this.buildJoinColumn("join-column", index);
        joinColumn.removeSelf();
    }

    @Override
    public void removeJoinField(int index) {
        this.removeChild("join-field", index);
    }

    @Override
    public void setId(Boolean id) {
    }

    @Override
    public void setMappedByMappingName(String name) {
        this.setAttribute("mapped-by", name);
    }

    @Override
    public void setMapsId(String mapsId) {
        this.setAttribute(MAPS_ID, mapsId);
    }

    @Override
    public void setOrphanRemoval(Boolean removeOrphans) {
        this.setAttribute(ORPHAN_REMOVAL, removeOrphans);
    }

    @Override
    public void setPrivateOwned(Boolean privateOwned) {
        if (privateOwned == Boolean.TRUE) {
            this.addChild(PRIVATE_OWNED);
        } else {
            this.removeChild(PRIVATE_OWNED);
        }
    }
}

