/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.gen.nosql.mongo;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import java.io.File;
import java.io.FileOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.persistence.AccessType;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.eclipse.persistence.tools.gen.nosql.mongo.meta.CollectionDescriptor;
import org.eclipse.persistence.tools.gen.nosql.mongo.meta.ColumnDescriptor;
import org.eclipse.persistence.tools.gen.nosql.mongo.meta.LeafColumnDescriptor;
import org.eclipse.persistence.tools.gen.nosql.mongo.meta.NestedColumnDescriptor;
import org.eclipse.persistence.tools.mapping.orm.DataFormatType;
import org.eclipse.persistence.tools.mapping.orm.ExternalElementCollectionMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalEmbeddableEntity;
import org.eclipse.persistence.tools.mapping.orm.ExternalEmbeddedMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntity;
import org.eclipse.persistence.tools.mapping.orm.ExternalNamedQuery;
import org.eclipse.persistence.tools.mapping.orm.ExternalNoSql;
import org.eclipse.persistence.tools.mapping.orm.ExternalORMConfiguration;
import org.eclipse.persistence.tools.mapping.orm.ORMDocumentType;
import org.eclipse.persistence.tools.mapping.orm.dom.ORMRepository;
import org.eclipse.persistence.tools.utility.NameTools;
import org.eclipse.persistence.tools.utility.StringTools;
import org.eclipse.persistence.tools.utility.collection.ListTools;

public class MongoEntityGenerator {
    private Mongo connection;
    private DB database;
    private int rowSampleSize;

    public MongoEntityGenerator(String host, int port, String dbName, int rowSampleSize) throws MongoException, UnknownHostException {
        this.rowSampleSize = rowSampleSize;
        this.connection = new Mongo(new ServerAddress(host, port));
        this.database = this.connection.getDB(dbName);
    }

    private List<CollectionDescriptor> buildCollectionDescriptors(Collection<String> collectionNames) {
        LinkedList<CollectionDescriptor> collectionDescriptors = new LinkedList<CollectionDescriptor>();
        for (String collectionName : collectionNames) {
            CollectionDescriptor collectionDescriptor = new CollectionDescriptor(collectionName);
            collectionDescriptors.add(collectionDescriptor);
            this.updateColumnDescriptors(collectionDescriptor);
        }
        return collectionDescriptors;
    }

    private void updateColumnDescriptors(CollectionDescriptor collectionDescriptor) {
        DBCollection collection = this.database.getCollection(collectionDescriptor.getName());
        DBCursor cursor = collection.find().limit(this.rowSampleSize);
        while (cursor.hasNext()) {
            DBObject row = cursor.next();
            this.updateCollectionDescriptor(collectionDescriptor, row);
        }
    }

    public void generateSource(Collection<String> collectionNames, String packageName, File baseDirectory, AccessType type, String characterEncoding) throws Exception {
        List<CollectionDescriptor> collectionDescriptors = this.buildCollectionDescriptors(collectionNames);
        ExternalORMConfiguration config = this.generate(collectionDescriptors);
        File packageDirectory = new File(baseDirectory, String.valueOf(packageName.replace('.', '/')) + "/");
        packageDirectory.mkdirs();
        Properties vep = new Properties();
        vep.setProperty("resource.loader", "class");
        vep.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        VelocityEngine ve = new VelocityEngine();
        ve.init(vep);
        for (ExternalEntity entity : config.entities()) {
            this.generateSource((ExternalEmbeddableEntity)entity, type, "entity.java.vm", packageName, packageDirectory, ve, characterEncoding);
        }
        for (ExternalEntity entity : config.embeddableEntities()) {
            this.generateSource((ExternalEmbeddableEntity)entity, type, "embeddable.java.vm", packageName, packageDirectory, ve, characterEncoding);
        }
    }

    private void generateSource(ExternalEmbeddableEntity entity, AccessType accessType, String templateName, String packageName, File packageDirectory, VelocityEngine ve, String characterEncoding) throws Exception {
        VelocityContext context = new VelocityContext();
        context.put("entity", (Object)entity);
        context.put("mappings", (Object)ListTools.list((Iterable)entity.mappings()));
        context.put("packageName", (Object)packageName);
        context.put("accessType", (Object)accessType);
        StringWriter w = new StringWriter();
        ve.mergeTemplate(templateName, (Context)context, (Writer)w);
        String fileContent = w.toString();
        File javaFile = new File(packageDirectory, String.valueOf(entity.getClassName()) + ".java");
        byte[] content = fileContent.getBytes(characterEncoding);
        javaFile.createNewFile();
        FileOutputStream writer = new FileOutputStream(javaFile);
        writer.write(content);
        writer.flush();
        writer.close();
    }

    private void generateLeafMapping(ExternalEmbeddableEntity exEntity, LeafColumnDescriptor column, String columnName, String javaColumnName) {
        Object mapping;
        if (column.isList()) {
            mapping = exEntity.addElementCollectionMapping(columnName);
            mapping.setTargetClassName(column.getColumnType().getName());
            mapping.setAttributeType(Vector.class.getName());
        } else {
            mapping = columnName.equals("_id") ? exEntity.addIdMapping(javaColumnName) : exEntity.addBasicMapping(javaColumnName);
            mapping.setAttributeType(column.getColumnType().getName());
        }
        mapping.setNoSqlField(columnName);
    }

    private void generateMappings(ExternalEmbeddableEntity exEntity, CollectionDescriptor collection, ExternalORMConfiguration config, Set<String> allEntityNames) {
        for (ColumnDescriptor columnDescriptor : collection.columns()) {
            String columnName = columnDescriptor.getColumnName();
            String javaColumnName = NameToolsTemp.javaNameFromDatabaseName(columnName);
            if (columnDescriptor instanceof LeafColumnDescriptor) {
                this.generateLeafMapping(exEntity, (LeafColumnDescriptor)columnDescriptor, columnName, javaColumnName);
                continue;
            }
            if (!(columnDescriptor instanceof NestedColumnDescriptor)) continue;
            this.generateNestedMapping(exEntity, config, allEntityNames, (NestedColumnDescriptor)columnDescriptor, columnName, javaColumnName);
        }
    }

    private void generateNestedMapping(ExternalEmbeddableEntity exEntity, ExternalORMConfiguration config, Set<String> allEntityNames, NestedColumnDescriptor column, String columnName, String javaColumnName) {
        String embeddableName = NameToolsTemp.javaNameFromDatabaseName(columnName, true);
        embeddableName = NameTools.uniqueName((String)embeddableName, allEntityNames);
        allEntityNames.add(embeddableName);
        ExternalEmbeddableEntity embeddable = config.addEmbeddableEntity(embeddableName);
        embeddable.addNoSql().setDataFormat(DataFormatType.MAPPED);
        embeddable.setAccessType("VIRTUAL");
        this.generateMappings(embeddable, column.getColumnDescriptor(), config, allEntityNames);
        if (column.isList()) {
            ExternalElementCollectionMapping mapping = exEntity.addElementCollectionMapping(javaColumnName);
            mapping.setNoSqlField(columnName);
            mapping.setAttributeType(Vector.class.getName());
            mapping.setTargetClassName(embeddableName);
        } else {
            ExternalEmbeddedMapping mapping = exEntity.addEmbeddedMapping(javaColumnName);
            mapping.setNoSqlField(columnName);
            mapping.setAttributeType(embeddableName);
        }
    }

    private void generateQueries(ExternalORMConfiguration config) {
        for (ExternalEntity entity : config.entities()) {
            String entityName = entity.getClassName();
            ExternalNamedQuery query = config.addNamedQuery(String.valueOf(entityName) + ".findAll");
            char identifier = Character.toLowerCase(entityName.charAt(0));
            query.setQuery("select " + identifier + " from " + entityName + " " + identifier);
        }
    }

    private ExternalORMConfiguration generate(List<CollectionDescriptor> collectionDescriptors) {
        ExternalORMConfiguration config = new ORMRepository().buildORMConfiguration(ORMDocumentType.ECLIPELINK_2_4);
        HashSet<String> allEntityNames = new HashSet<String>();
        for (CollectionDescriptor collection : collectionDescriptors) {
            String collectionName = collection.getName();
            String entityName = NameToolsTemp.javaNameFromDatabaseName(collectionName, true);
            entityName = NameTools.uniqueName((String)entityName, allEntityNames);
            allEntityNames.add(entityName);
            ExternalEntity exEntity = config.addEntity(entityName);
            exEntity.setAccessType("VIRTUAL");
            ExternalNoSql noSqlDesc = exEntity.addNoSql();
            noSqlDesc.setDataFormat(DataFormatType.MAPPED);
            noSqlDesc.setDataType(collectionName);
            this.generateMappings((ExternalEmbeddableEntity)exEntity, collection, config, allEntityNames);
        }
        this.generateQueries(config);
        return config;
    }

    public String generateXML(Collection<String> collectionNames) {
        List<CollectionDescriptor> collectionDescriptors = this.buildCollectionDescriptors(collectionNames);
        return this.generate(collectionDescriptors).getXML();
    }

    private void handleLeafColumn(CollectionDescriptor collectionDescriptor, String columnName, Object value) {
        Class<Object> valueClass;
        LeafColumnDescriptor columnDescriptor = (LeafColumnDescriptor)collectionDescriptor.getColumn(columnName);
        if (columnDescriptor == null) {
            columnDescriptor = collectionDescriptor.addLeafColumn(columnName);
        }
        Class clazz = valueClass = (valueClass = value.getClass()).getName().equals("org.bson.types.ObjectId") ? String.class : valueClass;
        if (columnDescriptor.getColumnType() == null) {
            columnDescriptor.setColumnType(valueClass);
        } else if (columnDescriptor.getColumnType() != valueClass) {
            columnDescriptor.setColumnType(Object.class);
        }
    }

    private void handleListColumn(CollectionDescriptor collectionDescriptor, String columnName, Object value) {
        block4: {
            ColumnDescriptor columnDescriptor = collectionDescriptor.getColumn(columnName);
            BasicDBList listValue = (BasicDBList)value;
            if (listValue.size() <= 0) break block4;
            ListIterator listValues = listValue.listIterator();
            Object valueFromList = listValues.next();
            if (valueFromList instanceof BasicDBObject) {
                NestedColumnDescriptor nestedColumnDesc = columnDescriptor == null ? collectionDescriptor.addNestedColumn(columnName) : (NestedColumnDescriptor)columnDescriptor;
                nestedColumnDesc.setList(true);
                this.updateCollectionDescriptor(nestedColumnDesc.getColumnDescriptor(), (DBObject)valueFromList);
                while (listValues.hasNext()) {
                    valueFromList = listValues.next();
                    this.updateCollectionDescriptor(nestedColumnDesc.getColumnDescriptor(), (DBObject)valueFromList);
                }
            } else {
                LeafColumnDescriptor leafColumnDescriptor = columnDescriptor == null ? collectionDescriptor.addLeafColumn(columnName) : (LeafColumnDescriptor)columnDescriptor;
                leafColumnDescriptor.setList(true);
                leafColumnDescriptor.setColumnType(valueFromList.getClass());
                while (listValues.hasNext()) {
                    valueFromList = listValues.next();
                    if (leafColumnDescriptor.getColumnType() == valueFromList.getClass()) continue;
                    leafColumnDescriptor.setColumnType(Object.class);
                    break;
                }
            }
        }
    }

    private void handleNestedColumn(CollectionDescriptor collectionDescriptor, String columnName, Object value) {
        NestedColumnDescriptor columnDescriptor = (NestedColumnDescriptor)collectionDescriptor.getColumn(columnName);
        if (columnDescriptor == null) {
            columnDescriptor = collectionDescriptor.addNestedColumn(columnName);
        }
        this.updateCollectionDescriptor(columnDescriptor.getColumnDescriptor(), (DBObject)value);
    }

    public Set<String> listCollectionNames() {
        Set collectionNames = this.database.getCollectionNames();
        collectionNames.remove("system.indexes");
        return collectionNames;
    }

    private void updateCollectionDescriptor(CollectionDescriptor collectionDescriptor, DBObject dbObject) {
        for (String columnName : dbObject.keySet()) {
            Object value = dbObject.get(columnName);
            if (value == null) continue;
            if (value instanceof BasicDBList) {
                this.handleListColumn(collectionDescriptor, columnName, value);
                continue;
            }
            if (value instanceof BasicDBObject) {
                this.handleNestedColumn(collectionDescriptor, columnName, value);
                continue;
            }
            this.handleLeafColumn(collectionDescriptor, columnName, value);
        }
    }

    private static class NameToolsTemp {
        private static final Pattern DB_IDENTIFIER_EXCLUSIONS = Pattern.compile("[@$# .]");

        private NameToolsTemp() {
        }

        public static String javaNameFromDatabaseName(String databaseName) {
            return NameToolsTemp.javaNameFromDatabaseName(databaseName, false);
        }

        public static String javaNameFromDatabaseName(String databaseName, boolean capitalizeFirstLetter) {
            return StringTools.convertAllCapsToCamelCase((String)NameTools.convertToJavaIdentifier((String)DB_IDENTIFIER_EXCLUSIONS.matcher(databaseName).replaceAll("_")), (boolean)capitalizeFirstLetter);
        }
    }
}

