/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests;

import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.CompositeExceptionHandler;
import org.eclipse.persistence.tools.utility.ExceptionHandler;
import org.eclipse.persistence.tools.utility.ExceptionHandlerAdapter;
import org.eclipse.persistence.tools.utility.iterable.IterableTools;

public class CompositeExceptionHandlerTests
extends TestCase {
    public CompositeExceptionHandlerTests(String name) {
        super(name);
    }

    public void testHandleException() {
        TestExceptionHandler handler1 = new TestExceptionHandler();
        TestExceptionHandler handler2 = new TestExceptionHandler();
        CompositeExceptionHandler exceptionHandler = new CompositeExceptionHandler(new ExceptionHandler[]{handler1, handler2});
        NullPointerException npe = new NullPointerException();
        exceptionHandler.handleException((Throwable)npe);
        CompositeExceptionHandlerTests.assertEquals((Object)npe, (Object)handler1.throwable);
        CompositeExceptionHandlerTests.assertEquals((Object)npe, (Object)handler2.throwable);
    }

    public void testGetExceptionHandlers() {
        TestExceptionHandler handler1 = new TestExceptionHandler();
        TestExceptionHandler handler2 = new TestExceptionHandler();
        CompositeExceptionHandler exceptionHandler = new CompositeExceptionHandler(new ExceptionHandler[]{handler1, handler2});
        Iterable handlers = exceptionHandler.getExceptionHandlers();
        CompositeExceptionHandlerTests.assertTrue((boolean)IterableTools.contains((Iterable)handlers, (Object)((Object)handler1)));
        CompositeExceptionHandlerTests.assertTrue((boolean)IterableTools.contains((Iterable)handlers, (Object)((Object)handler2)));
    }

    public void testAddExceptionHandler() {
        TestExceptionHandler handler1 = new TestExceptionHandler();
        CompositeExceptionHandler exceptionHandler = new CompositeExceptionHandler(new ExceptionHandler[]{handler1});
        TestExceptionHandler handler2 = new TestExceptionHandler();
        exceptionHandler.addExceptionHandler((ExceptionHandler)handler2);
        NullPointerException npe = new NullPointerException();
        exceptionHandler.handleException((Throwable)npe);
        Iterable handlers = exceptionHandler.getExceptionHandlers();
        CompositeExceptionHandlerTests.assertTrue((boolean)IterableTools.contains((Iterable)handlers, (Object)((Object)handler1)));
        CompositeExceptionHandlerTests.assertTrue((boolean)IterableTools.contains((Iterable)handlers, (Object)((Object)handler2)));
        CompositeExceptionHandlerTests.assertEquals((Object)npe, (Object)handler1.throwable);
        CompositeExceptionHandlerTests.assertEquals((Object)npe, (Object)handler2.throwable);
    }

    public void testAddExceptionHandler_exception() {
        TestExceptionHandler handler1 = new TestExceptionHandler();
        CompositeExceptionHandler exceptionHandler = new CompositeExceptionHandler(new ExceptionHandler[]{handler1});
        try {
            exceptionHandler.addExceptionHandler((ExceptionHandler)handler1);
            CompositeExceptionHandlerTests.fail();
        }
        catch (IllegalArgumentException ex) {
            CompositeExceptionHandlerTests.assertTrue((boolean)ex.getMessage().contains("duplicate handler"));
        }
    }

    public void testRemoveExceptionHandler() {
        TestExceptionHandler handler1 = new TestExceptionHandler();
        CompositeExceptionHandler exceptionHandler = new CompositeExceptionHandler(new ExceptionHandler[]{handler1});
        TestExceptionHandler handler2 = new TestExceptionHandler();
        exceptionHandler.addExceptionHandler((ExceptionHandler)handler2);
        NullPointerException npe = new NullPointerException();
        exceptionHandler.handleException((Throwable)npe);
        Iterable handlers = exceptionHandler.getExceptionHandlers();
        CompositeExceptionHandlerTests.assertTrue((boolean)IterableTools.contains((Iterable)handlers, (Object)((Object)handler1)));
        CompositeExceptionHandlerTests.assertTrue((boolean)IterableTools.contains((Iterable)handlers, (Object)((Object)handler2)));
        CompositeExceptionHandlerTests.assertEquals((Object)npe, (Object)handler1.throwable);
        CompositeExceptionHandlerTests.assertEquals((Object)npe, (Object)handler2.throwable);
        handler1.throwable = null;
        handler2.throwable = null;
        exceptionHandler.removeExceptionHandler((ExceptionHandler)handler2);
        exceptionHandler.handleException((Throwable)npe);
        handlers = exceptionHandler.getExceptionHandlers();
        CompositeExceptionHandlerTests.assertTrue((boolean)IterableTools.contains((Iterable)handlers, (Object)((Object)handler1)));
        CompositeExceptionHandlerTests.assertFalse((boolean)IterableTools.contains((Iterable)handlers, (Object)((Object)handler2)));
        CompositeExceptionHandlerTests.assertEquals((Object)npe, (Object)handler1.throwable);
        CompositeExceptionHandlerTests.assertNull((Object)handler2.throwable);
    }

    public void testRemoveExceptionHandler_exception() {
        TestExceptionHandler handler1 = new TestExceptionHandler();
        CompositeExceptionHandler exceptionHandler = new CompositeExceptionHandler(new ExceptionHandler[]{handler1});
        TestExceptionHandler handler2 = new TestExceptionHandler();
        try {
            exceptionHandler.removeExceptionHandler((ExceptionHandler)handler2);
            CompositeExceptionHandlerTests.fail();
        }
        catch (IllegalArgumentException ex) {
            CompositeExceptionHandlerTests.assertTrue((boolean)ex.getMessage().contains("handler not registered"));
        }
    }

    public void testToString() {
        CompositeExceptionHandler exceptionHandler = new CompositeExceptionHandler();
        CompositeExceptionHandlerTests.assertNotNull((Object)exceptionHandler.toString());
    }

    public static class TestExceptionHandler
    extends ExceptionHandlerAdapter {
        public volatile Throwable throwable = null;

        public void handleException(Throwable t) {
            this.throwable = t;
        }
    }
}

