/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.io;

import java.io.CharArrayWriter;
import java.io.Writer;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.io.CompositeWriter;
import org.eclipse.persistence.tools.utility.tests.TestTools;

public class CompositeWriterTests
extends TestCase {
    private Writer writer1;
    private Writer writer2;
    private Writer tee;

    public CompositeWriterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.writer1 = new CharArrayWriter();
        this.writer2 = new CharArrayWriter();
        this.tee = new CompositeWriter(new Writer[]{this.writer1, this.writer2});
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testWrite() throws Exception {
        String string = "The quick brown fox jumps over the lazy dog.";
        this.tee.write(string);
        CompositeWriterTests.assertEquals((String)string, (String)this.writer1.toString());
        CompositeWriterTests.assertNotSame((Object)string, (Object)this.writer1.toString());
        CompositeWriterTests.assertEquals((String)string, (String)this.writer2.toString());
        CompositeWriterTests.assertNotSame((Object)string, (Object)this.writer2.toString());
    }
}

