/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.iterator;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.utility.iterator.ArrayListIterator;
import org.eclipse.persistence.tools.utility.tests.iterator.ArrayIteratorTests;

public class ArrayListIteratorTests
extends ArrayIteratorTests {
    public ArrayListIteratorTests(String name) {
        super(name);
    }

    public void testHasPrevious() {
        ListIterator<String> stream = this.buildListIterator();
        while (stream.hasNext()) {
            stream.next();
        }
        int i = 0;
        while (stream.hasPrevious()) {
            stream.previous();
            ++i;
        }
        ArrayListIteratorTests.assertEquals((int)this.buildArray().length, (int)i);
    }

    public void testPrevious() {
        ListIterator<String> stream = this.buildListIterator();
        while (stream.hasNext()) {
            stream.next();
        }
        int i = this.buildArray().length;
        while (stream.hasPrevious()) {
            ArrayListIteratorTests.assertEquals((String)"bogus element", (int)i--, (int)Integer.parseInt(stream.previous()));
        }
    }

    public void testNextIndex() {
        int i = 0;
        ListIterator<String> stream = this.buildListIterator();
        while (stream.hasNext()) {
            ArrayListIteratorTests.assertEquals((int)i, (int)stream.nextIndex());
            stream.next();
            ++i;
        }
        ArrayListIteratorTests.assertEquals((int)i, (int)stream.nextIndex());
    }

    public void testPreviousIndex() {
        int i = 0;
        ListIterator<String> stream = this.buildListIterator();
        while (stream.hasNext()) {
            ArrayListIteratorTests.assertEquals((int)(i - 1), (int)stream.previousIndex());
            stream.next();
            ++i;
        }
        ArrayListIteratorTests.assertEquals((int)(i - 1), (int)stream.previousIndex());
    }

    @Override
    public void testNoSuchElementException() {
        boolean exCaught = false;
        ListIterator<String> stream = this.buildListIterator();
        String string = null;
        try {
            string = stream.previous();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        ArrayListIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + string), (boolean)exCaught);
    }

    public void testUnsupportedOperationExceptionAdd() {
        boolean exCaught = false;
        ListIterator<String> stream = this.buildListIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals("3")) continue;
            try {
                stream.add("3.5");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        ArrayListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    public void testUnsupportedOperationExceptionSet() {
        boolean exCaught = false;
        ListIterator<String> stream = this.buildListIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals("3")) continue;
            try {
                stream.set("three");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        ArrayListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    @Override
    Iterator<Number> buildGenericIterator(Integer[] integers) {
        return new ArrayListIterator((Object[])integers);
    }

    @Override
    Iterator<Number> buildVarArgIterator() {
        return new ArrayListIterator((Object[])new Number[]{new Integer(0), new Integer(1), new Integer(2)});
    }

    private ListIterator<String> buildListIterator() {
        return this.buildListIterator(this.buildArray());
    }

    private ListIterator<String> buildListIterator(String[] array) {
        return new ArrayListIterator((Object[])array);
    }

    @Override
    Iterator<String> buildIterator(String[] array) {
        return new ArrayListIterator((Object[])array);
    }

    @Override
    Iterator<String> buildIterator(String[] array, int start, int end) {
        return new ArrayListIterator((Object[])array, start, end);
    }
}

