/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.iterator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.iterator.SimultaneousIterator;

public class SimultaneousIteratorTests
extends TestCase {
    public SimultaneousIteratorTests(String name) {
        super(name);
    }

    public void testConstructor() {
        boolean exCaught = false;
        try {
            Iterator<List<String>> iterator = this.buildIterator((Iterable<ListIterator<String>>)null);
            SimultaneousIteratorTests.fail((String)("bogus iterator: " + iterator));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        SimultaneousIteratorTests.assertTrue((boolean)exCaught);
    }

    public void testHasNext() {
        int i = 0;
        Iterator<List<String>> stream = this.buildIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        SimultaneousIteratorTests.assertEquals((int)this.buildList2().size(), (int)i);
    }

    public void testHasNextEmpty() {
        Iterator<List<String>> iterator = this.buildIterator(Collections.<ListIterator<String>>emptyList());
        SimultaneousIteratorTests.assertFalse((boolean)iterator.hasNext());
    }

    public void testNext() {
        Iterator<List<String>> stream = this.buildIterator();
        List<String> next = stream.next();
        SimultaneousIteratorTests.assertEquals((String)"1", (String)next.get(0));
        SimultaneousIteratorTests.assertEquals((String)"one", (String)next.get(1));
        next = stream.next();
        SimultaneousIteratorTests.assertEquals((String)"2", (String)next.get(0));
        SimultaneousIteratorTests.assertEquals((String)"two", (String)next.get(1));
        next = stream.next();
        SimultaneousIteratorTests.assertEquals((String)"3", (String)next.get(0));
        SimultaneousIteratorTests.assertEquals((String)"three", (String)next.get(1));
        next = stream.next();
        SimultaneousIteratorTests.assertEquals((String)"4", (String)next.get(0));
        SimultaneousIteratorTests.assertEquals((String)"four", (String)next.get(1));
        next = stream.next();
        SimultaneousIteratorTests.assertEquals((String)"5", (String)next.get(0));
        SimultaneousIteratorTests.assertEquals((String)"five", (String)next.get(1));
        next = stream.next();
        SimultaneousIteratorTests.assertEquals((String)"6", (String)next.get(0));
        SimultaneousIteratorTests.assertEquals((String)"six", (String)next.get(1));
        next = stream.next();
        SimultaneousIteratorTests.assertEquals((String)"7", (String)next.get(0));
        SimultaneousIteratorTests.assertEquals((String)"seven", (String)next.get(1));
    }

    public void testNextEmpty() {
        Iterator<List<String>> iterator = this.buildIterator(Collections.<ListIterator<String>>emptyList());
        boolean exCaught = false;
        try {
            List<String> next = iterator.next();
            SimultaneousIteratorTests.fail((String)("bogus element: " + next));
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        SimultaneousIteratorTests.assertTrue((boolean)exCaught);
    }

    public void testRemove() {
        List<String> list1 = this.buildList1();
        List<String> list2 = this.buildList2();
        SimultaneousIteratorTests.assertTrue((boolean)list1.contains("2"));
        SimultaneousIteratorTests.assertTrue((boolean)list2.contains("two"));
        Iterator<List<String>> stream = this.buildIterator(list1, list2);
        List<String> next = stream.next();
        SimultaneousIteratorTests.assertEquals((String)"1", (String)next.get(0));
        SimultaneousIteratorTests.assertEquals((String)"one", (String)next.get(1));
        next = stream.next();
        SimultaneousIteratorTests.assertEquals((String)"2", (String)next.get(0));
        SimultaneousIteratorTests.assertEquals((String)"two", (String)next.get(1));
        stream.remove();
        SimultaneousIteratorTests.assertFalse((boolean)list1.contains("2"));
        SimultaneousIteratorTests.assertFalse((boolean)list1.contains("two"));
    }

    public void testRemoveEmpty() {
        Iterator<List<String>> iterator = this.buildIterator(Collections.<ListIterator<String>>emptyList());
        boolean exCaught = false;
        try {
            iterator.remove();
            SimultaneousIteratorTests.fail((String)("bogus iterator: " + iterator));
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        SimultaneousIteratorTests.assertTrue((boolean)exCaught);
    }

    private List<String> buildList1() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("1");
        list.add("2");
        list.add("3");
        list.add("4");
        list.add("5");
        list.add("6");
        list.add("7");
        list.add("8");
        return list;
    }

    private List<String> buildList2() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        list.add("three");
        list.add("four");
        list.add("five");
        list.add("six");
        list.add("seven");
        return list;
    }

    protected Iterator<List<String>> buildIterator() {
        return this.buildIterator(this.buildList1(), this.buildList2());
    }

    protected Iterator<List<String>> buildIterator(List<String> list1, List<String> list2) {
        return this.buildIterator(list1.listIterator(), list2.listIterator());
    }

    protected Iterator<List<String>> buildIterator(ListIterator<String> ... iterators) {
        return new SimultaneousIterator((Iterator[])iterators);
    }

    protected Iterator<List<String>> buildIterator(Iterable<ListIterator<String>> iterators) {
        return new SimultaneousIterator(iterators);
    }
}

