/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.iterator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.iterator.IteratorTools;
import org.eclipse.persistence.tools.utility.tests.TestTools;
import org.eclipse.persistence.tools.utility.transformer.Transformer;

public class TreeIteratorTests
extends TestCase {
    Collection<TreeNode> nodes = new ArrayList<TreeNode>();

    public TreeIteratorTests(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testHasNext() {
        Iterator<TreeNode> iterator = this.buildTreeIterator();
        int i = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        TreeIteratorTests.assertEquals((int)this.nodes.size(), (int)i);
    }

    public void testNext() {
        Iterator<TreeNode> iterator = this.buildTreeIterator();
        while (iterator.hasNext()) {
            TreeIteratorTests.assertTrue((String)"bogus element", (boolean)this.nodes.contains(iterator.next()));
        }
    }

    public void testNoSuchElementException() {
        Iterator<TreeNode> iterator = this.buildTreeIterator();
        boolean exCaught = false;
        while (iterator.hasNext()) {
            iterator.next();
        }
        try {
            iterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        TreeIteratorTests.assertTrue((String)"NoSuchElementException not thrown", (boolean)exCaught);
    }

    public void testRemove() {
        Iterator<TreeNode> iterator = this.buildTreeIterator();
        String parentName = "child 2";
        String childName = "grandchild 2A";
        int startSize = this.childrenSize(parentName);
        while (iterator.hasNext()) {
            TreeNode node = iterator.next();
            if (!node.getName().equals(childName)) continue;
            iterator.remove();
        }
        int endSize = this.childrenSize(parentName);
        TreeIteratorTests.assertEquals((int)(startSize - 1), (int)endSize);
    }

    private int childrenSize(String nodeName) {
        for (TreeNode node : this.nodes) {
            if (!node.getName().equals(nodeName)) continue;
            return node.childrenSize();
        }
        throw new IllegalArgumentException(nodeName);
    }

    private Iterator<TreeNode> buildTreeIterator() {
        return IteratorTools.treeIterator((Object)this.buildTree(), this.buildTransformer());
    }

    private Transformer<TreeNode, Iterator<? extends TreeNode>> buildTransformer() {
        return new Transformer<TreeNode, Iterator<? extends TreeNode>>(){

            public Iterator<? extends TreeNode> transform(TreeNode node) {
                return node.children();
            }
        };
    }

    private TreeNode buildTree() {
        TreeNode root = new TreeNode("root");
        TreeNode child1 = new TreeNode(root, "child 1");
        new TreeNode(child1, "grandchild 1A");
        TreeNode child2 = new TreeNode(root, "child 2");
        new TreeNode(child2, "grandchild 2A");
        TreeNode grandchild2B = new TreeNode(child2, "grandchild 2B");
        new TreeNode(grandchild2B, "great-grandchild 2B1");
        new TreeNode(grandchild2B, "great-grandchild 2B2");
        TreeNode grandchild2C = new TreeNode(child2, "grandchild 2C");
        new TreeNode(grandchild2C, "great-grandchild 2C1");
        new TreeNode(root, "child 3");
        return root;
    }

    private class TreeNode {
        private String name;
        private Collection<TreeNode> children = new ArrayList<TreeNode>();

        public TreeNode(String name) {
            TreeIteratorTests.this.nodes.add(this);
            this.name = name;
        }

        public TreeNode(TreeNode parent, String name) {
            this(name);
            parent.addChild(this);
        }

        public String getName() {
            return this.name;
        }

        private void addChild(TreeNode child) {
            this.children.add(child);
        }

        public Iterator<TreeNode> children() {
            return this.children.iterator();
        }

        public int childrenSize() {
            return this.children.size();
        }

        public String toString() {
            return "TreeNode(" + this.name + ")";
        }
    }
}

