/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility;

import java.io.Serializable;
import org.eclipse.persistence.tools.utility.ObjectTools;

public interface ExceptionHandler {
    public void handleException(Throwable var1);

    public static final class Default
    implements ExceptionHandler,
    Serializable {
        public static final ExceptionHandler INSTANCE = new Default();
        private static final long serialVersionUID = 1L;

        public static ExceptionHandler instance() {
            return INSTANCE;
        }

        private Default() {
        }

        @Override
        public void handleException(Throwable t) {
            t.printStackTrace();
        }

        public String toString() {
            return ObjectTools.singletonToString(this);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    public static final class Null
    implements ExceptionHandler,
    Serializable {
        public static final ExceptionHandler INSTANCE = new Null();
        private static final long serialVersionUID = 1L;

        public static ExceptionHandler instance() {
            return INSTANCE;
        }

        private Null() {
        }

        @Override
        public void handleException(Throwable t) {
        }

        public String toString() {
            return ObjectTools.singletonToString(this);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    public static final class Runtime
    implements ExceptionHandler,
    Serializable {
        public static final ExceptionHandler INSTANCE = new Runtime();
        private static final long serialVersionUID = 1L;

        public static ExceptionHandler instance() {
            return INSTANCE;
        }

        private Runtime() {
        }

        @Override
        public void handleException(Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }

        public String toString() {
            return ObjectTools.singletonToString(this);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

