/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.collection;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.tools.utility.collection.ArrayQueue;
import org.eclipse.persistence.tools.utility.collection.ArrayStack;
import org.eclipse.persistence.tools.utility.collection.HashBag;
import org.eclipse.persistence.tools.utility.collection.ListTools;
import org.eclipse.persistence.tools.utility.filter.Filter;
import org.eclipse.persistence.tools.utility.transformer.Transformer;

public final class CollectionTools {
    public static <E> boolean addAll(Collection<? super E> collection, Iterable<? extends E> iterable) {
        return CollectionTools.addAll(collection, iterable.iterator());
    }

    public static <E> boolean addAll(Collection<? super E> collection, Iterable<? extends E> iterable, int size) {
        return CollectionTools.addAll(collection, iterable.iterator(), size);
    }

    public static <E> boolean addAll(Collection<? super E> collection, Iterator<? extends E> iterator) {
        return iterator.hasNext() ? CollectionTools.addAll_(collection, iterator) : false;
    }

    private static <E> boolean addAll_(Collection<? super E> collection, Iterator<? extends E> iterator) {
        boolean modified = false;
        while (iterator.hasNext()) {
            modified |= collection.add(iterator.next());
        }
        return modified;
    }

    public static <E> boolean addAll(Collection<? super E> collection, Iterator<? extends E> iterator, int size) {
        return iterator.hasNext() ? collection.addAll(ListTools.list(iterator, size)) : false;
    }

    public static <E> boolean addAll(Collection<? super E> collection, E ... array) {
        return array.length == 0 ? false : CollectionTools.addAll_(collection, array);
    }

    private static <E> boolean addAll_(Collection<? super E> collection, E ... array) {
        boolean modified = false;
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E element = EArray[n2];
            modified |= collection.add(element);
            ++n2;
        }
        return modified;
    }

    public static boolean containsAll(Collection<?> collection, Iterable<?> iterable) {
        return CollectionTools.containsAll(collection, iterable.iterator());
    }

    public static boolean containsAll(Collection<?> collection, Iterator<?> iterator) {
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(Collection<?> collection, Object ... array) {
        int i = array.length;
        while (i-- > 0) {
            if (collection.contains(array[i])) continue;
            return false;
        }
        return true;
    }

    public static <E> HashBag<E> filter(Collection<? extends E> collection, Filter<E> filter) {
        HashBag<E> result = new HashBag<E>(collection.size());
        for (E e : collection) {
            if (!filter.accept(e)) continue;
            result.add(e);
        }
        return result;
    }

    public static boolean removeAll(Collection<?> collection, Iterable<?> iterable) {
        return CollectionTools.removeAll(collection, iterable.iterator());
    }

    public static boolean removeAll(Collection<?> collection, Iterable<?> iterable, int iterableSize) {
        return CollectionTools.removeAll(collection, iterable.iterator(), iterableSize);
    }

    public static boolean removeAll(Collection<?> collection, Iterator<?> iterator) {
        return iterator.hasNext() ? collection.removeAll(CollectionTools.set(iterator)) : false;
    }

    public static boolean removeAll(Collection<?> collection, Iterator<?> iterator, int iteratorSize) {
        return iterator.hasNext() ? collection.removeAll(CollectionTools.set(iterator, iteratorSize)) : false;
    }

    public static boolean removeAll(Collection<?> collection, Object ... array) {
        return array.length == 0 ? false : collection.removeAll(CollectionTools.set(array));
    }

    /*
     * Unable to fully structure code
     */
    public static boolean removeAllOccurrences(Collection<?> collection, Object value) {
        block2: {
            modified = false;
            stream = collection.iterator();
            if (value != null) ** GOTO lbl13
            while (stream.hasNext()) {
                if (stream.next() != null) continue;
                stream.remove();
                modified = true;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                if (!value.equals(stream.next())) continue;
                stream.remove();
                modified = true;
lbl13:
                // 3 sources

                ** while (stream.hasNext())
            }
        }
        return modified;
    }

    public static boolean retainAll(Collection<?> collection, Iterable<?> iterable) {
        return CollectionTools.retainAll(collection, iterable.iterator());
    }

    public static boolean retainAll(Collection<?> collection, Iterable<?> iterable, int iterableSize) {
        return CollectionTools.retainAll(collection, iterable.iterator(), iterableSize);
    }

    public static boolean retainAll(Collection<?> collection, Iterator<?> iterator) {
        if (iterator.hasNext()) {
            return collection.retainAll(CollectionTools.set(iterator));
        }
        if (collection.isEmpty()) {
            return false;
        }
        collection.clear();
        return true;
    }

    public static boolean retainAll(Collection<?> collection, Iterator<?> iterator, int iteratorSize) {
        if (iterator.hasNext()) {
            return collection.retainAll(CollectionTools.set(iterator, iteratorSize));
        }
        if (collection.isEmpty()) {
            return false;
        }
        collection.clear();
        return true;
    }

    public static boolean retainAll(Collection<?> collection, Object ... array) {
        if (array.length > 0) {
            return collection.retainAll(CollectionTools.set(array));
        }
        if (collection.isEmpty()) {
            return false;
        }
        collection.clear();
        return true;
    }

    public static <E1, E2> HashBag<E2> transform(Collection<E1> collection, Transformer<E1, ? extends E2> transformer) {
        HashBag<E2> result = new HashBag<E2>(collection.size());
        for (E1 e : collection) {
            result.add(transformer.transform(e));
        }
        return result;
    }

    public static <E> HashBag<E> bag(Iterable<? extends E> iterable) {
        return CollectionTools.bag(iterable.iterator());
    }

    public static <E> HashBag<E> bag(Iterable<? extends E> iterable, int iterableSize) {
        return CollectionTools.bag(iterable.iterator(), iterableSize);
    }

    public static <E> HashBag<E> bag(Iterator<? extends E> iterator) {
        return CollectionTools.bag(iterator, new HashBag());
    }

    public static <E> HashBag<E> bag(Iterator<? extends E> iterator, int iteratorSize) {
        return CollectionTools.bag(iterator, new HashBag(iteratorSize));
    }

    private static <E> HashBag<E> bag(Iterator<? extends E> iterator, HashBag<E> bag) {
        while (iterator.hasNext()) {
            bag.add(iterator.next());
        }
        return bag;
    }

    public static <E> HashBag<E> bag(E ... array) {
        int len = array.length;
        HashBag<E> bag = new HashBag<E>(len);
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E item = EArray[n2];
            bag.add(item);
            ++n2;
        }
        return bag;
    }

    public static <E> HashBag<E> collection(Iterable<? extends E> iterable) {
        return CollectionTools.collection(iterable.iterator());
    }

    public static <E> HashBag<E> collection(Iterable<? extends E> iterable, int iterableSize) {
        return CollectionTools.collection(iterable.iterator(), iterableSize);
    }

    public static <E> HashBag<E> collection(Iterator<? extends E> iterator) {
        return CollectionTools.bag(iterator);
    }

    public static <E> HashBag<E> collection(Iterator<? extends E> iterator, int iteratorSize) {
        return CollectionTools.bag(iterator, iteratorSize);
    }

    public static <E> HashBag<E> collection(E ... array) {
        return CollectionTools.bag(array);
    }

    public static <E> ArrayQueue<E> queue(Iterable<? extends E> iterable) {
        return CollectionTools.queue(iterable.iterator());
    }

    public static <E> ArrayQueue<E> queue(Iterable<? extends E> iterable, int iterableSize) {
        return CollectionTools.queue(iterable.iterator(), iterableSize);
    }

    public static <E> ArrayQueue<E> queue(Iterator<? extends E> iterator) {
        return CollectionTools.queue(iterator, new ArrayQueue());
    }

    public static <E> ArrayQueue<E> queue(Iterator<? extends E> iterator, int iteratorSize) {
        return CollectionTools.queue(iterator, new ArrayQueue(iteratorSize));
    }

    private static <E> ArrayQueue<E> queue(Iterator<? extends E> iterator, ArrayQueue<E> queue) {
        while (iterator.hasNext()) {
            queue.enqueue(iterator.next());
        }
        return queue;
    }

    public static <E> ArrayQueue<E> queue(E ... array) {
        int len = array.length;
        ArrayQueue<E> queue = new ArrayQueue<E>(len);
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E item = EArray[n2];
            queue.enqueue(item);
            ++n2;
        }
        return queue;
    }

    public static <E> HashSet<E> set(Iterable<? extends E> iterable) {
        return CollectionTools.set(iterable.iterator());
    }

    public static <E> HashSet<E> set(Iterable<? extends E> iterable, int iterableSize) {
        return CollectionTools.set(iterable.iterator(), iterableSize);
    }

    public static <E> HashSet<E> set(Iterator<? extends E> iterator) {
        return CollectionTools.set(iterator, new HashSet());
    }

    public static <E> HashSet<E> set(Iterator<? extends E> iterator, int iteratorSize) {
        return CollectionTools.set(iterator, new HashSet(iteratorSize));
    }

    private static <E> HashSet<E> set(Iterator<? extends E> iterator, HashSet<E> set) {
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static <E> HashSet<E> set(E ... array) {
        HashSet<E> set = new HashSet<E>(array.length);
        int i = array.length;
        while (i-- > 0) {
            set.add(array[i]);
        }
        return set;
    }

    public static <E extends Comparable<? super E>> TreeSet<E> sortedSet(Iterable<? extends E> iterable) {
        return CollectionTools.sortedSet(iterable.iterator());
    }

    public static <E extends Comparable<? super E>> TreeSet<E> sortedSet(Iterable<? extends E> iterable, int iterableSize) {
        return CollectionTools.sortedSet(iterable.iterator(), iterableSize);
    }

    public static <E> TreeSet<E> sortedSet(Iterable<? extends E> iterable, Comparator<? super E> comparator) {
        return CollectionTools.sortedSet(iterable.iterator(), comparator);
    }

    public static <E> TreeSet<E> sortedSet(Iterable<? extends E> iterable, Comparator<? super E> comparator, int iterableSize) {
        return CollectionTools.sortedSet(iterable.iterator(), comparator, iterableSize);
    }

    public static <E extends Comparable<? super E>> TreeSet<E> sortedSet(Iterator<? extends E> iterator) {
        return CollectionTools.sortedSet(iterator, null);
    }

    public static <E extends Comparable<? super E>> TreeSet<E> sortedSet(Iterator<? extends E> iterator, int iteratorSize) {
        return CollectionTools.sortedSet(iterator, null, iteratorSize);
    }

    public static <E> TreeSet<E> sortedSet(Iterator<? extends E> iterator, Comparator<? super E> comparator) {
        return CollectionTools.sortedSet(ListTools.list(iterator), comparator);
    }

    public static <E> TreeSet<E> sortedSet(Iterator<? extends E> iterator, Comparator<? super E> comparator, int iteratorSize) {
        return CollectionTools.sortedSet(ListTools.list(iterator, iteratorSize), comparator);
    }

    private static <E> TreeSet<E> sortedSet(List<E> list, Comparator<? super E> comparator) {
        TreeSet<E> sortedSet = new TreeSet<E>(comparator);
        sortedSet.addAll(list);
        return sortedSet;
    }

    public static <E extends Comparable<? super E>> TreeSet<E> sortedSet(E ... array) {
        return CollectionTools.sortedSet(array, null);
    }

    public static <E> TreeSet<E> sortedSet(E[] array, Comparator<? super E> comparator) {
        TreeSet<E> sortedSet = new TreeSet<E>(comparator);
        sortedSet.addAll(Arrays.asList(array));
        return sortedSet;
    }

    public static <E> ArrayStack<E> stack(Iterable<? extends E> iterable) {
        return CollectionTools.stack(iterable.iterator());
    }

    public static <E> ArrayStack<E> stack(Iterable<? extends E> iterable, int iterableSize) {
        return CollectionTools.stack(iterable.iterator(), iterableSize);
    }

    public static <E> ArrayStack<E> stack(Iterator<? extends E> iterator) {
        return CollectionTools.stack(iterator, new ArrayStack());
    }

    public static <E> ArrayStack<E> stack(Iterator<? extends E> iterator, int iteratorSize) {
        return CollectionTools.stack(iterator, new ArrayStack(iteratorSize));
    }

    private static <E> ArrayStack<E> stack(Iterator<? extends E> iterator, ArrayStack<E> stack) {
        while (iterator.hasNext()) {
            stack.push(iterator.next());
        }
        return stack;
    }

    public static <E> ArrayStack<E> stack(E ... array) {
        int len = array.length;
        ArrayStack<E> stack = new ArrayStack<E>(len);
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E item = EArray[n2];
            stack.push(item);
            ++n2;
        }
        return stack;
    }

    public static <E> Vector<E> vector(Iterable<? extends E> iterable) {
        return CollectionTools.vector(iterable.iterator());
    }

    public static <E> Vector<E> vector(Iterable<? extends E> iterable, int size) {
        return CollectionTools.vector(iterable.iterator(), size);
    }

    public static <E> Vector<E> vector(Iterator<? extends E> iterator) {
        return CollectionTools.vector(iterator, new Vector());
    }

    public static <E> Vector<E> vector(Iterator<? extends E> iterator, int size) {
        return CollectionTools.vector(iterator, new Vector(size));
    }

    private static <E> Vector<E> vector(Iterator<? extends E> iterator, Vector<E> v) {
        while (iterator.hasNext()) {
            v.addElement(iterator.next());
        }
        return v;
    }

    public static <E> Vector<E> vector(E ... array) {
        Vector<E> v = new Vector<E>(array.length);
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E item = EArray[n2];
            v.addElement(item);
            ++n2;
        }
        return v;
    }

    private CollectionTools() {
        throw new UnsupportedOperationException();
    }
}

