/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.RandomAccess;
import org.eclipse.persistence.tools.utility.Range;
import org.eclipse.persistence.tools.utility.filter.Filter;
import org.eclipse.persistence.tools.utility.transformer.Transformer;

public final class ListTools {
    public static <E> boolean addAll(List<? super E> list, int index, Iterable<? extends E> iterable) {
        return ListTools.addAll(list, index, iterable.iterator());
    }

    public static <E> boolean addAll(List<? super E> list, int index, Iterable<? extends E> iterable, int iterableSize) {
        return ListTools.addAll(list, index, iterable.iterator(), iterableSize);
    }

    public static <E> boolean addAll(List<? super E> list, int index, Iterator<? extends E> iterator) {
        return iterator.hasNext() ? list.addAll(index, ListTools.list(iterator)) : false;
    }

    public static <E> boolean addAll(List<? super E> list, int index, Iterator<? extends E> iterator, int iteratorSize) {
        return iterator.hasNext() ? list.addAll(index, ListTools.list(iterator, iteratorSize)) : false;
    }

    public static <E> boolean addAll(List<? super E> list, int index, E ... array) {
        return array.length == 0 ? false : list.addAll(index, Arrays.asList(array));
    }

    public static Range differenceRange(List<?> list1, List<?> list2) {
        int end = ListTools.lastIndexOfDifference(list1, list2);
        if (end == -1) {
            return new Range(list1.size(), end);
        }
        return new Range(ListTools.indexOfDifference(list1, list2), end);
    }

    public static int indexOfDifference(List<?> list1, List<?> list2) {
        int end = Math.min(list1.size(), list2.size());
        int i = 0;
        while (i < end) {
            Object o = list1.get(i);
            if (o == null ? list2.get(i) != null : !o.equals(list2.get(i))) {
                return i;
            }
            ++i;
        }
        return end;
    }

    public static int lastIndexOfDifference(List<?> list1, List<?> list2) {
        int len2;
        int len1 = list1.size();
        if (len1 != (len2 = list2.size())) {
            return Math.max(len1, len2) - 1;
        }
        int i = len1 - 1;
        while (i > -1) {
            Object o = list1.get(i);
            if (o == null ? list2.get(i) != null : !o.equals(list2.get(i))) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static <E> ArrayList<E> filter(Collection<? extends E> list, Filter<E> filter) {
        ArrayList<E> result = new ArrayList<E>(list.size());
        for (E e : list) {
            if (!filter.accept(e)) continue;
            result.add(e);
        }
        return result;
    }

    public static Range identityDifferenceRange(List<?> list1, List<?> list2) {
        int end = ListTools.lastIndexOfIdentityDifference(list1, list2);
        if (end == -1) {
            return new Range(list1.size(), end);
        }
        return new Range(ListTools.indexOfIdentityDifference(list1, list2), end);
    }

    public static int indexOfIdentityDifference(List<?> list1, List<?> list2) {
        int end = Math.min(list1.size(), list2.size());
        int i = 0;
        while (i < end) {
            if (list1.get(i) != list2.get(i)) {
                return i;
            }
            ++i;
        }
        return end;
    }

    public static int lastIndexOfIdentityDifference(List<?> list1, List<?> list2) {
        int len2;
        int len1 = list1.size();
        if (len1 != (len2 = list2.size())) {
            return Math.max(len1, len2) - 1;
        }
        int i = len1 - 1;
        while (i > -1) {
            if (list1.get(i) != list2.get(i)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static <E extends Comparable<? super E>> int insertionIndexOf(List<E> sortedList, Comparable<E> value) {
        if (sortedList instanceof RandomAccess) {
            int i = sortedList.size();
            while (i-- > 0) {
                if (value.compareTo((Comparable)sortedList.get(i)) < 0) continue;
                return i + 1;
            }
            return 0;
        }
        int i = 0;
        for (Comparable element : sortedList) {
            if (value.compareTo(element) <= 0) {
                return i;
            }
            ++i;
        }
        return i;
    }

    public static <E> int insertionIndexOf(List<E> sortedList, E value, Comparator<? super E> comparator) {
        if (sortedList instanceof RandomAccess) {
            int i = sortedList.size();
            while (i-- > 0) {
                if (comparator.compare(value, sortedList.get(i)) < 0) continue;
                return i + 1;
            }
            return 0;
        }
        int i = 0;
        for (E element : sortedList) {
            if (comparator.compare(value, element) <= 0) {
                return i;
            }
            ++i;
        }
        return i;
    }

    public static <E> List<E> move(List<E> list, int targetIndex, int sourceIndex) {
        return targetIndex == sourceIndex ? list : ListTools.move_(list, targetIndex, sourceIndex);
    }

    private static <E> List<E> move_(List<E> list, int targetIndex, int sourceIndex) {
        if (list instanceof RandomAccess) {
            E temp = list.get(sourceIndex);
            if (targetIndex < sourceIndex) {
                int i = sourceIndex;
                while (i-- > targetIndex) {
                    list.set(i + 1, list.get(i));
                }
            } else {
                int i = sourceIndex;
                while (i < targetIndex) {
                    list.set(i, list.get(i + 1));
                    ++i;
                }
            }
            list.set(targetIndex, temp);
        } else {
            list.add(targetIndex, list.remove(sourceIndex));
        }
        return list;
    }

    public static <E> List<E> move(List<E> list, int targetIndex, int sourceIndex, int length) {
        if (targetIndex == sourceIndex || length == 0) {
            return list;
        }
        if (length == 1) {
            return ListTools.move_(list, targetIndex, sourceIndex);
        }
        if (list instanceof RandomAccess) {
            int i;
            ArrayList<E> temp = new ArrayList<E>(list.subList(sourceIndex, sourceIndex + length));
            if (targetIndex < sourceIndex) {
                i = sourceIndex;
                while (i-- > targetIndex) {
                    list.set(i + length, list.get(i));
                }
            } else {
                i = sourceIndex;
                while (i < targetIndex) {
                    list.set(i, list.get(i + length));
                    ++i;
                }
            }
            i = 0;
            while (i < length) {
                list.set(targetIndex + i, temp.get(i));
                ++i;
            }
        } else {
            list.addAll(targetIndex, ListTools.removeElementsAtIndex(list, sourceIndex, length));
        }
        return list;
    }

    public static <E> ArrayList<E> removeElementsAtIndex(List<E> list, int index, int length) {
        List<E> subList = list.subList(index, index + length);
        ArrayList<E> removed = new ArrayList<E>(subList);
        subList.clear();
        return removed;
    }

    public static <E> boolean removeDuplicateElements(List<E> list) {
        int listSize = list.size();
        if (listSize == 0 || listSize == 1) {
            return false;
        }
        LinkedHashSet<E> temp = new LinkedHashSet<E>(listSize);
        boolean modified = false;
        for (E item : list) {
            if (temp.add(item)) continue;
            modified = true;
        }
        if (modified) {
            int i = 0;
            for (Object e : temp) {
                list.set(i, e);
                ++i;
            }
            int tempSize = temp.size();
            i = list.size();
            while (i-- > tempSize) {
                list.remove(i);
            }
        }
        return modified;
    }

    public static <E> List<E> rotate(List<E> list) {
        return ListTools.rotate(list, 1);
    }

    public static <E1, E2> ArrayList<E2> transform(List<E1> list, Transformer<E1, ? extends E2> transformer) {
        ArrayList<E2> result = new ArrayList<E2>(list.size());
        for (E1 e : list) {
            result.add(transformer.transform(e));
        }
        return result;
    }

    public static <E> List<E> copy(List<E> dest, List<? extends E> src) {
        Collections.copy(dest, src);
        return dest;
    }

    public static <E> List<E> fill(List<E> list, E value) {
        Collections.fill(list, value);
        return list;
    }

    public static <E> List<E> reverse(List<E> list) {
        Collections.reverse(list);
        return list;
    }

    public static <E> List<E> rotate(List<E> list, int distance) {
        Collections.rotate(list, distance);
        return list;
    }

    public static <E> List<E> shuffle(List<E> list) {
        Collections.shuffle(list);
        return list;
    }

    public static <E> List<E> shuffle(List<E> list, Random random) {
        Collections.shuffle(list, random);
        return list;
    }

    public static <E extends Comparable<? super E>> List<E> sort(List<E> list) {
        Collections.sort(list);
        return list;
    }

    public static <E> List<E> sort(List<E> list, Comparator<? super E> comparator) {
        Collections.sort(list, comparator);
        return list;
    }

    public static <E> List<E> swap(List<E> list, int i, int j) {
        Collections.swap(list, i, j);
        return list;
    }

    public static <E> ArrayList<E> list(Iterable<? extends E> iterable) {
        return ListTools.list(iterable.iterator());
    }

    public static <E> ArrayList<E> list(Iterable<? extends E> iterable, int iterableSize) {
        return ListTools.list(iterable.iterator(), iterableSize);
    }

    public static <E> ArrayList<E> list(Iterator<? extends E> iterator) {
        return ListTools.list(iterator, new ArrayList());
    }

    public static <E> ArrayList<E> list(Iterator<? extends E> iterator, int iteratorSize) {
        return ListTools.list(iterator, new ArrayList(iteratorSize));
    }

    private static <E> ArrayList<E> list(Iterator<? extends E> iterator, ArrayList<E> list) {
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static <E> ArrayList<E> list(E ... array) {
        ArrayList<E> list = new ArrayList<E>(array.length);
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E e = EArray[n2];
            list.add(e);
            ++n2;
        }
        return list;
    }

    private ListTools() {
        throw new UnsupportedOperationException();
    }
}

