/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.iterable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.tools.utility.collection.CollectionTools;
import org.eclipse.persistence.tools.utility.collection.HashBag;
import org.eclipse.persistence.tools.utility.collection.ListTools;
import org.eclipse.persistence.tools.utility.collection.Queue;
import org.eclipse.persistence.tools.utility.collection.Stack;
import org.eclipse.persistence.tools.utility.command.InterruptibleParameterizedCommand;
import org.eclipse.persistence.tools.utility.command.ParameterizedCommand;
import org.eclipse.persistence.tools.utility.filter.Filter;
import org.eclipse.persistence.tools.utility.iterable.ArrayIterable;
import org.eclipse.persistence.tools.utility.iterable.ArrayListIterable;
import org.eclipse.persistence.tools.utility.iterable.ChainIterable;
import org.eclipse.persistence.tools.utility.iterable.CompositeIterable;
import org.eclipse.persistence.tools.utility.iterable.CompositeListIterable;
import org.eclipse.persistence.tools.utility.iterable.EmptyIterable;
import org.eclipse.persistence.tools.utility.iterable.EmptyListIterable;
import org.eclipse.persistence.tools.utility.iterable.FilteringIterable;
import org.eclipse.persistence.tools.utility.iterable.GraphIterable;
import org.eclipse.persistence.tools.utility.iterable.LateralIterableWrapper;
import org.eclipse.persistence.tools.utility.iterable.LateralListIterableWrapper;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.eclipse.persistence.tools.utility.iterable.LiveCloneIterable;
import org.eclipse.persistence.tools.utility.iterable.LiveCloneListIterable;
import org.eclipse.persistence.tools.utility.iterable.PeekableIterable;
import org.eclipse.persistence.tools.utility.iterable.QueueIterable;
import org.eclipse.persistence.tools.utility.iterable.ReadOnlyCompositeListIterable;
import org.eclipse.persistence.tools.utility.iterable.ReadOnlyIterable;
import org.eclipse.persistence.tools.utility.iterable.ReadOnlyListIterable;
import org.eclipse.persistence.tools.utility.iterable.SimultaneousIterable;
import org.eclipse.persistence.tools.utility.iterable.SimultaneousListIterable;
import org.eclipse.persistence.tools.utility.iterable.SingleElementIterable;
import org.eclipse.persistence.tools.utility.iterable.SingleElementListIterable;
import org.eclipse.persistence.tools.utility.iterable.SnapshotCloneIterable;
import org.eclipse.persistence.tools.utility.iterable.SnapshotCloneListIterable;
import org.eclipse.persistence.tools.utility.iterable.StackIterable;
import org.eclipse.persistence.tools.utility.iterable.SubIterableWrapper;
import org.eclipse.persistence.tools.utility.iterable.SubListIterableWrapper;
import org.eclipse.persistence.tools.utility.iterable.SuperIterableWrapper;
import org.eclipse.persistence.tools.utility.iterable.SuperListIterableWrapper;
import org.eclipse.persistence.tools.utility.iterable.TransformationIterable;
import org.eclipse.persistence.tools.utility.iterable.TransformationListIterable;
import org.eclipse.persistence.tools.utility.iterable.TreeIterable;
import org.eclipse.persistence.tools.utility.iterator.ChainIterator;
import org.eclipse.persistence.tools.utility.iterator.CloneIterator;
import org.eclipse.persistence.tools.utility.iterator.CloneListIterator;
import org.eclipse.persistence.tools.utility.iterator.GraphIterator;
import org.eclipse.persistence.tools.utility.iterator.IteratorTools;
import org.eclipse.persistence.tools.utility.transformer.Transformer;

public final class IterableTools {
    public static final Transformer LIST_LIST_ITERABLE_TRANSFORMER = new ListListIterableTransformer();
    public static final Transformer READ_ONLY_LIST_LIST_ITERABLE_TRANSFORMER = new ReadOnlyListListIterableTransformer();

    public static <E> HashBag<E> bag(Iterable<? extends E> iterable) {
        return CollectionTools.bag(iterable);
    }

    public static <E> HashBag<E> bag(Iterable<? extends E> iterable, int iterableSize) {
        return CollectionTools.bag(iterable, iterableSize);
    }

    public static <E> HashBag<E> collection(Iterable<? extends E> iterable) {
        return CollectionTools.collection(iterable);
    }

    public static <E> HashBag<E> collection(Iterable<? extends E> iterable, int iterableSize) {
        return CollectionTools.collection(iterable, iterableSize);
    }

    public static boolean contains(Iterable<?> iterable, Object value) {
        return IteratorTools.contains(iterable.iterator(), value);
    }

    public static boolean containsAll(Iterable<?> iterable, Collection<?> collection) {
        return IteratorTools.containsAll(iterable.iterator(), collection);
    }

    public static boolean containsAll(Iterable<?> iterable, int iterableSize, Collection<?> collection) {
        return IteratorTools.containsAll(iterable.iterator(), iterableSize, collection);
    }

    public static boolean containsAll(Iterable<?> iterable1, Iterable<?> iterable2) {
        return IteratorTools.containsAll(iterable1.iterator(), iterable2);
    }

    public static boolean containsAll(Iterable<?> iterable1, int iterable1Size, Iterable<?> iterable2) {
        return IteratorTools.containsAll(iterable1.iterator(), iterable1Size, iterable2);
    }

    public static boolean containsAll(Iterable<?> iterable, Iterator<?> iterator) {
        return IteratorTools.containsAll(iterable.iterator(), iterator);
    }

    public static boolean containsAll(Iterable<?> iterable, int iterableSize, Iterator<?> iterator) {
        return IteratorTools.containsAll(iterable.iterator(), iterableSize, iterator);
    }

    public static boolean containsAll(Iterable<?> iterable, Object ... array) {
        return IteratorTools.containsAll(iterable.iterator(), array);
    }

    public static boolean containsAll(Iterable<?> iterable, int iterableSize, Object ... array) {
        return IteratorTools.containsAll(iterable.iterator(), iterableSize, array);
    }

    public static boolean elementsAreDifferent(Iterable<?> iterable1, Iterable<?> iterable2) {
        return IteratorTools.elementsAreDifferent(iterable1.iterator(), iterable2.iterator());
    }

    public static boolean elementsAreEqual(Iterable<?> iterable1, Iterable<?> iterable2) {
        return IteratorTools.elementsAreEqual(iterable1.iterator(), iterable2.iterator());
    }

    public static boolean elementsAreIdentical(Iterable<?> iterable1, Iterable<?> iterable2) {
        return IteratorTools.elementsAreIdentical(iterable1.iterator(), iterable2.iterator());
    }

    public static boolean elementsAreNotIdentical(Iterable<?> iterable1, Iterable<?> iterable2) {
        return IteratorTools.elementsAreNotIdentical(iterable1.iterator(), iterable2.iterator());
    }

    public static <E> void execute(Iterable<? extends E> iterable, ParameterizedCommand<E> command) {
        IteratorTools.execute(iterable.iterator(), command);
    }

    public static <E> void execute(Iterable<? extends E> iterable, InterruptibleParameterizedCommand<E> command) throws InterruptedException {
        IteratorTools.execute(iterable.iterator(), command);
    }

    public static <E> E get(Iterable<? extends E> iterable, int index) {
        return IteratorTools.get(iterable.iterator(), index);
    }

    public static int hashCode(Iterable<?> iterable) {
        return iterable == null ? 0 : IteratorTools.hashCode(iterable.iterator());
    }

    public static int indexOf(Iterable<?> iterable, Object value) {
        return IteratorTools.indexOf(iterable.iterator(), value);
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return IteratorTools.isEmpty(iterable.iterator());
    }

    public static <E> E last(Iterable<E> iterable) {
        return IteratorTools.last(iterable.iterator());
    }

    public static int lastIndexOf(Iterable<?> iterable, Object value) {
        return IteratorTools.lastIndexOf(iterable.iterator(), value);
    }

    public static <E> ArrayList<E> list(Iterable<? extends E> iterable) {
        return ListTools.list(iterable);
    }

    public static <E> ArrayList<E> list(Iterable<? extends E> iterable, int iterableSize) {
        return ListTools.list(iterable, iterableSize);
    }

    public static int size(Iterable<?> iterable) {
        return IteratorTools.size(iterable.iterator());
    }

    public static <E extends Comparable<? super E>> Iterable<E> sort(Iterable<E> iterable) {
        return IterableTools.sort(iterable, null);
    }

    public static <E extends Comparable<? super E>> Iterable<E> sort(Iterable<E> iterable, int iterableSize) {
        return IterableTools.sort(iterable, null, iterableSize);
    }

    public static <E> Iterable<E> sort(Iterable<E> iterable, Comparator<? super E> comparator) {
        return ListTools.sort(ListTools.list(iterable), comparator);
    }

    public static <E> Iterable<E> sort(Iterable<E> iterable, Comparator<? super E> comparator, int iterableSize) {
        return ListTools.sort(ListTools.list(iterable, iterableSize), comparator);
    }

    public static Object[] toArray(Iterable<?> iterable) {
        return IterableTools.list(iterable).toArray();
    }

    public static Object[] toArray(Iterable<?> iterable, int iterableSize) {
        return IterableTools.list(iterable, iterableSize).toArray();
    }

    public static <E> E[] toArray(Iterable<? extends E> iterable, E[] array) {
        return IterableTools.list(iterable).toArray(array);
    }

    public static <E> E[] toArray(Iterable<? extends E> iterable, int iterableSize, E[] array) {
        return IterableTools.list(iterable, iterableSize).toArray(array);
    }

    public static <E> ChainIterable<E> chainIterable(E startLink, ChainIterator.Linker<E> linker) {
        return new ChainIterable<E>(startLink, linker);
    }

    public static <E> CompositeIterable<E> compositeIterable(E object, Iterable<? extends E> iterable) {
        return IterableTools.compositeIterable(new Iterable[]{IterableTools.singletonIterable(object), iterable});
    }

    public static <E> CompositeIterable<E> compositeIterable(Iterable<? extends E> iterable, E object) {
        return IterableTools.compositeIterable(new Iterable[]{iterable, IterableTools.singletonIterable(object)});
    }

    public static <E> CompositeIterable<E> compositeIterable(Iterable<? extends E> ... iterables) {
        return IterableTools.compositeIterable(Arrays.asList(iterables));
    }

    public static <E> CompositeIterable<E> compositeIterable(Iterable<? extends Iterable<? extends E>> iterables) {
        return new CompositeIterable(iterables);
    }

    public static <P, E> CompositeIterable<E> compositeIterable(Iterable<? extends P> parents, Transformer<P, Iterable<? extends E>> childrenTransformer) {
        return IterableTools.compositeIterable(IterableTools.transform(parents, childrenTransformer));
    }

    public static <E> CompositeListIterable<E> compositeListIterable(E object, List<E> list) {
        return IterableTools.compositeListIterable(object, IterableTools.listIterable(list));
    }

    public static <E> CompositeListIterable<E> compositeListIterable(E object, ListIterable<E> iterable) {
        return IterableTools.compositeListIterable(new ListIterable[]{IterableTools.singletonListIterable(object), iterable});
    }

    public static <E> CompositeListIterable<E> compositeListIterable(List<E> list, E object) {
        return IterableTools.compositeListIterable(IterableTools.listIterable(list), object);
    }

    public static <E> CompositeListIterable<E> compositeListIterable(List<E> ... lists) {
        return IterableTools.compositeListIterable(Arrays.asList(lists));
    }

    public static <E> CompositeListIterable<E> compositeListIterable(List<? extends List<E>> lists) {
        Transformer<List<E>, ListIterable<E>> transformer = IterableTools.listListIterableTransformer();
        return IterableTools.compositeListIterable(IterableTools.transform(IterableTools.listIterable(lists), transformer));
    }

    public static <E> CompositeListIterable<E> compositeListIterable(ListIterable<? extends ListIterable<E>> iterables) {
        return new CompositeListIterable(iterables);
    }

    public static <P, E> CompositeListIterable<E> compositeListIterable(ListIterable<? extends P> parents, Transformer<P, ListIterable<E>> childrenTransformer) {
        return IterableTools.compositeListIterable(IterableTools.transform(parents, childrenTransformer));
    }

    public static <E> CompositeListIterable<E> compositeListIterable(ListIterable<E> iterable, E object) {
        return IterableTools.compositeListIterable(new ListIterable[]{iterable, IterableTools.singletonListIterable(object)});
    }

    public static <E> CompositeListIterable<E> compositeListIterable(ListIterable<E> ... iterables) {
        return IterableTools.compositeListIterable(IterableTools.listIterable(iterables));
    }

    public static <E> Iterable<E> emptyIterable() {
        return EmptyIterable.instance();
    }

    public static <E> ListIterable<E> emptyListIterable() {
        return EmptyListIterable.instance();
    }

    public static <E> FilteringIterable<E> filter(Iterable<? extends E> iterable, Filter<E> filter) {
        return new FilteringIterable<E>(iterable, filter);
    }

    public static <E> GraphIterable<E> graphIterable(E root, GraphIterator.MisterRogers<E> misterRogers) {
        return new GraphIterable<E>(root, misterRogers);
    }

    public static <E> GraphIterable<E> graphIterable(E[] roots, GraphIterator.MisterRogers<E> misterRogers) {
        return new GraphIterable<E>(roots, misterRogers);
    }

    public static <E> GraphIterable<E> graphIterable(Iterable<E> roots, GraphIterator.MisterRogers<E> misterRogers) {
        return new GraphIterable<E>(roots, misterRogers);
    }

    public static <E> ArrayIterable<E> iterable(E ... array) {
        return IterableTools.iterable(array, 0);
    }

    public static <E> ArrayIterable<E> iterable(E[] array, int start) {
        return IterableTools.iterable(array, start, array.length);
    }

    public static <E> ArrayIterable<E> iterable(E[] array, int start, int end) {
        return new ArrayIterable<E>(array, start, end);
    }

    public static <E> QueueIterable<E> iterable(Queue<E> queue) {
        return new QueueIterable<E>(queue);
    }

    public static <E> StackIterable<E> iterable(Stack<E> stack) {
        return new StackIterable<E>(stack);
    }

    public static <E1, E2> LateralIterableWrapper<E1, E2> lateralIterable(Iterable<E1> iterable) {
        return new LateralIterableWrapper(iterable);
    }

    public static <E1, E2> LateralListIterableWrapper<E1, E2> lateralIterable(ListIterable<E1> iterable) {
        return new LateralListIterableWrapper(iterable);
    }

    public static <E> ArrayListIterable<E> listIterable(E ... array) {
        return IterableTools.listIterable(array, 0);
    }

    public static <E> ArrayListIterable<E> listIterable(E[] array, int start) {
        return IterableTools.listIterable(array, start, array.length);
    }

    public static <E> ArrayListIterable<E> listIterable(E[] array, int start, int end) {
        return new ArrayListIterable<E>(array, start, end);
    }

    public static <E> ListListIterable<E> listIterable(List<E> list) {
        return new ListListIterable<E>(list);
    }

    public static <E> Transformer<List<E>, ListIterable<E>> listListIterableTransformer() {
        return LIST_LIST_ITERABLE_TRANSFORMER;
    }

    public static <E> Transformer<List<? extends E>, ListIterable<? extends E>> readOnlyListListIterableTransformer() {
        return READ_ONLY_LIST_LIST_ITERABLE_TRANSFORMER;
    }

    public static <E> LiveCloneIterable<E> liveCloneIterable(Collection<? extends E> collection) {
        return new LiveCloneIterable<E>(collection);
    }

    public static <E> LiveCloneIterable<E> liveCloneIterable(Collection<? extends E> collection, CloneIterator.Remover<E> remover) {
        return new LiveCloneIterable<E>(collection, remover);
    }

    public static <E> LiveCloneListIterable<E> liveCloneListIterable(List<? extends E> list) {
        return new LiveCloneListIterable<E>(list);
    }

    public static <E> LiveCloneListIterable<E> liveCloneListIterable(List<? extends E> list, CloneListIterator.Mutator<E> mutator) {
        return new LiveCloneListIterable<E>(list, mutator);
    }

    public static <E> PeekableIterable<E> peekableIterable(Iterable<? extends E> iterable) {
        return new PeekableIterable<E>(iterable);
    }

    public static <E, T extends E> ReadOnlyCompositeListIterable<E> readOnlyCompositeListIterable(E object, List<T> list) {
        return IterableTools.readOnlyCompositeListIterable(object, IterableTools.listIterable(list));
    }

    public static <E> ReadOnlyCompositeListIterable<E> readOnlyCompositeListIterable(E object, ListIterable<? extends E> iterable) {
        return IterableTools.readOnlyCompositeListIterable(new ListIterable[]{IterableTools.singletonListIterable(object), iterable});
    }

    public static <E> ReadOnlyCompositeListIterable<E> readOnlyCompositeListIterable(List<E> list, E object) {
        return IterableTools.readOnlyCompositeListIterable(IterableTools.listIterable(list), object);
    }

    public static <E> ReadOnlyCompositeListIterable<E> readOnlyCompositeListIterable(List<E> ... lists) {
        return IterableTools.readOnlyCompositeListIterable(Arrays.asList(lists));
    }

    public static <E> ReadOnlyCompositeListIterable<E> readOnlyCompositeListIterable(List<? extends List<? extends E>> lists) {
        Transformer<List<E>, ListIterable<E>> transformer = IterableTools.readOnlyListListIterableTransformer();
        return IterableTools.readOnlyCompositeListIterable(IterableTools.transform(IterableTools.listIterable(lists), transformer));
    }

    public static <E> ReadOnlyCompositeListIterable<E> readOnlyCompositeListIterable(ListIterable<? extends ListIterable<? extends E>> iterables) {
        return new ReadOnlyCompositeListIterable(iterables);
    }

    public static <P, E> ReadOnlyCompositeListIterable<E> readOnlyCompositeListIterable(ListIterable<? extends P> parents, Transformer<P, ListIterable<? extends E>> childrenTransformer) {
        return IterableTools.readOnlyCompositeListIterable(IterableTools.transform(parents, childrenTransformer));
    }

    public static <E> ReadOnlyCompositeListIterable<E> readOnlyCompositeListIterable(ListIterable<? extends E> iterable, E object) {
        return IterableTools.readOnlyCompositeListIterable(new ListIterable[]{iterable, IterableTools.singletonListIterable(object)});
    }

    public static <E> ReadOnlyCompositeListIterable<E> readOnlyCompositeListIterable(ListIterable<? extends E> ... iterables) {
        return IterableTools.readOnlyCompositeListIterable(IterableTools.listIterable(iterables));
    }

    public static <E> ReadOnlyIterable<E> readOnlyIterable(Iterable<? extends E> iterable) {
        return new ReadOnlyIterable<E>(iterable);
    }

    public static <E> ReadOnlyListIterable<E> readOnlyListIterable(ListIterable<? extends E> iterable) {
        return new ReadOnlyListIterable<E>(iterable);
    }

    public static <E, I extends Iterable<E>> SimultaneousIterable<E> simultaneousIterable(I ... iterables) {
        return new SimultaneousIterable(iterables);
    }

    public static <E, I extends Iterable<E>> SimultaneousIterable<E> simultaneousIterable(Iterable<I> iterables) {
        return new SimultaneousIterable(iterables);
    }

    public static <E, I extends Iterable<E>> SimultaneousIterable<E> simultaneousIterable(Iterable<I> iterables, int iterablesSize) {
        return new SimultaneousIterable(iterables, iterablesSize);
    }

    public static <E, I extends ListIterable<E>> SimultaneousListIterable<E> simultaneousListIterable(I ... iterables) {
        return new SimultaneousListIterable(iterables);
    }

    public static <E, I extends ListIterable<E>> SimultaneousListIterable<E> simultaneousListIterable(Iterable<I> iterables) {
        return new SimultaneousListIterable(iterables);
    }

    public static <E, I extends ListIterable<E>> SimultaneousListIterable<E> simultaneousListIterable(Iterable<I> iterables, int iterablesSize) {
        return new SimultaneousListIterable(iterables, iterablesSize);
    }

    public static <E> SingleElementIterable<E> singletonIterable(E value) {
        return new SingleElementIterable<E>(value);
    }

    public static <E> SingleElementListIterable<E> singletonListIterable(E value) {
        return new SingleElementListIterable<E>(value);
    }

    public static <E> SnapshotCloneIterable<E> snapshotCloneIterable(Collection<? extends E> collection) {
        return new SnapshotCloneIterable<E>(collection);
    }

    public static <E> SnapshotCloneIterable<E> snapshotCloneIterable(Collection<? extends E> collection, CloneIterator.Remover<E> remover) {
        return new SnapshotCloneIterable<E>(collection, remover);
    }

    public static <E> SnapshotCloneListIterable<E> snapshotCloneIterable(List<? extends E> list) {
        return new SnapshotCloneListIterable<E>(list);
    }

    public static <E> SnapshotCloneListIterable<E> snapshotCloneIterable(List<? extends E> list, CloneListIterator.Mutator<E> mutator) {
        return new SnapshotCloneListIterable<E>(list, mutator);
    }

    public static <E1, E2 extends E1> SubIterableWrapper<E1, E2> subIterable(Iterable<E1> iterable) {
        return new SubIterableWrapper(iterable);
    }

    public static <E1, E2 extends E1> SubListIterableWrapper<E1, E2> subListIterable(List<E1> list) {
        return new SubListIterableWrapper(list);
    }

    public static <E1, E2 extends E1> SubListIterableWrapper<E1, E2> subListIterable(ListIterable<E1> iterable) {
        return new SubListIterableWrapper(iterable);
    }

    public static <E> SuperIterableWrapper<E> superIterable(Iterable<? extends E> iterable) {
        return new SuperIterableWrapper<E>(iterable);
    }

    public static <E> SuperListIterableWrapper<E> superListIterable(List<? extends E> list) {
        return new SuperListIterableWrapper(list);
    }

    public static <E> SuperListIterableWrapper<E> superListIterable(ListIterable<? extends E> iterable) {
        return new SuperListIterableWrapper<E>(iterable);
    }

    public static <E1, E2> TransformationIterable<E1, E2> transform(Iterable<? extends E1> iterable, Transformer<E1, ? extends E2> transformer) {
        return new TransformationIterable<E1, E2>(iterable, transformer);
    }

    public static <E1, E2, T extends E1> TransformationListIterable<E1, E2> transformationListIterable(List<T> list, Transformer<E1, ? extends E2> transformer) {
        return new TransformationListIterable<E1, E2>(list, transformer);
    }

    public static <E1, E2> TransformationListIterable<E1, E2> transform(ListIterable<? extends E1> iterable, Transformer<E1, ? extends E2> transformer) {
        return new TransformationListIterable<E1, E2>(iterable, transformer);
    }

    public static <E> TreeIterable<E> treeIterable(E root, Transformer<E, Iterator<? extends E>> transformer) {
        return IterableTools.treeIterable(new SingleElementIterable<E>(root), transformer);
    }

    public static <E> TreeIterable<E> treeIterable(E[] roots, Transformer<E, Iterator<? extends E>> transformer) {
        return IterableTools.treeIterable(new ArrayIterable<E>(roots), transformer);
    }

    public static <E> TreeIterable<E> treeIterable(Iterable<? extends E> roots, Transformer<E, Iterator<? extends E>> transformer) {
        return new TreeIterable<E>(roots, transformer);
    }

    private IterableTools() {
        throw new UnsupportedOperationException();
    }

    static class ListListIterableTransformer<E>
    implements Transformer<List<E>, ListIterable<E>> {
        ListListIterableTransformer() {
        }

        @Override
        public ListIterable<E> transform(List<E> list) {
            return IterableTools.listIterable(list);
        }
    }

    static class ReadOnlyListListIterableTransformer<E>
    implements Transformer<List<? extends E>, ListIterable<? extends E>> {
        ReadOnlyListListIterableTransformer() {
        }

        @Override
        public ListIterable<? extends E> transform(List<? extends E> list) {
            return IterableTools.listIterable(list);
        }
    }
}

