/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.iterable;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.utility.collection.ListTools;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.eclipse.persistence.tools.utility.iterator.TransformationListIterator;
import org.eclipse.persistence.tools.utility.transformer.Transformer;

public class TransformationListIterable<E1, E2>
implements ListIterable<E2> {
    private final ListIterable<? extends E1> iterable;
    private final Transformer<E1, ? extends E2> transformer;

    public <T extends E1> TransformationListIterable(List<T> list) {
        this(new ListListIterable<T>(list));
    }

    public TransformationListIterable(ListIterable<? extends E1> iterable) {
        if (iterable == null) {
            throw new NullPointerException();
        }
        this.iterable = iterable;
        this.transformer = this.buildDefaultTransformer();
    }

    public <T extends E1> TransformationListIterable(List<T> list, Transformer<E1, ? extends E2> transformer) {
        this(new ListListIterable<T>(list), transformer);
    }

    public TransformationListIterable(ListIterable<? extends E1> iterable, Transformer<E1, ? extends E2> transformer) {
        if (iterable == null || transformer == null) {
            throw new NullPointerException();
        }
        this.iterable = iterable;
        this.transformer = transformer;
    }

    protected Transformer<E1, ? extends E2> buildDefaultTransformer() {
        return new DefaultTransformer();
    }

    @Override
    public ListIterator<E2> iterator() {
        return new TransformationListIterator<E1, E2>(this.iterable.iterator(), this.transformer);
    }

    protected E2 transform(E1 o) {
        throw new RuntimeException("This method was not overridden.");
    }

    public String toString() {
        return ListTools.list(this).toString();
    }

    protected class DefaultTransformer
    implements Transformer<E1, E2> {
        protected DefaultTransformer() {
        }

        @Override
        public E2 transform(E1 o) {
            return TransformationListIterable.this.transform(o);
        }
    }
}

