/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.iterator;

import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.iterable.ArrayListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterator.ArrayListIterator;
import org.eclipse.persistence.tools.utility.iterator.SingleElementListIterator;
import org.eclipse.persistence.tools.utility.iterator.TransformationListIterator;

public class CompositeListIterator<E>
implements ListIterator<E> {
    private final ListIterator<? extends ListIterator<E>> iterators;
    private ListIterator<E> nextIterator;
    private int nextIndex;
    private boolean nextReturned;
    private ListIterator<E> lastIteratorToReturnElement;

    public CompositeListIterator(List<? extends List<E>> lists) {
        this(new TransformationListIterator<List<E>, ListIterator<E>>(lists.listIterator()){

            @Override
            protected ListIterator<E> transform(List<E> list) {
                return list.listIterator();
            }
        });
    }

    public CompositeListIterator(ListIterable<? extends ListIterable<E>> listIterables) {
        this(new TransformationListIterator<ListIterable<E>, ListIterator<E>>(listIterables.iterator()){

            @Override
            protected ListIterator<E> transform(ListIterable<E> list) {
                return list.iterator();
            }
        });
    }

    public CompositeListIterator(ListIterator<? extends ListIterator<E>> iterators) {
        if (iterators == null) {
            throw new NullPointerException();
        }
        this.iterators = iterators;
        this.nextIndex = 0;
        this.nextReturned = false;
    }

    public CompositeListIterator(E object, List<E> list) {
        this(object, list.listIterator());
    }

    public CompositeListIterator(E object, ListIterable<E> listIterable) {
        this(object, listIterable.iterator());
    }

    public CompositeListIterator(E object, ListIterator<E> iterator) {
        this(new ListIterator[]{new SingleElementListIterator<E>(object), iterator});
    }

    public CompositeListIterator(List<E> list, E object) {
        this(list.listIterator(), object);
    }

    public CompositeListIterator(ListIterable<E> listIterable, E object) {
        this(listIterable.iterator(), object);
    }

    public CompositeListIterator(ListIterator<E> iterator, E object) {
        this(new ListIterator[]{iterator, new SingleElementListIterator<E>(object)});
    }

    public CompositeListIterator(List<E> ... lists) {
        this(Arrays.asList(lists));
    }

    public CompositeListIterator(ListIterable<E> ... listIterables) {
        this((ListIterable<ListIterable<E>>)new ArrayListIterable<ListIterable<E>>(listIterables));
    }

    public CompositeListIterator(ListIterator<E> ... iterators) {
        this((ListIterator<ListIterator<E>>)new ArrayListIterator<ListIterator<E>>(iterators));
    }

    @Override
    public void add(E o) {
        this.checkNextIterator();
        this.nextIterator.add(o);
        ++this.nextIndex;
    }

    @Override
    public boolean hasNext() {
        try {
            this.loadNextIterator();
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        return this.nextIterator.hasNext();
    }

    @Override
    public boolean hasPrevious() {
        try {
            this.loadPreviousIterator();
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        return this.nextIterator.hasPrevious();
    }

    @Override
    public E next() {
        this.loadNextIterator();
        E result = this.nextIterator.next();
        this.lastIteratorToReturnElement = this.nextIterator;
        ++this.nextIndex;
        this.nextReturned = true;
        return result;
    }

    @Override
    public int nextIndex() {
        return this.nextIndex;
    }

    @Override
    public E previous() {
        this.loadPreviousIterator();
        E result = this.nextIterator.previous();
        this.lastIteratorToReturnElement = this.nextIterator;
        --this.nextIndex;
        this.nextReturned = false;
        return result;
    }

    @Override
    public int previousIndex() {
        return this.nextIndex - 1;
    }

    @Override
    public void remove() {
        if (this.lastIteratorToReturnElement == null) {
            throw new IllegalStateException();
        }
        this.lastIteratorToReturnElement.remove();
        if (this.nextReturned) {
            --this.nextIndex;
        }
    }

    @Override
    public void set(E e) {
        if (this.lastIteratorToReturnElement == null) {
            throw new IllegalStateException();
        }
        this.lastIteratorToReturnElement.set(e);
    }

    private void loadNextIterator() {
        this.checkNextIterator();
        while (!this.nextIterator.hasNext() && this.iterators.hasNext()) {
            this.nextIterator = this.iterators.next();
        }
    }

    private void loadPreviousIterator() {
        this.checkNextIterator();
        while (!this.nextIterator.hasPrevious() && this.iterators.hasPrevious()) {
            this.nextIterator = this.iterators.previous();
        }
    }

    private void checkNextIterator() {
        if (this.nextIterator == null) {
            this.nextIterator = this.iterators.next();
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.iterators);
    }
}

