/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.value;

import java.util.EventListener;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.utility.ArrayTools;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.collection.ListTools;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterator.EmptyListIterator;
import org.eclipse.persistence.tools.utility.iterator.IteratorTools;
import org.eclipse.persistence.tools.utility.model.listener.ListChangeListener;
import org.eclipse.persistence.tools.utility.model.value.AspectAdapter;
import org.eclipse.persistence.tools.utility.model.value.ListValueModel;
import org.eclipse.persistence.tools.utility.model.value.PropertyValueModel;

public abstract class AspectListValueModelAdapter<S, E>
extends AspectAdapter<S, List<E>>
implements ListValueModel<E> {
    protected AspectListValueModelAdapter(PropertyValueModel<? extends S> subjectModel) {
        super(subjectModel);
    }

    @Override
    public ListIterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.subject == null ? EmptyListIterator.instance() : this.listIterator_();
    }

    protected ListIterator<E> listIterator_() {
        return this.getListIterable().iterator();
    }

    protected ListIterable<E> getListIterable() {
        throw new RuntimeException("This method was not overridden.");
    }

    @Override
    public E get(int index) {
        return IteratorTools.get(this.listIterator(), index);
    }

    @Override
    public int size() {
        return this.subject == null ? 0 : this.size_();
    }

    protected int size_() {
        return IteratorTools.size(this.listIterator());
    }

    @Override
    public Object[] toArray() {
        return this.subject == null ? ObjectTools.EMPTY_OBJECT_ARRAY : this.toArray_();
    }

    protected Object[] toArray_() {
        return ArrayTools.array(this.listIterator(), this.size());
    }

    @Override
    protected List<E> getAspectValue() {
        return this.buildValueList();
    }

    @Override
    protected Class<? extends EventListener> getListenerClass() {
        return ListChangeListener.class;
    }

    @Override
    protected String getListenerAspectName() {
        return "list values";
    }

    @Override
    protected boolean hasListeners() {
        return this.hasAnyListChangeListeners("list values");
    }

    @Override
    protected void fireAspectChanged(List<E> oldValue, List<E> newValue) {
        this.fireListChanged("list values", newValue);
    }

    protected void aspectChanged() {
        this.fireListChanged("list values", this.buildValueList());
    }

    protected List<E> buildValueList() {
        return ListTools.list(this.iterator());
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.buildValueList());
    }
}

