/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.value;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.persistence.tools.utility.ArrayTools;
import org.eclipse.persistence.tools.utility.iterator.ArrayIterator;
import org.eclipse.persistence.tools.utility.iterator.ArrayListIterator;
import org.eclipse.persistence.tools.utility.model.AbstractModel;
import org.eclipse.persistence.tools.utility.model.value.ListValueModel;

public class StaticListValueModel<E>
extends AbstractModel
implements ListValueModel<E>,
Serializable {
    protected final Object[] elements;
    private static final long serialVersionUID = 1L;

    public StaticListValueModel(E ... elements) {
        this.elements = (Object[])elements.clone();
    }

    public StaticListValueModel(Iterable<? extends E> elements) {
        this.elements = ArrayTools.array(elements);
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayIterator<Object>(this.elements);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ArrayListIterator<Object>(this.elements);
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public E get(int index) {
        return (E)this.elements[index];
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.elements.clone();
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(Arrays.toString(this.elements));
    }
}

