/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.value;

import java.util.Arrays;
import org.eclipse.persistence.tools.utility.model.Model;
import org.eclipse.persistence.tools.utility.model.event.CollectionAddEvent;
import org.eclipse.persistence.tools.utility.model.event.CollectionChangeEvent;
import org.eclipse.persistence.tools.utility.model.event.CollectionClearEvent;
import org.eclipse.persistence.tools.utility.model.event.CollectionRemoveEvent;
import org.eclipse.persistence.tools.utility.model.listener.CollectionChangeListener;
import org.eclipse.persistence.tools.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.ValueAspectAdapter;

public class ValueCollectionAdapter<V extends Model>
extends ValueAspectAdapter<V> {
    protected final String[] collectionNames;
    protected final CollectionChangeListener valueCollectionListener;

    public ValueCollectionAdapter(ModifiablePropertyValueModel<V> valueHolder, String ... collectionNames) {
        super(valueHolder);
        if (collectionNames == null) {
            throw new NullPointerException();
        }
        this.collectionNames = collectionNames;
        this.valueCollectionListener = this.buildValueCollectionListener();
    }

    protected CollectionChangeListener buildValueCollectionListener() {
        return new CollectionChangeListener(){

            @Override
            public void itemsAdded(CollectionAddEvent event) {
                ValueCollectionAdapter.this.itemsAdded(event);
            }

            @Override
            public void itemsRemoved(CollectionRemoveEvent event) {
                ValueCollectionAdapter.this.itemsRemoved(event);
            }

            @Override
            public void collectionCleared(CollectionClearEvent event) {
                ValueCollectionAdapter.this.collectionCleared(event);
            }

            @Override
            public void collectionChanged(CollectionChangeEvent event) {
                ValueCollectionAdapter.this.collectionChanged(event);
            }

            public String toString() {
                return "value collection listener: " + Arrays.asList(ValueCollectionAdapter.this.collectionNames);
            }
        };
    }

    @Override
    protected void engageValue_() {
        String[] stringArray = this.collectionNames;
        int n = this.collectionNames.length;
        int n2 = 0;
        while (n2 < n) {
            String collectionName = stringArray[n2];
            ((Model)this.value).addCollectionChangeListener(collectionName, this.valueCollectionListener);
            ++n2;
        }
    }

    @Override
    protected void disengageValue_() {
        String[] stringArray = this.collectionNames;
        int n = this.collectionNames.length;
        int n2 = 0;
        while (n2 < n) {
            String collectionName = stringArray[n2];
            ((Model)this.value).removeCollectionChangeListener(collectionName, this.valueCollectionListener);
            ++n2;
        }
    }

    protected void itemsAdded(CollectionAddEvent event) {
        this.valueAspectChanged();
    }

    protected void itemsRemoved(CollectionRemoveEvent event) {
        this.valueAspectChanged();
    }

    protected void collectionCleared(CollectionClearEvent event) {
        this.valueAspectChanged();
    }

    protected void collectionChanged(CollectionChangeEvent event) {
        this.valueAspectChanged();
    }
}

