/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.value.swing;

import javax.swing.ComboBoxModel;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.model.event.PropertyChangeEvent;
import org.eclipse.persistence.tools.utility.model.listener.PropertyChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.awt.AWTPropertyChangeListenerWrapper;
import org.eclipse.persistence.tools.utility.model.value.CollectionValueModel;
import org.eclipse.persistence.tools.utility.model.value.ListValueModel;
import org.eclipse.persistence.tools.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.swing.ListModelAdapter;

public class ComboBoxModelAdapter
extends ListModelAdapter
implements ComboBoxModel {
    protected final ModifiablePropertyValueModel<Object> selectionHolder;
    protected final PropertyChangeListener selectionListener;
    private static final long serialVersionUID = 1L;

    public ComboBoxModelAdapter(ListValueModel<?> listHolder, ModifiablePropertyValueModel<Object> selectionHolder) {
        super(listHolder);
        if (selectionHolder == null) {
            throw new NullPointerException();
        }
        this.selectionHolder = selectionHolder;
        this.selectionListener = this.buildSelectionListener();
    }

    public ComboBoxModelAdapter(CollectionValueModel<?> collectionHolder, ModifiablePropertyValueModel<Object> selectionHolder) {
        super(collectionHolder);
        if (selectionHolder == null) {
            throw new NullPointerException();
        }
        this.selectionHolder = selectionHolder;
        this.selectionListener = this.buildSelectionListener();
    }

    protected PropertyChangeListener buildSelectionListener() {
        return new AWTPropertyChangeListenerWrapper(this.buildSelectionListener_());
    }

    protected PropertyChangeListener buildSelectionListener_() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChanged(PropertyChangeEvent event) {
                ComboBoxModelAdapter.this.fireSelectionChanged();
            }

            public String toString() {
                return "selection listener";
            }
        };
    }

    @Override
    public Object getSelectedItem() {
        return this.selectionHolder.getValue();
    }

    @Override
    public void setSelectedItem(Object selectedItem) {
        this.selectionHolder.setValue(selectedItem);
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        this.selectionHolder.addPropertyChangeListener("value", this.selectionListener);
    }

    @Override
    protected void disengageModel() {
        this.selectionHolder.removePropertyChangeListener("value", this.selectionListener);
        super.disengageModel();
    }

    protected void fireSelectionChanged() {
        this.fireContentsChanged(this, -1, -1);
    }

    @Override
    public String toString() {
        return ObjectTools.toString((Object)this, this.selectionHolder + ":" + this.listHolder);
    }
}

