/*******************************************************************************
 * Copyright (c) 2011 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.persistence.tools.db.driver;

import org.eclipse.persistence.tools.gen.db.Database;

/**
 * Factory interface.
 *
 * @version 2.5
 */
interface WorkbenchDriverAdapterFactory {

	/**
	 * Build a new Workbench driver adapter for the specified Dali database.
	 */
	WorkbenchDriverAdapter buildAdapter(Database database);

	/**
	 * Returns the vendors supported by the factory's adapter.
	 */
	String[] getSupportedVendors();
}