/*******************************************************************************
 * Copyright (c) 1998, 2012 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation from Oracle TopLink
******************************************************************************/
package org.eclipse.persistence.tools.db.relational;

import org.eclipse.persistence.tools.db.relational.handles.MWHandle;
import org.eclipse.persistence.tools.db.relational.platformsmodel.DatabaseType;
import org.eclipse.persistence.tools.utility.node.Node;

/**
 * This handle is a bit different from the other handles. It references an object that is completely
 * outside of the project and is only used by database fields.
 *
 * @version 2.5
 */
@SuppressWarnings("nls")
final class DatabaseTypeHandle extends MWHandle {

	/**
	 * This is the actual database type.
	 * It is built from the database type name, below.
	 */
	private volatile DatabaseType databaseType;

	/**
	 * The database type name is transient. It
	 * is used only to hold its value until #postProjectBuild()
	 * is called and we can resolve the actual database type.
	 * We do not keep it in synch with the database type itself because
	 * we cannot know when the database type has been renamed etc.
	 */
	private volatile String databaseTypeName;

	// ********** constructors **********

	DatabaseTypeHandle(ELColumn parent) {
		// database types are never removed
		super(parent, NodeReferenceScrubber.NULL_INSTANCE);
	}


	// ********** instance methods **********

	DatabaseType getDatabaseType() {
		return this.databaseType;
	}

	void setDatabaseType(DatabaseType databaseType) {
		this.databaseType = databaseType;
	}

	@Override
	protected Node node() {
		return getDatabaseType();
	}

	@Override
	public void toString(StringBuffer sb) {
		if (this.databaseType == null) {
			sb.append("null");
		} else {
			this.databaseType.toString(sb);
		}
	}


	// ********** TopLink methods **********

	String getDatabaseTypeNameForTopLink() {
		return (this.databaseType == null) ? null : this.databaseType.getName();
	}

	void setDatabaseTypeNameForTopLink(String name) {
		this.databaseTypeName = name;
	}
}