/*******************************************************************************
 * Copyright (c) 2005, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.tests;

import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.CharacterTools;

public class CharacterToolsTests
	extends TestCase
{
	public void testEqualsIgnoreCase() {
		assertTrue(CharacterTools.equalsIgnoreCase('a', 'a'));
		assertTrue(CharacterTools.equalsIgnoreCase('a', 'A'));
		assertTrue(CharacterTools.equalsIgnoreCase('A', 'a'));
		assertTrue(CharacterTools.equalsIgnoreCase('A', 'A'));

		assertFalse(CharacterTools.equalsIgnoreCase('a', 'b'));
		assertFalse(CharacterTools.equalsIgnoreCase('A', 'b'));
	}
}