/*******************************************************************************
 * Copyright (c) 2007, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.tests.model.value.swing;

import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.utility.model.value.ExtendedListValueModelWrapper;
import org.eclipse.persistence.tools.utility.model.value.ListValueModel;
import org.eclipse.persistence.tools.utility.swing.SimpleListCellRenderer;

@SuppressWarnings("nls")
public class ComboBoxModelAdapterUITest2 extends ComboBoxModelAdapterUITest {

	public static void main(String[] args) throws Exception {
		new ComboBoxModelAdapterUITest2().exec();
	}

	public ComboBoxModelAdapterUITest2() {
		super();
	}

	/**
	 * use a different model that allows the color to be set to null
	 */
	@Override
	protected TestModel buildTestModel() {
		return new TestModel2();
	}

	/**
	 * add a null to the front of the list
	 */
	@Override
	protected ListValueModel<String> uiColorListHolder() {
		// the default is to prepend the wrapped list with a null item
		return new ExtendedListValueModelWrapper<String>(super.uiColorListHolder());
	}

	/**
	 * convert null to some text
	 */
	@Override
	protected ListCellRenderer buildComboBoxRenderer() {
		return new SimpleListCellRenderer() {
			@Override
			protected String buildText(Object value) {
				return (value == null) ? "<none selected>" : super.buildText(value);
			}
		};
	}


	protected static class TestModel2 extends TestModel {
		/**
		 * null is OK here
		 */
		@Override
		public void checkColor(String color) {
			if (color == null) {
				return;
			}
			super.checkColor(color);
		}
	}
}