/*******************************************************************************
 * Copyright (c) 2012 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

/**
 * Used to configure the data format type for an EIS descriptor.
 *
 * @see NoSql
 * @see org.eclipse.persistence.eis.EISDescriptor#setDataFormat(String)
 * @author James Sutherland
 * @since EclipseLink 2.4
 */
public enum DataFormatType {

	/**
	 * JCA IndexedRecords are used, objects data is decomposed into an array of field values.
	 */
	INDEXED,

	/**
	 * JCA MappedRecords are used, objects data is decomposed into a Map of key/value pairs.
	 */
	MAPPED,

	/**
	 * XML data is used. Objects are converted to XML. This is the default data format.
	 */
	XML
}