/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.annotations.CacheCoordinationType;
import org.eclipse.persistence.annotations.CacheType;
import org.eclipse.persistence.annotations.DatabaseChangeNotificationType;
import org.eclipse.persistence.config.CacheIsolationType;

/**
 * This interface and inherited behavior describe the configurable properties defined for an
 * optimistic locking definition in the EclipseLink 1.1 ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see org.eclipse.persistence.annotations.Cache
 *
 * @version 2.5
 * @author Les Davis
 */
public interface ExternalCache extends ExternalForm {

	/**
	 * Adds the time of day for expiration for this cache.
	 */
	void addExpiryTimeOfDay();

	/**
	 * Returns the coordination type for this cache.
	 */
	CacheCoordinationType getCoordinationType();

	/**
	 * Returns the database change notification type for this cache.
	 */
	DatabaseChangeNotificationType getDatabaseChangeNotificationType();

	/**
	 * Returns this cache's time of day for expiration.
	 */
	ExternalTimeOfDay getExpiryTimeOfDay();

	/**
	 * Returns this cache's time to live before expiration.
	 */
	Integer getExpiryTimeToLive();

	/**
	 * Returns the isolation type for this cache
	 */
	CacheIsolationType getIsolationType();

	/**
	 * Returns the size of the cache.
	 */
	Integer getSize();

	/**
	 * Returns the type of this cache.
	 */
	CacheType getType();

	/**
	 * Returns whether this cache is always refreshed.
	 */
	Boolean isAlwaysRefresh();

	/**
	 * Returns whether this cache disables hits.
	 */
	Boolean isDisableHits();

	/**
	 * Returns whether this cache refreshes only if newer.
	 */
	Boolean isRefreshOnlyIfNewer();

	/**
	 * Returns whether this cache is shared.
	 */
	Boolean isShared();

	/**
	 * Removes the time of day for expiration for this cache.
	 */
	void removeExpiryTimeOfDay();

	/**
	 * Sets whether this cache always refreshes.
	 */
	void setAlwaysRefresh(Boolean alwaysRefresh);

	/**
	 * Sets the coordination type for this cache.
	 */
	void setCoordinationType(CacheCoordinationType type);

	/**
	 * Sets the database change notification type for this cache.
	 */
	void setDatabaseChangeNotificationType(DatabaseChangeNotificationType type);

	/**
	 * Sets whether this cache disables hits.
	 */
	void setDisableHits(Boolean disableHits);

	/**
	 * Sets the time to live for this cache.
	 */
	void setExpiryTimeToLive(Integer timeToLive);

	/**
	 * Sets the isolation type for this cache.
	 */
	void setIsolationType(CacheIsolationType isolationType);

	/**
	 * Sets whether this cache refreshes only if newer.
	 */
	void setRefreshOnlyIfNewer(Boolean refreshOnlyIfNewer);

	/**
	 * Sets whether this cache is shared.
	 */
	void setShared(Boolean shared);

	/**
	 * Sets the size for this cache.
	 */
	void setSize(Integer size);

	/**
	 * Sets the type for this cache.
	 */
	void setType(CacheType type);
}