/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalBasicColumn;
import org.w3c.dom.Element;

/**
 * The external form of a basic column.
 *
 * @version 2.5
 * @author Les Davis
 * @author Pascal Filion
 */
@SuppressWarnings("nls")
abstract class AbstractColumn extends AbstractExternalForm
                              implements ExternalBasicColumn {

	/**
	 * The attribute name used to store and retrieve the column-definition property.
	 */
	static final String COLUMN_DEFINITION = "column-definition";

	/**
	 * The attribute name used to store and retrieve the insertable property.
	 */
	static final String INSERTABLE = "insertable";

	/**
	 * The attribute name used to store and retrieve the length property.
	 */
	static final String LENGTH = "length";

	/**
	 * The attribute name used to store and retrieve the name property.
	 */
	static final String NAME = "name";

	/**
	 * The attribute name used to store and retrieve the nullable property.
	 */
	static final String NULLABLE = "nullable";

	/**
	 * The attribute name used to store and retrieve the precision property.
	 */
	static final String PRECISION = "precision";

	/**
	 * The attribute name used to store and retrieve the scale property.
	 */
	static final String SCALE = "scale";

	/**
	 * The attribute name used to store and retrieve the table property.
	 */
	static final String TABLE = "table";

	/**
	 * The attribute name used to store and retrieve the unique property.
	 */
	static final String UNIQUE = "unique";

	/**
	 * The attribute name used to store and retrieve the updatable property.
	 */
	static final String UPDATABLE = "updatable";

	/**
	 * Creates a new <code>Column</code>.
	 *
	 * @param parent The parent of this external form
	 */
	AbstractColumn(AbstractExternalForm parent) {
		super(parent);
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	protected List<String> buildAttributeNamesOrder() {
		List<String> names = new ArrayList<String>();
		names.add(NAME);
		names.add(UNIQUE);
		names.add(NULLABLE);
		names.add(INSERTABLE);
		names.add(UPDATABLE);
		names.add(COLUMN_DEFINITION);
		names.add(TABLE);
		names.add(LENGTH);
		names.add(PRECISION);
		names.add(SCALE);
		return names;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final String getColumnDefinition() {
		return getAttribute(COLUMN_DEFINITION);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Element getElement() {
		return getChild(getParent(), getElementName());
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final String getName() {
		return getAttribute(NAME);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final String getTable() {
		return getAttribute(TABLE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final Boolean isInstertable() {
		return getBooleanAttribute(INSERTABLE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final Boolean isNullable() {
		return getBooleanAttribute(NULLABLE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final Boolean isUnique() {
		return getBooleanAttribute(UNIQUE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final Boolean isUpdatable() {
		return getBooleanAttribute(UPDATABLE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final void setColumnDefinition(String columnDefinition) {

		setAttribute(COLUMN_DEFINITION, columnDefinition);

		if (shouldRemoveEmptyElement() && !hasAnyChildren() && !hasAttributes()) {
			removeSelf();
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final void setInsertable(Boolean insertable) {

		setAttribute(INSERTABLE, insertable);

		if (shouldRemoveEmptyElement() && !hasAnyChildren() && !hasAttributes()) {
			removeSelf();
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final void setName(String name) {

		setAttribute(NAME, name);

		if (shouldRemoveEmptyElement() && !hasAnyChildren() && !hasAttributes()) {
			removeSelf();
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final void setNullable(Boolean nullable) {

		setAttribute(NULLABLE, nullable);

		if (shouldRemoveEmptyElement() && !hasAnyChildren() && !hasAttributes()) {
			removeSelf();
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final void setTable(String table) {

		setAttribute(TABLE, table);

		if (shouldRemoveEmptyElement() && !hasAnyChildren() && !hasAttributes()) {
			removeSelf();
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final void setUnique(Boolean unique) {

		setAttribute(UNIQUE, unique);

		if (shouldRemoveEmptyElement() && !hasAnyChildren() && !hasAttributes()) {
			removeSelf();
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public final void setUpdatable(Boolean updatable) {

		setAttribute(UPDATABLE, updatable);

		if (shouldRemoveEmptyElement() && !hasAnyChildren() && !hasAttributes()) {
			removeSelf();
		}
	}

	boolean shouldRemoveEmptyElement() {
		return false;
	}
}