/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalAccessMethods;

/**
 * The external form of an access methods.
 *
 * @see NonTransientMapping
 *
 * @version 2.5
 * @author Les Davis
 */
@SuppressWarnings("nls")
final class AccessMethods extends AbstractExternalForm
                          implements ExternalAccessMethods {

	/**
	 * The node name used to store and retrieve the {@link Element} encapsulated by this external form.
	 */
	static final String ACCESS_METHODS = "access-methods";

	/**
	 * The attribute name used to store and retrieve the get-method property.
	 */
	static final String GET_METHOD = "get-method";

	/**
	 * The attribute name used to store and retrieve the set-method property.
	 */
	static final String SET_METHOD = "set-method";

	/**
	 * Creates a new <code>AccessMethods</code>.
	 *
	 * @param parent The parent of this external form
	 */
	AccessMethods(AbstractExternalForm parent) {
		super(parent);
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	protected List<String> buildAttributeNamesOrder() {
		List<String> names = new ArrayList<String>();
		names.add(GET_METHOD);
		names.add(SET_METHOD);
		return names;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return ACCESS_METHODS;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getGetMethod() {
		return getAttribute(GET_METHOD);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getSetMethod() {
		return getAttribute(SET_METHOD);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setGetMethod(String getMethodName) {
		setAttribute(GET_METHOD, getMethodName);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setSetMethod(String setMethodName) {
		setAttribute(SET_METHOD, setMethodName);
	}
}