/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalNativeQuery;

/**
 * The external form of a native query.
 *
 * @see Entity
 * @see ORMConfiguration
 *
 * @version 2.5
 * @author Les Davis
 * @author Pascal Filion
 */
@SuppressWarnings("nls")
final class NamedNativeQuery extends Query
                             implements ExternalNativeQuery {

	/**
	 * The node name used to store and retrieve the {@link Element} encapsulated by this external form.
	 */
	static final String NAMED_NATIVE_QUERY = "named-native-query";

	/**
	 * The attribute name used to store and retrieve the result-class property.
	 */
	static final String RESULT_CLASS = "result-class";

	/**
	 * The attribute name used to store and retrieve the result-set-mapping property.
	 */
	static final String RESULT_SET_MAPPING = "result-set-mapping";

	/**
	 * Creates a new <code>NamedNativeQuery</code>.
	 *
	 * @param parent The parent of this external form
	 * @param index The position of the element within the list of children with the same type owned
	 * by the parent
	 */
	NamedNativeQuery(Entity parent, int index) {
		super(parent, index);
	}

	/**
	 * Creates a new <code>NamedNativeQuery</code>.
	 *
	 * @param parent The parent of this external form
	 * @param index The position of the element within the list of children with the same type owned
	 * by the parent
	 */
	NamedNativeQuery(ORMConfiguration parent, int index) {
		super(parent, index);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected List<String> buildAttributeNamesOrder() {
		List<String> names = new ArrayList<String>();
		names.add(NAME);
		names.add(RESULT_CLASS);
		names.add(RESULT_SET_MAPPING);
		return names;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected List<String> buildElementNamesOrder() {
		List<String> names = new ArrayList<String>();
		names.add(DESCRIPTION);
		return names;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return NAMED_NATIVE_QUERY;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getResultClassName() {
		return getAttribute(RESULT_CLASS);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getResultSetMapping() {
		return getAttribute(RESULT_SET_MAPPING);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setResultClassName(String name) {
		setAttribute(RESULT_CLASS, name);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setResultSetMapping(String mappingName) {
		setAttribute(RESULT_SET_MAPPING, mappingName);
	}
}