/*******************************************************************************
 * Copyright (c) 2012 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import org.eclipse.persistence.tools.mapping.orm.ExternalNoSqlField;

/**
 * The external form of a NoSQL field.
 *
 * @version 2.5
 * @since 2.5
 */
@SuppressWarnings("nls")
final class NoSqlField extends AbstractExternalForm
                       implements ExternalNoSqlField {

	/**
	 * The node name used to store and retrieve the {@link Element} encapsulated by this external form.
	 */
	static final String FIELD = "field";

	/**
	 * The attribute name used to store and retrieve the name property.
	 */
	static final String NAME = "name";

	/**
	 * Creates a new <code>NoSqlField</code>.
	 *
	 * @param parent The parent of this external form
	 */
	NoSqlField(AbstractExternalForm parent) {
		super(parent);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return FIELD;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getName() {
		return getAttribute(NAME);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setName(String name) {
		if (name == null) {
			removeSelf();
		}
		else {
			setAttribute(NAME, name);
		}
	}
}