/*******************************************************************************
 * Copyright (c) 2005, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.enumeration;

import java.util.Enumeration;
import java.util.Iterator;
import org.eclipse.persistence.tools.utility.ObjectTools;

/**
 * An <code>IteratorEnumeration</code> wraps an
 * {@link Iterator} so that it can be treated like an
 * {@link Enumeration}.
 * Hopefully we don't have much need for this....
 *
 * @param <E> the type of elements returned by the enumeration
 */
public class IteratorEnumeration<E>
	implements Enumeration<E>
{
	private final Iterator<? extends E> iterator;

	/**
	 * Construct an enumeration that wraps the specified iterable.
	 */
	public IteratorEnumeration(Iterable<? extends E> iterable) {
		this(iterable.iterator());
	}

	/**
	 * Construct an enumeration that wraps the specified iterator.
	 */
	public IteratorEnumeration(Iterator<? extends E> iterator) {
		super();
		if (iterator == null) {
			throw new NullPointerException();
		}
		this.iterator = iterator;
	}

	@Override
	public boolean hasMoreElements() {
		return this.iterator.hasNext();
	}

	@Override
	public E nextElement() {
		return this.iterator.next();
	}

	@Override
	public String toString() {
		return ObjectTools.toString(this, this.iterator);
	}
}