/*******************************************************************************
 * Copyright (c) 20012, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.filter;

import org.eclipse.persistence.tools.utility.ObjectTools;

/**
 * Convenience filter that "accepts" every object.
 *
 * @param <T> the type of objects to be filtered
 */
public class FilterAdapter<T>
	implements Filter<T>
{
	@Override
	public boolean accept(T o) {
		return true;
	}

	@Override
	public String toString() {
		return ObjectTools.toString(this);
	}
}