/*******************************************************************************
 * Copyright (c) 2011, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.iterator;

import java.util.Iterator;
import org.eclipse.persistence.tools.utility.ObjectTools;

/**
 * Wrap an iterator on elements of type <code>E1</code>, converting it into an
 * iterator on elements of type <code>E2</code>. <em>Assume</em> the wrapped
 * iterator returns only elements of type <code>E2</code>. The result is a
 * {@link ClassCastException} if this assumption is false.
 *
 * @param <E1> input: the type of elements returned by the wrapped iterator
 * @param <E2> output: the type of elements returned by the iterator
 *
 * @see org.eclipse.jpt.common.utility.internal.iterable.LateralIterableWrapper
 * @see SubIteratorWrapper
 */
public class LateralIteratorWrapper<E1, E2>
	implements Iterator<E2>
{
	private final Iterator<E1> iterator;


	public LateralIteratorWrapper(Iterable<E1> iterable) {
		this(iterable.iterator());
	}

	public LateralIteratorWrapper(Iterator<E1> iterator) {
		super();
		if (iterator == null) {
			throw new NullPointerException();
		}
		this.iterator = iterator;
	}

	@Override
	public boolean hasNext() {
		return this.iterator.hasNext();
	}

	@Override
	@SuppressWarnings("unchecked")
	public E2 next() {
		return (E2) this.iterator.next();
	}

	@Override
	public void remove() {
		this.iterator.remove();
	}

	@Override
	public String toString() {
		return ObjectTools.toString(this, this.iterator);
	}
}