/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.javax.persistence.osgi;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;
import javax.persistence.spi.PersistenceProviderResolverHolder;
import org.eclipse.persistence.javax.persistence.osgi.ProviderTrackerCustomizer;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator,
PersistenceProviderResolver {
    public static final String PERSISTENCE_PROVIDER = "javax.persistence.spi.PersistenceProvider";
    private BundleContext ctx;
    private ServiceTracker serviceTracker;
    private Map<String, PersistenceProvider> providers = new Hashtable<String, PersistenceProvider>();
    private static final String LOGGER_SUBSYSTEM = "org.eclipse.persistence.javax.persistence.osgi";
    private Logger logger;

    public void start(BundleContext bundleContext) throws Exception {
        this.log(Level.FINE, bundleContext.getBundle().getSymbolicName() + " - starting...");
        this.ctx = bundleContext;
        ProviderTrackerCustomizer providerTrackerCustomizer = new ProviderTrackerCustomizer(this);
        this.serviceTracker = new ServiceTracker(this.ctx, PERSISTENCE_PROVIDER, (ServiceTrackerCustomizer)providerTrackerCustomizer);
        this.serviceTracker.open();
        PersistenceProviderResolverHolder.setPersistenceProviderResolver(this);
        this.log(Level.FINE, bundleContext.getBundle().getSymbolicName() + " - started");
    }

    PersistenceProvider addProvider(ServiceReference serviceReference) {
        PersistenceProvider persistenceProvider = (PersistenceProvider)this.ctx.getService(serviceReference);
        String string = this.getProviderName(serviceReference);
        this.providers.put(string, persistenceProvider);
        return persistenceProvider;
    }

    protected void removeProvider(ServiceReference serviceReference) {
        String string = this.getProviderName(serviceReference);
        this.providers.remove(string);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.log(Level.FINE, bundleContext.getBundle().getSymbolicName() + " - stopping...");
        this.serviceTracker.close();
        this.serviceTracker = null;
        PersistenceProviderResolverHolder.setPersistenceProviderResolver(null);
        this.providers.clear();
        this.log(Level.FINE, bundleContext.getBundle().getSymbolicName() + " - stopped...");
    }

    public String getProviderName(ServiceReference serviceReference) {
        String string = (String)serviceReference.getProperty(PERSISTENCE_PROVIDER);
        if (string == null) {
            string = "PersistenceProvider-" + serviceReference.hashCode();
        }
        return string;
    }

    protected Map<String, PersistenceProvider> getProviders() {
        return this.providers;
    }

    @Override
    public List<PersistenceProvider> getPersistenceProviders() {
        return new ArrayList<PersistenceProvider>(this.getProviders().values());
    }

    private void log(Level level, String string) {
        if (this.logger == null) {
            this.logger = Logger.getLogger(LOGGER_SUBSYSTEM);
        }
        this.logger.log(level, "org.eclipse.persistence.javax.persistence.osgi::" + string);
    }

    @Override
    public void clearCachedProviders() {
    }
}

