/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.XMLFragmentReader;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class OutputStreamRecord
extends MarshalRecord {
    protected static byte[] OPEN_XML_PI_AND_VERSION_ATTRIBUTE;
    protected static byte[] OPEN_ENCODING_ATTRIBUTE;
    protected static byte[] CLOSE_PI;
    protected static byte[] SPACE;
    protected static byte[] CR;
    protected static byte[] OPEN_ATTRIBUTE_VALUE;
    protected static byte[] CLOSE_ATTRIBUTE_VALUE;
    protected static byte[] OPEN_CDATA;
    protected static byte[] CLOSE_CDATA;
    protected static byte[] OPEN_COMMENT;
    protected static byte[] CLOSE_COMMENT;
    protected static byte[] OPEN_START_ELEMENT;
    protected static byte[] OPEN_END_ELEMENT;
    protected static byte[] CLOSE_ELEMENT;
    protected static byte[] CLOSE_EMPTY_ELEMENT;
    protected static byte[] AMP;
    protected static byte[] LT;
    protected static byte[] QUOT;
    protected static byte[] ENCODING;
    protected static byte[] EQUALS;
    protected static byte[] DOUBLE_QUOTE;
    protected OutputStream outputStream;
    protected boolean isStartElementOpen = false;
    protected boolean isProcessingCData = false;

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
    }

    public void startDocument(String encoding, String version) {
        try {
            this.outputStream.write(OPEN_XML_PI_AND_VERSION_ATTRIBUTE);
            this.outputStream.write(version.getBytes("UTF-8"));
            this.outputStream.write(CLOSE_ATTRIBUTE_VALUE);
            if (null != encoding) {
                this.outputStream.write(OPEN_ENCODING_ATTRIBUTE);
                this.outputStream.write(ENCODING);
                this.outputStream.write(CLOSE_ATTRIBUTE_VALUE);
            }
            this.outputStream.write(CLOSE_PI);
            this.outputStream.write(CR);
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void endDocument() {
    }

    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        super.openStartElement(xPathFragment, namespaceResolver);
        try {
            if (this.isStartElementOpen) {
                this.outputStream.write(CLOSE_ELEMENT);
            }
            this.isStartElementOpen = true;
            this.outputStream.write(OPEN_START_ELEMENT);
            this.outputStream.write(xPathFragment.getShortNameBytes());
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void element(XPathFragment frag) {
        try {
            if (this.isStartElementOpen) {
                this.outputStream.write(CLOSE_ELEMENT);
                this.isStartElementOpen = false;
            }
            this.outputStream.write(OPEN_START_ELEMENT);
            this.outputStream.write(frag.getShortNameBytes());
            this.outputStream.write(CLOSE_EMPTY_ELEMENT);
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String value) {
        this.attribute(null, xPathFragment.getLocalName(), xPathFragment.getShortName(), value);
    }

    public void attribute(String namespaceURI, String localName, String qName, String value) {
        try {
            this.outputStream.write(SPACE);
            this.outputStream.write(qName.getBytes("UTF-8"));
            this.outputStream.write(OPEN_ATTRIBUTE_VALUE);
            this.writeValue(value);
            this.outputStream.write(CLOSE_ATTRIBUTE_VALUE);
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void closeStartElement() {
    }

    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        try {
            if (this.isStartElementOpen) {
                this.outputStream.write(CLOSE_EMPTY_ELEMENT);
                this.isStartElementOpen = false;
            } else {
                this.outputStream.write(OPEN_END_ELEMENT);
                this.outputStream.write(xPathFragment.getShortNameBytes());
                this.outputStream.write(CLOSE_ELEMENT);
            }
            this.isStartElementOpen = false;
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void characters(String value) {
        try {
            if (this.isStartElementOpen) {
                this.isStartElementOpen = false;
                this.outputStream.write(CLOSE_ELEMENT);
            }
            this.writeValue(value);
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void cdata(String value) {
        try {
            if (this.isStartElementOpen) {
                this.isStartElementOpen = false;
                this.outputStream.write(CLOSE_ELEMENT);
            }
            this.outputStream.write(OPEN_CDATA);
            this.outputStream.write(value.getBytes("UTF-8"));
            this.outputStream.write(CLOSE_CDATA);
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    protected void writeValue(String value) {
        try {
            block7: for (char character : value.toCharArray()) {
                switch (character) {
                    case '&': {
                        this.outputStream.write(AMP);
                        continue block7;
                    }
                    case '<': {
                        this.outputStream.write(LT);
                        continue block7;
                    }
                    case '\"': {
                        this.outputStream.write(QUOT);
                        continue block7;
                    }
                    default: {
                        this.outputStream.write(character);
                    }
                }
            }
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void node(Node node, NamespaceResolver namespaceResolver) {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String resolverPfx = null;
            if (namespaceResolver != null) {
                resolverPfx = namespaceResolver.resolveNamespaceURI(attr.getNamespaceURI());
            }
            if (resolverPfx != null) {
                this.attribute(attr.getNamespaceURI(), "", resolverPfx + ':' + attr.getLocalName(), attr.getNodeValue());
            } else {
                this.attribute(attr.getNamespaceURI(), "", attr.getName(), attr.getNodeValue());
                if (attr.getNamespaceURI() != null) {
                    this.attribute("http://www.w3.org/2000/xmlns/", "", "xmlns:" + attr.getPrefix(), attr.getNamespaceURI());
                }
            }
        } else if (node.getNodeType() == 3) {
            this.characters(node.getNodeValue());
        } else {
            try {
                OutputStreamRecordContentHandler handler = new OutputStreamRecordContentHandler();
                XMLFragmentReader xfragReader = new XMLFragmentReader(namespaceResolver);
                xfragReader.setContentHandler(handler);
                xfragReader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
                xfragReader.parse(node);
            }
            catch (SAXException sex) {
                throw XMLMarshalException.marshalException(sex);
            }
        }
    }

    static {
        try {
            OPEN_XML_PI_AND_VERSION_ATTRIBUTE = "<?xml version=\"".getBytes("UTF-8");
            OPEN_ENCODING_ATTRIBUTE = " encoding=\"".getBytes("UTF-8");
            CLOSE_PI = "?>".getBytes("UTF-8");
            SPACE = " ".getBytes("UTF-8");
            CR = Helper.cr().getBytes("UTF-8");
            OPEN_ATTRIBUTE_VALUE = "=\"".getBytes("UTF-8");
            CLOSE_ATTRIBUTE_VALUE = "\"".getBytes("UTF-8");
            OPEN_CDATA = "<![CDATA[".getBytes("UTF-8");
            CLOSE_CDATA = "]]>".getBytes("UTF-8");
            OPEN_COMMENT = "<!--".getBytes("UTF-8");
            CLOSE_COMMENT = "-->".getBytes("UTF-8");
            OPEN_START_ELEMENT = "<".getBytes("UTF-8");
            OPEN_END_ELEMENT = "</".getBytes("UTF-8");
            CLOSE_ELEMENT = ">".getBytes("UTF-8");
            CLOSE_EMPTY_ELEMENT = "/>".getBytes("UTF-8");
            AMP = "&amp;".getBytes("UTF-8");
            LT = "&lt;".getBytes("UTF-8");
            QUOT = "&quot;".getBytes("UTF-8");
            ENCODING = "UTF-8".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    protected class OutputStreamRecordContentHandler
    implements ContentHandler,
    LexicalHandler {
        Map<String, String> prefixMappings = new HashMap<String, String>();

        OutputStreamRecordContentHandler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            try {
                if (OutputStreamRecord.this.isStartElementOpen) {
                    OutputStreamRecord.this.outputStream.write(CLOSE_ELEMENT);
                }
                OutputStreamRecord.this.outputStream.write(OPEN_START_ELEMENT);
                OutputStreamRecord.this.outputStream.write(qName.getBytes("UTF-8"));
                OutputStreamRecord.this.isStartElementOpen = true;
                this.handleAttributes(atts);
                this.writePrefixMappings();
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            try {
                if (OutputStreamRecord.this.isStartElementOpen) {
                    OutputStreamRecord.this.outputStream.write(CLOSE_EMPTY_ELEMENT);
                } else {
                    OutputStreamRecord.this.outputStream.write(OPEN_END_ELEMENT);
                    OutputStreamRecord.this.outputStream.write(qName.getBytes("UTF-8"));
                    OutputStreamRecord.this.outputStream.write(CLOSE_ELEMENT);
                }
                OutputStreamRecord.this.isStartElementOpen = false;
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            String namespaceUri = OutputStreamRecord.this.getNamespaceResolver().resolveNamespacePrefix(prefix);
            if (namespaceUri == null || !namespaceUri.equals(uri)) {
                this.prefixMappings.put(prefix, uri);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (OutputStreamRecord.this.isProcessingCData) {
                OutputStreamRecord.this.cdata(new String(ch, start, length));
                return;
            }
            if (OutputStreamRecord.this.isStartElementOpen) {
                try {
                    OutputStreamRecord.this.outputStream.write(CLOSE_ELEMENT);
                    OutputStreamRecord.this.isStartElementOpen = false;
                }
                catch (IOException e) {
                    throw XMLMarshalException.marshalException(e);
                }
            }
            OutputStreamRecord.this.writeValue(new String(ch, start, length));
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            try {
                if (OutputStreamRecord.this.isStartElementOpen) {
                    OutputStreamRecord.this.outputStream.write(CLOSE_ELEMENT);
                    OutputStreamRecord.this.isStartElementOpen = false;
                }
                this.writeComment(ch, start, length);
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        public void startCDATA() throws SAXException {
            OutputStreamRecord.this.isProcessingCData = true;
        }

        public void endCDATA() throws SAXException {
            OutputStreamRecord.this.isProcessingCData = false;
        }

        protected void writePrefixMappings() {
            try {
                if (!this.prefixMappings.isEmpty()) {
                    for (String prefix : this.prefixMappings.keySet()) {
                        OutputStreamRecord.this.outputStream.write(SPACE);
                        OutputStreamRecord.this.outputStream.write("xmlns".getBytes("UTF-8"));
                        if (prefix.length() > 0) {
                            OutputStreamRecord.this.outputStream.write(58);
                            OutputStreamRecord.this.outputStream.write(prefix.getBytes("UTF-8"));
                        }
                        OutputStreamRecord.this.outputStream.write(OPEN_ATTRIBUTE_VALUE);
                        OutputStreamRecord.this.outputStream.write(this.prefixMappings.get(prefix).getBytes("UTF-8"));
                        OutputStreamRecord.this.outputStream.write(CLOSE_ATTRIBUTE_VALUE);
                    }
                    this.prefixMappings.clear();
                }
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        protected void handleAttributes(Attributes atts) {
            int attsLength = atts.getLength();
            for (int i = 0; i < attsLength; ++i) {
                String qName = atts.getQName(i);
                if (qName != null && (qName.startsWith("xmlns:") || qName.equals("xmlns"))) continue;
                OutputStreamRecord.this.attribute(atts.getURI(i), atts.getLocalName(i), qName, atts.getValue(i));
            }
        }

        protected void writeComment(char[] chars, int start, int length) {
            try {
                OutputStreamRecord.this.outputStream.write(OPEN_COMMENT);
                for (int x = start; x < length; ++x) {
                    OutputStreamRecord.this.outputStream.write(chars[x]);
                }
                OutputStreamRecord.this.outputStream.write(CLOSE_COMMENT);
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        protected void writeCharacters(char[] chars, int start, int length) {
            try {
                for (int x = start; x < length; ++x) {
                    OutputStreamRecord.this.outputStream.write(chars[x]);
                }
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void startEntity(String name) throws SAXException {
        }

        public void endEntity(String name) throws SAXException {
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        public void endDTD() throws SAXException {
        }
    }
}

