/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.InstantiationPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;

public class MultiArgInstantiationPolicy
extends InstantiationPolicy {
    private String[] parameterTypeNames;
    private Class[] parameterTypes;
    private Object[] defaultValues;

    public void setParameterTypeNames(String[] parameterTypeNames) {
        this.parameterTypeNames = parameterTypeNames;
    }

    public void setParameterTypes(Class[] parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public void setDefaultValues(Object[] values) {
        this.defaultValues = values;
    }

    public void convertClassNamesToClasses(ClassLoader loader) {
        super.convertClassNamesToClasses(loader);
        if (this.parameterTypes == null && this.parameterTypeNames != null) {
            Class[] values = new Class[this.parameterTypeNames.length];
            for (int i = 0; i < values.length; ++i) {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            values[i] = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.parameterTypeNames[i], true, loader));
                            continue;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames((String)this.parameterTypeNames[i], (Exception)exception.getException());
                        }
                    }
                    values[i] = PrivilegedAccessHelper.getClassForName((String)this.parameterTypeNames[i], (boolean)true, (ClassLoader)loader);
                    continue;
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames((String)this.factoryClassName, (Exception)exc);
                }
            }
            this.parameterTypes = values;
        }
    }

    protected void initializeMethod() throws DescriptorException {
        Class<?> tempClass = this.getFactory() == null ? this.getDescriptor().getJavaClass() : this.getFactory().getClass();
        if (this.parameterTypes == null) {
            this.setMethod(this.buildMethod(tempClass, this.getMethodName(), new Class[0]));
        } else {
            this.setMethod(this.buildMethod(tempClass, this.getMethodName(), this.parameterTypes));
        }
    }

    protected Object buildNewInstanceUsingFactory() throws DescriptorException {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedMethodInvoker(this.getMethod(), this.getFactory(), this.defaultValues));
                }
                catch (PrivilegedActionException exception) {
                    Exception throwableException = exception.getException();
                    if (throwableException instanceof IllegalAccessException) {
                        throw DescriptorException.illegalAccessWhileMethodInstantiation((String)this.getMethod().toString(), (ClassDescriptor)this.getDescriptor(), (Exception)throwableException);
                    }
                    throw DescriptorException.targetInvocationWhileMethodInstantiation((String)this.getMethod().toString(), (ClassDescriptor)this.getDescriptor(), (Exception)throwableException);
                }
            }
            return PrivilegedAccessHelper.invokeMethod((Method)this.getMethod(), (Object)this.getFactory(), (Object[])this.defaultValues);
        }
        catch (IllegalAccessException exception) {
            throw DescriptorException.illegalAccessWhileMethodInstantiation((String)this.getMethod().toString(), (ClassDescriptor)this.getDescriptor(), (Exception)exception);
        }
        catch (InvocationTargetException exception) {
            throw DescriptorException.targetInvocationWhileMethodInstantiation((String)this.getMethod().toString(), (ClassDescriptor)this.getDescriptor(), (Exception)exception);
        }
        catch (NullPointerException exception) {
            throw DescriptorException.nullPointerWhileMethodInstantiation((String)this.getMethod().toString(), (ClassDescriptor)this.getDescriptor(), (Exception)exception);
        }
    }
}

